/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class MaterializationMetadataRepository
extends MetadataRepository {
    public static final String ALLOW_MATVIEW_MANAGEMENT = "{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT";
    public static final String ON_VDB_START_SCRIPT = "{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT";
    public static final String ON_VDB_DROP_SCRIPT = "{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT";
    public static final String MATVIEW_AFTER_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT";
    public static final String MATVIEW_BEFORE_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT";
    public static final String MATVIEW_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT";
    public static final String MATVIEW_STATUS_TABLE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE";
    public static final String MATVIEW_TTL = "{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL";
    public static final String MATVIEW_STAGE_TABLE = "{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE";
    public static final String MATVIEW_SHARE_SCOPE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE";
    public static final String MATVIEW_ONERROR_ACTION = "{http://www.teiid.org/ext/relational/2012}MATVIEW_ONERROR_ACTION";
    public static final String MATVIEW_UPDATABLE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE";
    public static final String MATVIEW_PREFER_MEMORY = "{http://www.teiid.org/ext/relational/2012}MATVIEW_PREFER_MEMORY";
    public static final String MATVIEW_SCOPE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_SCOPE";

    public void loadMetadata(MetadataFactory factory, ExecutionFactory executionFactory, Object connectionFactory) throws TranslatorException {
        for (Table table : factory.getSchema().getTables().values()) {
            String manage;
            if (!table.isMaterialized() || table.getMaterializedTable() == null || !Boolean.valueOf(manage = table.getProperty(ALLOW_MATVIEW_MANAGEMENT, false)).booleanValue()) continue;
            String statusTable = table.getProperty(MATVIEW_STATUS_TABLE, false);
            String beforeScript = table.getProperty(MATVIEW_BEFORE_LOAD_SCRIPT, false);
            String afterScript = table.getProperty(MATVIEW_AFTER_LOAD_SCRIPT, false);
            String stageTable = table.getProperty(MATVIEW_STAGE_TABLE, false);
            String loadScript = table.getProperty(MATVIEW_LOAD_SCRIPT, false);
            if (statusTable == null || stageTable == null && loadScript == null) {
                throw new TranslatorException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31154, new Object[0]));
            }
            if (beforeScript != null && afterScript != null) continue;
            LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31155, new Object[0]));
        }
    }

    public static enum ErrorAction {
        THROW_EXCEPTION,
        IGNORE,
        WAIT;

    }

    public static enum Scope {
        NONE,
        VDB,
        SCHEMA;

    }

    public static enum LoadStates {
        NEEDS_LOADING,
        LOADING,
        LOADED,
        FAILED_LOAD;

    }
}

