/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Select
implements LanguageObject {
    private List<Expression> symbols = new ArrayList<Expression>();
    private boolean distinct;

    public Select() {
    }

    public Select(List<? extends Expression> symbols) {
        this.addSymbols(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public boolean isStar() {
        return this.symbols.size() == 1 && this.symbols.get(0) instanceof MultipleElementSymbol && ((MultipleElementSymbol)this.symbols.get(0)).getGroup() == null;
    }

    public List<Expression> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<? extends Expression> symbols) {
        this.symbols.clear();
        this.addSymbols(symbols);
    }

    public Expression getSymbol(int index) {
        return this.symbols.get(index);
    }

    public void addSymbol(Expression symbol) {
        if (!(symbol instanceof Symbol) && !(symbol instanceof MultipleElementSymbol)) {
            symbol = new ExpressionSymbol("expr" + (this.symbols.size() + 1), symbol);
        }
        this.symbols.add(symbol);
    }

    public void addSymbols(Collection<? extends Expression> toAdd) {
        if (toAdd != null) {
            for (Expression expression : toAdd) {
                this.addSymbol(expression);
            }
        }
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public boolean containsSymbol(Expression symbol) {
        return this.symbols.contains(symbol);
    }

    public void setDistinct(boolean isDistinct) {
        this.distinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List<Expression> getProjectedSymbols() {
        ArrayList<Expression> projectedSymbols = new ArrayList<Expression>();
        for (Expression symbol : this.symbols) {
            if (symbol instanceof MultipleElementSymbol) {
                List<ElementSymbol> multiSymbols = ((MultipleElementSymbol)symbol).getElementSymbols();
                if (multiSymbols == null) continue;
                projectedSymbols.addAll(multiSymbols);
                continue;
            }
            projectedSymbols.add(symbol);
        }
        return projectedSymbols;
    }

    @Override
    public Select clone() {
        Select copy = new Select(LanguageObject.Util.deepClone(this.symbols, Expression.class));
        copy.setDistinct(this.isDistinct());
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Select)) {
            return false;
        }
        Select other = (Select)obj;
        return other.isDistinct() == this.isDistinct() && EquivalenceUtil.areEqual(this.getSymbols(), other.getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getSymbols()});
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

