/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.DerivedExpression;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class AggregateSymbol
extends Function
implements DerivedExpression {
    private static final Expression[] EMPTY_ARGS = new Expression[0];
    private static final Map<String, Type> nameMap = new TreeMap<String, Type>(String.CASE_INSENSITIVE_ORDER);
    private Type aggregate;
    private boolean distinct;
    private OrderBy orderBy;
    private Expression condition;
    private boolean isWindowed;
    private static final Class<Integer> COUNT_TYPE;
    private static final Map<Class<?>, Class<?>> SUM_TYPES;
    private static final Map<Class<?>, Class<?>> AVG_TYPES;

    protected AggregateSymbol(String name, Type aggregateFunction, boolean isDistinct, Expression[] args) {
        super(name, args);
        this.aggregate = aggregateFunction;
        this.distinct = isDistinct;
    }

    public AggregateSymbol(String aggregateFunction, boolean isDistinct, Expression expression) {
        Expression[] expressionArray;
        if (expression == null) {
            expressionArray = EMPTY_ARGS;
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression;
        }
        this(aggregateFunction, isDistinct, expressionArray, null);
    }

    public AggregateSymbol(String aggregateFunction, boolean isDistinct, Expression[] args, OrderBy orderBy) {
        super(aggregateFunction, args);
        this.aggregate = nameMap.get(aggregateFunction);
        if (this.aggregate == null) {
            this.aggregate = Type.USER_DEFINED;
        }
        this.distinct = isDistinct;
        this.orderBy = orderBy;
    }

    public void setAggregateFunction(Type aggregateFunction) {
        this.aggregate = aggregateFunction;
    }

    public Type getAggregateFunction() {
        return this.aggregate;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public Class<?> getType() {
        switch (this.aggregate) {
            case COUNT: {
                return COUNT_TYPE;
            }
            case SUM: {
                Class<?> expressionType = this.getArg(0).getType();
                return SUM_TYPES.get(expressionType);
            }
            case AVG: {
                Class<?> expressionType = this.getArg(0).getType();
                return AVG_TYPES.get(expressionType);
            }
            case ARRAY_AGG: {
                if (this.getArg(0) == null) {
                    return null;
                }
                return DataTypeManager.getArrayType(this.getArg(0).getType());
            }
            case TEXTAGG: {
                return DataTypeManager.DefaultDataClasses.BLOB;
            }
            case USER_DEFINED: {
                if (this.getFunctionDescriptor() == null) {
                    return null;
                }
                return this.getFunctionDescriptor().getReturnType();
            }
            case JSONARRAY_AGG: {
                return DataTypeManager.DefaultDataClasses.CLOB;
            }
            case STRING_AGG: {
                return super.getType();
            }
        }
        if (this.isBoolean()) {
            return DataTypeManager.DefaultDataClasses.BOOLEAN;
        }
        if (this.isEnhancedNumeric()) {
            return DataTypeManager.DefaultDataClasses.DOUBLE;
        }
        if (this.isAnalytical()) {
            return DataTypeManager.DefaultDataClasses.INTEGER;
        }
        if (this.getArgs().length == 0) {
            return null;
        }
        return this.getArg(0).getType();
    }

    public boolean isAnalytical() {
        switch (this.aggregate) {
            case RANK: 
            case ROW_NUMBER: 
            case DENSE_RANK: {
                return true;
            }
        }
        return false;
    }

    public boolean isBoolean() {
        return this.aggregate == Type.EVERY || this.aggregate == Type.SOME || this.aggregate == Type.ANY;
    }

    public boolean isEnhancedNumeric() {
        return this.aggregate == Type.STDDEV_POP || this.aggregate == Type.STDDEV_SAMP || this.aggregate == Type.VAR_SAMP || this.aggregate == Type.VAR_POP;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public Object clone() {
        AggregateSymbol copy = new AggregateSymbol(this.getName(), this.getAggregateFunction(), this.isDistinct(), (Expression[])LanguageObject.Util.deepClone((LanguageObject[])this.getArgs()));
        if (this.orderBy != null) {
            copy.setOrderBy(this.orderBy.clone());
        }
        if (this.condition != null) {
            copy.setCondition((Expression)this.condition.clone());
        }
        copy.isWindowed = this.isWindowed;
        copy.setType(this.getType());
        copy.setFunctionDescriptor(this.getFunctionDescriptor());
        return copy;
    }

    @Override
    public int hashCode() {
        int hasCode = HashCodeUtil.hashCode((int)this.aggregate.hashCode(), (boolean)this.distinct);
        return HashCodeUtil.hashCode((int)hasCode, (int)super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AggregateSymbol)) {
            return false;
        }
        AggregateSymbol other = (AggregateSymbol)obj;
        return super.equals(obj) && this.aggregate.equals((Object)other.aggregate) && this.distinct == other.distinct && this.isWindowed == other.isWindowed && EquivalenceUtil.areEqual((Object)this.condition, (Object)other.condition) && EquivalenceUtil.areEqual((Object)this.getOrderBy(), (Object)other.getOrderBy());
    }

    public boolean isCardinalityDependent() {
        if (this.isDistinct()) {
            return false;
        }
        switch (this.getAggregateFunction()) {
            case MAX: 
            case MIN: 
            case ANY: 
            case SOME: 
            case EVERY: {
                return false;
            }
            case USER_DEFINED: {
                return !this.getFunctionDescriptor().getMethod().getAggregateAttributes().usesDistinctRows();
            }
        }
        return true;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public static boolean areAggregatesCardinalityDependent(Collection<AggregateSymbol> aggs) {
        for (AggregateSymbol aggregateSymbol : aggs) {
            if (!aggregateSymbol.isCardinalityDependent()) continue;
            return true;
        }
        return false;
    }

    public boolean respectsNulls() {
        switch (this.aggregate) {
            case ARRAY_AGG: 
            case TEXTAGG: 
            case JSONARRAY_AGG: {
                return true;
            }
        }
        return false;
    }

    public boolean canStage() {
        if (this.orderBy != null) {
            return false;
        }
        switch (this.aggregate) {
            case ARRAY_AGG: 
            case TEXTAGG: 
            case JSONARRAY_AGG: {
                return false;
            }
            case USER_DEFINED: {
                return this.getArgs().length == 1 && this.getFunctionDescriptor().getMethod().getAggregateAttributes().isDecomposable();
            }
        }
        return true;
    }

    public boolean isWindowed() {
        return this.isWindowed;
    }

    public void setWindowed(boolean isWindowed) {
        this.isWindowed = isWindowed;
    }

    static {
        for (Type t : Type.values()) {
            if (t == Type.USER_DEFINED) continue;
            nameMap.put(t.name(), t);
        }
        COUNT_TYPE = DataTypeManager.DefaultDataClasses.INTEGER;
        SUM_TYPES = new HashMap();
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, DataTypeManager.DefaultDataClasses.LONG);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_INTEGER);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        SUM_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES = new HashMap();
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BYTE, SQLParserUtil.DECIMAL_AS_DOUBLE ? DataTypeManager.DefaultDataClasses.DOUBLE : DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.SHORT, SQLParserUtil.DECIMAL_AS_DOUBLE ? DataTypeManager.DefaultDataClasses.DOUBLE : DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.INTEGER, SQLParserUtil.DECIMAL_AS_DOUBLE ? DataTypeManager.DefaultDataClasses.DOUBLE : DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.LONG, SQLParserUtil.DECIMAL_AS_DOUBLE ? DataTypeManager.DefaultDataClasses.DOUBLE : DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_INTEGER, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.FLOAT, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.DOUBLE, DataTypeManager.DefaultDataClasses.DOUBLE);
        AVG_TYPES.put(DataTypeManager.DefaultDataClasses.BIG_DECIMAL, DataTypeManager.DefaultDataClasses.BIG_DECIMAL);
    }

    public static enum Type {
        COUNT,
        SUM,
        AVG,
        MIN,
        MAX,
        XMLAGG,
        TEXTAGG,
        ARRAY_AGG,
        JSONARRAY_AGG,
        ANY,
        SOME,
        EVERY,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_POP,
        VAR_SAMP,
        RANK,
        DENSE_RANK,
        ROW_NUMBER,
        STRING_AGG,
        USER_DEFINED;

    }
}

