/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Blob;
import java.sql.Clob;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;

public class GeometryFunctionMethods {
    @TeiidFunction(name="st_astext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static ClobType asText(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToClob(geometry);
    }

    @TeiidFunction(name="st_asbinary", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static BlobType asBlob(GeometryType geometry) {
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    @TeiidFunction(name="st_asgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGeoJson(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToGeoJson(geometry);
    }

    @TeiidFunction(name="st_asgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGml(GeometryType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToGml(geometry);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromText(ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt);
    }

    @TeiidFunction(name="st_geomfromtext", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType geomFromText(ClobType wkt, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt, srid);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb);
    }

    @TeiidFunction(name="st_geomfromwkb", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true, alias="ST_GEOMFROMBINARY")
    public static GeometryType geoFromBlob(BlobType wkb, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb, srid);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(clob);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(clob, srid);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGml(gml);
    }

    @TeiidFunction(name="st_geomfromgml", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGml(ClobType gml, int srid) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGml((Clob)gml, srid);
    }

    @TeiidFunction(name="st_intersects", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.intersects(geom1, geom2);
    }

    @TeiidFunction(name="st_contains", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.contains(geom1, geom2);
    }

    @TeiidFunction(name="st_crosses", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean crosses(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.crosses(geom1, geom2);
    }

    @TeiidFunction(name="st_disjoint", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean disjoint(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.disjoint(geom1, geom2);
    }

    @TeiidFunction(name="st_distance", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Double distance(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.distance(geom1, geom2);
    }

    @TeiidFunction(name="st_overlaps", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean overlaps(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.overlaps(geom1, geom2);
    }

    @TeiidFunction(name="st_touches", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean touches(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.touches(geom1, geom2);
    }

    @TeiidFunction(name="st_srid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static int getSrid(GeometryType geom1) {
        return geom1.getSrid();
    }

    @TeiidFunction(name="st_setsrid", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeometryType setSrid(GeometryType geom1, int srid) {
        GeometryType gt = new GeometryType();
        gt.setReference(geom1.getReference());
        gt.setSrid(srid);
        return gt;
    }

    @TeiidFunction(name="st_equals", category="Geometry", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static Boolean equals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.equals(geom1, geom2);
    }
}

