/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;

public class WhileInstruction
extends ProcessorInstruction {
    private String resultSetName;
    private Program blockProgram;

    public WhileInstruction(String rsName) {
        this.resultSetName = rsName;
    }

    public void setBlockProgram(Program blockProgram) {
        this.blockProgram = blockProgram;
    }

    public Program getBlockProgram() {
        return this.blockProgram;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        List<?> row = context.getCurrentRow(this.resultSetName);
        if (row != null) {
            this.pushProgram(env, context, row);
            this.setFirst(context.getVariableContext(), Boolean.TRUE);
        } else {
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"WHILE removed finished result set:", this.resultSetName});
            env.incrementCurrentProgramCounter();
        }
        return context;
    }

    Map getPreviousValues(VariableContext varContext) {
        return (Map)varContext.getValue(new ElementSymbol("$" + this.getResultSetName() + "$previousValues"));
    }

    void setPreviousValues(VariableContext varContext, Map values) {
        varContext.setValue(new ElementSymbol("$" + this.getResultSetName() + "$previousValues"), values);
    }

    Boolean getFirst(VariableContext varContext) {
        return (Boolean)varContext.getValue(new ElementSymbol("$" + this.getResultSetName() + "$first"));
    }

    void setFirst(VariableContext varContext, Boolean value) {
        varContext.setValue(new ElementSymbol("$" + this.getResultSetName() + "$first"), value);
    }

    protected void pushProgram(XMLProcessorEnvironment env, XMLContext context, List row) throws TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"WHILE repeating for result set:", this.resultSetName, ", block program:", this.blockProgram});
        context.setVariableValues(this.resultSetName, row);
        env.pushProgram(this.blockProgram);
    }

    public String toString() {
        return "LOOP " + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("LOOP");
        props.addProperty("Result Set", this.resultSetName);
        props.addProperty("Program", this.blockProgram.getDescriptionProperties());
        return props;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }
}

