/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.validator.UpdateValidator;

public abstract class ProcedureContainerResolver
implements CommandResolver {
    public abstract void resolveProceduralCommand(Command var1, TempMetadataAdapter var2) throws QueryMetadataException, QueryResolverException, TeiidComponentException;

    public Command expandCommand(ProcedureContainer procCommand, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol group = procCommand.getGroup();
        Command subCommand = null;
        String plan = this.getPlan(metadata, procCommand);
        if (plan == null) {
            return null;
        }
        QueryParser parser = QueryParser.getQueryParser();
        try {
            subCommand = parser.parseProcedure(plan, !(procCommand instanceof StoredProcedure));
        }
        catch (QueryParserException e) {
            throw new QueryResolverException(QueryPlugin.Event.TEIID30060, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30060, new Object[]{group, procCommand.getClass().getSimpleName()}));
        }
        return subCommand;
    }

    protected abstract String getPlan(QueryMetadataInterface var1, GroupSymbol var2) throws TeiidComponentException, QueryMetadataException, QueryResolverException;

    public static void addChanging(TempMetadataStore discoveredMetadata, GroupContext externalGroups, List<ElementSymbol> elements) {
        ArrayList<ElementSymbol> changingElements = new ArrayList<ElementSymbol>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol virtualElmnt = elements.get(i);
            ElementSymbol changeElement = virtualElmnt.clone();
            changeElement.setType(DataTypeManager.DefaultDataClasses.BOOLEAN);
            changingElements.add(changeElement);
        }
        ProcedureContainerResolver.addScalarGroup("CHANGING", discoveredMetadata, externalGroups, changingElements, false);
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        ProcedureContainer procCommand = (ProcedureContainer)command;
        this.resolveGroup(metadata, procCommand);
        this.resolveProceduralCommand(procCommand, metadata);
    }

    private String getPlan(QueryMetadataInterface metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!procCommand.getGroup().isTempTable() && metadata.isVirtualGroup(procCommand.getGroup().getMetadataID())) {
            String plan = this.getPlan(metadata, procCommand.getGroup());
            if (plan == null && !metadata.isProcedure(procCommand.getGroup().getMetadataID())) {
                int type = procCommand.getType();
                ProcedureContainerResolver.getUpdateInfo(procCommand.getGroup(), metadata, type, true);
            }
            return plan;
        }
        return null;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata, int type, boolean validate) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        String error;
        UpdateValidator.UpdateInfo info = ProcedureContainerResolver.getUpdateInfo(group, metadata);
        if (info == null) {
            return null;
        }
        if (validate && (error = ProcedureContainerResolver.validateUpdateInfo(group, type, info)) != null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30061, error);
        }
        return info;
    }

    public static String validateUpdateInfo(GroupSymbol group, int type, UpdateValidator.UpdateInfo info) {
        String error = info.getDeleteValidationError();
        String name = "Delete";
        if (type == 3) {
            error = info.getUpdateValidationError();
            name = "Update";
        } else if (type == 2) {
            error = info.getInsertValidationError();
            name = "Insert";
        }
        if (error != null) {
            return QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30061, new Object[]{group, name, error});
        }
        return null;
    }

    public static UpdateValidator.UpdateInfo getUpdateInfo(GroupSymbol group, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
        if (!QueryResolver.isView(group, metadata)) {
            return null;
        }
        try {
            return QueryResolver.resolveView(group, metadata.getVirtualPlan(group.getMetadataID()), "SELECT", metadata).getUpdateInfo();
        }
        catch (QueryValidatorException e) {
            throw new QueryResolverException((Throwable)((Object)e));
        }
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws TeiidComponentException, QueryResolverException {
        GroupSymbol group = procCommand.getGroup();
        ResolverUtil.resolveGroup(group, metadata);
        if (!group.isTempTable()) {
            procCommand.setUpdateInfo(ProcedureContainerResolver.getUpdateInfo(group, metadata, procCommand.getType(), false));
        }
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols) {
        return ProcedureContainerResolver.addScalarGroup(name, metadata, externalGroups, symbols, true);
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols, boolean updatable) {
        boolean[] updateArray = new boolean[symbols.size()];
        if (updatable) {
            Arrays.fill(updateArray, true);
        }
        return ProcedureContainerResolver.addScalarGroup(name, metadata, externalGroups, symbols, updateArray);
    }

    public static GroupSymbol addScalarGroup(String name, TempMetadataStore metadata, GroupContext externalGroups, List<? extends Expression> symbols, boolean[] updatable) {
        GroupSymbol variables = new GroupSymbol(name);
        externalGroups.addGroup(variables);
        TempMetadataID tid = metadata.addTempGroup(name, symbols);
        tid.setMetadataType(TempMetadataID.Type.SCALAR);
        int i = 0;
        for (TempMetadataID cid : tid.getElements()) {
            cid.setMetadataType(TempMetadataID.Type.SCALAR);
            cid.setUpdatable(updatable[i++]);
        }
        variables.setMetadataID(tid);
        return variables;
    }

    public static void findChildCommandMetadata(Command currentCommand, GroupSymbol container, int type, QueryMetadataInterface metadata, boolean inferProcedureResultSetColumns) throws QueryMetadataException, TeiidComponentException, QueryResolverException {
        TempMetadataStore childMetadata = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, childMetadata);
        GroupContext externalGroups = new GroupContext();
        if (currentCommand instanceof TriggerAction) {
            TriggerAction ta = (TriggerAction)currentCommand;
            ta.setView(container);
            List<ElementSymbol> viewElements = ResolverUtil.resolveElementsInGroup(ta.getView(), metadata);
            if (type == 3 || type == 2) {
                ProcedureContainerResolver.addChanging(tma.getMetadataStore(), externalGroups, viewElements);
                ProcedureContainerResolver.addScalarGroup("NEW", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
            if (type == 3 || type == 4) {
                ProcedureContainerResolver.addScalarGroup("OLD", tma.getMetadataStore(), externalGroups, viewElements, false);
            }
        } else if (currentCommand instanceof CreateProcedureCommand) {
            CreateProcedureCommand cupc = (CreateProcedureCommand)currentCommand;
            cupc.setVirtualGroup(container);
            if (type == 6) {
                StoredProcedureInfo info = metadata.getStoredProcedureInfoForProcedure(container.getName());
                String procName = info.getProcedureCallableName();
                ArrayList<ElementSymbol> tempElements = new ArrayList<ElementSymbol>(info.getParameters().size());
                boolean[] updatable = new boolean[info.getParameters().size()];
                int i = 0;
                List<Object> rsColumns = Collections.emptyList();
                for (SPParameter param : info.getParameters()) {
                    if (param.getParameterType() != 5) {
                        ElementSymbol symbol = param.getParameterSymbol();
                        tempElements.add(symbol);
                        boolean bl = updatable[i++] = param.getParameterType() != 1;
                        if (param.getParameterType() != 4) continue;
                        cupc.setReturnVariable(symbol);
                        continue;
                    }
                    rsColumns = param.getResultSetColumns();
                }
                if (inferProcedureResultSetColumns) {
                    rsColumns = null;
                }
                GroupSymbol gs = ProcedureContainerResolver.addScalarGroup(procName, childMetadata, externalGroups, tempElements, updatable);
                if (cupc.getReturnVariable() != null) {
                    ResolverVisitor.resolveLanguageObject(cupc.getReturnVariable(), Arrays.asList(gs), metadata);
                }
                cupc.setResultSetColumns(rsColumns);
                cupc.setProjectedSymbols(rsColumns);
            } else {
                cupc.setUpdateType(type);
            }
        }
        QueryResolver.setChildMetadata(currentCommand, childMetadata, externalGroups);
    }
}

