/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.io.BufferedReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.TimeValue;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.CharsetUtils;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.WSConnection;
import org.teiid.util.StAXSQLXML;

public class XMLSystemFunctions {
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Location dummyLocation = new Location(){

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }
    };
    private static final EventFilter declarationOmittingFilter = new EventFilter(){

        @Override
        public boolean accept(XMLEvent event) {
            return !event.isStartDocument() && !event.isEndDocument();
        }
    };
    static ThreadLocal<XMLOutputFactory> threadLocalOutputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLSystemFunctions.newXmlOutputFactory();
        }
    };
    static ThreadLocal<XMLEventFactory> threadLocalEventtFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newFactory();
        }

        @Override
        public XMLEventFactory get() {
            XMLEventFactory eventFactory = (XMLEventFactory)super.get();
            eventFactory.setLocation(null);
            return eventFactory;
        }
    };
    private static final String P_OUTPUT_VALIDATE_STRUCTURE = "com.ctc.wstx.outputValidateStructure";
    static XMLOutputFactory xmlOutputFactory = XMLSystemFunctions.newXmlOutputFactory();

    static XMLOutputFactory newXmlOutputFactory() throws FactoryConfigurationError {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (factory.isPropertySupported(P_OUTPUT_VALIDATE_STRUCTURE)) {
            factory.setProperty(P_OUTPUT_VALIDATE_STRUCTURE, false);
        }
        return factory;
    }

    private static XMLEventReader getXMLEventReader(StAXSource source) throws XMLStreamException {
        XMLEventReader reader = source.getXMLEventReader();
        if (reader == null) {
            XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
            reader = inputFactory.createXMLEventReader(source.getXMLStreamReader());
        }
        return reader;
    }

    public static XMLOutputFactory getOutputFactory() throws FactoryConfigurationError {
        return XMLSystemFunctions.getOutputFactory(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClobType xslTransform(CommandContext context, Object xml, Object styleSheet) throws Exception {
        Source styleSource = null;
        Source xmlSource = null;
        try {
            styleSource = XMLSystemFunctions.convertToSource(styleSheet);
            final Source xmlParam = xmlSource = XMLSystemFunctions.convertToSource(xml);
            TransformerFactory factory = StandardXMLTranslator.getThreadLocalTransformerFactory();
            final Transformer transformer = factory.newTransformer(styleSource);
            SQLXMLImpl result = XMLSystemFunctions.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

                public void translate(Writer writer) throws TransformerException {
                    transformer.transform(xmlParam, new StreamResult(writer));
                }
            }, context);
            ClobType clobType = new ClobType((Clob)new ClobImpl(result.getStreamFactory(), -1L));
            return clobType;
        }
        finally {
            WSConnection.Util.closeSource((Source)styleSource);
            WSConnection.Util.closeSource((Source)xmlSource);
        }
    }

    public static XMLType xmlForest(CommandContext context, final Evaluator.NameValuePair[] namespaces, final Evaluator.NameValuePair[] values) throws TeiidComponentException, TeiidProcessingException {
        boolean valueExists = false;
        for (Evaluator.NameValuePair nameValuePair : values) {
            if (nameValuePair.value == null) continue;
            valueExists = true;
            break;
        }
        if (!valueExists) {
            return null;
        }
        XMLType result = new XMLType((SQLXML)XMLSystemFunctions.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                try {
                    XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                    XMLEventWriter eventWriter = factory.createXMLEventWriter(writer);
                    XMLEventFactory eventFactory = threadLocalEventtFactory.get();
                    for (Evaluator.NameValuePair nameValuePair : values) {
                        if (nameValuePair.value == null) continue;
                        XMLSystemFunctions.addElement(nameValuePair.name, writer, eventWriter, eventFactory, namespaces, null, Collections.singletonList(nameValuePair.value));
                    }
                    eventWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new TransformerException(e);
                }
            }
        }, context));
        result.setType(XMLType.Type.CONTENT);
        return result;
    }

    public static XMLType xmlElement(CommandContext context, final String name, final Evaluator.NameValuePair<String>[] namespaces, final Evaluator.NameValuePair<?>[] attributes, final List<?> contents) throws TeiidComponentException, TeiidProcessingException {
        XMLType result = new XMLType((SQLXML)XMLSystemFunctions.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

            public void translate(Writer writer) throws TransformerException, IOException {
                try {
                    XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                    XMLEventWriter eventWriter = factory.createXMLEventWriter(writer);
                    XMLEventFactory eventFactory = threadLocalEventtFactory.get();
                    XMLSystemFunctions.addElement(name, writer, eventWriter, eventFactory, namespaces, attributes, contents);
                    eventWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new TransformerException(e);
                }
            }
        }, context));
        result.setType(XMLType.Type.ELEMENT);
        return result;
    }

    private static void addElement(String name, Writer writer, XMLEventWriter eventWriter, XMLEventFactory eventFactory, Evaluator.NameValuePair<String>[] namespaces, Evaluator.NameValuePair<?>[] attributes, List<?> contents) throws XMLStreamException, IOException, TransformerException {
        eventWriter.add(eventFactory.createStartElement("", null, name));
        if (namespaces != null) {
            for (Evaluator.NameValuePair<String> nameValuePair : namespaces) {
                if (nameValuePair.name == null) {
                    if (nameValuePair.value == null) {
                        eventWriter.add(eventFactory.createNamespace(""));
                        continue;
                    }
                    eventWriter.add(eventFactory.createNamespace((String)nameValuePair.value));
                    continue;
                }
                eventWriter.add(eventFactory.createNamespace(nameValuePair.name, (String)nameValuePair.value));
            }
        }
        if (attributes != null) {
            for (Evaluator.NameValuePair<String> nameValuePair : attributes) {
                if (nameValuePair.value == null) continue;
                eventWriter.add(eventFactory.createAttribute(new QName(nameValuePair.name), XMLSystemFunctions.convertToAtomicValue(nameValuePair.value).getStringValue()));
            }
        }
        eventWriter.add(eventFactory.createCharacters(""));
        for (Object object : contents) {
            XMLSystemFunctions.convertValue(writer, eventWriter, eventFactory, object);
        }
        eventWriter.add(eventFactory.createEndElement("", null, name));
    }

    public static XMLType xmlConcat(CommandContext context, XMLType xml, Object ... other) throws TeiidProcessingException {
        XMLType singleValue = xml;
        XMLType.Type type = null;
        for (Object object : other) {
            if (object == null) continue;
            if (singleValue != null) {
                type = XMLType.Type.CONTENT;
                break;
            }
            if (object instanceof XMLType) {
                singleValue = (XMLType)object;
                continue;
            }
            type = XMLType.Type.CONTENT;
            break;
        }
        if (type == null) {
            return singleValue;
        }
        XmlConcat concat = new XmlConcat(context.getBufferManager());
        concat.addValue(xml);
        for (Object object : other) {
            concat.addValue(object);
        }
        return concat.close(context);
    }

    public static XMLType xmlPi(String name) {
        return XMLSystemFunctions.xmlPi(name, "");
    }

    public static XMLType xmlPi(String name, String content) {
        int start;
        char[] chars = content.toCharArray();
        for (start = 0; start < chars.length && chars[start] == ' '; ++start) {
        }
        XMLType result = new XMLType((SQLXML)new SQLXMLImpl("<?" + name + " " + content.substring(start) + "?>"));
        result.setType(XMLType.Type.PI);
        return result;
    }

    public static AtomicValue convertToAtomicValue(Object value) throws TransformerException {
        if (value instanceof Date) {
            Date d = (Date)value;
            DateTimeValue tdv = DateTimeValue.fromJavaDate((Date)d);
            if (value instanceof java.sql.Date) {
                value = new DateValue(tdv.getYear(), tdv.getMonth(), tdv.getDay(), tdv.getTimezoneInMinutes(), true);
            } else if (value instanceof Time) {
                value = new TimeValue(tdv.getHour(), tdv.getMinute(), tdv.getSecond(), tdv.getMicrosecond(), tdv.getTimezoneInMinutes());
            } else if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                value = tdv.add((DurationValue)DayTimeDurationValue.fromMicroseconds((long)(ts.getNanos() / 1000)));
            }
            return (AtomicValue)value;
        }
        JPConverter converter = JPConverter.allocate(value.getClass(), null);
        return (AtomicValue)converter.convert(value, null);
    }

    static void convertValue(Writer writer, XMLEventWriter eventWriter, XMLEventFactory eventFactory, Object object) throws IOException, FactoryConfigurationError, XMLStreamException, TransformerException {
        if (object == null) {
            return;
        }
        Reader r = null;
        try {
            if (object instanceof XMLType) {
                XMLType xml = (XMLType)object;
                XMLType.Type type = xml.getType();
                XMLSystemFunctions.convertReader(writer, eventWriter, null, type, xml);
            } else if (object instanceof ClobType) {
                ExtendedWriter ew;
                ClobType clob = (ClobType)object;
                InputStreamFactory.StorageMode storageMode = InputStreamFactory.getStorageMode((Object)clob);
                if ((storageMode == InputStreamFactory.StorageMode.PERSISTENT || storageMode == InputStreamFactory.StorageMode.OTHER) && writer instanceof ExtendedWriter && (ew = (ExtendedWriter)writer).include((Streamable<?>)clob)) {
                    return;
                }
                r = clob.getCharacterStream();
                XMLSystemFunctions.convertReader(writer, eventWriter, r, XMLType.Type.TEXT, null);
            } else {
                String val = XMLSystemFunctions.convertToAtomicValue(object).getStringValue();
                eventWriter.add(eventFactory.createCharacters(val));
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private static void convertReader(Writer writer, XMLEventWriter eventWriter, Reader r, XMLType.Type type, XMLType xml) throws XMLStreamException, IOException, FactoryConfigurationError, SQLException {
        switch (type) {
            case CONTENT: 
            case ELEMENT: 
            case PI: 
            case COMMENT: {
                ExtendedWriter ew;
                eventWriter.flush();
                InputStreamFactory.StorageMode storageMode = InputStreamFactory.getStorageMode((Object)xml);
                if ((storageMode == InputStreamFactory.StorageMode.PERSISTENT || storageMode == InputStreamFactory.StorageMode.OTHER) && writer instanceof ExtendedWriter && (ew = (ExtendedWriter)writer).include((Streamable<?>)xml)) break;
                char[] buf = new char[8192];
                int read = -1;
                if (r == null) {
                    r = xml.getCharacterStream();
                }
                while ((read = r.read(buf)) != -1) {
                    writer.write(buf, 0, read);
                }
                break;
            }
            case UNKNOWN: 
            case DOCUMENT: {
                XMLEventReader eventReader = null;
                XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
                if (r != null) {
                    if (!(r instanceof BufferedReader)) {
                        r = new BufferedReader(r);
                    }
                    eventReader = inputFactory.createXMLEventReader(r);
                } else {
                    StAXSource staxSource = (StAXSource)xml.getSource(StAXSource.class);
                    eventReader = staxSource.getXMLEventReader();
                    if (eventReader == null) {
                        eventReader = inputFactory.createXMLEventReader(staxSource.getXMLStreamReader());
                    }
                }
                eventReader = inputFactory.createFilteredReader(eventReader, declarationOmittingFilter);
                eventWriter.add(eventReader);
                break;
            }
            case TEXT: {
                if (r == null) {
                    r = xml.getCharacterStream();
                }
                XMLEventFactory eventFactory = threadLocalEventtFactory.get();
                char[] buf = new char[8192];
                int read = -1;
                while ((read = r.read(buf)) != -1) {
                    eventWriter.add(eventFactory.createCharacters(new String(buf, 0, read)));
                }
                break;
            }
        }
    }

    public static XMLType xmlComment(String comment) throws FunctionExecutionException {
        if (comment.contains("--") || comment.endsWith("-")) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31159, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31159, new Object[]{comment}));
        }
        XMLType result = new XMLType((SQLXML)new SQLXMLImpl("<!--" + comment + "-->"));
        result.setType(XMLType.Type.COMMENT);
        return result;
    }

    public static Source convertToSource(Object value) throws TeiidProcessingException {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof SQLXML) {
                return ((SQLXML)value).getSource(null);
            }
            if (value instanceof Clob) {
                return new StreamSource(((Clob)value).getCharacterStream());
            }
            if (value instanceof Blob) {
                return new StreamSource(((Blob)value).getBinaryStream());
            }
            if (value instanceof String) {
                return new StreamSource(new StringReader((String)value));
            }
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30443, (Throwable)e);
        }
        throw new AssertionError((Object)"Unknown type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xpathValue(Object doc, String xpath) throws XPathException, TeiidProcessingException {
        Source s = null;
        try {
            s = XMLSystemFunctions.convertToSource(doc);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            Object o = expr.evaluateSingle(s);
            if (o == null) {
                String string = null;
                return string;
            }
            if (o instanceof Item) {
                Item i = (Item)o;
                if (XMLSystemFunctions.isNull(i)) {
                    String string = null;
                    return string;
                }
                String string = i.getStringValue();
                return string;
            }
            String string = o.toString();
            return string;
        }
        finally {
            WSConnection.Util.closeSource((Source)s);
        }
    }

    public static boolean isNull(Item i) {
        if (i instanceof NodeInfo) {
            NodeInfo ni = (NodeInfo)i;
            return ni.getNodeKind() == 1 && !ni.hasChildNodes() && Boolean.valueOf(ni.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) != false;
        }
        return false;
    }

    public static void validateXpath(String xpath) throws XPathException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        eval.createExpression(xpath);
    }

    public static String escapeName(String name, boolean fully) {
        StringBuilder sb = new StringBuilder();
        char[] chars = name.toCharArray();
        int i = 0;
        if (fully && name.regionMatches(true, 0, "xml", 0, 3)) {
            sb.append(XMLSystemFunctions.escapeChar(name.charAt(0)));
            sb.append(chars, 1, 2);
            i = 3;
        }
        while (i < chars.length) {
            block8: {
                char chr = chars[i];
                switch (chr) {
                    case ':': {
                        if (!fully && i != 0) break;
                        sb.append(XMLSystemFunctions.escapeChar(chr));
                        break block8;
                    }
                    case '_': {
                        if (chars.length <= i || chars[i + 1] != 'x') break;
                        sb.append(XMLSystemFunctions.escapeChar(chr));
                        break block8;
                    }
                    default: {
                        if (i == 0) {
                            if (Name11Checker.getInstance().isNCNameStartChar((int)chr)) break;
                            sb.append(XMLSystemFunctions.escapeChar(chr));
                        } else {
                            if (Name11Checker.getInstance().isNCNameChar((int)chr)) break;
                            sb.append(XMLSystemFunctions.escapeChar(chr));
                        }
                        break block8;
                    }
                }
                sb.append(chr);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String escapeChar(char chr) {
        CharBuffer cb = CharBuffer.allocate(7);
        cb.append("_u");
        CharsetUtils.toHex(cb, (byte)(chr >> 8));
        CharsetUtils.toHex(cb, (byte)chr);
        return cb.append("_").flip().toString();
    }

    public static SQLXML jsonToXml(CommandContext context, String rootName, Blob json) throws TeiidComponentException, TeiidProcessingException, SQLException, IOException {
        return XMLSystemFunctions.jsonToXml(context, rootName, json, false);
    }

    public static SQLXML jsonToXml(CommandContext context, String rootName, Blob json, boolean stream) throws TeiidComponentException, TeiidProcessingException, SQLException, IOException {
        InputStreamReader r = XMLSystemFunctions.getJsonReader(json);
        return XMLSystemFunctions.jsonToXml(context, rootName, r, stream);
    }

    public static InputStreamReader getJsonReader(Blob json) throws SQLException, IOException {
        InputStream is = json.getBinaryStream();
        PushbackInputStream pStream = new PushbackInputStream(is, 4);
        byte[] encoding = new byte[4];
        int read = pStream.read(encoding);
        pStream.unread(encoding, 0, read);
        Charset charset = UTF_8;
        if (read > 3) {
            if (encoding[0] == 0 && encoding[2] == 0) {
                charset = encoding[1] == 0 ? UTF_32BE : UTF_16BE;
            } else if (encoding[1] == 0 && encoding[3] == 0) {
                charset = encoding[2] == 0 ? UTF_32LE : UTF_16LE;
            }
        }
        return new InputStreamReader((InputStream)pStream, charset);
    }

    public static SQLXML jsonToXml(CommandContext context, String rootName, Clob json) throws TeiidComponentException, TeiidProcessingException, SQLException {
        return XMLSystemFunctions.jsonToXml(context, rootName, json, false);
    }

    public static SQLXML jsonToXml(CommandContext context, String rootName, Clob json, boolean stream) throws TeiidComponentException, TeiidProcessingException, SQLException {
        return XMLSystemFunctions.jsonToXml(context, rootName, json.getCharacterStream(), stream);
    }

    private static SQLXML jsonToXml(CommandContext context, String rootName, final Reader r, boolean stream) throws TeiidComponentException, TeiidProcessingException {
        JSONParser parser = new JSONParser();
        final JsonToXmlContentHandler reader = new JsonToXmlContentHandler(rootName, r, parser, threadLocalEventtFactory.get());
        SQLXMLImpl sqlXml = null;
        if (stream) {
            try {
                reader.eventFactory.setLocation(dummyLocation);
                sqlXml = new StAXSQLXML(new StAXSource(reader));
            }
            catch (XMLStreamException e) {
                throw new TeiidProcessingException((Throwable)e);
            }
        } else {
            sqlXml = XMLSystemFunctions.saveToBufferManager(context.getBufferManager(), new XMLTranslator(){

                public void translate(Writer writer) throws TransformerException, IOException {
                    try {
                        XMLOutputFactory factory = XMLSystemFunctions.getOutputFactory();
                        XMLEventWriter streamWriter = factory.createXMLEventWriter(writer);
                        streamWriter.add(reader);
                        streamWriter.flush();
                    }
                    catch (XMLStreamException e) {
                        throw new TransformerException(e);
                    }
                    finally {
                        try {
                            r.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }, context);
        }
        XMLType result = new XMLType((SQLXML)sqlXml);
        result.setType(XMLType.Type.DOCUMENT);
        return result;
    }

    public static SQLXMLImpl saveToBufferManager(BufferManager bufferMgr, XMLTranslator translator, CommandContext context) throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        FileStore lobBuffer = bufferMgr.createFileStore("xml");
        FileStoreInputStreamFactory fsisf = new FileStoreInputStreamFactory(lobBuffer, "UTF-8");
        try {
            Writer writer = fsisf.getWriter();
            ExtendedWriter ew = new ExtendedWriter(writer, fsisf);
            translator.translate((Writer)ew);
            ew.close();
            success = true;
            SQLXMLImpl sQLXMLImpl = XMLSystemFunctions.createSQLXML(fsisf, ew, context);
            return sQLXMLImpl;
        }
        catch (IOException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30444, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30445, (Throwable)e);
        }
        finally {
            if (!success && lobBuffer != null) {
                lobBuffer.remove();
            }
        }
    }

    private static SQLXMLImpl createSQLXML(final FileStoreInputStreamFactory fsisf, final ExtendedWriter ew, CommandContext context) {
        if (ew.includes.isEmpty()) {
            if (fsisf.getStorageMode() == InputStreamFactory.StorageMode.MEMORY) {
                byte[] bytes = fsisf.getMemoryBytes();
                fsisf.free();
                return new SQLXMLImpl(bytes);
            }
            if (context != null) {
                context.addCreatedLob(fsisf);
            }
            return new SQLXMLImpl((InputStreamFactory)fsisf);
        }
        InputStreamFactory isf = new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                ArrayList<InputStream> streams = new ArrayList<InputStream>(ew.includes.size() * 2 + 1);
                long last = 0L;
                for (int i = 0; i < ew.includes.size(); ++i) {
                    Include include = (Include)ew.includes.get(i);
                    streams.add(fsisf.getInputStream(last, include.start - last));
                    last = include.start;
                    try {
                        streams.add(((BaseLob)include.streamable.getReference()).getBinaryStream());
                        continue;
                    }
                    catch (SQLException e) {
                        throw new IOException(e);
                    }
                }
                streams.add(fsisf.getInputStream(last, -1L));
                return new SequenceInputStream(Collections.enumeration(streams));
            }

            public void free() throws IOException {
                fsisf.free();
                ew.includes.clear();
            }
        };
        if (context != null) {
            context.addCreatedLob(isf);
        }
        return new SQLXMLImpl(isf);
    }

    public static Object serialize(XMLSerialize xs, XMLType value) throws TransformationException {
        Object isf;
        XMLType.Type type = value.getType();
        final Charset encoding = xs.getEncoding() != null ? Charset.forName(xs.getEncoding()) : UTF_8;
        if (Boolean.TRUE.equals(xs.getDeclaration())) {
            if (type == XMLType.Type.ELEMENT || type == XMLType.Type.DOCUMENT) {
                XMLEventFactory xmlEventFactory = threadLocalEventtFactory.get();
                xmlEventFactory.setLocation(dummyLocation);
                StartDocument start = null;
                start = xs.getVersion() != null ? xmlEventFactory.createStartDocument(encoding.name(), xs.getVersion()) : (xs.getEncoding() != null ? xmlEventFactory.createStartDocument(encoding.name()) : xmlEventFactory.createStartDocument());
                DeclarationStaxSourceProvider sourceProvider = new DeclarationStaxSourceProvider(start, value);
                value = new XMLType((SQLXML)new StAXSQLXML((StAXSQLXML.StAXSourceProvider)sourceProvider, encoding));
                value.setType(type);
            }
        } else if (type == XMLType.Type.DOCUMENT && Boolean.FALSE.equals(xs.getDeclaration())) {
            final XMLType v = value;
            StAXSQLXML.StAXSourceProvider sourceProvider = new StAXSQLXML.StAXSourceProvider(){

                public StAXSource getStaxSource() throws SQLException {
                    try {
                        XMLEventReader eventReader = XMLSystemFunctions.getXMLEventReader((StAXSource)v.getSource(StAXSource.class));
                        eventReader = XMLType.getXmlInputFactory().createFilteredReader(eventReader, declarationOmittingFilter);
                        return new StAXSource(eventReader);
                    }
                    catch (XMLStreamException e) {
                        throw new SQLException(e);
                    }
                }
            };
            value = new XMLType((SQLXML)new StAXSQLXML(sourceProvider, encoding));
            value.setType(XMLType.Type.DOCUMENT);
        }
        if (xs.getType() == DataTypeManager.DefaultDataClasses.STRING) {
            return DataTypeManager.transformValue((Object)value, xs.getType());
        }
        if (xs.getType() == DataTypeManager.DefaultDataClasses.CLOB) {
            isf = Evaluator.getInputStreamFactory(value);
            return new ClobType((Clob)new ClobImpl(isf, -1L));
        }
        if (xs.getType() == DataTypeManager.DefaultDataClasses.VARBINARY) {
            try {
                InputStream is = null;
                is = !Charset.forName(value.getEncoding()).equals(encoding) ? new ReaderInputStream(value.getCharacterStream(), encoding) : value.getBinaryStream();
                byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is, (int)DataTypeManager.MAX_VARBINARY_BYTES);
                return new BinaryType(bytes);
            }
            catch (SQLException e) {
                throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10080, (Throwable)e, CorePlugin.Util.gs((BundleUtil.Event)CorePlugin.Event.TEIID10080, new Object[]{"XML", "VARBINARY"}));
            }
            catch (IOException e) {
                throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10080, (Throwable)e, CorePlugin.Util.gs((BundleUtil.Event)CorePlugin.Event.TEIID10080, new Object[]{"XML", "VARBINARY"}));
            }
        }
        isf = null;
        isf = !Charset.forName(value.getEncoding()).equals(encoding) ? new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)value){

            public InputStream getInputStream() throws IOException {
                try {
                    return new ReaderInputStream(this.sqlxml.getCharacterStream(), encoding);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        } : Evaluator.getInputStreamFactory(value);
        return new BlobType((Blob)new BlobImpl(isf));
    }

    public static XMLOutputFactory getOutputFactory(boolean repairing) {
        if (XMLType.isThreadSafeXmlFactories() && !repairing) {
            return xmlOutputFactory;
        }
        XMLOutputFactory f = threadLocalOutputFactory.get();
        if (repairing && f.isPropertySupported("javax.xml.stream.isRepairingNamespaces")) {
            f.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        } else {
            f.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        }
        return f;
    }

    @TeiidFunction(category="XML")
    public static XMLType xmlText(String val) throws XMLStreamException, FactoryConfigurationError, IOException, TransformerException {
        StringWriter writer = new StringWriter();
        XMLEventWriter eventWriter = XMLSystemFunctions.getOutputFactory().createXMLEventWriter(writer);
        XMLSystemFunctions.convertValue(writer, eventWriter, threadLocalEventtFactory.get(), val);
        XMLType result = new XMLType((SQLXML)new SQLXMLImpl(writer.toString()));
        result.setType(XMLType.Type.TEXT);
        return result;
    }

    public static class ExtendedWriter
    extends FilterWriter {
        private static int MAX_INCLUDES = 4096;
        private FileStoreInputStreamFactory fsisf;
        private List<Include> includes = new ArrayList<Include>();

        public ExtendedWriter(Writer out, FileStoreInputStreamFactory fsisf) {
            super(out);
            this.fsisf = fsisf;
        }

        public boolean include(Streamable<?> s) throws IOException {
            if (this.includes.size() == MAX_INCLUDES) {
                return false;
            }
            this.out.flush();
            long length = this.fsisf.getLength();
            this.includes.add(new Include(length, s));
            return true;
        }
    }

    private static class Include {
        long start;
        Streamable<?> streamable;

        public Include(long start, Streamable<?> streamable) {
            this.start = start;
            this.streamable = streamable;
        }
    }

    public static class XmlConcat {
        private XMLOutputFactory factory;
        private XMLEventWriter eventWriter;
        private Writer writer;
        private FileStoreInputStreamFactory fsisf;
        private FileStore fs;
        private XMLType.Type type;
        private ExtendedWriter ew;

        public XmlConcat(BufferManager bm) throws TeiidProcessingException {
            this.fs = bm.createFileStore("xml");
            this.fsisf = new FileStoreInputStreamFactory(this.fs, "UTF-8");
            this.writer = this.fsisf.getWriter();
            this.ew = new ExtendedWriter(this.writer, this.fsisf);
            this.factory = XMLSystemFunctions.getOutputFactory();
            try {
                this.eventWriter = this.factory.createXMLEventWriter(this.writer);
            }
            catch (XMLStreamException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30437, (Throwable)e);
            }
        }

        public void addValue(Object object) throws TeiidProcessingException {
            if (this.type == null) {
                if (object instanceof XMLType) {
                    this.type = ((XMLType)object).getType();
                }
            } else {
                this.type = XMLType.Type.CONTENT;
            }
            try {
                XMLSystemFunctions.convertValue(this.ew, this.eventWriter, threadLocalEventtFactory.get(), object);
            }
            catch (IOException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
            }
            catch (XMLStreamException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30439, (Throwable)e);
            }
            catch (TransformerException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30440, (Throwable)e);
            }
        }

        public Writer getWriter() {
            return this.writer;
        }

        public XMLType close(CommandContext context) throws TeiidProcessingException {
            try {
                this.eventWriter.flush();
                this.ew.close();
            }
            catch (XMLStreamException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30441, (Throwable)e);
            }
            catch (IOException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30442, (Throwable)e);
            }
            XMLType result = new XMLType((SQLXML)XMLSystemFunctions.createSQLXML(this.fsisf, this.ew, context));
            if (this.type == null) {
                result.setType(XMLType.Type.CONTENT);
            } else {
                result.setType(this.type);
            }
            return result;
        }
    }

    private static final class JsonToXmlContentHandler
    implements ContentHandler,
    XMLEventReader {
        private Reader reader;
        private JSONParser parser;
        private XMLEventFactory eventFactory;
        private LinkedList<String> nameStack = new LinkedList();
        private LinkedList<XMLEvent> eventStack = new LinkedList();
        private boolean rootArray;
        private boolean end;
        private boolean declaredNs;

        private JsonToXmlContentHandler(String rootName, Reader reader, JSONParser parser, XMLEventFactory eventFactory) {
            this.nameStack.push(XMLSystemFunctions.escapeName(rootName, true));
            this.reader = reader;
            this.eventFactory = eventFactory;
            this.parser = parser;
        }

        @Override
        public boolean startObjectEntry(String key) throws ParseException, IOException {
            this.nameStack.push(XMLSystemFunctions.escapeName(key, true));
            return false;
        }

        @Override
        public boolean startObject() throws ParseException, IOException {
            this.start();
            return false;
        }

        private void start() {
            this.eventStack.add(this.eventFactory.createStartElement("", "", this.nameStack.peek()));
            if (!this.declaredNs) {
                this.eventStack.add(this.eventFactory.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
                this.declaredNs = true;
            }
        }

        @Override
        public void startJSON() throws ParseException, IOException {
            this.eventStack.add(this.eventFactory.createStartDocument("UTF-8", "1.0"));
        }

        @Override
        public boolean startArray() throws ParseException, IOException {
            if (this.nameStack.size() == 1) {
                this.rootArray = true;
                this.start();
            }
            return false;
        }

        @Override
        public boolean primitive(Object value) throws ParseException, IOException {
            this.start();
            if (value != null) {
                String type = "decimal";
                if (value instanceof String) {
                    type = null;
                } else if (value instanceof Boolean) {
                    type = "boolean";
                }
                if (type != null) {
                    this.eventStack.add(this.eventFactory.createAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", type));
                }
                this.eventStack.add(this.eventFactory.createCharacters(value.toString()));
            } else {
                this.eventStack.add(this.eventFactory.createAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true"));
            }
            this.end();
            return true;
        }

        private void end() {
            this.eventStack.add(this.eventFactory.createEndElement("", "", this.nameStack.peek()));
        }

        @Override
        public boolean endObjectEntry() throws ParseException, IOException {
            this.nameStack.pop();
            return false;
        }

        @Override
        public boolean endObject() throws ParseException, IOException {
            this.end();
            return false;
        }

        @Override
        public void endJSON() throws ParseException, IOException {
            this.eventStack.add(this.eventFactory.createEndDocument());
            this.end = true;
        }

        @Override
        public boolean endArray() throws ParseException, IOException {
            if (this.nameStack.size() == 1 && this.rootArray) {
                this.end();
            }
            return false;
        }

        @Override
        public void close() throws XMLStreamException {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public String getElementText() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return null;
        }

        @Override
        public boolean hasNext() {
            return !this.eventStack.isEmpty() || !this.end;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            while (this.eventStack.isEmpty() && !this.end) {
                try {
                    this.parser.parse(this.reader, (ContentHandler)this, true);
                }
                catch (IOException e) {
                    throw new XMLStreamException(e);
                }
                catch (ParseException e) {
                    throw new XMLStreamException(e);
                }
            }
            return this.eventStack.remove();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public XMLEvent peek() throws XMLStreamException {
            if (this.hasNext()) {
                XMLEvent next = this.next();
                this.eventStack.push(next);
                return next;
            }
            return null;
        }

        @Override
        public XMLEvent next() {
            try {
                return this.nextEvent();
            }
            catch (XMLStreamException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DeclarationStaxSourceProvider
    implements StAXSQLXML.StAXSourceProvider {
        private final XMLEvent start;
        private XMLType value;

        private DeclarationStaxSourceProvider(XMLEvent start, XMLType value) {
            this.start = start;
            this.value = value;
        }

        public StAXSource getStaxSource() throws SQLException {
            StAXSource source = (StAXSource)this.value.getSource(StAXSource.class);
            try {
                XMLEventReader reader = XMLSystemFunctions.getXMLEventReader(source);
                reader = new EventReaderDelegate(reader){

                    @Override
                    public XMLEvent nextEvent() throws XMLStreamException {
                        return this.replaceStart(super.nextEvent());
                    }

                    @Override
                    public XMLEvent peek() throws XMLStreamException {
                        return this.replaceStart(super.peek());
                    }

                    private XMLEvent replaceStart(XMLEvent event) {
                        if (event != null && event.getEventType() == 7) {
                            return DeclarationStaxSourceProvider.this.start;
                        }
                        return event;
                    }

                    @Override
                    public Object next() {
                        try {
                            return this.nextEvent();
                        }
                        catch (XMLStreamException e) {
                            throw new NoSuchElementException();
                        }
                    }
                };
                return new StAXSource(reader);
            }
            catch (XMLStreamException e) {
                throw new SQLException(e);
            }
        }
    }
}

