/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.WindowFunction;

public class AggregateSymbolCollectorVisitor
extends LanguageVisitor {
    private Collection<? super AggregateSymbol> aggregates;
    private Collection<? super ElementSymbol> otherElements;
    private Collection<? super WindowFunction> windowFunctions;

    public AggregateSymbolCollectorVisitor(Collection<? super AggregateSymbol> aggregates, Collection<? super ElementSymbol> elements) {
        this.aggregates = aggregates;
        this.otherElements = elements;
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (this.aggregates != null && !obj.isWindowed()) {
            this.aggregates.add(obj);
        }
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        if (this.windowFunctions != null) {
            this.windowFunctions.add(windowFunction);
        }
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (this.otherElements != null && !obj.isExternalReference()) {
            this.otherElements.add(obj);
        }
    }

    public static final void getAggregates(LanguageObject obj, Collection<? super AggregateSymbol> aggregates, Collection<? super ElementSymbol> otherElements, Collection<? super Expression> groupingColsUsed, Collection<? super WindowFunction> windowFunctions, Collection<? extends Expression> groupingCols) {
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(aggregates, otherElements);
        visitor.windowFunctions = windowFunctions;
        AggregateStopNavigator asn = new AggregateStopNavigator((LanguageVisitor)visitor, groupingColsUsed, groupingCols);
        asn.visitNode(obj);
    }

    public static final Collection<AggregateSymbol> getAggregates(LanguageObject obj, boolean removeDuplicates) {
        if (obj == null) {
            return Collections.emptyList();
        }
        AbstractCollection aggregates = null;
        aggregates = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(aggregates, null);
        AggregateStopNavigator asn = new AggregateStopNavigator((LanguageVisitor)visitor, null, null);
        obj.acceptVisitor(asn);
        return aggregates;
    }

    public static class AggregateStopNavigator
    extends PreOrPostOrderNavigator {
        private Collection<? extends Expression> groupingCols;
        private Collection<? super Expression> groupingColsUsed;

        public AggregateStopNavigator(LanguageVisitor visitor, Collection<? super Expression> groupingColsUsed, Collection<? extends Expression> groupingCols) {
            super(visitor, true, false);
            this.groupingCols = groupingCols;
            this.groupingColsUsed = groupingColsUsed;
        }

        public AggregateStopNavigator(LanguageVisitor visitor, Collection<? extends Expression> groupingCols) {
            super(visitor, true, true);
            this.groupingCols = groupingCols;
        }

        @Override
        public void visit(AggregateSymbol obj) {
            this.preVisitVisitor(obj);
            this.postVisitVisitor(obj);
        }

        @Override
        protected void visitNode(LanguageObject obj) {
            if (this.groupingCols != null && obj instanceof Expression && this.groupingCols.contains(obj)) {
                if (this.groupingColsUsed != null) {
                    this.groupingColsUsed.add((Expression)obj);
                }
                return;
            }
            super.visitNode(obj);
        }
    }
}

