/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.client.plan.Annotation;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.translator.ExecutionFactory;

public class CriteriaCapabilityValidatorVisitor
extends LanguageVisitor {
    private Object modelID;
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder capFinder;
    private AnalysisRecord analysisRecord;
    private SourceCapabilities caps;
    private TeiidComponentException exception;
    private boolean valid = true;
    private boolean isJoin;
    static HashSet<String> parseFormat = new HashSet();

    CriteriaCapabilityValidatorVisitor(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, SourceCapabilities caps) throws QueryMetadataException, TeiidComponentException {
        this.modelID = modelID;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.caps = caps;
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.markInvalid(obj, "Pushdown of XMLAttributes not allowed");
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.markInvalid(obj, "Pushdown of XMLNamespaces not allowed");
    }

    @Override
    public void visit(TextLine obj) {
        this.markInvalid(obj, "Pushdown of TextLine not allowed");
    }

    @Override
    public void visit(XMLForest obj) {
        this.markInvalid(obj, "Pushdown of XMLForest not allowed");
    }

    @Override
    public void visit(JSONObject obj) {
        this.markInvalid(obj, "Pushdown of JSONObject not allowed");
    }

    @Override
    public void visit(XMLElement obj) {
        this.markInvalid(obj, "Pushdown of XMLElement not allowed");
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.markInvalid(obj, "Pushdown of XMLSerialize not allowed");
    }

    @Override
    public void visit(XMLParse obj) {
        this.markInvalid(obj, "Pushdown of XMLParse not allowed");
    }

    @Override
    public void visit(XMLQuery obj) {
        this.markInvalid(obj, "Pushdown of XMLQuery not allowed");
    }

    @Override
    public void visit(XMLExists obj) {
        this.markInvalid(obj, "Pushdown of XMLExists not allowed");
    }

    @Override
    public void visit(XMLCast xmlCast) {
        this.markInvalid(xmlCast, "Pushdown of XMLCast not allowed");
    }

    @Override
    public void visit(QueryString obj) {
        this.markInvalid(obj, "Pushdown of QueryString not allowed");
    }

    @Override
    public void visit(Array array) {
        try {
            if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.ARRAY_TYPE, this.modelID, this.metadata, this.capFinder)) {
                this.markInvalid(array, "Array type not supported by source");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        try {
            if (!CapabilitiesUtil.supportsAggregateFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid(obj, "Aggregate function pushdown not supported by source");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.ELEMENTARY_OLAP)) {
            this.markInvalid(windowFunction, "Window function not supported by source");
            return;
        }
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES) && windowFunction.getWindowSpecification().getOrderBy() != null && !windowFunction.getFunction().isAnalytical()) {
            this.markInvalid(windowFunction, "Window function order by with aggregate not supported by source");
            return;
        }
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.WINDOW_FUNCTION_DISTINCT_AGGREGATES) && windowFunction.getFunction().isDistinct()) {
            this.markInvalid(windowFunction, "Window function distinct aggregate not supported by source");
            return;
        }
        OrderBy orderBy = windowFunction.getWindowSpecification().getOrderBy();
        if (orderBy != null) {
            for (OrderByItem item : orderBy.getOrderByItems()) {
                if (!EvaluatableVisitor.willBecomeConstant(SymbolMap.getExpression(item.getSymbol()))) continue;
                this.markInvalid(windowFunction, "Window function order by constant not supported.");
                return;
            }
        }
        try {
            if (!CapabilitiesUtil.checkElementsAreSearchable(windowFunction.getWindowSpecification().getPartition(), this.metadata, 2)) {
                this.markInvalid(windowFunction, "not all source columns support search type");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        try {
            this.checkElementsAreSearchable(obj.getSymbol(), 2);
            if (!CapabilitiesUtil.supportsNullOrdering(this.metadata, this.capFinder, this.modelID, obj)) {
                this.markInvalid(obj, "Desired null ordering is not supported by source");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CaseExpression obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_CASE)) {
            this.markInvalid(obj, "CaseExpression pushdown not supported by source");
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        this.checkCompareCriteria(obj);
        this.checkLiteralComparison(obj, Arrays.asList(obj.getRightExpression()));
    }

    private void checkLiteralComparison(LanguageObject obj, Collection<? extends LanguageObject> toCheck) {
        if (this.isJoin || !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_ONLY_LITERAL_COMPARE)) {
            return;
        }
        for (LanguageObject languageObject : toCheck) {
            if (EvaluatableVisitor.willBecomeConstant(languageObject)) continue;
            this.markInvalid(obj, "Non-literal comparison not supported by source.");
            return;
        }
    }

    public void checkCompareCriteria(AbstractCompareCriteria obj) {
        boolean negated = false;
        SourceCapabilities.Capability operatorCap = null;
        switch (obj.getOperator()) {
            case 2: {
                negated = true;
            }
            case 1: {
                operatorCap = SourceCapabilities.Capability.CRITERIA_COMPARE_EQ;
                break;
            }
            case 3: 
            case 4: {
                operatorCap = SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED_EXCLUSIVE;
                break;
            }
            case 5: 
            case 6: {
                operatorCap = SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED;
            }
        }
        if (!this.caps.supportsCapability(operatorCap)) {
            boolean unsupported = true;
            if (operatorCap == SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED_EXCLUSIVE && this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED) && this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
                unsupported = false;
            }
            if (unsupported) {
                this.markInvalid(obj, (Object)((Object)operatorCap) + " CompareCriteria not supported by source");
                return;
            }
        }
        if (negated && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid(obj, "Negation is not supported by source");
            return;
        }
        try {
            this.checkElementsAreSearchable(obj.getLeftExpression(), 2);
            this.checkElementsAreSearchable(obj.getRightExpression(), 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(CompoundCriteria crit) {
        int operator = crit.getOperator();
        if (operator == 1 && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_OR)) {
            this.markInvalid(crit, "OR criteria not supported by source");
        }
    }

    @Override
    public void visit(Function obj) {
        try {
            if (EvaluatableVisitor.willBecomeConstant(obj, true)) {
                return;
            }
            if (obj.getFunctionDescriptor().getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN) {
                this.markInvalid(obj, "Function metadata indicates it cannot be pusheddown.");
                return;
            }
            if (!CapabilitiesUtil.supportsScalarFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid(obj, (obj.isImplicit() ? "(implicit) " : "") + obj.getName() + " function not supported by source");
                return;
            }
            String name = obj.getName();
            if (CapabilitiesUtil.supports(SourceCapabilities.Capability.ONLY_FORMAT_LITERALS, this.modelID, this.metadata, this.capFinder) && parseFormat.contains(name)) {
                if (!(obj.getArg(1) instanceof Constant)) {
                    this.markInvalid(obj, obj.getName() + " non-literal parse format function not supported by source");
                    return;
                }
                Constant c = (Constant)obj.getArg(1);
                if (c.isMultiValued()) {
                    this.markInvalid(obj, obj.getName() + " non-literal parse format function not supported by source");
                    return;
                }
                if (!CapabilitiesUtil.getCapabilities(this.modelID, this.metadata, this.capFinder).supportsFormatLiteral((String)c.getValue(), name.endsWith("timestamp") ? ExecutionFactory.Format.DATE : ExecutionFactory.Format.NUMBER)) {
                    this.markInvalid(obj, obj.getName() + " literal parse " + c + " not supported by source");
                    return;
                }
                c.setBindEligible(false);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_ISNULL)) {
            this.markInvalid(obj, "IsNull not supported by source");
            return;
        }
        if (obj.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid(obj, "Negation is not supported by source");
            return;
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        switch (obj.getMode()) {
            case LIKE: {
                if (this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_LIKE)) break;
                this.markInvalid(obj, "Like is not supported by source");
                return;
            }
            case SIMILAR: {
                if (this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_SIMILAR)) break;
                this.markInvalid(obj, "Similar to is not supported by source");
                return;
            }
            case REGEX: {
                if (this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_LIKE_REGEX)) break;
                this.markInvalid(obj, "Like_regex is not supported by source");
                return;
            }
        }
        if (obj.getEscapeChar() != '\u0000' && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE)) {
            this.markInvalid(obj, "Like escape is not supported by source");
            return;
        }
        if (obj.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid(obj, "Negation is not supported by source");
            return;
        }
        try {
            this.checkElementsAreSearchable(obj.getLeftExpression(), 1);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
        this.checkLiteralComparison(obj, Arrays.asList(obj.getRightExpression()));
    }

    @Override
    public void visit(NotCriteria obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid(obj, "Negation is not supported by source");
            return;
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_SEARCHED_CASE)) {
            this.markInvalid(obj, "SearchedCase is not supported by source");
        }
    }

    @Override
    public void visit(SetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
        try {
            int maxSize = CapabilitiesUtil.getMaxInCriteriaSize(this.modelID, this.metadata, this.capFinder);
            int maxPredicates = CapabilitiesUtil.getMaxDependentPredicates(this.modelID, this.metadata, this.capFinder);
            if (maxSize > 0 && maxPredicates > 0 && (long)crit.getValues().size() > Math.max((long)maxSize, (long)maxSize * (long)maxPredicates / 2L)) {
                this.markInvalid(crit, "SetCriteria size exceeds maximum for source");
                return;
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
        this.checkLiteralComparison(crit, crit.getValues());
    }

    @Override
    public void visit(ExistsCriteria crit) {
        if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_EXISTS)) {
            this.markInvalid(crit, "Exists is not supported by source");
            return;
        }
        if (crit.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
            this.markInvalid(crit, "Negation is not supported by source");
            return;
        }
        try {
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder, this.analysisRecord) == null) {
                if (crit.getCommand().getCorrelatedReferences() == null) {
                    crit.setShouldEvaluate(true);
                } else {
                    this.markInvalid(crit.getCommand(), "Subquery cannot be pushed down");
                }
            }
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria crit) {
        SourceCapabilities.Capability capability = SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR;
        switch (crit.getPredicateQuantifier()) {
            case 4: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL;
                break;
            }
            case 3: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME;
                break;
            }
            case 2: {
                capability = SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME;
            }
        }
        if (!this.caps.supportsCapability(capability)) {
            this.markInvalid(crit, "SubqueryCompare not supported by source");
            return;
        }
        this.checkCompareCriteria(crit);
        try {
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder, this.analysisRecord) == null) {
                this.markInvalid(crit.getCommand(), "Subquery cannot be pushed down");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR) || CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(obj, this.modelID, this.metadata, this.capFinder, this.analysisRecord) == null) {
                if (obj.getCommand().getCorrelatedReferences() == null && !FunctionCollectorVisitor.isNonDeterministic(obj.getCommand())) {
                    obj.setShouldEvaluate(true);
                } else {
                    this.markInvalid(obj.getCommand(), !this.caps.supportsCapability(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR) ? "Correlated ScalarSubquery is not supported" : "Subquery cannot be pushed down");
                }
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(SubquerySetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY)) {
                this.markInvalid(crit, "SubqueryIn is not supported by source");
                return;
            }
            if (CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(crit, this.modelID, this.metadata, this.capFinder, this.analysisRecord) == null) {
                this.markInvalid(crit.getCommand(), "Subquery cannot be pushed down");
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    public void checkAbstractSetCriteria(AbstractSetCriteria crit) {
        try {
            if (!this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_IN)) {
                this.markInvalid(crit, "In is not supported by source");
                return;
            }
            if (crit.isNegated() && !this.caps.supportsCapability(SourceCapabilities.Capability.CRITERIA_NOT)) {
                this.markInvalid(crit, "Negation is not supported by source");
                return;
            }
            this.checkElementsAreSearchable(crit.getExpression(), 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e)));
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(DependentSetCriteria crit) {
        this.checkAbstractSetCriteria(crit);
    }

    private void checkElementsAreSearchable(LanguageObject crit, int searchableType) throws QueryMetadataException, TeiidComponentException {
        if (!CapabilitiesUtil.checkElementsAreSearchable(Arrays.asList(crit), this.metadata, searchableType)) {
            this.markInvalid(crit, "not all source columns support search type");
        }
    }

    public static Object validateSubqueryPushdown(SubqueryContainer<?> subqueryContainer, Object critNodeModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord) throws TeiidComponentException {
        ProcessorPlan plan = ((Command)subqueryContainer.getCommand()).getProcessorPlan();
        if (plan != null) {
            AccessNode aNode = CriteriaCapabilityValidatorVisitor.getAccessNode(plan);
            if (aNode == null) {
                return null;
            }
            critNodeModelID = CriteriaCapabilityValidatorVisitor.validateCommandPushdown(critNodeModelID, metadata, capFinder, aNode, true);
        }
        if (critNodeModelID == null) {
            return null;
        }
        SymbolMap refs = ((Command)subqueryContainer.getCommand()).getCorrelatedReferences();
        try {
            if (refs != null && !refs.asMap().isEmpty()) {
                if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, critNodeModelID, metadata, capFinder)) {
                    return null;
                }
                if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject(subqueryContainer.getCommand(), critNodeModelID, metadata, capFinder, analysisRecord)) {
                    return null;
                }
            } else if (CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SUBQUERIES_ONLY_CORRELATED, critNodeModelID, metadata, capFinder)) {
                return null;
            }
        }
        catch (QueryMetadataException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30271, (Throwable)((Object)e));
        }
        return critNodeModelID;
    }

    public static Object validateCommandPushdown(Object critNodeModelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AccessNode aNode, boolean considerConformed) throws TeiidComponentException {
        try {
            if (!(aNode.getCommand() instanceof QueryCommand)) {
                return null;
            }
            Object modelID = aNode.getModelId();
            if (critNodeModelID == null) {
                critNodeModelID = modelID;
            } else if (!(CapabilitiesUtil.isSameConnector(critNodeModelID, modelID, metadata, capFinder) || considerConformed && RuleRaiseAccess.isConformed(metadata, capFinder, aNode.getConformedTo(), modelID, null, critNodeModelID))) {
                return null;
            }
        }
        catch (QueryMetadataException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30272, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30272, new Object[0]));
        }
        return critNodeModelID;
    }

    public static AccessNode getAccessNode(ProcessorPlan plan) {
        if (!(plan instanceof RelationalPlan)) {
            return null;
        }
        RelationalPlan rplan = (RelationalPlan)plan;
        RelationalNode accessNode = rplan.getRootNode();
        if (accessNode instanceof LimitNode) {
            LimitNode ln = (LimitNode)accessNode;
            if (!ln.isImplicit()) {
                return null;
            }
            accessNode = ln.getChildren()[0];
        }
        if (!(accessNode instanceof AccessNode)) {
            return null;
        }
        return (AccessNode)accessNode;
    }

    public static QueryCommand getQueryCommand(AccessNode aNode) {
        if (aNode == null) {
            return null;
        }
        Command command = aNode.getCommand();
        if (!(command instanceof QueryCommand)) {
            return null;
        }
        QueryCommand queryCommand = (QueryCommand)command;
        if (aNode.getProjection() != null && aNode.getProjection().length > 0) {
            Query newCommand = (Query)queryCommand.clone();
            newCommand.getSelect().setSymbols(aNode.getOriginalSelect());
            return newCommand;
        }
        return queryCommand;
    }

    private void handleException(TeiidComponentException e) {
        this.valid = false;
        this.exception = e;
        this.setAbort(true);
    }

    public TeiidComponentException getException() {
        return this.exception;
    }

    private void markInvalid(LanguageObject object, String reason) {
        this.valid = false;
        this.setAbort(true);
        if (this.analysisRecord != null && this.analysisRecord.recordAnnotations()) {
            try {
                this.analysisRecord.addAnnotation("Relational Planner", reason + " " + this.metadata.getName(this.modelID), object + " was not pushed", Annotation.Priority.LOW);
            }
            catch (QueryMetadataException e) {
            }
            catch (TeiidComponentException teiidComponentException) {
                // empty catch block
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public static boolean canPushLanguageObject(LanguageObject obj, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        return CriteriaCapabilityValidatorVisitor.canPushLanguageObject(obj, modelID, metadata, capFinder, analysisRecord, false);
    }

    public static boolean canPushLanguageObject(LanguageObject obj, Object modelID, final QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, boolean isJoin) throws QueryMetadataException, TeiidComponentException {
        if (obj == null) {
            return true;
        }
        if (modelID == null || metadata.isVirtualModel(modelID)) {
            return false;
        }
        String modelName = metadata.getFullName(modelID);
        SourceCapabilities caps = capFinder.findCapabilities(modelName);
        if (caps == null) {
            return true;
        }
        CriteriaCapabilityValidatorVisitor visitor = new CriteriaCapabilityValidatorVisitor(modelID, metadata, capFinder, caps);
        visitor.analysisRecord = analysisRecord;
        visitor.isJoin = isJoin;
        final EvaluatableVisitor ev = new EvaluatableVisitor(modelID, metadata, capFinder);
        PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(visitor, false, false){

            @Override
            public void visit(DependentSetCriteria obj1) {
                if (obj1.hasMultipleAttributes()) {
                    Array array = (Array)obj1.getExpression();
                    this.visitNodes(array.getExpressions());
                    super.postVisitVisitor(obj1);
                } else {
                    super.visit(obj1);
                }
            }

            @Override
            protected void visitNode(LanguageObject obj) {
                if (obj == null) {
                    return;
                }
                FunctionMethod.Determinism d = ev.getDeterminismLevel();
                boolean pushDown = ev.requiresEvaluation(EvaluatableVisitor.EvaluationLevel.PUSH_DOWN);
                ev.reset();
                super.visitNode(obj);
                ev.setDeterminismLevel(d);
                if (pushDown) {
                    ev.evaluationNotPossible(EvaluatableVisitor.EvaluationLevel.PUSH_DOWN);
                }
            }

            @Override
            protected void visitVisitor(LanguageObject obj) {
                if (obj == null) {
                    return;
                }
                if (!ev.requiresEvaluation(EvaluatableVisitor.EvaluationLevel.PUSH_DOWN) && ev.getDeterminismLevel() != FunctionMethod.Determinism.NONDETERMINISTIC) {
                    Function f;
                    ElementSymbol es;
                    if (obj instanceof ElementSymbol && (es = (ElementSymbol)obj).getMetadataID() != null) {
                        try {
                            if (metadata.isMultiSourceElement(es.getMetadataID())) {
                                return;
                            }
                        }
                        catch (QueryMetadataException e) {
                        }
                        catch (TeiidComponentException teiidComponentException) {
                            // empty catch block
                        }
                    }
                    obj.acceptVisitor(ev);
                    if (obj instanceof Expression && (obj instanceof Function ? !(obj instanceof AggregateSymbol) && (f = (Function)obj).getFunctionDescriptor().getPushdown() != FunctionMethod.PushDown.MUST_PUSHDOWN && f.getFunctionDescriptor().getDeterministic() != FunctionMethod.Determinism.NONDETERMINISTIC : obj instanceof Criteria && !(obj instanceof SubqueryContainer) && !(obj instanceof DependentSetCriteria))) {
                        return;
                    }
                }
                super.visitVisitor(obj);
            }
        };
        obj.acceptVisitor(nav);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
        return visitor.isValid();
    }

    static {
        parseFormat.add("parsebigdecimal");
        parseFormat.add("formatbigdecimal");
        parseFormat.add("parsetimestamp");
        parseFormat.add("formattimestamp");
    }
}

