/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.ArrayAgg;
import org.teiid.query.function.aggregate.Avg;
import org.teiid.query.function.aggregate.ConstantFunction;
import org.teiid.query.function.aggregate.Count;
import org.teiid.query.function.aggregate.JSONArrayAgg;
import org.teiid.query.function.aggregate.Max;
import org.teiid.query.function.aggregate.Min;
import org.teiid.query.function.aggregate.RankingFunction;
import org.teiid.query.function.aggregate.StatsFunction;
import org.teiid.query.function.aggregate.StringAgg;
import org.teiid.query.function.aggregate.Sum;
import org.teiid.query.function.aggregate.TextAgg;
import org.teiid.query.function.aggregate.UserDefined;
import org.teiid.query.function.aggregate.XMLAgg;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class GroupingNode
extends SubqueryAwareRelationalNode {
    private List<OrderByItem> orderBy;
    private boolean removeDuplicates;
    private SymbolMap outputMapping;
    private int phase = 1;
    private Map<Expression, Integer> elementMap;
    private LinkedHashMap<Expression, Integer> collectedExpressions;
    private int distinctCols = -1;
    private SortUtility sortUtility;
    private TupleBuffer sortBuffer;
    private TupleSource groupTupleSource;
    private AggregateFunction[][] functions;
    private List<?> lastRow;
    private List<?> currentGroupTuple;
    private STree tree;
    private AggregateFunction[] groupSortfunctions;
    private int[] accumulatorStateCount;
    private TupleSource groupSortTupleSource;
    private int[] projection;
    private static final int COLLECTION = 1;
    private static final int SORT = 2;
    private static final int GROUP = 3;
    private static final int GROUP_SORT = 4;
    private static final int GROUP_SORT_OUTPUT = 5;
    private int[] indexes;
    private boolean rollup;
    private HashMap<Integer, Integer> indexMap;

    public GroupingNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.phase = 1;
        this.sortUtility = null;
        this.sortBuffer = null;
        this.lastRow = null;
        this.currentGroupTuple = null;
        if (this.functions != null) {
            AggregateFunction[][] aggregateFunctionArray = this.functions;
            int n = aggregateFunctionArray.length;
            for (int i = 0; i < n; ++i) {
                AggregateFunction[] functions;
                for (AggregateFunction function : functions = aggregateFunctionArray[i]) {
                    function.reset();
                }
            }
        }
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public void setOrderBy(List<OrderByItem> orderBy) {
        this.orderBy = orderBy;
    }

    public void setOutputMapping(SymbolMap outputMapping) {
        this.outputMapping = outputMapping;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.functions != null) {
            return;
        }
        List<? extends Expression> sourceElements = this.getChildren()[0].getElements();
        this.elementMap = GroupingNode.createLookupMap(sourceElements);
        this.collectedExpressions = new LinkedHashMap();
        if (this.orderBy != null) {
            for (OrderByItem orderByItem : this.orderBy) {
                Expression ex = SymbolMap.getExpression(orderByItem.getSymbol());
                GroupingNode.getIndex(ex, this.collectedExpressions);
            }
            if (this.removeDuplicates) {
                for (Expression expression : sourceElements) {
                    GroupingNode.getIndex(expression, this.collectedExpressions);
                }
                this.distinctCols = this.collectedExpressions.size();
            }
        }
        this.functions = new AggregateFunction[this.getElements().size()][];
        for (int i = 0; i < this.getElements().size(); ++i) {
            void var6_13;
            Expression expression = this.getElements().get(i);
            if (this.outputMapping != null) {
                Expression expression2 = this.outputMapping.getMappedExpression((ElementSymbol)expression);
            }
            Class<?> outputType = var6_13.getType();
            if (var6_13 instanceof AggregateSymbol) {
                AggregateSymbol aggSymbol = (AggregateSymbol)var6_13;
                this.functions[i] = new AggregateFunction[this.rollup ? this.orderBy.size() + 1 : 1];
                for (int j = 0; j < this.functions[i].length; ++j) {
                    this.functions[i][j] = GroupingNode.initAccumulator(aggSymbol, this, this.collectedExpressions);
                }
                continue;
            }
            ConstantFunction af = new ConstantFunction();
            af.setArgIndexes(new int[]{this.collectedExpressions.get(var6_13)});
            ((AggregateFunction)af).initialize(outputType, new Class[]{var6_13.getType()});
            this.functions[i] = new AggregateFunction[]{af};
        }
    }

    static Integer getIndex(Expression ex, LinkedHashMap<Expression, Integer> expressionIndexes) {
        Integer index = expressionIndexes.get(ex);
        if (index == null) {
            index = expressionIndexes.size();
            expressionIndexes.put(ex, index);
        }
        return index;
    }

    static AggregateFunction initAccumulator(AggregateSymbol aggSymbol, RelationalNode node, LinkedHashMap<Expression, Integer> expressionIndexes) {
        int[] argIndexes = new int[aggSymbol.getArgs().length];
        AggregateFunction result = null;
        Expression[] args = aggSymbol.getArgs();
        Class[] inputTypes = new Class[args.length];
        for (int j = 0; j < args.length; ++j) {
            inputTypes[j] = args[j].getType();
            argIndexes[j] = GroupingNode.getIndex(args[j], expressionIndexes);
        }
        AggregateSymbol.Type function = aggSymbol.getAggregateFunction();
        switch (function) {
            case RANK: 
            case DENSE_RANK: {
                result = new RankingFunction(function);
                break;
            }
            case ROW_NUMBER: 
            case COUNT: {
                result = new Count();
                break;
            }
            case SUM: {
                result = new Sum();
                break;
            }
            case AVG: {
                result = new Avg();
                break;
            }
            case MIN: {
                result = new Min();
                break;
            }
            case MAX: {
                result = new Max();
                break;
            }
            case XMLAGG: {
                result = new XMLAgg();
                break;
            }
            case ARRAY_AGG: {
                result = new ArrayAgg();
                break;
            }
            case JSONARRAY_AGG: {
                result = new JSONArrayAgg();
                break;
            }
            case TEXTAGG: {
                result = new TextAgg((TextLine)args[0]);
                break;
            }
            case STRING_AGG: {
                result = new StringAgg(aggSymbol.getType() == DataTypeManager.DefaultDataClasses.BLOB);
                break;
            }
            case USER_DEFINED: {
                result = new UserDefined(aggSymbol.getFunctionDescriptor());
                break;
            }
            default: {
                result = new StatsFunction(function);
            }
        }
        if (aggSymbol.getOrderBy() != null) {
            int numOrderByItems = aggSymbol.getOrderBy().getOrderByItems().size();
            ArrayList<OrderByItem> orderByItems = new ArrayList<OrderByItem>(numOrderByItems);
            List<ElementSymbol> schema = GroupingNode.createSortSchema(result, inputTypes);
            argIndexes = Arrays.copyOf(argIndexes, argIndexes.length + numOrderByItems);
            ListIterator<OrderByItem> iterator = aggSymbol.getOrderBy().getOrderByItems().listIterator();
            while (iterator.hasNext()) {
                OrderByItem item = iterator.next();
                argIndexes[args.length + iterator.previousIndex()] = GroupingNode.getIndex(item.getSymbol(), expressionIndexes);
                ElementSymbol element = new ElementSymbol(String.valueOf(iterator.previousIndex()));
                element.setType(item.getSymbol().getType());
                schema.add(element);
                OrderByItem newItem = item.clone();
                newItem.setSymbol(element);
                orderByItems.add(newItem);
            }
            SortingFilter filter = new SortingFilter(result, node.getBufferManager(), node.getConnectionID(), aggSymbol.isDistinct());
            filter.setElements(schema);
            filter.setSortItems(orderByItems);
            result = filter;
        } else if (aggSymbol.isDistinct()) {
            SortingFilter filter = new SortingFilter(result, node.getBufferManager(), node.getConnectionID(), true);
            List<ElementSymbol> elements = GroupingNode.createSortSchema(result, inputTypes);
            filter.setElements(elements);
            result = filter;
        }
        result.setArgIndexes(argIndexes);
        if (aggSymbol.getCondition() != null) {
            result.setConditionIndex(GroupingNode.getIndex(aggSymbol.getCondition(), expressionIndexes));
        }
        result.initialize(aggSymbol.getType(), inputTypes);
        return result;
    }

    private static List<ElementSymbol> createSortSchema(AggregateFunction af, Class<?>[] inputTypes) {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(inputTypes.length);
        int[] filteredArgIndexes = new int[inputTypes.length];
        for (int i = 0; i < inputTypes.length; ++i) {
            ElementSymbol element = new ElementSymbol("val" + i);
            element.setType(inputTypes[i]);
            elements.add(element);
            filteredArgIndexes[i] = i;
        }
        af.setArgIndexes(filteredArgIndexes);
        return elements;
    }

    AggregateFunction[][] getFunctions() {
        return this.functions;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == 1) {
            this.collectionPhase();
        }
        if (this.phase == 2) {
            this.sortPhase();
        }
        if (this.phase == 3) {
            return this.groupPhase();
        }
        if (this.phase == 4) {
            this.groupSortPhase();
        }
        if (this.phase == 5) {
            return this.groupSortOutputPhase();
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    public TupleSource getGroupSortTupleSource() {
        RelationalNode sourceNode = this.getChildren()[0];
        return new ProjectingTupleSource(sourceNode, this.getEvaluator(this.elementMap), new ArrayList<Expression>(this.collectedExpressions.keySet()), this.elementMap);
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return this.getChildren()[0].getOutputElements();
    }

    /*
     * WARNING - void declaration
     */
    private void collectionPhase() {
        if (this.orderBy == null) {
            this.groupTupleSource = this.getGroupSortTupleSource();
            this.phase = 3;
        } else {
            int i;
            ArrayList<SortSpecification.NullOrdering> nullOrdering = new ArrayList<SortSpecification.NullOrdering>(this.orderBy.size());
            ArrayList<Boolean> sortTypes = new ArrayList<Boolean>(this.orderBy.size());
            int size = this.orderBy.size();
            if (this.removeDuplicates) {
                size = this.distinctCols;
            }
            int[] sortIndexes = new int[size];
            for (i = 0; i < size; ++i) {
                int index = i;
                if (i < this.orderBy.size()) {
                    OrderByItem item = this.orderBy.get(i);
                    nullOrdering.add(item.getNullOrdering());
                    sortTypes.add(item.isAscending());
                    index = this.collectedExpressions.get(SymbolMap.getExpression(item.getSymbol()));
                } else {
                    nullOrdering.add(null);
                    sortTypes.add(true);
                }
                sortIndexes[i] = index;
            }
            this.indexes = Arrays.copyOf(sortIndexes, this.orderBy.size());
            if (this.rollup) {
                this.indexMap = new HashMap();
                for (i = 0; i < this.indexes.length; ++i) {
                    this.indexMap.put(this.indexes[i], this.orderBy.size() - i);
                }
            } else if (!this.removeDuplicates) {
                boolean groupSort = true;
                ArrayList<AggregateFunction> aggs = new ArrayList<AggregateFunction>();
                ArrayList allTypes = new ArrayList();
                this.accumulatorStateCount = new int[this.functions.length];
                for (AggregateFunction[] afs : this.functions) {
                    if (afs[0] instanceof ConstantFunction) continue;
                    aggs.add(afs[0]);
                    List<Class<?>> list = afs[0].getStateTypes();
                    if (list == null) {
                        groupSort = false;
                        break;
                    }
                    this.accumulatorStateCount[aggs.size() - 1] = list.size();
                    allTypes.addAll(list);
                }
                if (groupSort) {
                    this.groupSortfunctions = aggs.toArray(new AggregateFunction[aggs.size()]);
                    ArrayList<Expression> schema = new ArrayList<Expression>();
                    for (OrderByItem item : this.orderBy) {
                        schema.add(SymbolMap.getExpression(item.getSymbol()));
                    }
                    List<? extends Expression> elements = this.getElements();
                    this.projection = new int[elements.size()];
                    int index = 0;
                    for (int i2 = 0; i2 < elements.size(); ++i2) {
                        void var12_21;
                        Expression expression = elements.get(i2);
                        if (this.outputMapping != null) {
                            Expression expression2 = this.outputMapping.getMappedExpression((ElementSymbol)expression);
                        }
                        this.projection[i2] = var12_21 instanceof AggregateSymbol ? schema.size() + index++ : schema.indexOf(var12_21);
                    }
                    for (Class clazz : allTypes) {
                        ElementSymbol es = new ElementSymbol("x");
                        es.setType(clazz);
                        schema.add(es);
                    }
                    this.tree = this.getBufferManager().createSTree(schema, this.getConnectionID(), this.orderBy.size());
                    this.tree.getComparator().setNullOrdering(nullOrdering);
                    this.tree.getComparator().setOrderTypes(sortTypes);
                    this.groupSortTupleSource = this.getGroupSortTupleSource();
                    this.phase = 4;
                    return;
                }
            }
            this.sortUtility = new SortUtility(this.getGroupSortTupleSource(), this.removeDuplicates ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.getBufferManager(), this.getConnectionID(), new ArrayList<Expression>(this.collectedExpressions.keySet()), sortTypes, nullOrdering, sortIndexes);
            this.phase = 2;
        }
    }

    private void groupSortPhase() throws TeiidComponentException, TeiidProcessingException {
        List<?> tuple = null;
        while ((tuple = this.groupSortTupleSource.nextTuple()) != null) {
            List current = this.tree.find(tuple);
            boolean update = false;
            ArrayList<Object> accumulated = new ArrayList<Object>();
            for (int i = 0; i < this.orderBy.size(); ++i) {
                accumulated.add(tuple.get(i));
            }
            if (current != null) {
                update = true;
            }
            int index = this.orderBy.size();
            for (int i = 0; i < this.groupSortfunctions.length; ++i) {
                AggregateFunction aggregateFunction = this.groupSortfunctions[i];
                if (update) {
                    aggregateFunction.setState(current, index);
                } else {
                    aggregateFunction.reset();
                }
                index += this.accumulatorStateCount[i];
                aggregateFunction.addInput(tuple, this.getContext());
                aggregateFunction.getState(accumulated);
            }
            this.tree.insert(accumulated, update ? STree.InsertMode.UPDATE : STree.InsertMode.NEW, -1);
        }
        this.groupSortTupleSource.closeSource();
        this.groupSortTupleSource = this.tree.getTupleSource(true);
        this.phase = 5;
    }

    private TupleBatch groupSortOutputPhase() throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        List<?> tuple = null;
        int size = this.orderBy.size();
        List<Object> vals = Arrays.asList(new Object[size + this.groupSortfunctions.length]);
        while ((tuple = this.groupSortTupleSource.nextTuple()) != null) {
            for (int i = 0; i < size; ++i) {
                vals.set(i, tuple.get(i));
            }
            int index = size;
            for (int i = 0; i < this.groupSortfunctions.length; ++i) {
                AggregateFunction aggregateFunction = this.groupSortfunctions[i];
                aggregateFunction.setState(tuple, index);
                index += this.accumulatorStateCount[i];
                vals.set(size + i, aggregateFunction.getResult(this.getContext()));
            }
            List<Object> result = RelationalNode.projectTuple(this.projection, vals);
            this.addBatchRow(result);
            if (!this.isBatchFull()) continue;
            return this.pullBatch();
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    private void sortPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.sortBuffer = this.sortUtility.sort();
        this.sortBuffer.setForwardOnly(true);
        this.groupTupleSource = this.sortBuffer.createIndexedTupleSource();
        this.phase = 3;
    }

    private TupleBatch groupPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        CommandContext context = this.getContext();
        while (true) {
            if (this.currentGroupTuple == null) {
                this.currentGroupTuple = this.groupTupleSource.nextTuple();
                if (this.currentGroupTuple == null) break;
            }
            if (this.lastRow == null) {
                this.lastRow = this.currentGroupTuple;
            } else {
                int colDiff = GroupingNode.sameGroup(this.indexes, this.currentGroupTuple, this.lastRow);
                if (colDiff != -1) {
                    this.closeGroup(colDiff, true, context);
                    this.lastRow = this.currentGroupTuple;
                    if (this.isBatchFull()) {
                        return this.pullBatch();
                    }
                }
            }
            this.updateAggregates(this.currentGroupTuple);
            this.currentGroupTuple = null;
        }
        if (this.lastRow != null || this.orderBy == null) {
            this.closeGroup(-1, false, context);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    private void closeGroup(int colDiff, boolean reset, CommandContext context) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        ArrayList<Object> row = new ArrayList<Object>(this.functions.length);
        for (int i = 0; i < this.functions.length; ++i) {
            row.add(this.functions[i][0].getResult(context));
            if (!reset || this.rollup) continue;
            this.functions[i][0].reset();
        }
        this.addBatchRow(row);
        if (this.rollup) {
            int rollups = this.orderBy.size() - colDiff;
            for (int j = 1; j < rollups; ++j) {
                row = new ArrayList(this.functions.length);
                for (int i = 0; i < this.functions.length; ++i) {
                    if (this.functions[i].length == 1) {
                        int index = this.functions[i][0].getArgIndexes()[0];
                        Integer val = this.indexMap.get(index);
                        if (val != null && val <= j) {
                            row.add(null);
                            continue;
                        }
                        row.add(this.functions[i][0].getResult(context));
                        continue;
                    }
                    row.add(this.functions[i][j].getResult(context));
                    if (!reset) continue;
                    this.functions[i][j].reset();
                }
                this.addBatchRow(row);
            }
            if (reset) {
                for (int i = 0; i < this.functions.length; ++i) {
                    this.functions[i][0].reset();
                }
            }
        }
    }

    public static int sameGroup(int[] indexes, List<?> newTuple, List<?> oldTuple) {
        if (indexes == null) {
            return -1;
        }
        return MergeJoinStrategy.compareTuples(newTuple, oldTuple, indexes, indexes, true, true);
    }

    private void updateAggregates(List<?> tuple) throws TeiidComponentException, TeiidProcessingException {
        for (int i = 0; i < this.functions.length; ++i) {
            for (AggregateFunction function : this.functions[i]) {
                function.addInput(tuple, this.getContext());
            }
        }
    }

    @Override
    public void closeDirect() {
        if (this.sortBuffer != null) {
            this.sortBuffer.remove();
            this.sortBuffer = null;
        }
        if (this.sortUtility != null) {
            this.sortUtility.remove();
            this.sortUtility = null;
        }
        if (this.tree != null) {
            this.tree.remove();
            this.tree = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.orderBy);
        if (this.outputMapping != null) {
            str.append(this.outputMapping);
        }
    }

    @Override
    public Object clone() {
        GroupingNode clonedNode = new GroupingNode(super.getID());
        super.copyTo(clonedNode);
        clonedNode.removeDuplicates = this.removeDuplicates;
        clonedNode.outputMapping = this.outputMapping;
        clonedNode.orderBy = this.orderBy;
        clonedNode.rollup = this.rollup;
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.orderBy != null) {
            int elements = this.orderBy.size();
            ArrayList<String> groupCols = new ArrayList<String>(elements);
            for (int i = 0; i < elements; ++i) {
                groupCols.add(this.orderBy.get(i).toString());
            }
            props.addProperty("Grouping Columns", groupCols);
        }
        props.addProperty("Sort Mode", String.valueOf(this.removeDuplicates));
        if (this.rollup) {
            props.addProperty("Rollup", Boolean.TRUE.toString());
        }
        return props;
    }

    public void setRollup(boolean rollup) {
        this.rollup = rollup;
    }

    static class ProjectingTupleSource
    extends BatchCollector.BatchProducerTupleSource {
        private Evaluator eval;
        private List<Expression> collectedExpressions;
        private int[] projectionIndexes;

        ProjectingTupleSource(BatchCollector.BatchProducer sourceNode, Evaluator eval, List<Expression> expressions, Map<Expression, Integer> elementMap) {
            super(sourceNode);
            this.eval = eval;
            this.collectedExpressions = expressions;
            this.projectionIndexes = new int[this.collectedExpressions.size()];
            Arrays.fill(this.projectionIndexes, -1);
            for (int i = 0; i < expressions.size(); ++i) {
                Integer index = elementMap.get(expressions.get(i));
                if (index == null) continue;
                this.projectionIndexes[i] = index;
            }
        }

        protected List<Object> updateTuple(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
            int columns = this.collectedExpressions.size();
            ArrayList<Object> exprTuple = new ArrayList<Object>(columns);
            for (int col = 0; col < columns; ++col) {
                int index = this.projectionIndexes[col];
                Object value = null;
                value = index != -1 ? (Object)tuple.get(index) : this.eval.evaluate(this.collectedExpressions.get(col), tuple);
                exprTuple.add(value);
            }
            return exprTuple;
        }
    }
}

