/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

public class Insert
extends ProcedureContainer {
    private GroupSymbol group;
    private List<ElementSymbol> variables = new LinkedList<ElementSymbol>();
    private List<Expression> values = new LinkedList<Expression>();
    private QueryCommand queryExpression;
    private TupleSource tupleSource;
    private Criteria constraint;
    private boolean merge;

    public Insert() {
    }

    @Override
    public int getType() {
        return 2;
    }

    public Insert(GroupSymbol group, List<ElementSymbol> variables, List values) {
        this.group = group;
        this.variables = variables;
        this.values = values;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.group;
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    public List<ElementSymbol> getVariables() {
        return this.variables;
    }

    public void addVariable(ElementSymbol var) {
        this.variables.add(var);
    }

    public void addVariables(Collection<ElementSymbol> vars) {
        this.variables.addAll(vars);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setVariables(Collection<ElementSymbol> vars) {
        this.variables.clear();
        this.variables.addAll(vars);
    }

    public void addValue(Expression value) {
        this.values.add(value);
    }

    public void setQueryExpression(QueryCommand query) {
        Query expr;
        if (query instanceof Query && (expr = (Query)query).isRowConstructor()) {
            this.values.clear();
            this.queryExpression = null;
            for (Expression ex : expr.getSelect().getSymbols()) {
                this.addValue(SymbolMap.getExpression(ex));
            }
            if (expr.getOption() != null && this.getOption() == null) {
                this.setOption(expr.getOption());
            }
            return;
        }
        this.queryExpression = query;
    }

    public QueryCommand getQueryExpression() {
        return this.queryExpression;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.group});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.variables});
        return myHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Insert)) {
            return false;
        }
        Insert other = (Insert)obj;
        return EquivalenceUtil.areEqual((Object)this.getGroup(), (Object)other.getGroup()) && EquivalenceUtil.areEqual((Object)this.getValues(), (Object)other.getValues()) && EquivalenceUtil.areEqual(this.getVariables(), other.getVariables()) && this.sameOptionAndHint(other) && EquivalenceUtil.areEqual((Object)this.getQueryExpression(), (Object)other.getQueryExpression()) && this.merge == other.merge;
    }

    @Override
    public Object clone() {
        GroupSymbol copyGroup = null;
        if (this.group != null) {
            copyGroup = this.group.clone();
        }
        ArrayList<ElementSymbol> copyVars = LanguageObject.Util.deepClone(this.getVariables(), ElementSymbol.class);
        ArrayList<Expression> copyVals = null;
        if (this.getValues() != null) {
            copyVals = LanguageObject.Util.deepClone(this.getValues(), Expression.class);
        }
        Insert copy = new Insert(copyGroup, copyVars, copyVals);
        if (this.queryExpression != null) {
            copy.setQueryExpression((QueryCommand)this.queryExpression.clone());
        }
        this.copyMetadataState(copy);
        if (this.constraint != null) {
            copy.constraint = (Criteria)this.constraint.clone();
        }
        copy.merge = this.merge;
        return copy;
    }

    @Override
    public List<Expression> getProjectedSymbols() {
        return Command.getUpdateCommandSymbol();
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public TupleSource getTupleSource() {
        return this.tupleSource;
    }

    public Criteria getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Criteria constraint) {
        this.constraint = constraint;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }
}

