/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.TreeSet;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class EvaluatableVisitor
extends LanguageVisitor {
    private TreeSet<EvaluationLevel> levels = new TreeSet();
    private EvaluationLevel targetLevel;
    private FunctionMethod.Determinism determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
    private boolean hasCorrelatedReferences;
    private Object modelId;
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder capFinder;

    public EvaluatableVisitor() {
    }

    public EvaluatableVisitor(Object modelId, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) {
        this.modelId = modelId;
        this.metadata = metadata;
        this.capFinder = capFinder;
    }

    @Override
    public void visit(Function obj) {
        FunctionDescriptor fd = obj.getFunctionDescriptor();
        this.setDeterminismLevel(fd.getDeterministic());
        if (fd.getDeterministic() == FunctionMethod.Determinism.NONDETERMINISTIC || fd.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN) {
            if (obj.isEval()) {
                this.evaluationNotPossible(EvaluationLevel.PROCESSING);
            } else {
                this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
            }
        } else if (obj.getName().equalsIgnoreCase("lookup") || fd.getDeterministic().compareTo((Enum)FunctionMethod.Determinism.COMMAND_DETERMINISTIC) <= 0) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        } else if (fd.getProcedure() != null) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        }
    }

    @Override
    public void visit(Constant obj) {
        if (obj.isMultiValued()) {
            this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        }
    }

    public void setDeterminismLevel(FunctionMethod.Determinism value) {
        if (this.determinismLevel == null || value.compareTo((Enum)this.determinismLevel) < 0) {
            this.determinismLevel = value;
        }
    }

    public void evaluationNotPossible(EvaluationLevel newLevel) {
        this.levels.add(newLevel);
        EvaluationLevel level = this.levels.last();
        if (this.targetLevel != null && level.compareTo(this.targetLevel) > 0) {
            this.setAbort(true);
        }
    }

    @Override
    public void visit(ElementSymbol obj) {
        TempMetadataID tid;
        if (obj.getGroupSymbol() == null) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
            return;
        }
        if (obj.getGroupSymbol().getMetadataID() instanceof TempMetadataID && (tid = (TempMetadataID)obj.getGroupSymbol().getMetadataID()).isScalarGroup()) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
            return;
        }
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(AliasSymbol obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(AggregateSymbol obj) {
        if (obj.getFunctionDescriptor() != null) {
            this.setDeterminismLevel(obj.getFunctionDescriptor().getDeterministic());
        }
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(Reference obj) {
        this.hasCorrelatedReferences |= obj.isCorrelated();
        if (obj.isPositional()) {
            this.setDeterminismLevel(FunctionMethod.Determinism.COMMAND_DETERMINISTIC);
        } else if (this.modelId != null) {
            this.setDeterminismLevel(FunctionMethod.Determinism.NONDETERMINISTIC);
        }
        this.evaluationNotPossible(EvaluationLevel.PROCESSING);
    }

    @Override
    public void visit(StoredProcedure proc) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        for (SPParameter param : proc.getInputParameters()) {
            if (param.getExpression() instanceof Constant) continue;
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        if (obj.shouldEvaluate()) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        } else {
            this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        }
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.setDeterminismLevel(FunctionMethod.Determinism.NONDETERMINISTIC);
        this.evaluationNotPossible(EvaluationLevel.PROCESSING);
    }

    @Override
    public void visit(ExistsCriteria obj) {
        if (obj.shouldEvaluate()) {
            this.evaluationNotPossible(EvaluationLevel.PROCESSING);
        } else {
            this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.evaluationNotPossible(EvaluationLevel.PUSH_DOWN);
    }

    private boolean isEvaluationPossible() {
        if (this.levels.isEmpty()) {
            return true;
        }
        return this.levels.last().compareTo(this.targetLevel) <= 0;
    }

    public static final boolean willBecomeConstant(LanguageObject obj) {
        return EvaluatableVisitor.willBecomeConstant(obj, false);
    }

    public static final boolean isFullyEvaluatable(LanguageObject obj, boolean duringPlanning) {
        return EvaluatableVisitor.isEvaluatable(obj, duringPlanning ? EvaluationLevel.PLANNING : EvaluationLevel.PROCESSING);
    }

    public static final boolean isEvaluatable(LanguageObject obj, EvaluationLevel target) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        visitor.targetLevel = target;
        PreOrderNavigator.doVisit(obj, visitor);
        return visitor.isEvaluationPossible();
    }

    public static final boolean willBecomeConstant(LanguageObject obj, boolean pushdown) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        visitor.targetLevel = EvaluationLevel.PROCESSING;
        PreOrderNavigator.doVisit(obj, visitor);
        if (pushdown && (visitor.hasCorrelatedReferences || visitor.determinismLevel == FunctionMethod.Determinism.NONDETERMINISTIC)) {
            return false;
        }
        return visitor.isEvaluationPossible();
    }

    public static final boolean needsProcessingEvaluation(LanguageObject obj) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        DeepPreOrderNavigator.doVisit(obj, visitor);
        return visitor.levels.contains((Object)EvaluationLevel.PROCESSING);
    }

    public boolean requiresEvaluation(EvaluationLevel evaluationLevel) {
        return this.levels.contains((Object)evaluationLevel);
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.determinismLevel;
    }

    public boolean hasCorrelatedReferences() {
        return this.hasCorrelatedReferences;
    }

    public static final EvaluatableVisitor needsEvaluation(LanguageObject obj, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) {
        EvaluatableVisitor visitor = new EvaluatableVisitor();
        visitor.modelId = modelID;
        visitor.metadata = metadata;
        visitor.capFinder = capFinder;
        DeepPreOrderNavigator.doVisit(obj, visitor);
        return visitor;
    }

    public void reset() {
        this.determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
        this.levels.clear();
    }

    public static enum EvaluationLevel {
        PLANNING,
        PROCESSING,
        PUSH_DOWN;

    }
}

