/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.ColumnMaskingHelper;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RowBasedSecurityHelper;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleDecomposeJoin;
import org.teiid.query.optimizer.relational.rules.RuleMergeVirtual;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.optimizer.relational.rules.RulePushAggregates;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RuleApplySecurity
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64)) {
                Criteria filter;
                GroupSymbol group = sourceNode.getGroups().iterator().next();
                if (!RowBasedSecurityHelper.applyRowSecurity(metadata, group, context)) continue;
                List<Expression> cols = null;
                Command command = (Command)sourceNode.getProperty(NodeConstants.Info.VIRTUAL_COMMAND);
                if (group.isProcedure()) {
                    if (command == null) continue;
                    if (cols == null) {
                        cols = command.getProjectedSymbols();
                    }
                } else if (command != null && !command.returnsResultSet()) continue;
                if (cols == null) {
                    cols = ResolverUtil.resolveElementsInGroup(group, metadata);
                }
                List<? extends Expression> masked = ColumnMaskingHelper.maskColumns(cols, group, metadata, context);
                HashMap<Expression, Expression> mapping = null;
                ArrayList windowFunctions = new ArrayList(2);
                for (int i = 0; i < masked.size(); ++i) {
                    Expression maskedCol = masked.get(i);
                    AggregateSymbolCollectorVisitor.getAggregates(maskedCol, null, null, null, windowFunctions, null);
                    if (maskedCol.equals(cols.get(i))) continue;
                    if (mapping == null) {
                        mapping = new HashMap<Expression, Expression>();
                    }
                    mapping.put(cols.get(i), maskedCol);
                }
                PlanNode parentJoin = NodeEditor.findParent(sourceNode.getParent(), 4, 64);
                if (mapping != null) {
                    PlanNode project = null;
                    if (group.isProcedure()) {
                        project = NodeEditor.findParent(sourceNode, 8);
                        project.setProperty(NodeConstants.Info.PROJECT_COLS, masked);
                    }
                    if (windowFunctions.isEmpty() && RuleMergeVirtual.checkProjectedSymbols(group, parentJoin, metadata, masked, Collections.singleton(group), true)) {
                        if (!group.isProcedure()) {
                            FrameUtil.convertFrame(sourceNode.getParent(), group, Collections.singleton(group), mapping, metadata);
                        }
                    } else {
                        if (!group.isProcedure()) {
                            project = RelationalPlanner.createProjectNode(masked);
                        }
                        rules.getPlanner().planSubqueries(null, sourceNode.getGroups(), project, project.getSubqueryContainers(), true);
                        project.addGroups(GroupsUsedByElementsVisitor.getGroups(project.getCorrelatedReferenceElements()));
                        if (!group.isProcedure()) {
                            PlanNode root = sourceNode;
                            if (sourceNode.getParent().getType() == 1) {
                                root = sourceNode.getParent();
                            }
                            root.addAsParent(project);
                            this.addView(metadata, context, group, cols, masked, project);
                            parentJoin = null;
                        }
                    }
                    if (!windowFunctions.isEmpty() && project != null) {
                        project.setProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS, true);
                    }
                }
                if ((filter = RowBasedSecurityHelper.getRowBasedFilters(metadata, group, context, false)) == null) continue;
                List<Criteria> crits = Criteria.separateCriteriaByAnd(filter);
                PlanNode root = sourceNode;
                if (sourceNode.getParent().getType() == 1) {
                    root = sourceNode.getParent();
                }
                PlanNode parent = null;
                for (Criteria crit : crits) {
                    PlanNode critNode = RelationalPlanner.createSelectNode(crit, false);
                    if (parent == null) {
                        parent = critNode;
                    }
                    rules.getPlanner().planSubqueries(null, sourceNode.getGroups(), critNode, critNode.getSubqueryContainers(), true);
                    critNode.addGroups(GroupsUsedByElementsVisitor.getGroups(critNode.getCorrelatedReferenceElements()));
                    root.addAsParent(critNode);
                }
                if (RuleMergeVirtual.checkJoinCriteria(parent, group, parentJoin)) continue;
                PlanNode project = RelationalPlanner.createProjectNode(cols);
                parent.addAsParent(project);
                this.addView(metadata, context, group, cols, cols, project);
            }
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e);
        }
        return plan;
    }

    private void addView(QueryMetadataInterface metadata, CommandContext context, GroupSymbol group, List<ElementSymbol> cols, List<? extends Expression> old, PlanNode viewRoot) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        GroupSymbol securityVeiw = new GroupSymbol("sec");
        Set<String> groups = context.getGroups();
        securityVeiw = RulePlaceAccess.recontextSymbol(securityVeiw, groups);
        List<ElementSymbol> newCols = RulePushAggregates.defineNewGroup(securityVeiw, old, metadata);
        PlanNode newSourceNode = RuleDecomposeJoin.createSource(securityVeiw, viewRoot, newCols);
        Map<ElementSymbol, Expression> upperMapping = SymbolMap.createSymbolMap(cols, newCols).asMap();
        FrameUtil.convertFrame(newSourceNode.getParent(), group, Collections.singleton(securityVeiw), upperMapping, metadata);
    }

    public String toString() {
        return "ApplySecurity";
    }
}

