/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeSet;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.language.SortSpecification;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.Expression;

public class SortUtility {
    private TupleSource source;
    private Mode mode;
    private BufferManager bufferManager;
    private String groupName;
    private List<? extends Expression> schema;
    private int schemaSize;
    private int batchSize;
    private ListNestedSortComparator comparator;
    private int targetRowCount;
    private boolean doneReading;
    private int phase = 1;
    private List<TupleBuffer> activeTupleBuffers = new ArrayList<TupleBuffer>();
    private static final int INITIAL_SORT = 1;
    private static final int MERGE = 2;
    private static final int DONE = 3;
    private TupleBuffer workingBuffer;
    private long[] attempts = new long[2];
    private boolean nonBlocking;
    private static boolean STABLE_SORT = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.requireStableSort", (boolean)false);
    private boolean stableSort = STABLE_SORT;

    public SortUtility(TupleSource sourceID, List<OrderByItem> items, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema) {
        List<? extends Expression> sortElements = null;
        List<Boolean> sortTypes = null;
        ArrayList<SortSpecification.NullOrdering> nullOrderings = null;
        int distinctIndex = -1;
        if (items == null) {
            sortElements = schema;
            sortTypes = Collections.nCopies(sortElements.size(), true);
        } else {
            sortElements = new ArrayList<Expression>(items.size());
            sortTypes = new ArrayList<Boolean>(items.size());
            nullOrderings = new ArrayList<SortSpecification.NullOrdering>(items.size());
            for (OrderByItem orderByItem : items) {
                sortElements.add(orderByItem.getSymbol());
                sortTypes.add(orderByItem.isAscending());
                nullOrderings.add(orderByItem.getNullOrdering());
            }
            if (items.size() < schema.size() && mode == Mode.DUP_REMOVE_SORT) {
                ArrayList<? extends Expression> toAdd = new ArrayList<Expression>(schema);
                toAdd.removeAll(sortElements);
                sortElements.addAll(toAdd);
                sortTypes.addAll(Collections.nCopies(sortElements.size() - sortTypes.size(), true));
                nullOrderings.addAll(Collections.nCopies(sortElements.size() - nullOrderings.size(), null));
                distinctIndex = items.size() - 1;
            }
        }
        int[] cols = new int[sortElements.size()];
        ListIterator<? extends Expression> iter = sortElements.listIterator();
        while (iter.hasNext()) {
            Expression elem = iter.next();
            cols[iter.previousIndex()] = schema.indexOf(elem);
            Assertion.assertTrue((cols[iter.previousIndex()] != -1 ? 1 : 0) != 0);
        }
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
        if (distinctIndex != -1) {
            this.comparator.setDistinctIndex(distinctIndex);
        }
    }

    public SortUtility(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.init(sourceID, mode, bufferMgr, groupName, schema, sortTypes, nullOrderings, cols);
    }

    private void init(TupleSource sourceID, Mode mode, BufferManager bufferMgr, String groupName, List<? extends Expression> schema, List<Boolean> sortTypes, List<SortSpecification.NullOrdering> nullOrderings, int[] cols) {
        this.source = sourceID;
        this.mode = mode;
        this.bufferManager = bufferMgr;
        this.groupName = groupName;
        this.schema = schema;
        this.schemaSize = this.bufferManager.getSchemaSize(this.schema);
        this.batchSize = this.bufferManager.getProcessorBatchSize(this.schema);
        this.targetRowCount = Math.max(this.bufferManager.getMaxProcessingSize() / this.schemaSize, 2) * this.batchSize;
        this.comparator = new ListNestedSortComparator(cols, sortTypes).defaultNullOrder(bufferMgr.getOptions().getDefaultNullOrder());
        int distinctIndex = cols.length - 1;
        this.comparator.setDistinctIndex(distinctIndex);
        this.comparator.setNullOrdering(nullOrderings);
    }

    public SortUtility(TupleSource ts, List<? extends Expression> expressions, List<Boolean> types, Mode mode, BufferManager bufferManager, String connectionID, List schema) {
        this(ts, new OrderBy(expressions, types).getOrderByItems(), mode, bufferManager, connectionID, schema);
    }

    public TupleBuffer sort() throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        try {
            if (this.phase == 1) {
                this.initialSort(false, false);
            }
            if (this.phase == 2) {
                this.mergePhase();
            }
            success = true;
            TupleBuffer tupleBuffer = this.activeTupleBuffers.get(0);
            return tupleBuffer;
        }
        catch (BlockedException e) {
            success = true;
            throw e;
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    public List<TupleBuffer> onePassSort(boolean lowLatency) throws TeiidComponentException, TeiidProcessingException {
        boolean success = false;
        try {
            if (this.phase == 1) {
                this.initialSort(true, lowLatency);
                if (!this.isDoneReading()) {
                    this.phase = 1;
                }
            }
            for (TupleBuffer tb : this.activeTupleBuffers) {
                tb.close();
            }
            success = true;
            List<TupleBuffer> list = this.activeTupleBuffers;
            return list;
        }
        catch (BlockedException e) {
            success = true;
            throw e;
        }
        finally {
            if (!success) {
                this.remove();
            }
        }
    }

    private TupleBuffer createTupleBuffer() throws TeiidComponentException {
        TupleBuffer tb = this.bufferManager.createTupleBuffer(this.schema, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Created intermediate sort buffer", (Object)tb);
        }
        tb.setForwardOnly(true);
        return tb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialSort(boolean onePass, boolean lowLatency) throws TeiidComponentException, TeiidProcessingException {
        block26: {
            block7: while (!this.doneReading) {
                if (this.source != null) {
                    if (this.workingBuffer == null) {
                        this.workingBuffer = this.createTupleBuffer();
                    }
                    while (!this.doneReading) {
                        try {
                            List<?> tuple = this.source.nextTuple();
                            if (tuple == null) {
                                this.doneReading = true;
                                continue block7;
                            }
                            this.workingBuffer.addTuple(tuple);
                            if (!onePass || !lowLatency || this.workingBuffer.getRowCount() <= 2 * this.targetRowCount) continue;
                            break block7;
                        }
                        catch (BlockedException e) {
                            if (!onePass) {
                                throw e;
                            }
                            if (this.workingBuffer.getRowCount() >= this.targetRowCount) break block7;
                            throw e;
                        }
                    }
                    continue;
                }
                this.doneReading = true;
            }
            int totalReservedBuffers = 0;
            try {
                int maxRows = this.batchSize;
                AbstractCollection workingTuples = null;
                boolean done = false;
                this.workingBuffer.close();
                this.schemaSize = Math.max(1, this.workingBuffer.getRowSizeEstimate() * this.batchSize);
                long memorySpaceNeeded = (long)this.workingBuffer.getRowCount() * (long)this.workingBuffer.getRowSizeEstimate();
                totalReservedBuffers = this.bufferManager.reserveBuffers(Math.min(this.bufferManager.getMaxProcessingSize(), (int)Math.min(memorySpaceNeeded, Integer.MAX_VALUE)), BufferManager.BufferReserveMode.FORCE);
                if ((long)totalReservedBuffers != memorySpaceNeeded) {
                    int processingSublists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int desiredSpace = (int)Math.min(Integer.MAX_VALUE, (long)(this.workingBuffer.getRowCount() / processingSublists + this.workingBuffer.getRowCount() % processingSublists) * (long)this.workingBuffer.getRowSizeEstimate());
                    if (desiredSpace > totalReservedBuffers) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers(desiredSpace - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    } else if (memorySpaceNeeded <= Integer.MAX_VALUE) {
                        totalReservedBuffers += this.bufferManager.reserveBuffers((int)memorySpaceNeeded - totalReservedBuffers, BufferManager.BufferReserveMode.NO_WAIT);
                    }
                    if (totalReservedBuffers > this.schemaSize) {
                        int additional = totalReservedBuffers % this.schemaSize;
                        totalReservedBuffers -= additional;
                        this.bufferManager.releaseBuffers(additional);
                    }
                }
                TupleBuffer.TupleBufferTupleSource ts = this.workingBuffer.createIndexedTupleSource(this.source != null);
                ts.setReverse(!this.stableSort && this.workingBuffer.getRowCount() > this.batchSize);
                maxRows = Math.max(1, totalReservedBuffers / this.schemaSize) * this.batchSize;
                workingTuples = this.mode == Mode.SORT ? new ArrayList() : new TreeSet(this.comparator);
                while (!done) {
                    while (!done && workingTuples.size() < maxRows) {
                        List<?> tuple = ts.nextTuple();
                        if (tuple == null) {
                            done = true;
                            if (!workingTuples.isEmpty()) break;
                            break block26;
                        }
                        workingTuples.add(tuple);
                    }
                    TupleBuffer sublist = this.createTupleBuffer();
                    this.activeTupleBuffers.add(sublist);
                    if (this.mode == Mode.SORT) {
                        Collections.sort((List)((Object)workingTuples), this.comparator);
                    }
                    for (List list : workingTuples) {
                        sublist.addTuple(list);
                    }
                    workingTuples.clear();
                    sublist.saveBatch();
                }
            }
            catch (BlockedException e) {
                Assertion.failed((String)"should not block during memory sublist sorting");
            }
            finally {
                this.bufferManager.releaseBuffers(totalReservedBuffers);
                if (this.workingBuffer != null) {
                    if (this.source != null) {
                        this.workingBuffer.remove();
                    }
                    this.workingBuffer = null;
                }
            }
        }
        if (this.activeTupleBuffers.isEmpty()) {
            this.activeTupleBuffers.add(this.createTupleBuffer());
        }
        this.phase = 2;
    }

    public void setWorkingBuffer(TupleBuffer workingBuffer) {
        this.workingBuffer = workingBuffer;
    }

    protected void mergePhase() throws TeiidComponentException, TeiidProcessingException {
        if (this.activeTupleBuffers.size() > 1) {
            this.doMerge();
        }
        Assertion.assertTrue((boolean)this.doneReading);
        this.activeTupleBuffers.get(0).close();
        this.activeTupleBuffers.get(0).setForwardOnly(false);
        this.phase = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge() throws TeiidComponentException, TeiidProcessingException {
        int total;
        int reserved;
        int toForce;
        long desiredSpace;
        block19: {
            desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
            toForce = (int)Math.min(desiredSpace, (long)Math.max(2 * this.schemaSize, this.bufferManager.getMaxProcessingSize()));
            reserved = 0;
            if (desiredSpace > (long)toForce) {
                try {
                    int subLists = Math.max(2, this.bufferManager.getMaxProcessingSize() / this.schemaSize);
                    int twoPass = subLists * subLists;
                    if (twoPass < this.activeTupleBuffers.size()) {
                        int needed;
                        for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.5)); this.activeTupleBuffers.size() / needed + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                        }
                        if ((reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, false)) == 0 && twoPass * subLists < this.activeTupleBuffers.size()) {
                            for (needed = (int)Math.ceil(Math.pow(this.activeTupleBuffers.size(), 0.3333333333333333)); this.activeTupleBuffers.size() / (needed * needed) + this.activeTupleBuffers.size() % needed > needed; ++needed) {
                            }
                            reserved += this.bufferManager.reserveBuffersBlocking(needed * this.schemaSize - toForce, this.attempts, true);
                            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)"performing three pass sort");
                        }
                    } else if (desiredSpace < Integer.MAX_VALUE) {
                        reserved += this.bufferManager.reserveBuffersBlocking((int)desiredSpace - toForce, this.attempts, false);
                    }
                }
                catch (BlockedException be) {
                    if (this.nonBlocking) break block19;
                    throw be;
                }
            }
        }
        if ((total = reserved + toForce) > this.schemaSize) {
            toForce -= total % this.schemaSize;
        }
        reserved += this.bufferManager.reserveBuffers(toForce, BufferManager.BufferReserveMode.FORCE);
        try {
            while (this.activeTupleBuffers.size() > 1) {
                ArrayList<SortedSublist> sublists = new ArrayList<SortedSublist>(this.activeTupleBuffers.size());
                TupleBuffer merged = this.createTupleBuffer();
                desiredSpace = (long)this.activeTupleBuffers.size() * (long)this.schemaSize;
                if (desiredSpace < (long)reserved) {
                    this.bufferManager.releaseBuffers(reserved - (int)desiredSpace);
                    reserved = (int)desiredSpace;
                }
                int maxSortIndex = Math.max(2, reserved / this.schemaSize);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Merging", maxSortIndex, "sublists out of", this.activeTupleBuffers.size()});
                }
                int i = 0;
                while (i < maxSortIndex) {
                    TupleBuffer activeID = this.activeTupleBuffers.get(i);
                    SortedSublist sortedSublist = new SortedSublist();
                    sortedSublist.its = activeID.createIndexedTupleSource();
                    sortedSublist.its.setNoBlocking(true);
                    sortedSublist.index = i++;
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                while (sublists.size() > 0) {
                    SortedSublist sortedSublist = (SortedSublist)sublists.remove(sublists.size() - 1);
                    merged.addTuple(sortedSublist.tuple);
                    this.incrementWorkingTuple(sublists, sortedSublist);
                }
                for (i = 0; i < maxSortIndex; ++i) {
                    TupleBuffer id = this.activeTupleBuffers.remove(0);
                    id.remove();
                }
                merged.saveBatch();
                this.activeTupleBuffers.add(merged);
            }
        }
        finally {
            this.bufferManager.releaseBuffers(reserved);
        }
    }

    private void incrementWorkingTuple(ArrayList<SortedSublist> subLists, SortedSublist sortedSublist) throws TeiidComponentException, TeiidProcessingException {
        int index;
        do {
            sortedSublist.tuple = null;
            if (sortedSublist.limit < sortedSublist.its.getCurrentIndex()) {
                return;
            }
            sortedSublist.tuple = sortedSublist.its.nextTuple();
            if (sortedSublist.tuple == null) {
                return;
            }
            index = Collections.binarySearch(subLists, sortedSublist);
            if (index >= 0) continue;
            subLists.add(-index - 1, sortedSublist);
            return;
        } while (this.mode != Mode.SORT);
        subLists.add(index, sortedSublist);
    }

    public boolean isDistinct() {
        return this.comparator.isDistinct();
    }

    public void remove() {
        if (this.workingBuffer != null && this.source != null) {
            this.workingBuffer.remove();
            this.workingBuffer = null;
        }
        if (!this.activeTupleBuffers.isEmpty()) {
            for (int i = 0; i < this.activeTupleBuffers.size(); ++i) {
                TupleBuffer tb = this.activeTupleBuffers.get(i);
                if (i == 0 && this.phase == 3) continue;
                tb.remove();
            }
            this.activeTupleBuffers.clear();
        }
    }

    public void setNonBlocking(boolean b) {
        this.nonBlocking = b;
    }

    public void setStableSort(boolean stableSort) {
        this.stableSort = stableSort;
    }

    void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isDoneReading() {
        return this.doneReading;
    }

    private class SortedSublist
    implements Comparable<SortedSublist> {
        List<?> tuple;
        int index;
        TupleBuffer.TupleBufferTupleSource its;
        int limit = Integer.MAX_VALUE;

        private SortedSublist() {
        }

        @Override
        public int compareTo(SortedSublist o) {
            return -SortUtility.this.comparator.compare(this.tuple, o.tuple);
        }

        public String toString() {
            return this.index + " " + this.tuple;
        }
    }

    public static enum Mode {
        SORT,
        DUP_REMOVE,
        DUP_REMOVE_SORT;

    }
}

