/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.command.SetQueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class SimpleQueryResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Query query = (Query)command;
        SimpleQueryResolver.resolveWith(metadata, query);
        try {
            QueryResolverVisitor qrv = new QueryResolverVisitor(query, metadata);
            qrv.visit(query);
            ResolverVisitor visitor = (ResolverVisitor)qrv.getVisitor();
            visitor.throwException(true);
            if (visitor.hasUserDefinedAggregate()) {
                ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

                    @Override
                    public Expression replaceExpression(Expression element) {
                        if (element instanceof Function && !(element instanceof AggregateSymbol) && ((Function)element).isAggregate()) {
                            Function f = (Function)element;
                            AggregateSymbol as = new AggregateSymbol(f.getName(), false, f.getArgs(), null);
                            as.setType(f.getType());
                            as.setFunctionDescriptor(f.getFunctionDescriptor());
                            return as;
                        }
                        return element;
                    }
                };
                PreOrPostOrderNavigator.doVisit(query, emv, false);
            }
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryResolverException) {
                throw (QueryResolverException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
        if (query.getLimit() != null) {
            ResolverUtil.resolveLimit(query.getLimit());
        }
        if (query.getOrderBy() != null) {
            ResolverUtil.resolveOrderBy(query.getOrderBy(), query, metadata);
        }
        List<Expression> symbols = query.getSelect().getProjectedSymbols();
        if (query.getInto() != null) {
            GroupSymbol symbol = query.getInto().getGroup();
            ResolverUtil.resolveImplicitTempGroup(metadata, symbol, symbols);
        } else if (resolveNullLiterals) {
            ResolverUtil.resolveNullLiterals(symbols);
        }
    }

    static void resolveWith(TempMetadataAdapter metadata, QueryCommand query) throws QueryResolverException, TeiidComponentException {
        if (query.getWith() == null) {
            return;
        }
        LinkedHashSet<GroupSymbol> discoveredGroups = new LinkedHashSet<GroupSymbol>();
        for (WithQueryCommand obj : query.getWith()) {
            QueryCommand queryExpression = obj.getCommand();
            QueryResolver.setChildMetadata(queryExpression, query);
            QueryCommand recursive = null;
            try {
                QueryResolver.resolveCommand(queryExpression, metadata.getMetadata(), false);
            }
            catch (QueryResolverException e) {
                if (!(queryExpression instanceof SetQuery)) {
                    throw e;
                }
                SetQuery setQuery = (SetQuery)queryExpression;
                if (setQuery.getOperation() != SetQuery.Operation.UNION || setQuery.getLimit() != null || setQuery.getOrderBy() != null || setQuery.getOption() != null) {
                    throw e;
                }
                QueryResolver.resolveCommand(setQuery.getLeftQuery(), metadata.getMetadata(), false);
                recursive = setQuery.getRightQuery();
            }
            if (!discoveredGroups.add(obj.getGroupSymbol())) {
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30101, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30101, new Object[]{obj.getGroupSymbol()}));
            }
            List<Expression> projectedSymbols = obj.getCommand().getProjectedSymbols();
            if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
                if (obj.getColumns().size() != projectedSymbols.size()) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30102, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30102, new Object[]{obj.getGroupSymbol()}));
                }
                Iterator<ElementSymbol> iter = obj.getColumns().iterator();
                for (Expression expression : projectedSymbols) {
                    ElementSymbol es = iter.next();
                    es.setType(expression.getType());
                }
                projectedSymbols = obj.getColumns();
            }
            TempMetadataID id = ResolverUtil.addTempGroup(metadata, obj.getGroupSymbol(), projectedSymbols, true);
            obj.getGroupSymbol().setMetadataID(metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
            obj.getGroupSymbol().setIsTempTable(true);
            List<GroupSymbol> groups = Collections.singletonList(obj.getGroupSymbol());
            if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
                for (Expression singleElementSymbol2 : projectedSymbols) {
                    ResolverVisitor.resolveLanguageObject(singleElementSymbol2, groups, metadata);
                }
            }
            if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
                Iterator<ElementSymbol> iterator = obj.getColumns().iterator();
                for (TempMetadataID colid : id.getElements()) {
                    ElementSymbol es = iterator.next();
                    es.setMetadataID(colid);
                    es.setGroupSymbol(obj.getGroupSymbol());
                }
            }
            if (recursive == null) continue;
            QueryResolver.setChildMetadata(recursive, query);
            QueryResolver.resolveCommand(recursive, metadata.getMetadata(), false);
            new SetQueryResolver().resolveSetQuery(metadata, false, (SetQuery)queryExpression, ((SetQuery)queryExpression).getLeftQuery(), recursive);
            obj.setRecursive(true);
        }
    }

    private static GroupSymbol resolveAllInGroup(MultipleElementSymbol allInGroupSymbol, Set<GroupSymbol> groups, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        String groupAlias = allInGroupSymbol.getGroup().getName();
        List<GroupSymbol> groupSymbols = ResolverUtil.findMatchingGroups(groupAlias, groups, metadata);
        if (groupSymbols.isEmpty() || groupSymbols.size() > 1) {
            String msg = QueryPlugin.Util.getString(groupSymbols.isEmpty() ? "ERR.015.008.0047" : "SimpleQueryResolver.ambiguous_all_in_group", new Object[]{allInGroupSymbol});
            QueryResolverException qre = new QueryResolverException(msg);
            qre.addUnresolvedSymbol(new UnresolvedSymbolDescription(allInGroupSymbol.toString(), msg));
            throw qre;
        }
        allInGroupSymbol.setGroup(groupSymbols.get(0).clone());
        return groupSymbols.get(0);
    }

    public static class QueryResolverVisitor
    extends PostOrderNavigator {
        private LinkedHashSet<GroupSymbol> currentGroups = new LinkedHashSet();
        private LinkedList<GroupSymbol> discoveredGroups = new LinkedList();
        private List<GroupSymbol> implicitGroups = new LinkedList<GroupSymbol>();
        private TempMetadataAdapter metadata;
        private Query query;
        private boolean allowImplicit = true;

        public QueryResolverVisitor(Query query, TempMetadataAdapter metadata) {
            super(new ResolverVisitor(metadata, null, query.getExternalGroupContexts()));
            ResolverVisitor visitor = (ResolverVisitor)this.getVisitor();
            visitor.setGroups(this.currentGroups);
            this.query = query;
            this.metadata = metadata;
        }

        @Override
        protected void postVisitVisitor(LanguageObject obj) {
            super.postVisitVisitor(obj);
            ResolverVisitor visitor = (ResolverVisitor)this.getVisitor();
            try {
                visitor.throwException(false);
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30103, (Throwable)e);
            }
        }

        @Override
        public void visit(Query obj) {
            Object var;
            this.visitNode(obj.getInto());
            this.visitNode(obj.getFrom());
            this.visitNode(obj.getCriteria());
            this.visitNode(obj.getGroupBy());
            this.visitNode(obj.getHaving());
            this.visitNode(obj.getSelect());
            GroupBy groupBy = obj.getGroupBy();
            if (groupBy != null && Boolean.TRUE.equals(var = DQPWorkContext.getWorkContext().getSession().getSessionVariables().get("resolve_groupby_positional"))) {
                for (int i = 0; i < groupBy.getCount(); ++i) {
                    Integer val;
                    List<Expression> select = obj.getSelect().getProjectedSymbols();
                    Expression ex = groupBy.getSymbols().get(i);
                    if (!((ex = SymbolMap.getExpression(ex)) instanceof Constant) || ex.getType() != DataTypeManager.DefaultDataClasses.INTEGER || (val = (Integer)((Constant)ex).getValue()) == null || val <= 0 || val > select.size()) continue;
                    Expression selectExpression = select.get(val - 1);
                    selectExpression = SymbolMap.getExpression(selectExpression);
                    groupBy.getSymbols().set(i, (Expression)selectExpression.clone());
                }
            }
            this.visitNode(obj.getLimit());
        }

        @Override
        public void visit(GroupSymbol obj) {
            try {
                ResolverUtil.resolveGroup(obj, this.metadata);
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((Throwable)err);
            }
        }

        private void resolveSubQuery(SubqueryContainer<?> obj, Collection<GroupSymbol> externalGroups) {
            Object command = obj.getCommand();
            QueryResolver.setChildMetadata(command, this.query);
            ((Command)command).pushNewResolvingContext(externalGroups);
            try {
                QueryResolver.resolveCommand(command, this.metadata.getMetadata(), false);
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((Throwable)err);
            }
        }

        @Override
        public void visit(MultipleElementSymbol obj) {
            try {
                ArrayList<ElementSymbol> elementSymbols = new ArrayList<ElementSymbol>();
                SequencedCollection<GroupSymbol> groups = this.currentGroups;
                if (obj.getGroup() != null) {
                    groups = Arrays.asList(SimpleQueryResolver.resolveAllInGroup(obj, this.currentGroups, this.metadata));
                }
                for (GroupSymbol group : groups) {
                    elementSymbols.addAll(this.resolveSelectableElements(group));
                }
                obj.setElementSymbols(elementSymbols);
            }
            catch (TeiidException err) {
                throw new TeiidRuntimeException((Throwable)err);
            }
        }

        private List<ElementSymbol> resolveSelectableElements(GroupSymbol group) throws QueryMetadataException, TeiidComponentException {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, this.metadata);
            ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(elements.size());
            for (ElementSymbol element : elements) {
                if (!this.metadata.elementSupports(element.getMetadataID(), 0) || this.metadata.isPseudo(element.getMetadataID())) continue;
                element = element.clone();
                element.setGroupSymbol(group);
                result.add(element);
            }
            return result;
        }

        @Override
        public void visit(ScalarSubquery obj) {
            this.resolveSubQuery(obj, this.currentGroups);
        }

        @Override
        public void visit(ExistsCriteria obj) {
            this.resolveSubQuery(obj, this.currentGroups);
        }

        @Override
        public void visit(SubqueryCompareCriteria obj) {
            this.visitNode(obj.getLeftExpression());
            this.resolveSubQuery(obj, this.currentGroups);
            this.postVisitVisitor(obj);
        }

        @Override
        public void visit(SubquerySetCriteria obj) {
            this.visitNode(obj.getExpression());
            this.resolveSubQuery(obj, this.currentGroups);
            this.postVisitVisitor(obj);
        }

        @Override
        public void visit(TextTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNode(obj.getFile());
            try {
                obj.setFile(ResolverUtil.convertExpression(obj.getFile(), "clob", this.metadata));
            }
            catch (QueryResolverException e) {
                throw new TeiidRuntimeException((Throwable)((Object)e));
            }
            this.postTableFunctionReference(obj, saved);
            for (TextTable.TextColumn col : obj.getColumns()) {
                if (col.getWidth() == null) continue;
                obj.setFixedWidth(true);
                break;
            }
        }

        @Override
        public void visit(ArrayTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNode(obj.getArrayValue());
            this.postTableFunctionReference(obj, saved);
        }

        @Override
        public void visit(XMLTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNodes(obj.getPassing());
            this.postTableFunctionReference(obj, saved);
            try {
                ResolverUtil.setDesiredType(obj.getPassing(), obj);
                obj.compileXqueryExpression();
                for (XMLTable.XMLColumn column : obj.getColumns()) {
                    if (column.getDefaultExpression() == null) continue;
                    this.visitNode(column.getDefaultExpression());
                    Expression ex = ResolverUtil.convertExpression(column.getDefaultExpression(), DataTypeManager.getDataTypeName(column.getSymbol().getType()), this.metadata);
                    column.setDefaultExpression(ex);
                }
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }

        @Override
        public void visit(ObjectTable obj) {
            LinkedHashSet<GroupSymbol> saved = this.preTableFunctionReference(obj);
            this.visitNodes(obj.getPassing());
            this.postTableFunctionReference(obj, saved);
            try {
                ResolverUtil.setDesiredType(obj.getPassing(), obj, DataTypeManager.DefaultDataClasses.OBJECT);
                for (ObjectTable.ObjectColumn column : obj.getColumns()) {
                    if (column.getDefaultExpression() == null) continue;
                    this.visitNode(column.getDefaultExpression());
                    Expression ex = ResolverUtil.convertExpression(column.getDefaultExpression(), DataTypeManager.getDataTypeName(column.getSymbol().getType()), this.metadata);
                    column.setDefaultExpression(ex);
                }
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }

        public LinkedHashSet<GroupSymbol> preTableFunctionReference(TableFunctionReference tfr) {
            LinkedHashSet<GroupSymbol> saved = new LinkedHashSet<GroupSymbol>(this.currentGroups);
            if (this.allowImplicit) {
                this.currentGroups.addAll(this.implicitGroups);
            }
            return saved;
        }

        public void postTableFunctionReference(TableFunctionReference obj, LinkedHashSet<GroupSymbol> saved) {
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)obj, false)) {
                if (symbol.isExternalReference() || !this.implicitGroups.contains(symbol.getGroupSymbol())) continue;
                symbol.setIsExternalReference(true);
            }
            if (this.allowImplicit) {
                this.currentGroups.clear();
                this.currentGroups.addAll(saved);
            }
            this.discoveredGroup(obj.getGroupSymbol());
            try {
                ResolverUtil.addTempGroup(this.metadata, obj.getGroupSymbol(), obj.getProjectedSymbols(), false);
            }
            catch (QueryResolverException err) {
                throw new TeiidRuntimeException((Throwable)((Object)err));
            }
            obj.getGroupSymbol().setMetadataID(this.metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(obj.getGroupSymbol());
            for (ElementSymbol symbol : obj.getProjectedSymbols()) {
                try {
                    ResolverVisitor.resolveLanguageObject(symbol, groups, null, this.metadata);
                }
                catch (TeiidException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        }

        @Override
        public void visit(SubqueryFromClause obj) {
            AbstractCollection externalGroups = this.currentGroups;
            if (obj.isTable() && this.allowImplicit) {
                externalGroups = new ArrayList<GroupSymbol>(externalGroups);
                externalGroups.addAll(this.implicitGroups);
            }
            this.resolveSubQuery(obj, externalGroups);
            this.discoveredGroup(obj.getGroupSymbol());
            try {
                ResolverUtil.addTempGroup(this.metadata, obj.getGroupSymbol(), obj.getCommand().getProjectedSymbols(), false);
            }
            catch (QueryResolverException err) {
                throw new TeiidRuntimeException((Throwable)((Object)err));
            }
            obj.getGroupSymbol().setMetadataID(this.metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
        }

        @Override
        public void visit(UnaryFromClause obj) {
            GroupSymbol group = obj.getGroup();
            this.visitNode(group);
            try {
                if (!group.isProcedure() && this.metadata.isXMLGroup(group.getMetadataID())) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30112, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30112, new Object[0]));
                }
                this.discoveredGroup(group);
                if (group.isProcedure()) {
                    this.createProcRelational(obj);
                }
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }

        private void discoveredGroup(GroupSymbol group) {
            this.discoveredGroups.add(group);
            if (this.allowImplicit) {
                this.implicitGroups.add(group);
            }
        }

        private void createProcRelational(UnaryFromClause obj) throws TeiidComponentException, QueryMetadataException, QueryResolverException {
            GroupSymbol group = obj.getGroup();
            String fullName = this.metadata.getFullName(group.getMetadataID());
            String queryName = group.getName();
            StoredProcedureInfo storedProcedureInfo = this.metadata.getStoredProcedureInfoForProcedure(fullName);
            StoredProcedure storedProcedureCommand = new StoredProcedure();
            storedProcedureCommand.setProcedureRelational(true);
            storedProcedureCommand.setProcedureName(fullName);
            List<SPParameter> metadataParams = storedProcedureInfo.getParameters();
            Query procQuery = new Query();
            From from = new From();
            from.addClause(new SubqueryFromClause("X", (Command)storedProcedureCommand));
            procQuery.setFrom(from);
            Select select = new Select();
            select.addSymbol(new MultipleElementSymbol("X"));
            procQuery.setSelect(select);
            LinkedList<String> accessPatternElementNames = new LinkedList<String>();
            int paramIndex = 1;
            for (SPParameter metadataParameter : metadataParams) {
                SPParameter clonedParam = (SPParameter)metadataParameter.clone();
                if (clonedParam.getParameterType() != 1 && metadataParameter.getParameterType() != 3) continue;
                ElementSymbol paramSymbol = clonedParam.getParameterSymbol();
                Reference ref = new Reference(paramSymbol);
                clonedParam.setExpression(ref);
                clonedParam.setIndex(paramIndex++);
                storedProcedureCommand.setParameter(clonedParam);
                String aliasName = paramSymbol.getShortName();
                if (metadataParameter.getParameterType() == 3) {
                    aliasName = aliasName + "_IN";
                }
                AliasSymbol newSymbol = new AliasSymbol(aliasName, new ExpressionSymbol(paramSymbol.getShortName(), ref));
                select.addSymbol(newSymbol);
                accessPatternElementNames.add(queryName + "." + aliasName);
            }
            QueryResolver.resolveCommand(procQuery, this.metadata.getMetadata());
            List<Expression> projectedSymbols = procQuery.getProjectedSymbols();
            TreeSet<String> foundNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Expression ses : projectedSymbols) {
                if (foundNames.add(Symbol.getShortName(ses))) continue;
                throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30114, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30114, new Object[]{fullName}));
            }
            TempMetadataID id = this.metadata.getMetadataStore().getTempGroupID(queryName);
            if (id == null) {
                this.metadata.getMetadataStore().addTempGroup(queryName, projectedSymbols, true);
                id = this.metadata.getMetadataStore().getTempGroupID(queryName);
                id.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
                if (!accessPatternElementNames.isEmpty()) {
                    LinkedList<TempMetadataID> accessPatternIds = new LinkedList<TempMetadataID>();
                    for (String name : accessPatternElementNames) {
                        accessPatternIds.add(this.metadata.getMetadataStore().getTempElementID(name));
                    }
                    id.setAccessPatterns(Arrays.asList(new TempMetadataID("procedure access pattern", accessPatternIds)));
                }
            }
            group.setMetadataID(id);
            obj.setExpandedCommand(procQuery);
        }

        @Override
        public void visit(Into obj) {
            if (!obj.getGroup().isImplicitTempGroupSymbol()) {
                super.visit(obj);
            }
        }

        @Override
        public void visit(JoinPredicate obj) {
            assert (this.currentGroups.isEmpty());
            ArrayList<GroupSymbol> tempImplicitGroups = new ArrayList<GroupSymbol>(this.discoveredGroups);
            this.discoveredGroups.clear();
            this.visitNode(obj.getLeftClause());
            ArrayList<GroupSymbol> leftGroups = new ArrayList<GroupSymbol>(this.discoveredGroups);
            this.discoveredGroups.clear();
            this.visitNode(obj.getRightClause());
            this.discoveredGroups.addAll(leftGroups);
            this.addDiscoveredGroups();
            this.visitNodes(obj.getJoinCriteria());
            this.discoveredGroups.addAll(this.currentGroups);
            this.currentGroups.clear();
            this.discoveredGroups.addAll(tempImplicitGroups);
        }

        private void addDiscoveredGroups() {
            for (GroupSymbol group : this.discoveredGroups) {
                if (this.currentGroups.add(group)) continue;
                String msg = QueryPlugin.Util.getString("ERR.015.008.0046", new Object[]{group.getName()});
                QueryResolverException qre = new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30115, msg);
                qre.addUnresolvedSymbol(new UnresolvedSymbolDescription(group.toString(), msg));
                throw new TeiidRuntimeException((Throwable)((Object)qre));
            }
            this.discoveredGroups.clear();
        }

        @Override
        public void visit(From obj) {
            assert (this.currentGroups.isEmpty());
            for (FromClause clause : obj.getClauses()) {
                this.checkImplicit(clause);
            }
            super.visit(obj);
            this.addDiscoveredGroups();
        }

        private void checkImplicit(FromClause clause) {
            if (clause instanceof JoinPredicate) {
                JoinPredicate jp = (JoinPredicate)clause;
                if (jp.getJoinType() == JoinType.JOIN_FULL_OUTER || jp.getJoinType() == JoinType.JOIN_RIGHT_OUTER) {
                    this.allowImplicit = false;
                    return;
                }
                this.checkImplicit(jp.getLeftClause());
                if (this.allowImplicit) {
                    this.checkImplicit(jp.getRightClause());
                }
            }
        }

        @Override
        public void visit(Limit obj) {
            super.visit(obj);
            if (obj.getOffset() != null) {
                ResolverUtil.setTypeIfNull(obj.getOffset(), DataTypeManager.DefaultDataClasses.INTEGER);
                try {
                    obj.setOffset(ResolverUtil.convertExpression(obj.getOffset(), "integer", this.metadata));
                }
                catch (QueryResolverException e) {
                    throw new TeiidRuntimeException((Throwable)((Object)e));
                }
            }
            if (obj.getRowLimit() != null) {
                ResolverUtil.setTypeIfNull(obj.getRowLimit(), DataTypeManager.DefaultDataClasses.INTEGER);
                try {
                    obj.setRowLimit(ResolverUtil.convertExpression(obj.getRowLimit(), "integer", this.metadata));
                }
                catch (QueryResolverException e) {
                    throw new TeiidRuntimeException((Throwable)((Object)e));
                }
            }
        }
    }
}

