/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class UpdateProcedureResolver
implements CommandResolver {
    public static final List<ElementSymbol> exceptionGroup;

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupContext externalGroups = command.getExternalGroupContexts();
        LinkedList<ElementSymbol> symbols = new LinkedList<ElementSymbol>();
        String countVar = "VARIABLES.ROWCOUNT";
        ElementSymbol updateCount = new ElementSymbol(countVar);
        updateCount.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        symbols.add(updateCount);
        ProcedureContainerResolver.addScalarGroup("VARIABLES", metadata.getMetadataStore(), externalGroups, symbols);
        if (command instanceof TriggerAction) {
            TriggerAction ta = (TriggerAction)command;
            CreateProcedureCommand cmd = new CreateProcedureCommand(ta.getBlock());
            cmd.setVirtualGroup(ta.getView());
            cmd.setUpdateType(2);
            this.resolveBlock(cmd, ta.getBlock(), ta.getExternalGroupContexts(), metadata);
            return;
        }
        CreateProcedureCommand procCommand = (CreateProcedureCommand)command;
        this.resolveBlock(procCommand, procCommand.getBlock(), externalGroups, metadata);
    }

    public void resolveBlock(CreateProcedureCommand command, Block block, GroupContext originalExternalGroups, TempMetadataAdapter original) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving block", block});
        TempMetadataStore store = original.getMetadataStore().clone();
        TempMetadataAdapter metadata = new TempMetadataAdapter(original.getMetadata(), store);
        GroupContext externalGroups = new GroupContext(originalExternalGroups, null);
        GroupSymbol variables = ProcedureContainerResolver.addScalarGroup("VARIABLES", store, externalGroups, new LinkedList());
        for (Statement statement : block.getStatements()) {
            this.resolveStatement(command, statement, externalGroups, variables, metadata);
        }
        if (block.getExceptionGroup() != null) {
            store = original.getMetadataStore().clone();
            metadata = new TempMetadataAdapter(original.getMetadata(), store);
            externalGroups = new GroupContext(originalExternalGroups, null);
            variables = ProcedureContainerResolver.addScalarGroup("VARIABLES", store, externalGroups, new LinkedList());
            this.isValidGroup(metadata, block.getExceptionGroup());
            if (block.getExceptionStatements() != null) {
                ProcedureContainerResolver.addScalarGroup(block.getExceptionGroup(), store, externalGroups, exceptionGroup, false);
                for (Statement statement : block.getExceptionStatements()) {
                    this.resolveStatement(command, statement, externalGroups, variables, metadata);
                }
            }
        }
    }

    private void resolveStatement(CreateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving statement", statement});
        switch (statement.getType()) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ifCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                ResolverVisitor.resolveLanguageObject(ifCrit, null, externalGroups, metadata);
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, metadata);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, metadata);
                break;
            }
            case 2: {
                DynamicCommand dynCommand;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                TempMetadataStore discoveredMetadata = this.resolveEmbeddedCommand(metadata, externalGroups, subCommand);
                if (subCommand instanceof StoredProcedure) {
                    StoredProcedure sp = (StoredProcedure)subCommand;
                    for (SPParameter param : sp.getParameters()) {
                        switch (param.getParameterType()) {
                            case 2: 
                            case 4: {
                                if (param.getExpression() != null && !this.isAssignable(metadata, param)) {
                                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30121, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30121, new Object[]{param.getExpression()}));
                                }
                                sp.setCallableStatement(true);
                                break;
                            }
                            case 3: {
                                if (!this.isAssignable(metadata, param)) break;
                                sp.setCallableStatement(true);
                            }
                        }
                    }
                }
                if (discoveredMetadata != null) {
                    metadata.getMetadataStore().getData().putAll(discoveredMetadata.getData());
                }
                if (subCommand instanceof DynamicCommand && (dynCommand = (DynamicCommand)subCommand).getIntoGroup() == null && !dynCommand.isAsClauseSet()) {
                    if (command.getResultSetColumns() != null && command.getResultSetColumns().isEmpty() || !cmdStmt.isReturnable() || command.getResultSetColumns() == null) {
                        dynCommand.setAsColumns(Collections.EMPTY_LIST);
                    } else {
                        dynCommand.setAsColumns(command.getResultSetColumns());
                    }
                }
                if (command.getResultSetColumns() != null || !cmdStmt.isReturnable() || !subCommand.returnsResultSet() || subCommand.getResultSetColumns() == null || subCommand.getResultSetColumns().isEmpty()) break;
                command.setResultSetColumns(subCommand.getResultSetColumns());
                if (!command.getProjectedSymbols().isEmpty()) break;
                command.setProjectedSymbols(subCommand.getResultSetColumns());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                if (exprStmt.getExpression() != null) {
                    Expression expr = exprStmt.getExpression();
                    for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                        this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                    }
                    ResolverVisitor.resolveLanguageObject(expr, null, externalGroups, metadata);
                }
                switch (statement.getType()) {
                    case 3: {
                        this.collectDeclareVariable((DeclareStatement)statement, variables, metadata, externalGroups);
                        break;
                    }
                    case 5: {
                        AssignmentStatement assStmt = (AssignmentStatement)statement;
                        ResolverVisitor.resolveLanguageObject(assStmt.getVariable(), null, externalGroups, metadata);
                        if (!metadata.elementSupports(assStmt.getVariable().getMetadataID(), 5)) {
                            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30121, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30121, new Object[]{assStmt.getVariable()}));
                        }
                        assStmt.getVariable().setIsExternalReference(false);
                        break;
                    }
                    case 13: {
                        ReturnStatement rs = (ReturnStatement)statement;
                        if (rs.getExpression() == null) break;
                        if (command.getReturnVariable() == null) {
                            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID31125, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31125, new Object[]{rs}));
                        }
                        rs.setVariable(command.getReturnVariable().clone());
                    }
                }
                if (exprStmt.getExpression() == null) break;
                Class<?> varType = exprStmt.getExpectedType();
                Class<?> exprType = exprStmt.getExpression().getType();
                if (exprType == null) {
                    throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30123, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30123, new Object[0]));
                }
                String varTypeName = DataTypeManager.getDataTypeName(varType);
                exprStmt.setExpression(ResolverUtil.convertExpression(exprStmt.getExpression(), varTypeName, metadata));
                if (statement.getType() != 4) break;
                ResolverVisitor.checkException(exprStmt.getExpression());
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(whileCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, (Command)container.getCommand());
                }
                ResolverVisitor.resolveLanguageObject(whileCrit, null, externalGroups, metadata);
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, metadata);
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                String groupName = loopStmt.getCursorName();
                this.isValidGroup(metadata, groupName);
                Command cmd = loopStmt.getCommand();
                this.resolveEmbeddedCommand(metadata, externalGroups, cmd);
                List<Expression> symbols = cmd.getProjectedSymbols();
                TempMetadataStore store = metadata.getMetadataStore().clone();
                metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
                externalGroups = new GroupContext(externalGroups, null);
                ProcedureContainerResolver.addScalarGroup(groupName, store, externalGroups, symbols, false);
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, metadata);
                break;
            }
            case 11: {
                this.resolveBlock(command, (Block)statement, externalGroups, metadata);
            }
        }
    }

    private void isValidGroup(TempMetadataAdapter metadata, String groupName) throws QueryResolverException {
        if (metadata.getMetadataStore().getTempGroupID(groupName) != null) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30124, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30124, new Object[]{groupName}));
        }
        if (GroupSymbol.isTempGroupName(groupName)) {
            throw new QueryResolverException((BundleUtil.Event)QueryPlugin.Event.TEIID30125, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30125, new Object[]{groupName}));
        }
    }

    private boolean isAssignable(TempMetadataAdapter metadata, SPParameter param) throws TeiidComponentException, QueryMetadataException {
        if (!(param.getExpression() instanceof ElementSymbol)) {
            return false;
        }
        ElementSymbol symbol = (ElementSymbol)param.getExpression();
        return metadata.elementSupports(symbol.getMetadataID(), 5);
    }

    private TempMetadataStore resolveEmbeddedCommand(TempMetadataAdapter metadata, GroupContext groupContext, Command cmd) throws TeiidComponentException, QueryResolverException {
        QueryResolver.setChildMetadata(cmd, metadata.getMetadataStore(), groupContext);
        return QueryResolver.resolveCommand(cmd, metadata.getMetadata());
    }

    private void collectDeclareVariable(DeclareStatement obj, GroupSymbol variables, TempMetadataAdapter metadata, GroupContext externalGroups) throws QueryResolverException, TeiidComponentException {
        ElementSymbol variable = obj.getVariable();
        String typeName = obj.getVariableType();
        GroupSymbol gs = variable.getGroupSymbol();
        if (gs == null) {
            String outputName = variable.getShortName();
            variable.setGroupSymbol(new GroupSymbol("VARIABLES"));
            variable.setOutputName(outputName);
        } else if (gs.getSchema() != null || !gs.getShortName().equalsIgnoreCase("VARIABLES")) {
            this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0031", new Object[]{"VARIABLES", variable}));
        }
        boolean exists = false;
        try {
            ResolverVisitor.resolveLanguageObject(variable, null, externalGroups, metadata);
            exists = true;
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
        if (exists) {
            this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0032", new Object[]{variable.getOutputName()}));
        }
        variable.setType(DataTypeManager.getDataTypeClass((String)typeName));
        variable.setGroupSymbol(variables);
        TempMetadataID id = new TempMetadataID(variable.getName(), typeName.equalsIgnoreCase("EXCEPTION") ? Exception.class : variable.getType());
        id.setUpdatable(true);
        variable.setMetadataID(id);
        metadata.getMetadataStore().addElementToTempGroup("VARIABLES", variable.clone());
    }

    private void handleUnresolvableDeclaration(ElementSymbol variable, String description) throws QueryResolverException {
        UnresolvedSymbolDescription symbol = new UnresolvedSymbolDescription(variable.toString(), description);
        QueryResolverException e = new QueryResolverException(symbol.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(symbol));
        throw e;
    }

    static {
        ElementSymbol es1 = new ElementSymbol("STATE");
        es1.setType(DataTypeManager.DefaultDataClasses.STRING);
        ElementSymbol es2 = new ElementSymbol("ERRORCODE");
        es2.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es3 = new ElementSymbol("TEIIDCODE");
        es3.setType(DataTypeManager.DefaultDataClasses.STRING);
        ElementSymbol es4 = new ElementSymbol("EXCEPTION");
        es4.setType(Exception.class);
        ElementSymbol es5 = new ElementSymbol("CHAIN");
        es5.setType(Exception.class);
        exceptionGroup = Arrays.asList(es1, es2, es3, es4, es5);
    }
}

