/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Alter;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.Validator;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;

public class ValidationVisitor
extends AbstractValidationVisitor {
    public static final Reference.Constraint LIMIT_CONSTRAINT = new PositiveIntegerConstraint("ValidationVisitor.badlimit2");
    private boolean isXML = false;
    private boolean inQuery;
    private CreateProcedureCommand createProc;

    @Override
    public void reset() {
        super.reset();
        this.isXML = false;
        this.inQuery = false;
        this.createProc = null;
    }

    @Override
    public void visit(BatchedUpdateCommand obj) {
        List<Command> commands = obj.getUpdateCommands();
        Command command = null;
        int type = 0;
        for (int i = 0; i < commands.size(); ++i) {
            Into into;
            command = commands.get(i);
            type = command.getType();
            if (type != 2 && type != 3 && type != 4 && type != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), command);
                continue;
            }
            if (type != 1 || (into = ((Query)command).getInto()) != null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), command);
        }
    }

    @Override
    public void visit(Delete obj) {
        this.validateNoXMLUpdates(obj);
        GroupSymbol group = obj.getGroup();
        this.validateGroupSupportsUpdate(group);
        if (obj.getUpdateInfo() != null && obj.getUpdateInfo().isInherentDelete()) {
            this.validateUpdate(obj, 4, obj.getUpdateInfo());
        }
    }

    @Override
    public void visit(GroupBy obj) {
        List<Expression> groupBySymbols = obj.getSymbols();
        this.validateSortable(groupBySymbols);
        for (Expression expr : groupBySymbols) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr).isEmpty() && !(expr instanceof Constant) && !(expr instanceof Reference)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.groupby_subquery", new Object[]{expr}), expr);
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        try {
            if (this.getMetadata().isScalarGroup(obj.getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_scalar_group_reference", new Object[]{obj}), obj);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(Insert obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateInsert(obj);
        try {
            if (obj.isMerge()) {
                Collection keys = this.getMetadata().getUniqueKeysInGroup(obj.getGroup().getMetadataID());
                if (keys.isEmpty()) {
                    this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31132, new Object[]{obj.getGroup()}), obj);
                } else {
                    LinkedHashSet keyCols = new LinkedHashSet(this.getMetadata().getElementIDsInKey(keys.iterator().next()));
                    for (ElementSymbol es : obj.getVariables()) {
                        keyCols.remove(es.getMetadataID());
                    }
                    if (!keyCols.isEmpty()) {
                        this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31133, new Object[]{obj.getGroup(), obj.getVariables()}), obj);
                    }
                }
            }
        }
        catch (QueryMetadataException e1) {
            this.handleException((TeiidException)((Object)e1));
        }
        catch (TeiidComponentException e1) {
            this.handleException((TeiidException)((Object)e1));
        }
        if (obj.getQueryExpression() != null) {
            this.validateMultisourceInsert(obj.getGroup());
        }
        if (obj.getUpdateInfo() != null && obj.getUpdateInfo().isInherentInsert()) {
            this.validateUpdate(obj, 2, obj.getUpdateInfo());
            try {
                if (obj.getUpdateInfo().findInsertUpdateMapping(obj, false) == null) {
                    this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30376, new Object[]{obj.getVariables()}), obj);
                }
            }
            catch (QueryValidatorException e) {
                this.handleValidationError(e.getMessage(), obj);
            }
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        this.validateSortable(obj.getSymbol());
        if (obj.getExpressionPosition() < 0) {
            for (SubqueryContainer<?> subquery : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(obj)) {
                for (ElementSymbol es : ElementCollectorVisitor.getElements(obj, true, true)) {
                    if (!es.isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31156, new Object[]{subquery}), obj);
                }
            }
        }
    }

    @Override
    public void visit(Query obj) {
        this.validateHasProjectedSymbols(obj);
        if (this.isXMLCommand(obj)) {
            if (obj.getInto() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0069"), obj);
            }
            this.isXML = true;
            this.validateXMLQuery(obj);
        } else {
            this.inQuery = true;
            this.validateAggregates(obj);
            if (obj.getSelect() != null && obj.getFrom() == null && !ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(obj.getSelect()).isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0067"), obj);
            }
            if (obj.getInto() != null) {
                this.validateSelectInto(obj);
            }
        }
    }

    @Override
    public void visit(Select obj) {
        this.validateSelectElements(obj);
        if (obj.isDistinct()) {
            this.validateSortable(obj.getProjectedSymbols());
        }
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj, DataTypeManager.getDataTypeName(obj.getExpression().getType())}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
        List<Expression> projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0011"), obj);
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        if (obj.getEncoding() != null) {
            try {
                Charset.forName(obj.getEncoding());
            }
            catch (IllegalArgumentException e) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_encoding", new Object[]{obj.getEncoding()}), obj);
            }
            if (obj.getType() != DataTypeManager.DefaultDataClasses.BLOB && obj.getType() != DataTypeManager.DefaultDataClasses.VARBINARY) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.encoding_for_binary"), obj);
            }
        }
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SetQuery obj) {
        this.validateHasProjectedSymbols(obj);
        this.validateSetQuery(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateNoXMLUpdates(obj);
        this.validateGroupSupportsUpdate(obj.getGroup());
        this.validateUpdate(obj);
    }

    @Override
    public void visit(Into obj) {
        GroupSymbol target = obj.getGroup();
        this.validateGroupSupportsUpdate(target);
        this.validateMultisourceInsert(obj.getGroup());
    }

    private void validateMultisourceInsert(GroupSymbol group) {
        try {
            if (this.getMetadata().isMultiSource(this.getMetadata().getModelID(group.getMetadataID()))) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.multisource_insert", new Object[]{group}), group);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(Function obj) {
        block18: {
            block23: {
                block21: {
                    block22: {
                        block20: {
                            block19: {
                                if (!"lookup".equalsIgnoreCase(obj.getName())) break block19;
                                try {
                                    ResolverUtil.ResolvedLookup resolvedLookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                                    if (ValidationVisitor.isNonComparable(resolvedLookup.getKeyElement())) {
                                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_lookup_key", new Object[]{resolvedLookup.getKeyElement(), DataTypeManager.getDataTypeName(resolvedLookup.getKeyElement().getType())}), resolvedLookup.getKeyElement());
                                    }
                                    break block18;
                                }
                                catch (TeiidComponentException e) {
                                    this.handleException((TeiidException)((Object)e), obj);
                                }
                                catch (TeiidProcessingException e) {
                                    this.handleException((TeiidException)((Object)e), obj);
                                }
                                break block18;
                            }
                            if (!obj.getName().equalsIgnoreCase("context")) break block20;
                            if (!this.isXML) {
                                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_context_function_cannot_be_used_in_a_non-XML_command"), obj);
                            } else {
                                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.004.0036"), obj);
                                }
                                for (Function function : FunctionCollectorVisitor.getFunctions((LanguageObject)obj.getArg(1), false)) {
                                    if (!function.getName().equalsIgnoreCase("context")) continue;
                                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Context_function_nested"), obj);
                                }
                            }
                            break block18;
                        }
                        if (!obj.getName().equalsIgnoreCase("rowlimit") && !obj.getName().equalsIgnoreCase("rowlimitexception")) break block21;
                        if (!this.isXML) break block22;
                        if (obj.getArg(0) instanceof ElementSymbol) break block18;
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.2"), obj);
                        break block18;
                    }
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_rowlimit_function_cannot_be_used_in_a_non-XML_command"), obj);
                    break block18;
                }
                if (!obj.getName().equalsIgnoreCase("xpathvalue")) break block23;
                if (!(obj.getArgs()[1] instanceof Constant)) break block18;
                Constant xpathConst = (Constant)obj.getArgs()[1];
                try {
                    XMLSystemFunctions.validateXpath((String)xpathConst.getValue());
                }
                catch (XPathException e) {
                    this.handleValidationError(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", new Object[]{e.getMessage()}), obj);
                }
                break block18;
            }
            if (obj.getName().equalsIgnoreCase("to_bytes") || obj.getName().equalsIgnoreCase("to_chars")) {
                try {
                    FunctionMethods.getCharset((String)((Constant)obj.getArg(1)).getValue());
                }
                catch (IllegalArgumentException e) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_encoding", new Object[]{obj.getArg(1)}), obj);
                }
            } else if (obj.isAggregate()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.user_defined_aggregate_as_function", new Object[]{obj, obj.getName()}), obj);
            } else if ("jsonarray".equalsIgnoreCase(obj.getName())) {
                Expression[] args;
                for (Expression expression : args = obj.getArgs()) {
                    this.validateJSONValue(obj, expression);
                }
            }
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        for (SPParameter param : obj.getInputParameters()) {
            try {
                if (this.getMetadata().elementSupports(param.getMetadataID(), 4) || !EvaluatableVisitor.isFullyEvaluatable(param.getExpression(), true)) continue;
                try {
                    Object evaluatedValue = Evaluator.evaluate(param.getExpression());
                    if (evaluatedValue == null) {
                        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", new Object[]{param.getParameterSymbol()}), param.getParameterSymbol());
                        continue;
                    }
                    if (!(evaluatedValue instanceof ArrayImpl) || !this.getMetadata().isVariadic(param.getMetadataID())) continue;
                    ArrayImpl av = (ArrayImpl)evaluatedValue;
                    for (Object o : av.getValues()) {
                        if (o != null) continue;
                        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", new Object[]{param.getParameterSymbol()}), param.getParameterSymbol());
                    }
                }
                catch (ExpressionEvaluationException e) {
                }
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e));
            }
        }
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.validateSubquery(obj);
        List<Expression> projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.008.0032", new Object[]{obj.getCommand()}), obj.getCommand());
        }
    }

    @Override
    public void visit(CreateProcedureCommand obj) {
        if (obj.getUpdateType() == 0) {
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_has_group_self_reference"), obj);
            }
            if (obj.getResultSetColumns() != null) {
                this.createProc = obj;
            }
        }
    }

    @Override
    public void visit(CompoundCriteria obj) {
        if (this.isXML) {
            ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit(obj, visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit(obj, visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Iterator<Criteria> conjunctIter = Criteria.separateCriteriaByAnd(obj).iterator();
                int i = 0;
                while (conjunctIter.hasNext() && i < functionCount) {
                    CompareCriteria crit;
                    Criteria conjunct = conjunctIter.next();
                    if (!(conjunct instanceof CompareCriteria) || (!rowLimitFunctions.contains((crit = (CompareCriteria)conjunct).getLeftExpression()) || rowLimitFunctions.contains(crit.getRightExpression())) && (!rowLimitFunctions.contains(crit.getRightExpression()) || rowLimitFunctions.contains(crit.getLeftExpression()))) continue;
                    ++i;
                }
                if (i < functionCount) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), obj);
                }
            }
        }
    }

    protected void validateSelectElements(Select obj) {
        if (this.isXML) {
            return;
        }
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)obj, true);
        Collection<ElementSymbol> cantSelect = this.validateElementsSupport(elements, 0);
        if (cantSelect != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0024", new Object[]{cantSelect}), cantSelect);
        }
    }

    protected void validateHasProjectedSymbols(Command obj) {
        if (obj.getProjectedSymbols().size() == 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0025"), obj);
        }
    }

    protected void validateSortable(List<? extends Expression> symbols) {
        for (Expression expression : symbols) {
            this.validateSortable(expression);
        }
    }

    private void validateSortable(Expression symbol) {
        if (ValidationVisitor.isNonComparable(symbol)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0026", new Object[]{symbol, DataTypeManager.getDataTypeName(symbol.getType())}), symbol);
        }
    }

    public static boolean isNonComparable(Expression symbol) {
        return DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(symbol.getType()));
    }

    protected void validateNoXMLUpdates(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0029"), obj);
        }
    }

    protected void validateNoXMLProcedures(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0030"), obj);
        }
    }

    private void validateXMLQuery(Query obj) {
        if (obj.getGroupBy() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0031"), obj);
        }
        if (obj.getHaving() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0032"), obj);
        }
        if (obj.getLimit() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.limit_not_valid_for_xml"), obj);
        }
        if (obj.getOrderBy() != null) {
            OrderBy orderBy = obj.getOrderBy();
            for (OrderByItem item : orderBy.getOrderByItems()) {
                if (item.getSymbol() instanceof ElementSymbol) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.orderby_expression_xml"), obj);
            }
        }
    }

    protected void validateGroupSupportsUpdate(GroupSymbol groupSymbol) {
        try {
            if (!this.getMetadata().groupSupports(groupSymbol.getMetadataID(), 0)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0033", new Object[]{SQLStringVisitor.getSQLString(groupSymbol)}), groupSymbol);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), groupSymbol);
        }
    }

    protected void validateSetQuery(SetQuery query) {
        for (QueryCommand subQuery : query.getQueryCommands()) {
            if (this.isXMLCommand(subQuery)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0034"), query);
            }
            if (!(subQuery instanceof Query) || ((Query)subQuery).getInto() == null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.union_insert"), query);
        }
        if (!query.isAll() || query.getOperation() == SetQuery.Operation.EXCEPT || query.getOperation() == SetQuery.Operation.INTERSECT) {
            this.validateSortable(query.getProjectedSymbols());
        }
        if (query.isAll() && (query.getOperation() == SetQuery.Operation.EXCEPT || query.getOperation() == SetQuery.Operation.INTERSECT)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.excpet_intersect_all"), query);
        }
    }

    private void validateAggregates(Query query) {
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        Criteria having = query.getHaving();
        this.validateNoAggsInClause(groupBy);
        List<GroupSymbol> correlationGroups = null;
        this.validateNoAggsInClause(query.getCriteria());
        if (query.getFrom() == null) {
            this.validateNoAggsInClause(select);
            this.validateNoAggsInClause(query.getOrderBy());
        } else {
            this.validateNoAggsInClause(query.getFrom());
            correlationGroups = query.getFrom().getGroups();
        }
        HashSet<Expression> groupSymbols = null;
        boolean hasAgg = false;
        if (groupBy != null) {
            groupSymbols = new HashSet<Expression>(groupBy.getSymbols());
            hasAgg = true;
        }
        LinkedHashSet<Expression> invalid = new LinkedHashSet<Expression>();
        LinkedHashSet invalidWindowFunctions = new LinkedHashSet();
        LinkedList aggs = new LinkedList();
        if (having != null) {
            this.validateCorrelatedReferences(query, correlationGroups, groupSymbols, having, invalid);
            AggregateSymbolCollectorVisitor.getAggregates(having, aggs, invalid, null, invalidWindowFunctions, groupSymbols);
            hasAgg = true;
        }
        if (groupBy != null && query.getOrderBy() != null) {
            HashSet<Expression> exanded = new HashSet<Expression>(groupSymbols);
            exanded.addAll(select.getProjectedSymbols());
            for (OrderByItem item : query.getOrderBy().getOrderByItems()) {
                if (!item.isUnrelated()) continue;
                AggregateSymbolCollectorVisitor.getAggregates(item.getSymbol(), aggs, invalid, null, invalidWindowFunctions, exanded);
            }
        }
        for (Expression symbol : select.getProjectedSymbols()) {
            if (hasAgg || !aggs.isEmpty()) {
                this.validateCorrelatedReferences(query, correlationGroups, groupSymbols, symbol, invalid);
            }
            AggregateSymbolCollectorVisitor.getAggregates(symbol, aggs, invalid, null, null, groupSymbols);
        }
        if (!(aggs.isEmpty() && !hasAgg || invalid.isEmpty())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0037", new Object[]{invalid}), invalid);
        }
        if (!invalidWindowFunctions.isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("SQLParser.window_only_top_level", new Object[]{invalidWindowFunctions}), invalidWindowFunctions);
        }
    }

    private void validateCorrelatedReferences(Query query, final List<GroupSymbol> correlationGroups, final Set<Expression> groupingSymbols, LanguageObject object, LinkedHashSet<Expression> invalid) {
        if (query.getFrom() == null) {
            return;
        }
        ElementCollectorVisitor ecv = new ElementCollectorVisitor(invalid){

            @Override
            public void visit(ElementSymbol obj) {
                if (obj.isExternalReference() && correlationGroups.contains(obj.getGroupSymbol()) && (groupingSymbols == null || !groupingSymbols.contains(obj))) {
                    super.visit(obj);
                }
            }
        };
        AggregateSymbolCollectorVisitor.AggregateStopNavigator asn = new AggregateSymbolCollectorVisitor.AggregateStopNavigator(ecv, groupingSymbols);
        object.acceptVisitor(asn);
    }

    private void validateNoAggsInClause(LanguageObject clause) {
        if (clause == null) {
            return;
        }
        LinkedHashSet aggs = new LinkedHashSet();
        AggregateSymbolCollectorVisitor.getAggregates(clause, aggs, null, null, aggs, null);
        if (!aggs.isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("SQLParser.Aggregate_only_top_level", new Object[]{aggs}), aggs);
        }
    }

    protected void validateInsert(Insert obj) {
        List<ElementSymbol> vars = obj.getVariables();
        Iterator varIter = vars.iterator();
        List values = obj.getValues();
        Iterator valIter = values.iterator();
        GroupSymbol insertGroup = obj.getGroup();
        try {
            boolean multiSource = this.getMetadata().isMultiSource(this.getMetadata().getModelID(insertGroup.getMetadataID()));
            for (ElementSymbol elementSymbol : vars) {
                if (!this.getMetadata().elementSupports(elementSymbol.getMetadataID(), 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0052", new Object[]{elementSymbol}), elementSymbol);
                }
                if (!multiSource || !this.getMetadata().isMultiSourceElement(elementSymbol.getMetadataID())) continue;
                multiSource = false;
            }
            if (multiSource) {
                this.validateMultisourceInsert(insertGroup);
            }
            LinkedList<ElementSymbol> insertElmnts = new LinkedList<ElementSymbol>(ResolverUtil.resolveElementsInGroup(insertGroup, this.getMetadata()));
            insertElmnts.removeAll(vars);
            for (ElementSymbol nextElmnt : insertElmnts) {
                if (this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 7) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 4) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 8)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0053", new Object[]{insertGroup, nextElmnt}), nextElmnt);
            }
            while (valIter.hasNext() && varIter.hasNext()) {
                Expression expression = (Expression)valIter.next();
                ElementSymbol nextVar = (ElementSymbol)varIter.next();
                if (!EvaluatableVisitor.isFullyEvaluatable(expression, true)) continue;
                try {
                    Object evaluatedValue = Evaluator.evaluate(expression);
                    if (evaluatedValue != null || this.getMetadata().elementSupports(nextVar.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", new Object[]{nextVar}), nextVar);
                }
                catch (ExpressionEvaluationException e) {}
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), obj);
        }
    }

    protected void validateSetClauseList(SetClauseList list) {
        HashSet<ElementSymbol> dups = new HashSet<ElementSymbol>();
        HashSet<ElementSymbol> changeVars = new HashSet<ElementSymbol>();
        for (SetClause clause : list.getClauses()) {
            ElementSymbol elementID = clause.getSymbol();
            if (changeVars.add(elementID)) continue;
            dups.add(elementID);
        }
        if (!dups.isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0062", new Object[]{dups}), dups);
        }
    }

    protected void validateUpdate(Update update) {
        try {
            UpdateValidator.UpdateInfo info = update.getUpdateInfo();
            for (SetClause entry : update.getChangeList().getClauses()) {
                Expression value;
                ElementSymbol elementID = entry.getSymbol();
                if (!this.getMetadata().elementSupports(elementID.getMetadataID(), 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0059", new Object[]{elementID}), elementID);
                }
                Object metadataID = elementID.getMetadataID();
                if (this.getMetadata().isMultiSourceElement(metadataID)) {
                    this.handleValidationError(QueryPlugin.Util.getString("multi_source_update_not_allowed", new Object[]{elementID}), elementID);
                }
                if (EvaluatableVisitor.isFullyEvaluatable(value = entry.getValue(), true)) {
                    try {
                        value = new Constant(Evaluator.evaluate(value));
                    }
                    catch (ExpressionEvaluationException err) {
                        // empty catch block
                    }
                }
                if (!(value instanceof Constant) || !((Constant)value).isNull() || this.getMetadata().elementSupports(elementID.getMetadataID(), 4)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0060", new Object[]{SQLStringVisitor.getSQLString(elementID)}), elementID);
            }
            if (info != null && info.isInherentUpdate()) {
                this.validateUpdate(update, 3, info);
                Set<ElementSymbol> updateCols = update.getChangeList().getClauseMap().keySet();
                if (!info.hasValidUpdateMapping(updateCols)) {
                    this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30376, new Object[]{updateCols}), update);
                }
            }
        }
        catch (TeiidException e) {
            this.handleException(e, update);
        }
        this.validateSetClauseList(update.getChangeList());
    }

    private void validateUpdate(TargetedCommand update, int type, UpdateValidator.UpdateInfo info) {
        String error = ProcedureContainerResolver.validateUpdateInfo(update.getGroup(), type, info);
        if (error != null) {
            this.handleValidationError(error, update.getGroup());
        }
    }

    protected void validateSelectInto(Query query) {
        List<Expression> symbols = query.getSelect().getProjectedSymbols();
        GroupSymbol intoGroup = query.getInto().getGroup();
        this.validateInto(query, symbols, intoGroup);
    }

    private void validateInto(LanguageObject query, List<Expression> symbols, GroupSymbol intoGroup) {
        try {
            List elementIDs = this.getMetadata().getElementIDsInGroupID(intoGroup.getMetadataID());
            if (symbols.size() != elementIDs.size()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_wrong_elements", new Object[]{new Integer(elementIDs.size()), new Integer(symbols.size())}), query);
                return;
            }
            for (int symbolNum = 0; symbolNum < symbols.size(); ++symbolNum) {
                String targetTypeName;
                Class<?> symbolType;
                String symbolTypeName;
                Expression symbol = symbols.get(symbolNum);
                Object elementID = elementIDs.get(symbolNum);
                if (!this.getMetadata().elementSupports(elementID, 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.element_updates_not_allowed", new Object[]{this.getMetadata().getFullName(elementID)}), intoGroup);
                }
                if ((symbolTypeName = DataTypeManager.getDataTypeName(symbolType = symbol.getType())).equals(targetTypeName = this.getMetadata().getElementType(elementID)) || DataTypeManager.isImplicitConversion((String)symbolTypeName, (String)targetTypeName)) continue;
                Object[] params = new Object[]{symbolTypeName, targetTypeName, new Integer(symbolNum + 1), query};
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_no_implicit_conversion", params), query);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e), query);
        }
    }

    private void validateRowLimitFunctionNotInInvalidCriteria(Criteria obj) {
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit(obj, visitor);
        if (rowLimitFunctions.size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), obj);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj, DataTypeManager.getDataTypeName(obj.getExpression().getType())}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(IsNullCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(IsDistinctCriteria isDistinctCriteria) {
        try {
            QueryMetadataInterface metadata = this.getMetadata();
            if (!metadata.isScalarGroup(isDistinctCriteria.getLeftRowValue().getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31171, new Object[]{isDistinctCriteria.getLeftRowValue()}), isDistinctCriteria.getLeftRowValue());
            }
            if (!metadata.isScalarGroup(isDistinctCriteria.getRightRowValue().getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31171, new Object[]{isDistinctCriteria.getRightRowValue()}), isDistinctCriteria.getRightRowValue());
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(NotCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SetCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj, DataTypeManager.getDataTypeName(obj.getExpression().getType())}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        this.validateSubquery(obj);
        if (ValidationVisitor.isNonComparable(obj.getLeftExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj, DataTypeManager.getDataTypeName(obj.getLeftExpression().getType())}), obj);
        }
        this.validateRowLimitFunctionNotInInvalidCriteria(obj);
    }

    @Override
    public void visit(Option obj) {
        List<String> dep = obj.getDependentGroups();
        List<String> notDep = obj.getNotDependentGroups();
        if (dep != null && !dep.isEmpty() && notDep != null && !notDep.isEmpty()) {
            String groupName2 = null;
            String notDepGroup2 = null;
            for (String groupName2 : dep) {
                for (String notDepGroup2 : notDep) {
                    if (!notDepGroup2.equalsIgnoreCase(groupName2)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.group_in_both_dep", new Object[]{groupName2}), obj);
                    return;
                }
            }
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null) {
            this.validateInto(obj, obj.getAsColumns(), obj.getIntoGroup());
        }
        if (obj.getUsing() != null) {
            this.validateSetClauseList(obj.getUsing());
        }
    }

    @Override
    public void visit(Create obj) {
        Table t;
        if (!obj.getPrimaryKey().isEmpty()) {
            this.validateSortable(obj.getPrimaryKey());
        }
        if (obj.getTableMetadata() != null && !(t = obj.getTableMetadata()).getForeignKeys().isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.temp_fk", new Object[]{obj.getTable()}), obj);
        }
    }

    @Override
    public void visit(Drop drop) {
        if (!drop.getTable().isTempTable()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.drop_of_nontemptable", new Object[]{drop.getTable()}), drop);
        }
        try {
            if (this.getMetadata().isVirtualGroup(drop.getTable().getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.drop_of_globaltemptable", new Object[]{drop.getTable()}), drop);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)((Object)e));
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        if (ValidationVisitor.isNonComparable(obj.getLeftExpression())) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0027", new Object[]{obj, DataTypeManager.getDataTypeName(obj.getLeftExpression().getType())}), obj);
        }
        ArrayList<Function> rowLimitFunctions = new ArrayList<Function>();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit(obj, visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit(obj, visitor);
        int functionCount = rowLimitFunctions.size();
        if (functionCount > 0) {
            Function rightExpr;
            Function leftExpr;
            Function function = null;
            Expression expr = null;
            if (obj.getLeftExpression() instanceof Function && ((leftExpr = (Function)obj.getLeftExpression()).getName().equalsIgnoreCase("rowlimit") || leftExpr.getName().equalsIgnoreCase("rowlimitexception"))) {
                function = leftExpr;
                expr = obj.getRightExpression();
            }
            if (function == null && obj.getRightExpression() instanceof Function && ((rightExpr = (Function)obj.getRightExpression()).getName().equalsIgnoreCase("rowlimit") || rightExpr.getName().equalsIgnoreCase("rowlimitexception"))) {
                function = rightExpr;
                expr = obj.getLeftExpression();
            }
            if (function == null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.0"), obj);
            } else if (expr instanceof Constant) {
                Constant constant = (Constant)expr;
                if (constant.getValue() instanceof Integer) {
                    Integer integer = (Integer)constant.getValue();
                    if (integer < 0) {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
                    }
                } else {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
                }
            } else if (expr instanceof Reference) {
                ((Reference)expr).setConstraint(new PositiveIntegerConstraint("ValidationVisitor.1"));
            } else {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), obj);
            }
        }
    }

    @Override
    public void visit(Limit obj) {
        this.validateLimitExpression(obj, obj.getOffset());
        this.validateLimitExpression(obj, obj.getRowLimit());
    }

    private void validateLimitExpression(Limit obj, Expression limitExpr) {
        if (limitExpr != null) {
            if (limitExpr instanceof Constant) {
                Integer limit = (Integer)((Constant)limitExpr).getValue();
                if (limit < 0) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit2"), obj);
                }
            } else if (limitExpr instanceof Reference) {
                ((Reference)limitExpr).setConstraint(LIMIT_CONSTRAINT);
            } else if (!EvaluatableVisitor.willBecomeConstant(limitExpr)) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit1"), obj);
            }
        }
    }

    @Override
    public void visit(XMLForest obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            if (dc.getAlias() == null) continue;
            this.validateQName(obj, dc.getAlias());
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
    }

    @Override
    public void visit(JSONObject obj) {
        for (DerivedColumn dc : obj.getArgs()) {
            this.validateJSONValue(obj, dc.getExpression());
        }
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        AggregateSymbol.Type type = windowFunction.getFunction().getAggregateFunction();
        switch (type) {
            case RANK: 
            case DENSE_RANK: 
            case ROW_NUMBER: {
                if (windowFunction.getWindowSpecification().getOrderBy() != null) break;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.ranking_requires_order_by", new Object[]{windowFunction}), windowFunction);
                break;
            }
            case TEXTAGG: 
            case ARRAY_AGG: 
            case JSONARRAY_AGG: 
            case XMLAGG: 
            case STRING_AGG: {
                if (windowFunction.getWindowSpecification().getOrderBy() == null) break;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.window_order_by", new Object[]{windowFunction}), windowFunction);
            }
        }
        this.validateNoSubqueriesOrOuterReferences(windowFunction);
        if (windowFunction.getFunction().getOrderBy() != null || windowFunction.getFunction().isDistinct() && windowFunction.getWindowSpecification().getOrderBy() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0042", new Object[]{windowFunction.getFunction(), windowFunction}), windowFunction);
        }
        if (windowFunction.getWindowSpecification().getPartition() != null) {
            this.validateSortable(windowFunction.getWindowSpecification().getPartition());
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        Expression[] aggExps;
        if (!this.inQuery) {
            this.handleValidationError(QueryPlugin.Util.getString("SQLParser.Aggregate_only_top_level", new Object[]{obj}), obj);
            return;
        }
        if (obj.getAggregateFunction() == AggregateSymbol.Type.USER_DEFINED) {
            AggregateAttributes aa = obj.getFunctionDescriptor().getMethod().getAggregateAttributes();
            if (!aa.allowsDistinct() && obj.isDistinct()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.uda_not_allowed", new Object[]{"DISTINCT", obj}), obj);
            }
            if (!aa.allowsOrderBy() && obj.getOrderBy() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.uda_not_allowed", new Object[]{"ORDER BY", obj}), obj);
            }
            if (aa.isAnalytic() && !obj.isWindowed()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.uda_analytic", new Object[]{obj}), obj);
            }
        }
        if (obj.getCondition() != null) {
            Expression condition = obj.getCondition();
            this.validateNoSubqueriesOrOuterReferences(condition);
        }
        for (Expression expression : aggExps = obj.getArgs()) {
            this.validateNoNestedAggs(expression, obj.isWindowed());
        }
        this.validateNoNestedAggs(obj.getOrderBy(), false);
        this.validateNoNestedAggs(obj.getCondition(), false);
        AggregateSymbol.Type aggregateFunction = obj.getAggregateFunction();
        if ((aggregateFunction == AggregateSymbol.Type.SUM || aggregateFunction == AggregateSymbol.Type.AVG) && obj.getType() == null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0041", new Object[]{aggregateFunction, obj}), obj);
        } else if (obj.getType() != DataTypeManager.DefaultDataClasses.NULL) {
            if (aggregateFunction == AggregateSymbol.Type.XMLAGG && aggExps[0].getType() != DataTypeManager.DefaultDataClasses.XML) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_xml", new Object[]{aggregateFunction, obj}), obj);
            } else if (obj.isBoolean() && aggExps[0].getType() != DataTypeManager.DefaultDataClasses.BOOLEAN) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_boolean", new Object[]{aggregateFunction, obj}), obj);
            } else if (aggregateFunction == AggregateSymbol.Type.JSONARRAY_AGG) {
                this.validateJSONValue(obj, aggExps[0]);
            }
        }
        if ((obj.isDistinct() || aggregateFunction == AggregateSymbol.Type.MIN || aggregateFunction == AggregateSymbol.Type.MAX) && DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(aggExps[0].getType()))) {
            this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.non_comparable", new Object[]{aggregateFunction, obj}), obj);
        }
        if (obj.isEnhancedNumeric()) {
            if (!Number.class.isAssignableFrom(aggExps[0].getType())) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0041", new Object[]{aggregateFunction, obj}), obj);
            }
            if (obj.isDistinct()) {
                this.handleValidationError(QueryPlugin.Util.getString("AggregateValidationVisitor.invalid_distinct", new Object[]{aggregateFunction, obj}), obj);
            }
        }
        if (obj.getAggregateFunction() != AggregateSymbol.Type.TEXTAGG) {
            return;
        }
        TextLine tl = (TextLine)aggExps[0];
        if (tl.isIncludeHeader()) {
            this.validateDerivedColumnNames(obj, tl.getExpressions());
        }
        for (DerivedColumn dc : tl.getExpressions()) {
            this.validateXMLContentTypes(dc.getExpression(), obj);
        }
        this.validateTextOptions(obj, tl.getDelimiter(), tl.getQuote(), Character.valueOf('\n'));
        if (tl.getEncoding() != null) {
            try {
                Charset.forName(tl.getEncoding());
            }
            catch (IllegalArgumentException e) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_encoding", new Object[]{tl.getEncoding()}), obj);
            }
        }
    }

    private void validateJSONValue(LanguageObject obj, Expression expr) {
        if (expr.getType() != DataTypeManager.DefaultDataClasses.STRING && !DataTypeManager.isTransformable(expr.getType(), (Class)DataTypeManager.DefaultDataClasses.STRING)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_json_value", new Object[]{expr, obj}), obj);
        }
    }

    private void validateNoSubqueriesOrOuterReferences(Expression expr) {
        if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.filter_subquery", new Object[]{expr}), expr);
        }
        for (ElementSymbol es : ElementCollectorVisitor.getElements((LanguageObject)expr, false)) {
            if (!es.isExternalReference()) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.filter_subquery", new Object[]{es}), es);
        }
    }

    private void validateNoNestedAggs(LanguageObject aggExp, boolean windowOnly) {
        if (aggExp != null) {
            LinkedHashSet nestedAggs = new LinkedHashSet();
            AggregateSymbolCollectorVisitor.getAggregates(aggExp, windowOnly ? null : nestedAggs, null, null, nestedAggs, null);
            if (!nestedAggs.isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0039", new Object[]{nestedAggs}), nestedAggs);
            }
        }
    }

    private String[] validateQName(LanguageObject obj, String name) {
        try {
            return Name11Checker.getInstance().getQNameParts((CharSequence)name);
        }
        catch (QNameException e) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_invalid_qname", new Object[]{name}), obj);
            return null;
        }
    }

    private void validateDerivedColumnNames(LanguageObject obj, List<DerivedColumn> cols) {
        for (DerivedColumn dc : cols) {
            if (dc.getAlias() != null || dc.getExpression() instanceof ElementSymbol) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.expression_requires_name"), obj);
        }
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
        for (DerivedColumn dc : obj.getArgs()) {
            String[] parts;
            if (dc.getAlias() == null) continue;
            if ("xmlns".equals(dc.getAlias())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_attributes_reserved"), obj);
            }
            if ((parts = this.validateQName(obj, dc.getAlias())) == null || !"xmlns".equals(parts[0])) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_attributes_reserved", new Object[]{dc.getAlias()}), obj);
        }
    }

    @Override
    public void visit(XMLElement obj) {
        for (Expression expression : obj.getContent()) {
            this.validateXMLContentTypes(expression, obj);
        }
        this.validateQName(obj, obj.getName());
    }

    public void validateXMLContentTypes(Expression expression, LanguageObject parent) {
        if (expression.getType() == DataTypeManager.DefaultDataClasses.OBJECT || expression.getType() == DataTypeManager.DefaultDataClasses.BLOB) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_content_type", new Object[]{expression}), parent);
        }
    }

    @Override
    public void visit(QueryString obj) {
        this.validateDerivedColumnNames(obj, obj.getArgs());
    }

    @Override
    public void visit(XMLTable obj) {
        List<DerivedColumn> passing = obj.getPassing();
        this.validatePassing(obj, obj.getXQueryExpression(), passing);
        boolean hasOrdinal = false;
        for (XMLTable.XMLColumn xc : obj.getColumns()) {
            if (!xc.isOrdinal()) {
                if (xc.getDefaultExpression() == null || EvaluatableVisitor.isFullyEvaluatable(xc.getDefaultExpression(), false)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_default", new Object[]{xc.getDefaultExpression()}), obj);
                continue;
            }
            if (hasOrdinal) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.one_ordinal"), obj);
                break;
            }
            hasOrdinal = true;
        }
    }

    @Override
    public void visit(ObjectTable obj) {
        List<DerivedColumn> passing = obj.getPassing();
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DerivedColumn dc : passing) {
            if (dc.getAlias() == null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.context_item_not_allowed"), obj);
                continue;
            }
            if (names.add(dc.getAlias())) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.duplicate_passing", new Object[]{dc.getAlias()}), obj);
        }
        Compilable scriptCompiler = null;
        try {
            ScriptEngine engine = this.getMetadata().getScriptEngine(obj.getScriptingLanguage());
            obj.setScriptEngine(engine);
            if (engine instanceof Compilable) {
                scriptCompiler = (Compilable)((Object)engine);
                engine.put("javax.script.filename", "OBJECTTABLE");
                obj.setCompiledScript(scriptCompiler.compile(obj.getRowScript()));
            }
        }
        catch (TeiidProcessingException e) {
            this.handleValidationError(e.getMessage(), obj);
        }
        catch (ScriptException e) {
            this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31110, new Object[]{obj.getRowScript(), e.getMessage()}), obj);
        }
        for (ObjectTable.ObjectColumn xc : obj.getColumns()) {
            if (scriptCompiler != null) {
                try {
                    xc.setCompiledScript(scriptCompiler.compile(xc.getPath()));
                }
                catch (ScriptException e) {
                    this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31110, new Object[]{xc.getPath(), e.getMessage()}), obj);
                }
            }
            if (xc.getDefaultExpression() == null || EvaluatableVisitor.isFullyEvaluatable(xc.getDefaultExpression(), false)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_default", new Object[]{xc.getDefaultExpression()}), obj);
        }
    }

    @Override
    public void visit(XMLQuery obj) {
        this.validatePassing(obj, obj.getXQueryExpression(), obj.getPassing());
    }

    @Override
    public void visit(XMLExists obj) {
        this.validatePassing(obj, obj.getXmlQuery().getXQueryExpression(), obj.getXmlQuery().getPassing());
    }

    @Override
    public void visit(XMLCast obj) {
        if (obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.XML && obj.getType() != DataTypeManager.DefaultDataClasses.XML) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xmlcast_types", new Object[]{obj}), obj);
        }
    }

    private void validatePassing(LanguageObject obj, SaxonXQueryExpression xqe, List<DerivedColumn> passing) {
        boolean context = false;
        boolean hadError = false;
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (DerivedColumn dc : passing) {
            if (dc.getAlias() == null) {
                Class<?> type = dc.getExpression().getType();
                if (type != DataTypeManager.DefaultDataClasses.XML) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.context_item_type"), obj);
                }
                if (context && !hadError) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.passing_requires_name"), obj);
                    hadError = true;
                }
                context = true;
                continue;
            }
            this.validateXMLContentTypes(dc.getExpression(), obj);
            if (names.add(dc.getAlias())) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.duplicate_passing", new Object[]{dc.getAlias()}), obj);
        }
        if (xqe.usesContextItem() && !context) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.context_required"), obj);
        }
    }

    @Override
    public void visit(XMLNamespaces obj) {
        boolean hasDefault = false;
        for (XMLNamespaces.NamespaceItem item : obj.getNamespaceItems()) {
            if (item.getPrefix() != null) {
                if (item.getPrefix().equals("xml") || item.getPrefix().equals("xmlns")) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces_reserved"), obj);
                } else if (!Name11Checker.getInstance().isValidNCName((CharSequence)item.getPrefix())) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces_invalid", new Object[]{item.getPrefix()}), obj);
                }
                if (item.getUri().length() != 0) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces_null_uri"), obj);
                continue;
            }
            if (hasDefault) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xml_namespaces"), obj);
                break;
            }
            hasDefault = true;
        }
    }

    @Override
    public void visit(TextTable obj) {
        boolean widthSet = false;
        Character delimiter = null;
        Character quote = null;
        boolean usingSelector = false;
        for (TextTable.TextColumn column : obj.getColumns()) {
            if (column.isOrdinal()) continue;
            if (column.getWidth() != null) {
                widthSet = true;
                if (column.getWidth() < 0) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
                }
            } else if (widthSet) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_invalid_width"), obj);
            }
            if (column.getSelector() != null) {
                usingSelector = true;
                if (obj.getSelector() != null && obj.getSelector().equals(column.getSelector())) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_selector_required"), obj);
                }
            }
            if (column.getPosition() == null || column.getPosition() >= 0) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
        }
        if (widthSet) {
            if (obj.getDelimiter() != null || obj.getHeader() != null || obj.getQuote() != null || usingSelector) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_width"), obj);
            }
        } else {
            if (obj.getHeader() != null && obj.getHeader() < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
            }
            if (!obj.isUsingRowDelimiter()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.fixed_option"), obj);
            }
            delimiter = obj.getDelimiter();
            quote = obj.getQuote();
            this.validateTextOptions(obj, delimiter, quote, obj.getRowDelimiter());
        }
        if (obj.getSkip() != null && obj.getSkip() < 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_negative"), obj);
        }
        if (usingSelector && obj.getSelector() == null) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_selector_required"), obj);
        }
    }

    private void validateTextOptions(LanguageObject obj, Character delimiter, Character quote, Character newLine) {
        if (quote == null) {
            quote = Character.valueOf('\"');
        }
        if (delimiter == null) {
            delimiter = Character.valueOf(',');
        }
        if (newLine == null) {
            newLine = Character.valueOf('\n');
        }
        if (EquivalenceUtil.areEqual((Object)quote, (Object)delimiter)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_delimiter"), obj);
        }
        if (EquivalenceUtil.areEqual((Object)quote, (Object)newLine) || EquivalenceUtil.areEqual((Object)delimiter, (Object)newLine)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.text_table_newline"), obj);
        }
    }

    @Override
    public void visit(XMLParse obj) {
        if (obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.STRING && obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.CLOB && obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.BLOB && obj.getExpression().getType() != DataTypeManager.DefaultDataClasses.VARBINARY) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.xmlparse_type"), obj);
        }
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(LoopStatement obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.validateSubquery(obj);
    }

    @Override
    public void visit(AlterView obj) {
        try {
            QueryResolver.validateProjectedSymbols(obj.getTarget(), this.getMetadata(), obj.getDefinition());
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            this.validateAlterTarget(obj);
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(e.getMessage(), (LanguageObject)obj.getDefinition());
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    private void validateAlterTarget(Alter<?> obj) {
        if (this.getMetadata().getImportedModels().contains(obj.getTarget().getSchema())) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_alter", new Object[]{obj.getTarget()}), obj.getTarget());
        }
    }

    @Override
    public void visit(AlterProcedure obj) {
        GroupSymbol gs = obj.getTarget();
        this.validateAlterTarget(obj);
        try {
            if (!gs.isProcedure() || !this.getMetadata().isVirtualModel(this.getMetadata().getModelID(gs.getMetadataID()))) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.not_a_procedure", new Object[]{gs}), gs);
                return;
            }
            Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            StoredProcedureInfo info = this.getMetadata().getStoredProcedureInfoForProcedure(gs.getName());
            for (SPParameter param : info.getParameters()) {
                if (param.getParameterType() != 5) continue;
                QueryResolver.validateProjectedSymbols(gs, param.getResultSetColumns(), ((CreateProcedureCommand)obj.getDefinition()).getProjectedSymbols());
                break;
            }
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(e.getMessage(), ((CreateProcedureCommand)obj.getDefinition()).getBlock());
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    @Override
    public void visit(Block obj) {
        if (obj.getLabel() == null) {
            return;
        }
        for (LanguageObject lo : this.stack) {
            if (!(lo instanceof Statement.Labeled)) continue;
            Statement.Labeled labeled = (Statement.Labeled)((Object)lo);
            if (!obj.getLabel().equalsIgnoreCase(labeled.getLabel())) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.duplicate_block_label", new Object[]{obj.getLabel()}), obj);
        }
    }

    @Override
    public void visit(CommandStatement obj) {
        if (this.createProc == null || this.createProc.getResultSetColumns().isEmpty() || !obj.isReturnable() || !obj.getCommand().returnsResultSet()) {
            return;
        }
        List<? extends Expression> symbols = obj.getCommand().getResultSetColumns();
        if (symbols == null && obj.getCommand() instanceof DynamicCommand) {
            DynamicCommand cmd = (DynamicCommand)obj.getCommand();
            cmd.setAsColumns(this.createProc.getResultSetColumns());
            return;
        }
        try {
            QueryResolver.validateProjectedSymbols(this.createProc.getVirtualGroup(), this.createProc.getResultSetColumns(), symbols);
        }
        catch (QueryValidatorException e) {
            this.handleValidationError(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31121, new Object[]{this.createProc.getVirtualGroup(), obj, e.getMessage()}), obj);
        }
    }

    @Override
    public void visit(BranchingStatement obj) {
        boolean matchedLabel = false;
        boolean inLoop = false;
        for (LanguageObject lo : this.stack) {
            if (lo instanceof LoopStatement || lo instanceof WhileStatement) {
                inLoop = true;
                if (obj.getLabel() == null) break;
                matchedLabel |= obj.getLabel().equalsIgnoreCase(((Statement.Labeled)((Object)lo)).getLabel());
                continue;
            }
            if (obj.getLabel() == null || !(lo instanceof Block) || !obj.getLabel().equalsIgnoreCase(((Block)lo).getLabel())) continue;
            matchedLabel = true;
            if (obj.getMode() == BranchingStatement.BranchingMode.LEAVE) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_label", new Object[]{obj.getLabel()}), obj);
        }
        if (obj.getMode() != BranchingStatement.BranchingMode.LEAVE && !inLoop) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.no_loop"), obj);
        }
        if (obj.getLabel() != null && !matchedLabel) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.unknown_block_label", new Object[]{obj.getLabel()}), obj);
        }
    }

    @Override
    public void visit(AlterTrigger obj) {
        this.validateAlterTarget(obj);
        this.validateGroupSupportsUpdate(obj.getTarget());
        try {
            if (obj.getDefinition() != null) {
                Validator.validate(obj.getDefinition(), this.getMetadata(), this);
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)((Object)e));
        }
    }

    private void validateSubquery(SubqueryContainer<?> subQuery) {
        if (subQuery.getCommand() instanceof Query && ((Query)subQuery.getCommand()).getInto() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.subquery_insert"), (LanguageObject)subQuery.getCommand());
        }
    }

    private static final class PositiveIntegerConstraint
    implements Reference.Constraint {
        private String msgKey;

        public PositiveIntegerConstraint(String msgKey) {
            this.msgKey = msgKey;
        }

        @Override
        public void validate(Object value) throws QueryValidatorException {
            if (value == null || (Integer)value < 0) {
                throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30242, QueryPlugin.Util.getString(this.msgKey));
            }
        }
    }
}

