/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.Request;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.ValidationVisitor;

public class ExecDynamicSqlInstruction
extends ProgramInstruction {
    private DynamicCommand dynamicCommand;
    IDGenerator idGenerator;
    CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    private boolean returnable;
    CreateProcedureCommand parentProcCommand;
    private Program dynamicProgram;

    public ExecDynamicSqlInstruction(CreateProcedureCommand parentProcCommand, DynamicCommand command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, boolean returnable) {
        this.parentProcCommand = parentProcCommand;
        this.dynamicCommand = command;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.idGenerator = idGenerator;
        this.returnable = returnable;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        VariableContext localContext = procEnv.getCurrentVariableContext();
        try {
            Object value = procEnv.evaluateExpression(this.dynamicCommand.getSql());
            if (value == null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.0"));
            }
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Executing dynamic sql ", value});
            Command command = QueryParser.getQueryParser().parseCommand(value.toString());
            command.setExternalGroupContexts(this.dynamicCommand.getExternalGroupContexts());
            command.setTemporaryMetadata(this.dynamicCommand.getTemporaryMetadata().clone());
            this.updateContextWithUsingValues(procEnv, localContext);
            TempMetadataStore metadataStore = command.getTemporaryMetadata();
            if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
                metadataStore.addTempGroup("USING", new LinkedList<ElementSymbol>(this.dynamicCommand.getUsing().getClauseMap().keySet()));
                GroupSymbol using = new GroupSymbol("USING");
                using.setMetadataID(metadataStore.getTempGroupID("USING"));
                command.addExternalGroupToContext(using);
                metadataStore.addTempGroup("DVARS", new LinkedList<ElementSymbol>(this.dynamicCommand.getUsing().getClauseMap().keySet()));
                using = new GroupSymbol("DVARS");
                using.setMetadataID(metadataStore.getTempGroupID("DVARS"));
                command.addExternalGroupToContext(using);
            }
            QueryResolver.resolveCommand(command, this.metadata.getDesignTimeMetadata());
            this.validateDynamicCommand(procEnv, command);
            Map<ElementSymbol, Expression> nameValueMap = this.createVariableValuesMap(localContext);
            ValidationVisitor visitor = new ValidationVisitor();
            Request.validateWithVisitor(visitor, this.metadata, command);
            boolean insertInto = false;
            boolean updateCommand = false;
            if (!command.returnsResultSet() && !(command instanceof StoredProcedure)) {
                if (this.dynamicCommand.isAsClauseSet() && (this.dynamicCommand.getProjectedSymbols().size() != 1 || ((Expression)this.dynamicCommand.getProjectedSymbols().get(0)).getType() != DataTypeManager.DefaultDataClasses.INTEGER)) {
                    throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31157, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31157, new Object[0]));
                }
                updateCommand = true;
            } else if (this.dynamicCommand.getAsColumns() != null && !this.dynamicCommand.getAsColumns().isEmpty()) {
                command = QueryRewriter.createInlineViewQuery(new GroupSymbol("X"), command, this.metadata, this.dynamicCommand.getAsColumns());
                if (this.dynamicCommand.getIntoGroup() != null) {
                    Insert insert = new Insert(this.dynamicCommand.getIntoGroup(), this.dynamicCommand.getAsColumns(), Collections.emptyList());
                    insert.setQueryExpression((Query)command);
                    command = insert;
                    insertInto = true;
                }
            }
            command = QueryRewriter.rewrite(command, this.metadata, procEnv.getContext(), nameValueMap);
            ProcessorPlan commandPlan = QueryOptimizer.optimizePlan(command, this.metadata, this.idGenerator, this.capFinder, AnalysisRecord.createNonRecordingRecord(), procEnv.getContext());
            CreateCursorResultSetInstruction inst = new CreateCursorResultSetInstruction(null, commandPlan, insertInto || updateCommand ? CreateCursorResultSetInstruction.Mode.UPDATE : (this.returnable ? CreateCursorResultSetInstruction.Mode.HOLD : CreateCursorResultSetInstruction.Mode.NOHOLD)){

                @Override
                public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
                    super.process(procEnv);
                    procEnv.getContext().popCall();
                }
            };
            this.dynamicProgram = new Program(false);
            this.dynamicProgram.addInstruction(inst);
            if (this.dynamicCommand.getIntoGroup() != null) {
                String groupName = this.dynamicCommand.getIntoGroup().getName();
                if (!procEnv.getTempTableStore().hasTempTable(groupName, true)) {
                    Create create = new Create();
                    create.setTable(new GroupSymbol(groupName));
                    for (ElementSymbol es : this.dynamicCommand.getAsColumns()) {
                        Column c = new Column();
                        c.setName(es.getShortName());
                        c.setRuntimeType(DataTypeManager.getDataTypeName(es.getType()));
                        create.getColumns().add(c);
                    }
                    procEnv.getDataManager().registerRequest(procEnv.getContext(), create, TempMetadataAdapter.TEMP_MODEL.getName(), new RegisterRequestParameter());
                }
                if (updateCommand) {
                    Insert insert = new Insert();
                    insert.setGroup(new GroupSymbol(groupName));
                    for (ElementSymbol es : this.dynamicCommand.getAsColumns()) {
                        ElementSymbol col = new ElementSymbol(es.getShortName(), insert.getGroup());
                        col.setType(es.getType());
                        insert.addVariable(col);
                    }
                    insert.addValue(new Constant(procEnv.getCurrentVariableContext().getValue(ProcedurePlan.ROWCOUNT)));
                    QueryResolver.resolveCommand(insert, this.metadata.getDesignTimeMetadata());
                    TupleSource ts = procEnv.getDataManager().registerRequest(procEnv.getContext(), insert, TempMetadataAdapter.TEMP_MODEL.getName(), new RegisterRequestParameter());
                    ts.nextTuple();
                    ts.closeSource();
                }
            }
            procEnv.push(this.dynamicProgram);
        }
        catch (TeiidProcessingException e) {
            Object[] params = new Object[]{this.dynamicCommand, this.dynamicCommand.getSql(), e.getMessage()};
            throw new QueryProcessingException(QueryPlugin.Event.TEIID30168, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30168, params));
        }
    }

    private void updateContextWithUsingValues(ProcedurePlan procEnv, VariableContext localContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
            for (SetClause setClause : this.dynamicCommand.getUsing().getClauses()) {
                Object assignment = procEnv.evaluateExpression(setClause.getValue());
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{this, " The using variable ", setClause.getSymbol(), " has value :", assignment});
                localContext.setValue(setClause.getSymbol(), assignment);
                ElementSymbol es = setClause.getSymbol().clone();
                es.getGroupSymbol().setShortName("USING");
                localContext.setValue(es, assignment);
            }
        }
    }

    private Map<ElementSymbol, Expression> createVariableValuesMap(VariableContext localContext) {
        HashMap variableMap = new HashMap();
        localContext.getFlattenedContextMap(variableMap);
        HashMap<ElementSymbol, Expression> nameValueMap = new HashMap<ElementSymbol, Expression>(variableMap.size());
        for (Map.Entry entry : variableMap.entrySet()) {
            if (!(entry.getKey() instanceof ElementSymbol)) continue;
            if (entry.getValue() instanceof Expression) {
                nameValueMap.put((ElementSymbol)entry.getKey(), (Expression)entry.getValue());
                continue;
            }
            nameValueMap.put((ElementSymbol)entry.getKey(), new Constant(entry.getValue(), ((ElementSymbol)entry.getKey()).getType()));
        }
        return nameValueMap;
    }

    private void validateDynamicCommand(ProcedurePlan procEnv, Command command) throws TeiidComponentException, QueryProcessingException {
        List dynamicExpectedColumns = this.dynamicCommand.getAsColumns();
        List<Expression> sourceProjectedSymbolList = command.getProjectedSymbols();
        if (dynamicExpectedColumns != null && !dynamicExpectedColumns.isEmpty()) {
            if (dynamicExpectedColumns.size() != sourceProjectedSymbolList.size()) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.4"));
            }
            Iterator dynamicIter = dynamicExpectedColumns.iterator();
            Iterator<Expression> sourceIter = sourceProjectedSymbolList.iterator();
            while (dynamicIter.hasNext()) {
                String sourceTypeName;
                Expression dynamicSymbol = (Expression)dynamicIter.next();
                Expression sourceExpr = sourceIter.next();
                Class<?> sourceSymbolDatatype = sourceExpr.getType();
                Class<?> dynamicType = dynamicSymbol.getType();
                String dynamicTypeName = DataTypeManager.getDataTypeName(dynamicType);
                if (dynamicTypeName.equals(sourceTypeName = DataTypeManager.getDataTypeName(sourceSymbolDatatype)) || DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)dynamicTypeName)) continue;
                throw new QueryProcessingException(QueryPlugin.Util.getString("ExecDynamicSqlInstruction.6", new Object[]{sourceTypeName, sourceExpr, dynamicTypeName}));
            }
        }
        CommandContext context = procEnv.getContext();
        if (this.parentProcCommand.getUpdateType() != 0) {
            context.pushCall(Command.getCommandToken(this.parentProcCommand.getUpdateType()) + " " + this.parentProcCommand.getVirtualGroup());
        } else if (this.parentProcCommand.getVirtualGroup() != null) {
            context.pushCall(this.parentProcCommand.getVirtualGroup().toString());
        }
    }

    @Override
    public ExecDynamicSqlInstruction clone() {
        ExecDynamicSqlInstruction clone = new ExecDynamicSqlInstruction(this.parentProcCommand, this.dynamicCommand, this.metadata, this.idGenerator, this.capFinder, this.returnable);
        return clone;
    }

    public String toString() {
        return "ExecDynamicSqlInstruction";
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("ExecDynamicSqlInstruction");
        props.addProperty("Query", this.dynamicCommand.toString());
        return props;
    }

    public boolean isReturnable() {
        return this.returnable;
    }

    public void setReturnable(boolean returnable) {
        this.returnable = returnable;
    }
}

