/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.util.CommandContext;

public class Sum
extends SingleArgumentAggregateFunction {
    protected static final int LONG = 0;
    protected static final int DOUBLE = 1;
    protected static final int BIG_INTEGER = 2;
    protected static final int BIG_DECIMAL = 3;
    protected int accumulatorType = 0;
    private long sumLong;
    private double sumDouble;
    private BigDecimal sumBigDecimal;
    private boolean isNull = true;

    protected int getAccumulatorType() {
        return this.accumulatorType;
    }

    @Override
    public void initialize(Class<?> dataType, Class<?> inputType) {
        this.accumulatorType = dataType.equals(DataTypeManager.DefaultDataClasses.LONG) ? 0 : (dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) ? 1 : (dataType.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER) ? 2 : 3));
    }

    @Override
    public void reset() {
        this.sumLong = 0L;
        this.sumDouble = 0.0;
        this.sumBigDecimal = null;
        this.isNull = true;
    }

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        this.isNull = false;
        switch (this.accumulatorType) {
            case 0: {
                this.sumLong = FunctionMethods.plus(this.sumLong, ((Number)input).longValue());
                break;
            }
            case 1: {
                this.sumDouble += ((Number)input).doubleValue();
                break;
            }
            case 2: 
            case 3: {
                if (this.sumBigDecimal == null) {
                    this.sumBigDecimal = BigDecimal.valueOf(0L);
                }
                if (input instanceof BigInteger) {
                    BigInteger bigIntegerInput = (BigInteger)input;
                    this.sumBigDecimal = this.sumBigDecimal.add(new BigDecimal(bigIntegerInput));
                    break;
                }
                this.sumBigDecimal = input instanceof BigDecimal ? this.sumBigDecimal.add((BigDecimal)input) : this.sumBigDecimal.add(new BigDecimal(((Number)input).longValue()));
            }
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        if (this.isNull) {
            return null;
        }
        switch (this.accumulatorType) {
            case 0: {
                return this.sumLong;
            }
            case 1: {
                return this.sumDouble;
            }
            case 2: {
                return this.sumBigDecimal.toBigInteger();
            }
        }
        return this.sumBigDecimal;
    }

    @Override
    public void getState(List<Object> state) {
        switch (this.accumulatorType) {
            case 0: {
                if (this.isNull) {
                    state.add(null);
                    break;
                }
                state.add(this.sumLong);
                break;
            }
            case 1: {
                if (this.isNull) {
                    state.add(null);
                    break;
                }
                state.add(this.sumDouble);
                break;
            }
            default: {
                state.add(this.sumBigDecimal);
            }
        }
    }

    @Override
    public List<? extends Class<?>> getStateTypes() {
        switch (this.accumulatorType) {
            case 0: {
                return Arrays.asList(Long.class);
            }
            case 1: {
                return Arrays.asList(Double.class);
            }
        }
        return Arrays.asList(BigDecimal.class);
    }

    @Override
    public int setState(List<?> state, int index) {
        switch (this.accumulatorType) {
            case 0: {
                Long val = (Long)state.get(index);
                if (val == null) {
                    this.isNull = true;
                    this.sumLong = 0L;
                    break;
                }
                this.isNull = false;
                this.sumLong = val;
                break;
            }
            case 1: {
                Double val = (Double)state.get(index);
                if (val == null) {
                    this.isNull = true;
                    this.sumDouble = 0.0;
                    break;
                }
                this.isNull = false;
                this.sumDouble = val;
                break;
            }
            default: {
                this.sumBigDecimal = (BigDecimal)state.get(index);
                if (this.sumBigDecimal == null) break;
                this.isNull = false;
            }
        }
        return index + 1;
    }
}

