/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class WindowFunctionProjectNode
extends SubqueryAwareRelationalNode {
    private static final List<Integer> SINGLE_VALUE_ID = Arrays.asList(0);
    private LinkedHashMap<WindowSpecification, WindowSpecificationInfo> windows = new LinkedHashMap();
    private LinkedHashMap<Expression, Integer> expressionIndexes;
    private List<int[]> passThrough = new ArrayList<int[]>();
    private Map<Expression, Integer> elementMap;
    private Phase phase = Phase.COLLECT;
    private TupleBuffer tb;
    private TupleSource inputTs;
    private STree[] partitionMapping;
    private STree[] valueMapping;
    private STree[] rowValueMapping;
    private IndexedTupleSource outputTs;

    public WindowFunctionProjectNode(int nodeId) {
        super(nodeId);
    }

    protected WindowFunctionProjectNode() {
    }

    @Override
    public void reset() {
        super.reset();
        this.tb = null;
        this.inputTs = null;
        this.phase = Phase.COLLECT;
        this.partitionMapping = null;
        this.valueMapping = null;
        this.rowValueMapping = null;
        this.outputTs = null;
    }

    @Override
    public void closeDirect() {
        if (this.tb != null) {
            this.tb.remove();
            this.tb = null;
        }
        this.removeMappings(this.partitionMapping);
        this.partitionMapping = null;
        this.removeMappings(this.valueMapping);
        this.valueMapping = null;
        this.removeMappings(this.rowValueMapping);
        this.rowValueMapping = null;
    }

    private void removeMappings(STree[] mappings) {
        if (mappings != null) {
            for (STree tree : mappings) {
                if (tree == null) continue;
                tree.remove();
            }
        }
    }

    @Override
    public Object clone() {
        WindowFunctionProjectNode clonedNode = new WindowFunctionProjectNode();
        this.copyTo(clonedNode);
        clonedNode.windows = this.windows;
        clonedNode.expressionIndexes = this.expressionIndexes;
        clonedNode.passThrough = this.passThrough;
        return clonedNode;
    }

    public void init() {
        this.expressionIndexes = new LinkedHashMap();
        for (int i = 0; i < this.getElements().size(); ++i) {
            Expression ex = SymbolMap.getExpression(this.getElements().get(i));
            if (ex instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)ex;
                WindowSpecification ws = wf.getWindowSpecification();
                WindowSpecificationInfo wsi = this.windows.get(ws);
                if (wsi == null) {
                    wsi = new WindowSpecificationInfo();
                    this.windows.put(wf.getWindowSpecification(), wsi);
                    if (ws.getPartition() != null) {
                        for (Expression ex1 : ws.getPartition()) {
                            Integer index = GroupingNode.getIndex(ex1, this.expressionIndexes);
                            wsi.groupIndexes.add(index);
                            wsi.orderType.add(true);
                            wsi.nullOrderings.add(null);
                        }
                    }
                    if (ws.getOrderBy() != null) {
                        for (OrderByItem item : ws.getOrderBy().getOrderByItems()) {
                            Expression ex1 = SymbolMap.getExpression(item.getSymbol());
                            Integer index = GroupingNode.getIndex(ex1, this.expressionIndexes);
                            wsi.sortIndexes.add(index);
                            wsi.orderType.add(item.isAscending());
                            wsi.nullOrderings.add(item.getNullOrdering());
                        }
                    }
                }
                WindowFunctionInfo wfi = new WindowFunctionInfo();
                wfi.function = wf;
                for (Expression e : wf.getFunction().getArgs()) {
                    GroupingNode.getIndex(e, this.expressionIndexes);
                }
                if (wf.getFunction().getOrderBy() != null) {
                    for (OrderByItem item : wf.getFunction().getOrderBy().getOrderByItems()) {
                        GroupingNode.getIndex(item.getSymbol(), this.expressionIndexes);
                    }
                }
                if (wf.getFunction().getCondition() != null) {
                    GroupingNode.getIndex(wf.getFunction().getCondition(), this.expressionIndexes);
                }
                wfi.outputIndex = i;
                if (wf.getFunction().getAggregateFunction() == AggregateSymbol.Type.ROW_NUMBER) {
                    wsi.rowValuefunctions.add(wfi);
                    continue;
                }
                wsi.functions.add(wfi);
                continue;
            }
            int index = GroupingNode.getIndex(ex, this.expressionIndexes);
            this.passThrough.add(new int[]{i, index});
        }
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == Phase.COLLECT) {
            this.saveInput();
            this.phase = Phase.PROCESS;
            this.partitionMapping = new STree[this.windows.size()];
            this.valueMapping = new STree[this.windows.size()];
            this.rowValueMapping = new STree[this.windows.size()];
        }
        if (this.phase == Phase.PROCESS) {
            this.buildResults();
            this.phase = Phase.OUTPUT;
        }
        if (this.phase == Phase.OUTPUT) {
            if (this.outputTs == null) {
                this.outputTs = this.tb.createIndexedTupleSource(true);
            }
            while (this.outputTs.hasNext()) {
                List<?> tuple = this.outputTs.nextTuple();
                Integer rowId = (Integer)tuple.get(tuple.size() - 1);
                int size = this.getElements().size();
                ArrayList<Object> outputRow = new ArrayList<Object>(size);
                for (int i = 0; i < size; ++i) {
                    outputRow.add(null);
                }
                for (int[] entry : this.passThrough) {
                    outputRow.set(entry[0], tuple.get(entry[1]));
                }
                ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>> specs = new ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>>(this.windows.entrySet());
                for (int specIndex = 0; specIndex < specs.size(); ++specIndex) {
                    WindowFunctionInfo wfi;
                    int i;
                    List valueRow;
                    Map.Entry entry = (Map.Entry)specs.get(specIndex);
                    List idRow = Arrays.asList(rowId);
                    List<WindowFunctionInfo> functions = ((WindowSpecificationInfo)entry.getValue()).rowValuefunctions;
                    if (!functions.isEmpty()) {
                        valueRow = this.rowValueMapping[specIndex].find(idRow);
                        for (i = 0; i < functions.size(); ++i) {
                            wfi = functions.get(i);
                            outputRow.set(wfi.outputIndex, valueRow.get(i + 1));
                        }
                    }
                    if ((functions = ((WindowSpecificationInfo)entry.getValue()).functions).isEmpty()) continue;
                    if (this.partitionMapping[specIndex] != null) {
                        idRow = this.partitionMapping[specIndex].find(idRow);
                        idRow = idRow.subList(1, 2);
                    } else {
                        idRow = SINGLE_VALUE_ID;
                    }
                    valueRow = this.valueMapping[specIndex].find(idRow);
                    for (i = 0; i < functions.size(); ++i) {
                        wfi = functions.get(i);
                        outputRow.set(wfi.outputIndex, valueRow.get(i + 1));
                    }
                }
                this.addBatchRow(outputRow);
                if (!this.isBatchFull()) continue;
                return this.pullBatch();
            }
            this.terminateBatches();
        }
        return this.pullBatch();
    }

    private void buildResults() throws TeiidComponentException, TeiidProcessingException, FunctionExecutionException, ExpressionEvaluationException {
        ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>> specs = new ArrayList<Map.Entry<WindowSpecification, WindowSpecificationInfo>>(this.windows.entrySet());
        for (int specIndex = 0; specIndex < specs.size(); ++specIndex) {
            Map.Entry entry = (Map.Entry)specs.get(specIndex);
            WindowSpecificationInfo info = (WindowSpecificationInfo)entry.getValue();
            TupleBuffer.TupleBufferTupleSource specificationTs = this.tb.createIndexedTupleSource();
            boolean multiGroup = false;
            int[] partitionIndexes = null;
            int[] orderIndexes = null;
            if (!info.orderType.isEmpty()) {
                multiGroup = true;
                int[] sortKeys = new int[info.orderType.size()];
                int i = 0;
                if (!info.groupIndexes.isEmpty()) {
                    for (Integer sortIndex : info.groupIndexes) {
                        sortKeys[i++] = sortIndex;
                    }
                    partitionIndexes = Arrays.copyOf(sortKeys, info.groupIndexes.size());
                }
                if (!info.sortIndexes.isEmpty()) {
                    for (Integer sortIndex : info.sortIndexes) {
                        sortKeys[i++] = sortIndex;
                    }
                    orderIndexes = Arrays.copyOfRange(sortKeys, info.groupIndexes.size(), info.groupIndexes.size() + info.sortIndexes.size());
                }
                if (!info.functions.isEmpty()) {
                    ElementSymbol key = new ElementSymbol("rowId");
                    key.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    ElementSymbol value = new ElementSymbol("partitionId");
                    value.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                    List<ElementSymbol> elements = Arrays.asList(key, value);
                    this.partitionMapping[specIndex] = this.getBufferManager().createSTree(elements, this.getConnectionID(), 1);
                }
                SortUtility su = new SortUtility(null, SortUtility.Mode.SORT, this.getBufferManager(), this.getConnectionID(), this.tb.getSchema(), info.orderType, info.nullOrderings, sortKeys);
                su.setWorkingBuffer(this.tb);
                su.setNonBlocking(true);
                TupleBuffer sorted = su.sort();
                specificationTs = sorted.createIndexedTupleSource(true);
            }
            List<AggregateFunction> aggs = this.initializeAccumulators(info.functions, specIndex, false);
            List<AggregateFunction> rowValueAggs = this.initializeAccumulators(info.rowValuefunctions, specIndex, true);
            int groupId = 0;
            List<?> lastRow = null;
            while (specificationTs.hasNext()) {
                List<?> tuple = specificationTs.nextTuple();
                if (multiGroup) {
                    if (lastRow != null) {
                        boolean samePartition;
                        boolean bl = samePartition = GroupingNode.sameGroup(partitionIndexes, tuple, lastRow) == -1;
                        if (!(aggs.isEmpty() || samePartition && GroupingNode.sameGroup(orderIndexes, tuple, lastRow) == -1)) {
                            this.saveValues(specIndex, aggs, groupId, samePartition, false);
                            ++groupId;
                        }
                        this.saveValues(specIndex, rowValueAggs, lastRow.get(lastRow.size() - 1), samePartition, true);
                    }
                    if (!aggs.isEmpty()) {
                        List<Object> partitionTuple = Arrays.asList(tuple.get(tuple.size() - 1), groupId);
                        this.partitionMapping[specIndex].insert(partitionTuple, STree.InsertMode.NEW, -1);
                    }
                }
                for (AggregateFunction function : aggs) {
                    function.addInput(tuple, this.getContext());
                }
                for (AggregateFunction function : rowValueAggs) {
                    function.addInput(tuple, this.getContext());
                }
                lastRow = tuple;
            }
            if (lastRow == null) continue;
            this.saveValues(specIndex, aggs, groupId, true, false);
            this.saveValues(specIndex, rowValueAggs, lastRow.get(lastRow.size() - 1), true, true);
        }
    }

    private void saveValues(int specIndex, List<AggregateFunction> aggs, Object id, boolean samePartition, boolean rowValue) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        if (aggs.isEmpty()) {
            return;
        }
        ArrayList<Object> row = new ArrayList<Object>(aggs.size() + 1);
        row.add(id);
        for (AggregateFunction function : aggs) {
            row.add(function.getResult(this.getContext()));
            if (samePartition) continue;
            function.reset();
        }
        if (rowValue) {
            this.rowValueMapping[specIndex].insert(row, STree.InsertMode.NEW, -1);
        } else {
            this.valueMapping[specIndex].insert(row, STree.InsertMode.ORDERED, -1);
        }
    }

    private List<AggregateFunction> initializeAccumulators(List<WindowFunctionInfo> functions, int specIndex, boolean rowValues) {
        ArrayList<AggregateFunction> aggs = new ArrayList<AggregateFunction>(functions.size());
        if (functions.isEmpty()) {
            return aggs;
        }
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(functions.size());
        ElementSymbol key = new ElementSymbol("key");
        key.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        elements.add(key);
        for (WindowFunctionInfo wfi : functions) {
            aggs.add(GroupingNode.initAccumulator(wfi.function.getFunction(), this, this.expressionIndexes));
            Class<?> outputType = wfi.function.getType();
            ElementSymbol value = new ElementSymbol("val");
            value.setType(outputType);
            elements.add(value);
        }
        if (!rowValues) {
            this.valueMapping[specIndex] = this.getBufferManager().createSTree(elements, this.getConnectionID(), 1);
        } else {
            this.rowValueMapping[specIndex] = this.getBufferManager().createSTree(elements, this.getConnectionID(), 1);
        }
        return aggs;
    }

    private void saveInput() throws TeiidComponentException, TeiidProcessingException {
        if (this.inputTs == null) {
            ArrayList<Expression> collectedExpressions = new ArrayList<Expression>(this.expressionIndexes.keySet());
            Evaluator eval = new Evaluator(this.elementMap, this.getDataManager(), this.getContext());
            RelationalNode sourceNode = this.getChildren()[0];
            this.inputTs = new GroupingNode.ProjectingTupleSource(sourceNode, eval, collectedExpressions, this.elementMap){
                int index;
                {
                    this.index = 0;
                }

                @Override
                public List<Object> nextTuple() throws TeiidComponentException, TeiidProcessingException {
                    List<Object> tuple = super.nextTuple();
                    if (tuple != null) {
                        tuple.add(this.index++);
                    }
                    return tuple;
                }
            };
            ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(collectedExpressions.size() + 1);
            int index = 0;
            for (Expression ex : collectedExpressions) {
                ElementSymbol es = new ElementSymbol(String.valueOf(index++));
                es.setType(ex.getType());
                schema.add(es);
            }
            ElementSymbol es = new ElementSymbol(String.valueOf(index++));
            es.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            schema.add(es);
            this.tb = this.getBufferManager().createTupleBuffer(schema, this.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
        }
        List<?> tuple = null;
        while ((tuple = this.inputTs.nextTuple()) != null) {
            this.tb.addTuple(tuple);
        }
        this.tb.close();
        this.inputTs.closeSource();
        this.inputTs = null;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            List<? extends Expression> sourceElements = this.getChildren()[0].getElements();
            this.elementMap = WindowFunctionProjectNode.createLookupMap(sourceElements);
        }
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return this.getElements();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Window Functions", this.windows.keySet());
        return props;
    }

    private static class WindowSpecificationInfo {
        List<Integer> groupIndexes = new ArrayList<Integer>();
        List<Integer> sortIndexes = new ArrayList<Integer>();
        List<SortSpecification.NullOrdering> nullOrderings = new ArrayList<SortSpecification.NullOrdering>();
        List<Boolean> orderType = new ArrayList<Boolean>();
        List<WindowFunctionInfo> functions = new ArrayList<WindowFunctionInfo>();
        List<WindowFunctionInfo> rowValuefunctions = new ArrayList<WindowFunctionInfo>();

        private WindowSpecificationInfo() {
        }
    }

    private static class WindowFunctionInfo {
        WindowFunction function;
        int outputIndex;

        private WindowFunctionInfo() {
        }
    }

    private static enum Phase {
        COLLECT,
        PROCESS,
        OUTPUT;

    }
}

