/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class ScalarSubquery
implements Expression,
SubqueryContainer<QueryCommand>,
ContextReference {
    private static AtomicInteger ID = new AtomicInteger();
    private QueryCommand command;
    private Class<?> type;
    private String id = "$sc/id" + ID.getAndIncrement();
    private boolean shouldEvaluate;
    private ExistsCriteria.SubqueryHint subqueryHint = new ExistsCriteria.SubqueryHint();

    ScalarSubquery() {
    }

    public ScalarSubquery(QueryCommand subqueryCommand) {
        this.setCommand(subqueryCommand);
    }

    public boolean shouldEvaluate() {
        return this.shouldEvaluate;
    }

    public void setShouldEvaluate(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public String getContextSymbol() {
        return this.id;
    }

    @Override
    public Class<?> getType() {
        if (this.type == null) {
            Expression symbol = this.command.getProjectedSymbols().iterator().next();
            this.type = symbol.getType();
        }
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public QueryCommand getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(QueryCommand command) {
        this.command = command;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScalarSubquery)) {
            return false;
        }
        ScalarSubquery other = (ScalarSubquery)obj;
        return other.getCommand().equals(this.getCommand()) && EquivalenceUtil.areEqual((Object)this.subqueryHint, (Object)other.subqueryHint);
    }

    public int hashCode() {
        if (this.command != null) {
            return this.command.hashCode();
        }
        return 0;
    }

    @Override
    public Object clone() {
        QueryCommand copyCommand = null;
        if (this.getCommand() != null) {
            copyCommand = (QueryCommand)this.getCommand().clone();
        }
        ScalarSubquery clone = new ScalarSubquery(copyCommand);
        clone.setType(this.type);
        clone.shouldEvaluate = this.shouldEvaluate;
        if (this.subqueryHint != null) {
            clone.subqueryHint = this.subqueryHint.clone();
        }
        return clone;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public ExistsCriteria.SubqueryHint getSubqueryHint() {
        return this.subqueryHint;
    }

    public void setSubqueryHint(ExistsCriteria.SubqueryHint subqueryHint) {
        this.subqueryHint = subqueryHint;
    }
}

