/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.Array;
import org.teiid.language.BatchedCommand;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.InsertValueSource;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.Parameter;
import org.teiid.language.QueryExpression;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.TableReference;
import org.teiid.language.Update;
import org.teiid.language.WindowFunction;
import org.teiid.language.WindowSpecification;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.translator.TranslatorException;

public class LanguageBridgeFactory {
    private RuntimeMetadataImpl metadataFactory = null;
    private int valueIndex = 0;
    private List<List<?>> allValues = new LinkedList();
    private Map<String, List<? extends List<?>>> dependentSets;
    private boolean convertIn;
    private boolean supportsConcat2;
    private int maxInCriteriaSize;

    public LanguageBridgeFactory(QueryMetadataInterface metadata) {
        if (metadata != null) {
            this.metadataFactory = new RuntimeMetadataImpl(metadata);
        }
    }

    public LanguageBridgeFactory(RuntimeMetadataImpl metadata) {
        this.metadataFactory = metadata;
    }

    public void setConvertIn(boolean convertIn) {
        this.convertIn = convertIn;
    }

    public void setSupportsConcat2(boolean supportsConcat2) {
        this.supportsConcat2 = supportsConcat2;
    }

    public Command translate(org.teiid.query.sql.lang.Command command) {
        try {
            if (command == null) {
                Command command2 = null;
                return command2;
            }
            if (command instanceof Query) {
                Select result = this.translate((Query)command);
                result.setDependentValues(this.dependentSets);
                this.setProjected((QueryExpression)result);
                Select select = result;
                return select;
            }
            if (command instanceof org.teiid.query.sql.lang.SetQuery) {
                SetQuery result = this.translate((org.teiid.query.sql.lang.SetQuery)command);
                this.setProjected((QueryExpression)result);
                SetQuery setQuery = result;
                return setQuery;
            }
            if (command instanceof Insert) {
                org.teiid.language.Insert insert = this.translate((Insert)command);
                return insert;
            }
            if (command instanceof org.teiid.query.sql.lang.Update) {
                Update update = this.translate((org.teiid.query.sql.lang.Update)command);
                return update;
            }
            if (command instanceof Delete) {
                org.teiid.language.Delete delete = this.translate((Delete)command);
                return delete;
            }
            if (command instanceof StoredProcedure) {
                Call call = this.translate((StoredProcedure)command);
                return call;
            }
            if (command instanceof BatchedUpdateCommand) {
                BatchedUpdates batchedUpdates = this.translate((BatchedUpdateCommand)command);
                return batchedUpdates;
            }
            throw new AssertionError((Object)(command.getClass().getName() + " " + command));
        }
        finally {
            this.allValues.clear();
            this.dependentSets = null;
            this.valueIndex = 0;
        }
    }

    private void setProjected(QueryExpression qe) {
        if (qe instanceof Select) {
            Select select = (Select)qe;
            for (DerivedColumn dc : select.getDerivedColumns()) {
                dc.setProjected(true);
            }
        } else {
            SetQuery sq = (SetQuery)qe;
            this.setProjected(sq.getLeftQuery());
            this.setProjected(sq.getRightQuery());
        }
    }

    QueryExpression translate(QueryCommand command) {
        if (command instanceof Query) {
            return this.translate((Query)command);
        }
        return this.translate((org.teiid.query.sql.lang.SetQuery)command);
    }

    SetQuery translate(org.teiid.query.sql.lang.SetQuery union) {
        SetQuery result = new SetQuery();
        result.setAll(union.isAll());
        switch (union.getOperation()) {
            case UNION: {
                result.setOperation(SetQuery.Operation.UNION);
                break;
            }
            case INTERSECT: {
                result.setOperation(SetQuery.Operation.INTERSECT);
                break;
            }
            case EXCEPT: {
                result.setOperation(SetQuery.Operation.EXCEPT);
            }
        }
        result.setLeftQuery(this.translate(union.getLeftQuery()));
        result.setRightQuery(this.translate(union.getRightQuery()));
        result.setOrderBy(this.translate(union.getOrderBy(), true));
        result.setLimit(this.translate(union.getLimit()));
        result.setWith(this.translate(union.getWith()));
        return result;
    }

    Select translate(Query query) {
        List<Expression> symbols = query.getSelect().getSymbols();
        ArrayList<DerivedColumn> translatedSymbols = new ArrayList<DerivedColumn>(symbols.size());
        for (Expression symbol : symbols) {
            String alias = null;
            if (symbol instanceof AliasSymbol) {
                alias = ((AliasSymbol)symbol).getOutputName();
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            org.teiid.language.Expression iExp = this.translate(symbol);
            DerivedColumn selectSymbol = new DerivedColumn(alias, iExp);
            translatedSymbols.add(selectSymbol);
        }
        ArrayList<TableReference> items = null;
        if (query.getFrom() != null) {
            List<FromClause> clauses = query.getFrom().getClauses();
            items = new ArrayList<TableReference>(clauses.size());
            Iterator<FromClause> i = clauses.iterator();
            while (i.hasNext()) {
                items.add(this.translate(i.next()));
            }
        }
        Select q = new Select(translatedSymbols, query.getSelect().isDistinct(), items, this.translate(query.getCriteria()), this.translate(query.getGroupBy()), this.translate(query.getHaving()), this.translate(query.getOrderBy(), false));
        q.setLimit(this.translate(query.getLimit()));
        q.setWith(this.translate(query.getWith()));
        return q;
    }

    public With translate(List<WithQueryCommand> with) {
        if (with == null || with.isEmpty()) {
            return null;
        }
        With result = new With();
        ArrayList<WithItem> items = new ArrayList<WithItem>(with.size());
        for (WithQueryCommand withQueryCommand : with) {
            WithItem item = new WithItem();
            item.setTable(this.translate(withQueryCommand.getGroupSymbol()));
            if (withQueryCommand.getColumns() != null) {
                ArrayList<ColumnReference> translatedElements = new ArrayList<ColumnReference>(withQueryCommand.getColumns().size());
                for (ElementSymbol es : withQueryCommand.getColumns()) {
                    ColumnReference cr = this.translate(es);
                    translatedElements.add(cr);
                    if (withQueryCommand.getCommand() != null) continue;
                    Object mid = es.getMetadataID();
                    if (mid instanceof TempMetadataID) {
                        TempMetadataID tid = (TempMetadataID)mid;
                        mid = tid.getOriginalMetadataID();
                    }
                    if (!(mid instanceof Column)) continue;
                    cr.setMetadataObject((Column)mid);
                }
                item.setColumns(translatedElements);
            }
            if (withQueryCommand.getCommand() != null) {
                item.setSubquery(this.translate(withQueryCommand.getCommand()));
            } else {
                item.setDependentValues((List)new TupleBufferList(withQueryCommand.getTupleBuffer()));
            }
            item.setRecusive(withQueryCommand.isRecursive());
            items.add(item);
        }
        result.setItems(items);
        return result;
    }

    public TableReference translate(FromClause clause) {
        if (clause == null) {
            return null;
        }
        if (clause instanceof JoinPredicate) {
            return this.translate((JoinPredicate)clause);
        }
        if (clause instanceof SubqueryFromClause) {
            return this.translate((SubqueryFromClause)clause);
        }
        if (clause instanceof UnaryFromClause) {
            return this.translate((UnaryFromClause)clause);
        }
        throw new AssertionError((Object)(clause.getClass().getName() + " " + clause));
    }

    Join translate(JoinPredicate join) {
        List crits = join.getJoinCriteria();
        Criteria crit = null;
        if (crits.size() == 1) {
            crit = (Criteria)crits.get(0);
        } else if (crits.size() > 1) {
            crit = new CompoundCriteria(crits);
        }
        Join.JoinType joinType = Join.JoinType.INNER_JOIN;
        if (join.getJoinType().equals(JoinType.JOIN_INNER)) {
            joinType = Join.JoinType.INNER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_LEFT_OUTER)) {
            joinType = Join.JoinType.LEFT_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_RIGHT_OUTER)) {
            joinType = Join.JoinType.RIGHT_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_FULL_OUTER)) {
            joinType = Join.JoinType.FULL_OUTER_JOIN;
        } else if (join.getJoinType().equals(JoinType.JOIN_CROSS)) {
            joinType = Join.JoinType.CROSS_JOIN;
        }
        return new Join(this.translate(join.getLeftClause()), this.translate(join.getRightClause()), joinType, this.translate(crit));
    }

    TableReference translate(SubqueryFromClause clause) {
        return new DerivedTable(this.translate((QueryCommand)clause.getCommand()), clause.getOutputName());
    }

    NamedTable translate(UnaryFromClause clause) {
        return this.translate(clause.getGroup());
    }

    public Condition translate(Criteria criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria instanceof CompareCriteria) {
            return this.translate((CompareCriteria)criteria);
        }
        if (criteria instanceof CompoundCriteria) {
            return this.translate((CompoundCriteria)criteria);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.translate((ExistsCriteria)criteria);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.translate((IsNullCriteria)criteria);
        }
        if (criteria instanceof MatchCriteria) {
            return this.translate((MatchCriteria)criteria);
        }
        if (criteria instanceof NotCriteria) {
            return this.translate((NotCriteria)criteria);
        }
        if (criteria instanceof SetCriteria) {
            return this.translate((SetCriteria)criteria);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.translate((SubqueryCompareCriteria)criteria);
        }
        if (criteria instanceof SubquerySetCriteria) {
            return this.translate((SubquerySetCriteria)criteria);
        }
        if (criteria instanceof DependentSetCriteria) {
            return this.translate((DependentSetCriteria)criteria);
        }
        throw new AssertionError((Object)(criteria.getClass().getName() + " " + criteria));
    }

    Comparison translate(DependentSetCriteria criteria) {
        Comparison.Operator operator = Comparison.Operator.EQ;
        Parameter arg = null;
        TupleBuffer tb = criteria.getDependentValueSource().getTupleBuffer();
        if (criteria.getValueExpression() instanceof org.teiid.query.sql.symbol.Array) {
            org.teiid.query.sql.symbol.Array array = (org.teiid.query.sql.symbol.Array)criteria.getValueExpression();
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            Class baseType = null;
            for (Expression ex : array.getExpressions()) {
                if (baseType == null) {
                    baseType = ex.getType();
                } else if (!baseType.equals(ex.getType())) {
                    baseType = DataTypeManager.DefaultDataClasses.OBJECT;
                }
                params.add(this.createParameter(criteria, tb, ex));
            }
            arg = new Array(baseType, params);
        } else {
            Expression ex = criteria.getValueExpression();
            arg = this.createParameter(criteria, tb, ex);
        }
        if (this.dependentSets == null) {
            this.dependentSets = new HashMap();
        }
        this.dependentSets.put(criteria.getContextSymbol(), new TupleBufferList(tb));
        Comparison result = new Comparison(this.translate(criteria.getExpression()), (org.teiid.language.Expression)arg, operator);
        return result;
    }

    private Parameter createParameter(DependentSetCriteria criteria, TupleBuffer tb, Expression ex) {
        Parameter p = new Parameter();
        p.setType(ex.getType());
        p.setValueIndex(tb.getSchema().indexOf(ex));
        p.setDependentValueId(criteria.getContextSymbol());
        return p;
    }

    Comparison translate(CompareCriteria criteria) {
        Comparison.Operator operator = Comparison.Operator.EQ;
        switch (criteria.getOperator()) {
            case 1: {
                operator = Comparison.Operator.EQ;
                break;
            }
            case 2: {
                operator = Comparison.Operator.NE;
                break;
            }
            case 3: {
                operator = Comparison.Operator.LT;
                break;
            }
            case 5: {
                operator = Comparison.Operator.LE;
                break;
            }
            case 4: {
                operator = Comparison.Operator.GT;
                break;
            }
            case 6: {
                operator = Comparison.Operator.GE;
            }
        }
        return new Comparison(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), operator);
    }

    AndOr translate(CompoundCriteria criteria) {
        List<Criteria> nestedCriteria = criteria.getCriteria();
        int size = nestedCriteria.size();
        AndOr.Operator op = criteria.getOperator() == 0 ? AndOr.Operator.AND : AndOr.Operator.OR;
        AndOr result = new AndOr(this.translate(nestedCriteria.get(size - 2)), this.translate(nestedCriteria.get(size - 1)), op);
        for (int i = nestedCriteria.size() - 3; i >= 0; --i) {
            result = new AndOr(this.translate(nestedCriteria.get(i)), (Condition)result, op);
        }
        return result;
    }

    Condition translate(ExistsCriteria criteria) {
        Exists exists = new Exists(this.translate(criteria.getCommand()));
        if (criteria.isNegated()) {
            return new Not((Condition)exists);
        }
        return exists;
    }

    IsNull translate(IsNullCriteria criteria) {
        return new IsNull(this.translate(criteria.getExpression()), criteria.isNegated());
    }

    Like translate(MatchCriteria criteria) {
        Character escapeChar = null;
        if (criteria.getEscapeChar() != '\u0000') {
            escapeChar = new Character(criteria.getEscapeChar());
        }
        Like like = new Like(this.translate(criteria.getLeftExpression()), this.translate(criteria.getRightExpression()), escapeChar, criteria.isNegated());
        like.setMode(criteria.getMode());
        return like;
    }

    Condition translate(SetCriteria criteria) {
        Collection expressions = criteria.getValues();
        ArrayList<org.teiid.language.Expression> translatedExpressions = this.translateExpressionList(expressions);
        org.teiid.language.Expression expr = this.translate(criteria.getExpression());
        if (this.convertIn) {
            Comparison condition = null;
            for (org.teiid.language.Expression expression : translatedExpressions) {
                if (condition == null) {
                    condition = new Comparison(expr, expression, criteria.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ);
                    continue;
                }
                condition = new AndOr((Condition)new Comparison(expr, expression, criteria.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ), (Condition)condition, criteria.isNegated() ? AndOr.Operator.AND : AndOr.Operator.OR);
            }
            return condition;
        }
        if (this.maxInCriteriaSize > 0 && translatedExpressions.size() > this.maxInCriteriaSize) {
            Object condition = null;
            int count = translatedExpressions.size() / this.maxInCriteriaSize + (translatedExpressions.size() % this.maxInCriteriaSize != 0 ? 1 : 0);
            for (int i = 0; i < count; ++i) {
                List subList = translatedExpressions.subList(this.maxInCriteriaSize * i, Math.min(translatedExpressions.size(), this.maxInCriteriaSize * (i + 1)));
                ArrayList translatedExpressionsSubList = new ArrayList(subList);
                condition = condition == null ? new In(expr, translatedExpressionsSubList, criteria.isNegated()) : new AndOr((Condition)condition, (Condition)new In(expr, translatedExpressionsSubList, criteria.isNegated()), criteria.isNegated() ? AndOr.Operator.AND : AndOr.Operator.OR);
            }
            return condition;
        }
        return new In(expr, translatedExpressions, criteria.isNegated());
    }

    SubqueryComparison translate(SubqueryCompareCriteria criteria) {
        SubqueryComparison.Quantifier quantifier = SubqueryComparison.Quantifier.ALL;
        switch (criteria.getPredicateQuantifier()) {
            case 4: {
                quantifier = SubqueryComparison.Quantifier.ALL;
                break;
            }
            case 3: {
                quantifier = SubqueryComparison.Quantifier.SOME;
                break;
            }
            case 2: {
                quantifier = SubqueryComparison.Quantifier.SOME;
            }
        }
        Comparison.Operator operator = Comparison.Operator.EQ;
        switch (criteria.getOperator()) {
            case 1: {
                operator = Comparison.Operator.EQ;
                break;
            }
            case 2: {
                operator = Comparison.Operator.NE;
                break;
            }
            case 3: {
                operator = Comparison.Operator.LT;
                break;
            }
            case 5: {
                operator = Comparison.Operator.LE;
                break;
            }
            case 4: {
                operator = Comparison.Operator.GT;
                break;
            }
            case 6: {
                operator = Comparison.Operator.GE;
            }
        }
        return new SubqueryComparison(this.translate(criteria.getLeftExpression()), operator, quantifier, this.translate(criteria.getCommand()));
    }

    SubqueryIn translate(SubquerySetCriteria criteria) {
        return new SubqueryIn(this.translate(criteria.getExpression()), criteria.isNegated(), this.translate(criteria.getCommand()));
    }

    Not translate(NotCriteria criteria) {
        return new Not(this.translate(criteria.getCriteria()));
    }

    public GroupBy translate(org.teiid.query.sql.lang.GroupBy groupBy) {
        if (groupBy == null) {
            return null;
        }
        List<Expression> items = groupBy.getSymbols();
        ArrayList<org.teiid.language.Expression> translatedItems = new ArrayList<org.teiid.language.Expression>();
        Iterator<Expression> i = items.iterator();
        while (i.hasNext()) {
            translatedItems.add(this.translate(i.next()));
        }
        GroupBy result = new GroupBy(translatedItems);
        result.setRollup(groupBy.isRollup());
        return result;
    }

    public org.teiid.language.OrderBy translate(OrderBy orderBy, boolean set) {
        if (orderBy == null) {
            return null;
        }
        List<OrderByItem> items = orderBy.getOrderByItems();
        ArrayList<SortSpecification> translatedItems = new ArrayList<SortSpecification>();
        for (int i = 0; i < items.size(); ++i) {
            Expression symbol = items.get(i).getSymbol();
            SortSpecification.Ordering direction = items.get(i).isAscending() ? SortSpecification.Ordering.ASC : SortSpecification.Ordering.DESC;
            SortSpecification orderByItem = null;
            orderByItem = !set && (items.get(i).isUnrelated() || symbol instanceof ElementSymbol) ? new SortSpecification(direction, this.translate(symbol)) : new SortSpecification(direction, (org.teiid.language.Expression)new ColumnReference(null, Symbol.getShortName(((Symbol)((Object)symbol)).getOutputName()), null, symbol.getType()));
            orderByItem.setNullOrdering(items.get(i).getNullOrdering());
            translatedItems.add(orderByItem);
        }
        return new org.teiid.language.OrderBy(translatedItems);
    }

    public org.teiid.language.Expression translate(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof Constant) {
            return this.translate((Constant)expr);
        }
        if (expr instanceof AggregateSymbol) {
            return this.translate((AggregateSymbol)expr);
        }
        if (expr instanceof org.teiid.query.sql.symbol.Function) {
            return this.translate((org.teiid.query.sql.symbol.Function)expr);
        }
        if (expr instanceof ScalarSubquery) {
            return this.translate((ScalarSubquery)expr);
        }
        if (expr instanceof SearchedCaseExpression) {
            return this.translate((SearchedCaseExpression)expr);
        }
        if (expr instanceof ElementSymbol) {
            return this.translate((ElementSymbol)expr);
        }
        if (expr instanceof ExpressionSymbol) {
            return this.translate((ExpressionSymbol)expr);
        }
        if (expr instanceof Criteria) {
            return this.translate((Criteria)expr);
        }
        if (expr instanceof org.teiid.query.sql.symbol.WindowFunction) {
            return this.translate((org.teiid.query.sql.symbol.WindowFunction)expr);
        }
        if (expr instanceof org.teiid.query.sql.symbol.Array) {
            return this.translate((org.teiid.query.sql.symbol.Array)expr);
        }
        throw new AssertionError((Object)(expr.getClass().getName() + " " + expr));
    }

    Array translate(org.teiid.query.sql.symbol.Array array) {
        return new Array(array.getComponentType(), this.translateExpressionList(array.getExpressions()));
    }

    WindowFunction translate(org.teiid.query.sql.symbol.WindowFunction windowFunction) {
        WindowFunction result = new WindowFunction();
        result.setFunction(this.translate(windowFunction.getFunction()));
        WindowSpecification ws = new WindowSpecification();
        ws.setOrderBy(this.translate(windowFunction.getWindowSpecification().getOrderBy(), false));
        List<Expression> partition = windowFunction.getWindowSpecification().getPartition();
        if (partition != null) {
            ArrayList<org.teiid.language.Expression> partitionList = this.translateExpressionList(partition);
            ws.setPartition(partitionList);
        }
        result.setWindowSpecification(ws);
        return result;
    }

    private ArrayList<org.teiid.language.Expression> translateExpressionList(Collection<? extends Expression> list) {
        ArrayList<org.teiid.language.Expression> result = new ArrayList<org.teiid.language.Expression>(list.size());
        for (Expression expression : list) {
            result.add(this.translate(expression));
        }
        return result;
    }

    org.teiid.language.Expression translate(Constant constant) {
        if (constant.isMultiValued()) {
            Parameter result = new Parameter();
            result.setType(constant.getType());
            List values = (List)constant.getValue();
            this.allValues.add(values);
            result.setValueIndex(this.valueIndex++);
            return result;
        }
        if (constant.getValue() instanceof ArrayImpl) {
            ArrayImpl av = (ArrayImpl)constant.getValue();
            ArrayList<Constant> vals = new ArrayList<Constant>();
            Class baseType = null;
            for (Object o : av.getValues()) {
                Constant c = new Constant(o);
                c.setBindEligible(constant.isBindEligible());
                vals.add(c);
                if (baseType == null) {
                    baseType = c.getType();
                    continue;
                }
                if (baseType.equals(c.getType())) continue;
                baseType = DataTypeManager.DefaultDataClasses.OBJECT;
            }
            return new Array(baseType, this.translateExpressionList(vals));
        }
        Literal result = new Literal(constant.getValue(), constant.getType());
        result.setBindEligible(constant.isBindEligible());
        return result;
    }

    org.teiid.language.Expression translate(org.teiid.query.sql.symbol.Function function) {
        Expression[] args = function.getArgs();
        ArrayList<org.teiid.language.Expression> params = new ArrayList<org.teiid.language.Expression>(args.length);
        for (int i = 0; i < args.length; ++i) {
            params.add(this.translate(args[i]));
        }
        String name = function.getName();
        if (function.getFunctionDescriptor() != null) {
            name = function.getFunctionDescriptor().getName();
            if (!this.supportsConcat2 && function.getFunctionDescriptor().getMethod().getParent() == null && name.equalsIgnoreCase("concat2")) {
                Expression[] newArgs = new Expression[args.length];
                boolean useCase = true;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] instanceof Constant) {
                        newArgs[i] = args[i];
                        useCase = false;
                        continue;
                    }
                    org.teiid.query.sql.symbol.Function f = new org.teiid.query.sql.symbol.Function("ifnull", new Expression[]{args[i], new Constant("")});
                    newArgs[i] = f;
                    f.setType(args[i].getType());
                    FunctionDescriptor descriptor = this.metadataFactory.getMetadata().getFunctionLibrary().findFunction("ifnull", new Class[]{args[i].getType(), DataTypeManager.DefaultDataClasses.STRING});
                    f.setFunctionDescriptor(descriptor);
                }
                org.teiid.query.sql.symbol.Function concat = new org.teiid.query.sql.symbol.Function("concat", newArgs);
                concat.setType(DataTypeManager.DefaultDataClasses.STRING);
                if (!useCase) {
                    return this.translate(concat);
                }
                FunctionDescriptor descriptor = this.metadataFactory.getMetadata().getFunctionLibrary().findFunction("concat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING});
                concat.setFunctionDescriptor(descriptor);
                List<CompoundCriteria> when = Arrays.asList(new CompoundCriteria(0, new IsNullCriteria(args[0]), new IsNullCriteria(args[1])));
                Constant nullConstant = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
                List<Constant> then = Arrays.asList(nullConstant);
                SearchedCaseExpression caseExpr = new SearchedCaseExpression(when, then);
                caseExpr.setElseExpression(concat);
                caseExpr.setType(DataTypeManager.DefaultDataClasses.STRING);
                return this.translate(caseExpr);
            }
            if (function.getFunctionDescriptor().getMethod().getNameInSource() != null && ("SYS".equals(function.getFunctionDescriptor().getSchema()) || function.getFunctionDescriptor().getMethod().getParent() != null && function.getFunctionDescriptor().getMethod().getParent().isPhysical())) {
                name = function.getFunctionDescriptor().getMethod().getNameInSource();
            }
        } else {
            name = Symbol.getShortName(name);
        }
        Function result = new Function(name, params, function.getType());
        if (function.getFunctionDescriptor() != null) {
            result.setMetadataObject(function.getFunctionDescriptor().getMethod());
        }
        return result;
    }

    SearchedCase translate(SearchedCaseExpression expr) {
        ArrayList<SearchedWhenClause> whens = new ArrayList<SearchedWhenClause>();
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            whens.add(new SearchedWhenClause(this.translate(expr.getWhenCriteria(i)), this.translate(expr.getThenExpression(i))));
        }
        return new SearchedCase(whens, this.translate(expr.getElseExpression()), expr.getType());
    }

    org.teiid.language.Expression translate(ScalarSubquery ss) {
        return new org.teiid.language.ScalarSubquery(this.translate(ss.getCommand()));
    }

    org.teiid.language.Expression translate(AliasSymbol symbol) {
        return this.translate(symbol.getSymbol());
    }

    ColumnReference translate(ElementSymbol symbol) {
        ColumnReference element = new ColumnReference(this.translate(symbol.getGroupSymbol()), Symbol.getShortName(symbol.getOutputName()), null, symbol.getType());
        if (element.getTable().getMetadataObject() == null) {
            return element;
        }
        Object mid = symbol.getMetadataID();
        element.setMetadataObject(this.metadataFactory.getElement(mid));
        return element;
    }

    AggregateFunction translate(AggregateSymbol symbol) {
        ArrayList<org.teiid.language.Expression> params = new ArrayList<org.teiid.language.Expression>(symbol.getArgs().length);
        for (Expression expression : symbol.getArgs()) {
            params.add(this.translate(expression));
        }
        String name = symbol.getAggregateFunction().name();
        if (symbol.getAggregateFunction() == AggregateSymbol.Type.USER_DEFINED) {
            name = symbol.getName();
        }
        AggregateFunction af = new AggregateFunction(name, symbol.isDistinct(), params, symbol.getType());
        af.setCondition(this.translate(symbol.getCondition()));
        af.setOrderBy(this.translate(symbol.getOrderBy(), false));
        return af;
    }

    org.teiid.language.Expression translate(ExpressionSymbol symbol) {
        return this.translate(symbol.getExpression());
    }

    org.teiid.language.Insert translate(Insert insert) {
        List<ElementSymbol> elements = insert.getVariables();
        ArrayList<ColumnReference> translatedElements = new ArrayList<ColumnReference>();
        for (ElementSymbol elementSymbol : elements) {
            translatedElements.add(this.translate(elementSymbol));
        }
        TupleSourceIterator parameterValues = null;
        QueryExpression valueSource = null;
        if (insert.getQueryExpression() != null) {
            valueSource = this.translate(insert.getQueryExpression());
        } else if (insert.getTupleSource() != null) {
            TupleSource ts = insert.getTupleSource();
            parameterValues = new TupleSourceIterator(ts);
            ArrayList<Parameter> translatedValues = new ArrayList<Parameter>();
            for (int i = 0; i < insert.getVariables().size(); ++i) {
                ElementSymbol es = insert.getVariables().get(i);
                Parameter param = new Parameter();
                param.setType(es.getType());
                param.setValueIndex(i);
                translatedValues.add(param);
            }
            valueSource = new ExpressionValueSource(translatedValues);
        } else {
            List values = insert.getValues();
            ArrayList<org.teiid.language.Expression> translatedValues = new ArrayList<org.teiid.language.Expression>();
            Iterator i = values.iterator();
            while (i.hasNext()) {
                translatedValues.add(this.translate((Expression)i.next()));
            }
            valueSource = new ExpressionValueSource(translatedValues);
        }
        org.teiid.language.Insert result = new org.teiid.language.Insert(this.translate(insert.getGroup()), translatedElements, (InsertValueSource)valueSource);
        result.setParameterValues((Iterator)parameterValues);
        this.setBatchValues((BatchedCommand)result);
        return result;
    }

    private void setBatchValues(BatchedCommand bc) {
        if (this.valueIndex == 0) {
            return;
        }
        if (bc.getParameterValues() != null) {
            throw new IllegalStateException("Already set batch values");
        }
        int rowCount = this.allValues.get(0).size();
        ArrayList result = new ArrayList(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            ArrayList row = new ArrayList(this.allValues.size());
            for (List<?> vals : this.allValues) {
                row.add(vals.get(i));
            }
            result.add(row);
        }
        bc.setParameterValues(result.iterator());
    }

    Update translate(org.teiid.query.sql.lang.Update update) {
        Update result = new Update(this.translate(update.getGroup()), this.translate(update.getChangeList()), this.translate(update.getCriteria()));
        this.setBatchValues((BatchedCommand)result);
        return result;
    }

    List<SetClause> translate(SetClauseList setClauseList) {
        ArrayList<SetClause> clauses = new ArrayList<SetClause>(setClauseList.getClauses().size());
        for (org.teiid.query.sql.lang.SetClause setClause : setClauseList.getClauses()) {
            clauses.add(this.translate(setClause));
        }
        return clauses;
    }

    SetClause translate(org.teiid.query.sql.lang.SetClause setClause) {
        return new SetClause(this.translate(setClause.getSymbol()), this.translate(setClause.getValue()));
    }

    org.teiid.language.Delete translate(Delete delete) {
        org.teiid.language.Delete deleteImpl = new org.teiid.language.Delete(this.translate(delete.getGroup()), this.translate(delete.getCriteria()));
        this.setBatchValues((BatchedCommand)deleteImpl);
        return deleteImpl;
    }

    Call translate(StoredProcedure sp) {
        Procedure proc = null;
        if (sp.getProcedureID() != null) {
            try {
                proc = this.metadataFactory.getProcedure(sp.getGroup().getName());
            }
            catch (TranslatorException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30486, (Throwable)e);
            }
        }
        Class<?> returnType = null;
        ArrayList<Argument> translatedParameters = new ArrayList<Argument>();
        block9: for (SPParameter param : sp.getParameters()) {
            Argument.Direction direction = Argument.Direction.IN;
            switch (param.getParameterType()) {
                case 1: {
                    direction = Argument.Direction.IN;
                    break;
                }
                case 3: {
                    direction = Argument.Direction.INOUT;
                    break;
                }
                case 2: {
                    direction = Argument.Direction.OUT;
                    break;
                }
                case 5: {
                    continue block9;
                }
                case 4: {
                    returnType = param.getClassType();
                    continue block9;
                }
            }
            if (param.isUsingDefault() && "omit".equalsIgnoreCase(this.metadataFactory.getMetadata().getExtensionProperty(param.getMetadataID(), "{http://www.teiid.org/ext/relational/2012}default_handling", false))) continue;
            ProcedureParameter metadataParam = this.metadataFactory.getParameter(param);
            Literal value = null;
            if (direction != Argument.Direction.OUT) {
                if (param.isVarArg()) {
                    ArrayImpl av = (ArrayImpl)((Constant)param.getExpression()).getValue();
                    if (av == null) break;
                    for (Object obj : av.getValues()) {
                        Argument arg = new Argument(direction, (org.teiid.language.Expression)new Literal(obj, param.getClassType().getComponentType()), param.getClassType().getComponentType(), metadataParam);
                        translatedParameters.add(arg);
                    }
                    break;
                }
                value = (Literal)this.translate(param.getExpression());
            }
            Argument arg = new Argument(direction, value, param.getClassType(), metadataParam);
            translatedParameters.add(arg);
        }
        Call call = new Call(this.removeSchemaName(sp.getProcedureName()), translatedParameters, proc);
        call.setReturnType(returnType);
        return call;
    }

    public NamedTable translate(GroupSymbol symbol) {
        String alias = null;
        String fullGroup = symbol.getOutputName();
        if (symbol.getOutputDefinition() != null) {
            alias = symbol.getOutputName();
            fullGroup = symbol.getOutputDefinition();
        }
        fullGroup = this.removeSchemaName(fullGroup);
        NamedTable group = new NamedTable(fullGroup, alias, null);
        try {
            group.setMetadataObject(this.metadataFactory.getGroup(symbol.getMetadataID()));
        }
        catch (QueryMetadataException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30487, (Throwable)((Object)e));
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30488, (Throwable)e);
        }
        return group;
    }

    private String removeSchemaName(String fullGroup) {
        int index = fullGroup.indexOf(".");
        if (index > 0) {
            fullGroup = fullGroup.substring(index + 1);
        }
        return fullGroup;
    }

    BatchedUpdates translate(BatchedUpdateCommand command) {
        List<org.teiid.query.sql.lang.Command> updates = command.getUpdateCommands();
        ArrayList<Command> translatedUpdates = new ArrayList<Command>(updates.size());
        Iterator<org.teiid.query.sql.lang.Command> i = updates.iterator();
        while (i.hasNext()) {
            translatedUpdates.add(this.translate(i.next()));
        }
        return new BatchedUpdates(translatedUpdates);
    }

    org.teiid.language.Limit translate(Limit limit) {
        if (limit == null) {
            return null;
        }
        int rowOffset = 0;
        if (limit.getOffset() != null) {
            Literal c1 = (Literal)this.translate(limit.getOffset());
            rowOffset = (Integer)c1.getValue();
        }
        Literal c2 = (Literal)this.translate(limit.getRowLimit());
        int rowLimit = Integer.MAX_VALUE;
        if (c2 != null) {
            rowLimit = (Integer)c2.getValue();
        }
        return new org.teiid.language.Limit(rowOffset, rowLimit);
    }

    public void setMaxInPredicateSize(int maxInCriteriaSize) {
        this.maxInCriteriaSize = maxInCriteriaSize;
    }

    private final class TupleSourceIterator
    implements Iterator<List<?>> {
        private final TupleSource ts;
        List<?> nextRow;

        private TupleSourceIterator(TupleSource ts) {
            this.ts = ts;
        }

        @Override
        public boolean hasNext() {
            if (this.nextRow == null) {
                try {
                    this.nextRow = this.ts.nextTuple();
                }
                catch (TeiidComponentException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30484, (Throwable)e);
                }
                catch (TeiidProcessingException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30485, (Throwable)e);
                }
            }
            return this.nextRow != null;
        }

        @Override
        public List<?> next() {
            if (this.nextRow == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            List<?> result = this.nextRow;
            this.nextRow = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class TupleBufferList
    extends AbstractList<List<?>>
    implements RandomAccess {
        private final TupleBuffer tb;

        private TupleBufferList(TupleBuffer tb) {
            this.tb = tb;
        }

        @Override
        public List<?> get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            try {
                return this.tb.getBatch(index + 1).getTuple(index + 1);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30483, (Throwable)e);
            }
        }

        @Override
        public int size() {
            return this.tb.getRowCount();
        }
    }
}

