/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.util.CommandContext;

public final class RuleValidateWhereAll
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode node : NodeEditor.findAllNodes(plan, 1)) {
            Object modelID = RuleRaiseAccess.getModelIDFromAccess(node, metadata);
            if (!CapabilitiesUtil.requiresCriteria(modelID, metadata, capFinder) || !RuleValidateWhereAll.hasNoCriteria((Command)node.getProperty(NodeConstants.Info.ATOMIC_REQUEST))) continue;
            String modelName = metadata.getFullName(modelID);
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30268, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30268, new Object[]{modelName}));
        }
        return plan;
    }

    static boolean hasNoCriteria(Command command) {
        if (command instanceof Query) {
            Query query = (Query)command;
            return query.getCriteria() == null;
        }
        if (command instanceof Delete) {
            Delete query = (Delete)command;
            return query.getCriteria() == null;
        }
        if (command instanceof Update) {
            Update query = (Update)command;
            return query.getCriteria() == null;
        }
        if (command instanceof SetQuery) {
            SetQuery query = (SetQuery)command;
            return RuleValidateWhereAll.hasNoCriteria(query.getLeftQuery()) || RuleValidateWhereAll.hasNoCriteria(query.getRightQuery());
        }
        return false;
    }

    public String toString() {
        return "ValidateWhereAll";
    }
}

