/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.CapabilitiesConverter;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.sql.lang.Command;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConnectorManager {
    private static final String JAVA_CONTEXT = "java:/";
    private String translatorName;
    private String connectionName;
    private List<String> id;
    private ConcurrentHashMap<AtomicRequestID, ConnectorWorkItem> requestStates = new ConcurrentHashMap();
    private SourceCapabilities cachedCapabilities;
    private volatile boolean stopped;
    private ExecutionFactory<Object, Object> executionFactory;

    public ConnectorManager(String translatorName, String connectionName) {
        this.translatorName = translatorName;
        this.connectionName = connectionName;
        this.id = Arrays.asList(translatorName, connectionName);
    }

    public String getStausMessage() {
        String msg = "";
        ExecutionFactory<Object, Object> ef = this.getExecutionFactory();
        if (ef != null) {
            if (ef.isSourceRequired()) {
                Object conn = null;
                try {
                    conn = this.getConnectionFactory();
                }
                catch (TranslatorException e) {
                    // empty catch block
                }
                if (conn == null) {
                    msg = QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.connectionName});
                }
            }
        } else {
            msg = QueryPlugin.Util.getString("translator_not_found", new Object[]{this.translatorName});
        }
        return msg;
    }

    public List<FunctionMethod> getPushDownFunctions() {
        return this.getExecutionFactory().getPushDownFunctions();
    }

    public SourceCapabilities getCapabilities() throws TeiidComponentException {
        if (this.cachedCapabilities != null) {
            return this.cachedCapabilities;
        }
        this.checkStatus();
        ExecutionFactory<Object, Object> translator = this.getExecutionFactory();
        BasicSourceCapabilities resultCaps = CapabilitiesConverter.convertCapabilities(translator, this.id);
        this.cachedCapabilities = resultCaps;
        return resultCaps;
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        this.checkStatus();
        AtomicRequestID atomicRequestId = message.getAtomicRequestID();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{atomicRequestId, "Create State"});
        ConnectorWorkItem item = new ConnectorWorkItem(message, this);
        Assertion.isNull((Object)this.requestStates.put(atomicRequestId, item), (String)"State already existed");
        return item;
    }

    ConnectorWork getState(AtomicRequestID requestId) {
        return this.requestStates.get(requestId);
    }

    boolean removeState(AtomicRequestID id) {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{id, "Remove State"});
        return this.requestStates.remove(id) != null;
    }

    int size() {
        return this.requestStates.size();
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{QueryPlugin.Util.getString("ConnectorManagerImpl.Initializing_connector", new Object[]{this.translatorName})});
    }

    public void stop() {
        this.stopped = true;
        for (ConnectorWorkItem workItem : this.requestStates.values()) {
            workItem.cancel();
        }
    }

    void logSRCCommand(AtomicRequestMessage qr, ExecutionContext context, CommandLogMessage.Event cmdStatus, Integer finalRowCnt) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5)) {
            return;
        }
        String sqlStr = null;
        if (cmdStatus == CommandLogMessage.Event.NEW) {
            Command cmd = qr.getCommand();
            sqlStr = cmd != null ? cmd.toString() : null;
        }
        String userName = qr.getWorkContext().getUserName();
        String transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTransactionId();
        }
        String modelName = qr.getModelName();
        AtomicRequestID id = qr.getAtomicRequestID();
        String principal = userName == null ? "unknown" : userName;
        CommandLogMessage message = null;
        message = cmdStatus == CommandLogMessage.Event.NEW ? new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, sqlStr, context) : new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, finalRowCnt, cmdStatus, context);
        LogManager.log((int)5, (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    public ExecutionFactory<Object, Object> getExecutionFactory() {
        return this.executionFactory;
    }

    public void setExecutionFactory(ExecutionFactory<?, ?> ef) {
        this.executionFactory = ef;
    }

    public Object getConnectionFactory() throws TranslatorException {
        if (this.connectionName != null) {
            String jndiName = this.connectionName;
            if (!this.connectionName.startsWith(JAVA_CONTEXT)) {
                jndiName = JAVA_CONTEXT + jndiName;
            }
            try {
                InitialContext ic = new InitialContext();
                try {
                    return ic.lookup(jndiName);
                }
                catch (Exception e) {
                    if (!jndiName.equals(this.connectionName)) {
                        return ic.lookup(this.connectionName);
                    }
                }
            }
            catch (Exception e) {
                throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30481, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30481, new Object[]{this.connectionName}));
            }
        }
        return null;
    }

    private void checkStatus() throws TeiidComponentException {
        if (this.stopped) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30482, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30482, new Object[]{this.translatorName}));
        }
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public List<String> getId() {
        return this.id;
    }
}

