/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class QueryString
implements Expression {
    private static final long serialVersionUID = -3348922701950966494L;
    private List<DerivedColumn> args;
    private Expression path;

    public QueryString(Expression path, List<DerivedColumn> args) {
        this.args = args;
        this.path = path;
    }

    public List<DerivedColumn> getArgs() {
        return this.args;
    }

    @Override
    public QueryString clone() {
        QueryString clone = new QueryString((Expression)this.path.clone(), LanguageObject.Util.deepClone(this.args, DerivedColumn.class));
        return clone;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryString)) {
            return false;
        }
        QueryString other = (QueryString)obj;
        return this.path.equals(other.path) && ((Object)this.args).equals(other.args);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Expression getPath() {
        return this.path;
    }

    public void setPath(Expression path) {
        this.path = path;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public Class<?> getType() {
        return DataTypeManager.DefaultDataClasses.STRING;
    }
}

