/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.XMLType;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.message.RequestID;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.tempdata.TempTableStore;

public class MetaDataProcessor {
    public static final String XML_COLUMN_NAME = "xml";
    private DQPCore requestManager;
    private QueryMetadataInterface metadata;
    private SessionAwareCache<PreparedPlan> planCache;
    private String vdbName;
    private int vdbVersion;
    private RequestID requestID;
    private boolean labelAsName;

    public MetaDataProcessor(DQPCore requestManager, SessionAwareCache<PreparedPlan> planCache, String vdbName, int vdbVersion) {
        this.requestManager = requestManager;
        this.planCache = planCache;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
    }

    MetadataResult processMessage(RequestID requestId, DQPWorkContext workContext, String preparedSql, boolean allowDoubleQuotedVariable) throws TeiidComponentException, TeiidProcessingException {
        DQPCore.ClientState state;
        RequestWorkItem workItem;
        block5: {
            this.requestID = requestId;
            this.metadata = (QueryMetadataInterface)workContext.getVDB().getAttachment(QueryMetadataInterface.class);
            this.labelAsName = workContext.getClientVersion().compareTo(DQPWorkContext.Version.SEVEN_3) <= 0;
            workItem = null;
            try {
                workItem = this.requestManager.getRequestWorkItem(this.requestID);
            }
            catch (TeiidProcessingException e) {
                if (preparedSql != null) break block5;
                throw e;
            }
        }
        TempTableStore tempTableStore = null;
        if (this.requestManager != null && (state = this.requestManager.getClientState(workContext.getSessionId(), false)) != null) {
            tempTableStore = state.sessionTables;
        }
        if (tempTableStore != null) {
            this.metadata = new TempMetadataAdapter(this.metadata, tempTableStore.getMetadataStore());
        }
        if (workItem != null) {
            return this.getMetadataForCommand(workItem.getOriginalCommand());
        }
        return this.obtainMetadataForPreparedSql(preparedSql, workContext, allowDoubleQuotedVariable);
    }

    private MetadataResult getMetadataForCommand(Command originalCommand) throws TeiidComponentException {
        Map[] columnMetadata = null;
        switch (originalCommand.getType()) {
            case 1: {
                if (originalCommand instanceof Query) {
                    if (((Query)originalCommand).getIsXML()) {
                        columnMetadata = new Map[]{this.createXMLColumnMetadata((Query)originalCommand)};
                        break;
                    }
                    if (((Query)originalCommand).getInto() != null) break;
                    columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                    break;
                }
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 6: {
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                columnMetadata = this.createProjectedSymbolMetadata(originalCommand);
            }
        }
        Map<Reference, String> paramMap = Collections.emptyMap();
        if (originalCommand instanceof StoredProcedure) {
            StoredProcedure sp = (StoredProcedure)originalCommand;
            paramMap = new HashMap();
            Collection<SPParameter> params = sp.getParameters();
            for (SPParameter spParameter : params) {
                if (spParameter.getParameterType() != 3 && spParameter.getParameterType() != 1 && spParameter.getParameterType() != 4) continue;
                Expression ex = spParameter.getExpression();
                if (ex instanceof Function && FunctionLibrary.isConvert((Function)ex)) {
                    ex = ((Function)ex).getArg(0);
                }
                if (!(ex instanceof Reference)) continue;
                paramMap.put((Reference)ex, spParameter.getParameterSymbol().getShortName());
            }
        }
        List<Reference> params = ReferenceCollectorVisitor.getReferences(originalCommand);
        Map[] paramMetadata = new Map[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Reference param = params.get(i);
            paramMetadata[i] = this.getDefaultColumn(null, (String)paramMap.get(param), param.getType());
        }
        return new MetadataResult(columnMetadata, paramMetadata);
    }

    private Map<Integer, Object>[] createProjectedSymbolMetadata(Command originalCommand) throws TeiidComponentException {
        TempMetadataStore tempMetadata = originalCommand.getTemporaryMetadata();
        if (tempMetadata != null && tempMetadata.getData().size() > 0) {
            TempMetadataAdapter tempFacade = new TempMetadataAdapter(this.metadata, tempMetadata);
            this.metadata = tempFacade;
        }
        List<Expression> projectedSymbols = originalCommand.getProjectedSymbols();
        Map[] columnMetadata = new Map[projectedSymbols.size()];
        Iterator<Expression> symbolIter = projectedSymbols.iterator();
        int i = 0;
        while (symbolIter.hasNext()) {
            Expression symbol = symbolIter.next();
            String shortColumnName = Symbol.getShortName(Symbol.getOutputName(symbol));
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            try {
                columnMetadata[i] = this.createColumnMetadata(shortColumnName, symbol);
            }
            catch (QueryMetadataException e) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30559, (Throwable)((Object)e));
            }
            ++i;
        }
        return columnMetadata;
    }

    private MetadataResult obtainMetadataForPreparedSql(String sql, DQPWorkContext workContext, boolean isDoubleQuotedVariablesAllowed) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Command command = null;
        ParseInfo info = new ParseInfo();
        info.ansiQuotedIdentifiers = isDoubleQuotedVariablesAllowed;
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(workContext, info, sql);
        PreparedPlan plan = this.planCache.get(id);
        if (plan != null) {
            command = plan.getCommand();
        } else {
            command = QueryParser.getQueryParser().parseCommand(sql, info);
            QueryResolver.resolveCommand(command, this.metadata);
        }
        return this.getMetadataForCommand(command);
    }

    private Map<Integer, Object> createXMLColumnMetadata(Query xmlCommand) {
        GroupSymbol doc = xmlCommand.getFrom().getGroups().get(0);
        Map<Integer, Object> xmlMetadata = this.getDefaultColumn(doc.getName(), XML_COLUMN_NAME, XMLType.class);
        xmlMetadata.put(ResultsMetadataConstants.DISPLAY_SIZE, JDBCSQLTypeInfo.XML_COLUMN_LENGTH);
        return xmlMetadata;
    }

    private Map<Integer, Object> createColumnMetadata(String label, Expression symbol) throws QueryMetadataException, TeiidComponentException {
        if (symbol instanceof ElementSymbol) {
            return this.createElementMetadata(label, (ElementSymbol)symbol);
        }
        if ((symbol = SymbolMap.getExpression(symbol)) instanceof AggregateSymbol) {
            return this.createAggregateMetadata(label, (AggregateSymbol)symbol);
        }
        if (symbol instanceof WindowFunction) {
            return this.createAggregateMetadata(label, ((WindowFunction)symbol).getFunction());
        }
        return this.createTypedMetadata(label, symbol);
    }

    private Map<Integer, Object> createElementMetadata(String label, ElementSymbol symbol) throws QueryMetadataException, TeiidComponentException {
        Object elementID = symbol.getMetadataID();
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, this.metadata.elementSupports(elementID, 8));
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, this.metadata.elementSupports(elementID, 9));
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        Class<?> type = symbol.getType();
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName(type));
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, label);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, this.labelAsName ? label : this.metadata.getName(elementID));
        GroupSymbol group = symbol.getGroupSymbol();
        if (group == null || group.getMetadataID() == null) {
            column.put(ResultsMetadataConstants.GROUP_NAME, null);
        } else {
            column.put(ResultsMetadataConstants.GROUP_NAME, this.metadata.getFullName(group.getMetadataID()));
        }
        boolean allowsNull = this.metadata.elementSupports(elementID, 4);
        boolean unknown = this.metadata.elementSupports(elementID, 10);
        Integer nullable = null;
        nullable = unknown ? ResultsMetadataConstants.NULL_TYPES.UNKNOWN : (allowsNull ? ResultsMetadataConstants.NULL_TYPES.NULLABLE : ResultsMetadataConstants.NULL_TYPES.NOT_NULL);
        column.put(ResultsMetadataConstants.NULLABLE, nullable);
        column.put(ResultsMetadataConstants.RADIX, new Integer(this.metadata.getRadix(elementID)));
        column.put(ResultsMetadataConstants.SCALE, new Integer(this.metadata.getScale(elementID)));
        int precision = this.getColumnPrecision(type, elementID);
        column.put(ResultsMetadataConstants.PRECISION, new Integer(precision));
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, this.getColumnDisplaySize(precision, type, elementID));
        boolean comparable = this.metadata.elementSupports(elementID, 2);
        boolean likable = this.metadata.elementSupports(elementID, 1);
        Integer searchable = null;
        searchable = comparable ? (likable ? ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE : ResultsMetadataConstants.SEARCH_TYPES.ALLEXCEPTLIKE) : (likable ? ResultsMetadataConstants.SEARCH_TYPES.LIKE_ONLY : ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        column.put(ResultsMetadataConstants.SIGNED, this.metadata.elementSupports(elementID, 11));
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.vdbName);
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.vdbVersion);
        column.put(ResultsMetadataConstants.WRITABLE, new Boolean(this.metadata.elementSupports(elementID, 5)));
        return column;
    }

    private Map<Integer, Object> createAggregateMetadata(String shortColumnName, AggregateSymbol symbol) throws QueryMetadataException, TeiidComponentException {
        Expression expression;
        AggregateSymbol.Type function = symbol.getAggregateFunction();
        if ((function == AggregateSymbol.Type.MIN || function == AggregateSymbol.Type.MAX) && (expression = symbol.getArg(0)) instanceof ElementSymbol) {
            return this.createColumnMetadata(shortColumnName, expression);
        }
        return this.createTypedMetadata(shortColumnName, symbol);
    }

    private Map<Integer, Object> createTypedMetadata(String shortColumnName, Expression symbol) {
        return this.getDefaultColumn(null, shortColumnName, symbol.getType());
    }

    private int getColumnPrecision(Class<?> dataType, Object elementID) throws QueryMetadataException, TeiidComponentException {
        if (!Number.class.isAssignableFrom(dataType)) {
            int length = this.metadata.getElementLength(elementID);
            if (length > 0) {
                return length;
            }
        } else {
            int precision = this.metadata.getPrecision(elementID);
            if (precision > 0) {
                return precision;
            }
        }
        return JDBCSQLTypeInfo.getDefaultPrecision(dataType);
    }

    private Integer getColumnDisplaySize(int precision, Class<?> dataType, Object elementID) throws QueryMetadataException, TeiidComponentException {
        int length;
        if (elementID != null && dataType.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            int length2 = this.metadata.getElementLength(elementID);
            if (length2 > 0) {
                return new Integer(length2);
            }
        } else if (Number.class.isAssignableFrom(dataType)) {
            if (precision > 0) {
                int displayLength = precision;
                displayLength = precision + 1;
                if (dataType.equals(DataTypeManager.DefaultDataClasses.FLOAT) || dataType.equals(DataTypeManager.DefaultDataClasses.DOUBLE) || dataType.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                    ++displayLength;
                }
                return new Integer(displayLength);
            }
        } else if (elementID != null && (dataType.equals(DataTypeManager.DefaultDataClasses.CLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.BLOB) || dataType.equals(DataTypeManager.DefaultDataClasses.OBJECT)) && (length = this.metadata.getElementLength(elementID)) > 0) {
            return new Integer(length);
        }
        return JDBCSQLTypeInfo.getMaxDisplaySize(dataType);
    }

    public Map<Integer, Object> getDefaultColumn(String tableName, String columnName, Class<?> javaType) {
        return this.getDefaultColumn(tableName, columnName, columnName, javaType);
    }

    public Map<Integer, Object> getDefaultColumn(String tableName, String columnName, String columnLabel, Class<?> javaType) {
        HashMap<Integer, Object> column = new HashMap<Integer, Object>();
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_NAME, this.vdbName);
        column.put(ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION, this.vdbVersion);
        column.put(ResultsMetadataConstants.GROUP_NAME, tableName);
        column.put(ResultsMetadataConstants.ELEMENT_NAME, this.labelAsName ? columnLabel : columnName);
        column.put(ResultsMetadataConstants.ELEMENT_LABEL, columnLabel);
        column.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        column.put(ResultsMetadataConstants.CASE_SENSITIVE, Boolean.FALSE);
        column.put(ResultsMetadataConstants.NULLABLE, ResultsMetadataConstants.NULL_TYPES.NULLABLE);
        column.put(ResultsMetadataConstants.SEARCHABLE, ResultsMetadataConstants.SEARCH_TYPES.SEARCHABLE);
        column.put(ResultsMetadataConstants.WRITABLE, Boolean.TRUE);
        column.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        column.put(ResultsMetadataConstants.DATA_TYPE, DataTypeManager.getDataTypeName(javaType));
        column.put(ResultsMetadataConstants.RADIX, JDBCSQLTypeInfo.DEFAULT_RADIX);
        column.put(ResultsMetadataConstants.SCALE, JDBCSQLTypeInfo.DEFAULT_SCALE);
        column.put(ResultsMetadataConstants.SIGNED, Boolean.TRUE);
        column.put(ResultsMetadataConstants.PRECISION, JDBCSQLTypeInfo.getDefaultPrecision(javaType));
        column.put(ResultsMetadataConstants.DISPLAY_SIZE, JDBCSQLTypeInfo.getMaxDisplaySize(javaType));
        return column;
    }
}

