/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public abstract class AbstractTupleSource
implements IndexedTupleSource {
    private int currentRow = 1;
    private int mark = 1;
    private List<?> currentTuple;
    protected TupleBatch batch;

    @Override
    public int getCurrentIndex() {
        return this.currentRow;
    }

    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        List<?> result = null;
        if (this.currentTuple != null) {
            result = this.currentTuple;
            this.currentTuple = null;
        } else {
            result = this.getCurrentTuple();
        }
        if (result != null) {
            ++this.currentRow;
        }
        return result;
    }

    protected List<?> getCurrentTuple() throws TeiidComponentException, BlockedException, TeiidProcessingException {
        if (this.available() > 0) {
            int row = this.getCurrentIndex();
            if (this.batch == null || !this.batch.containsRow(row)) {
                this.batch = this.getBatch(row);
            }
            return this.batch.getTuple(row);
        }
        this.batch = null;
        return this.finalRow();
    }

    protected abstract List<?> finalRow() throws BlockedException, TeiidComponentException, TeiidProcessingException;

    protected abstract TupleBatch getBatch(int var1) throws TeiidComponentException, TeiidProcessingException;

    protected abstract int available();

    @Override
    public void closeSource() {
        this.batch = null;
        this.mark = 1;
        this.reset();
    }

    @Override
    public boolean hasNext() throws TeiidComponentException, TeiidProcessingException {
        if (this.currentTuple != null) {
            return true;
        }
        this.currentTuple = this.getCurrentTuple();
        return this.currentTuple != null;
    }

    @Override
    public void reset() {
        this.setPosition(this.mark);
        this.mark = 1;
    }

    @Override
    public void mark() {
        this.mark = this.currentRow;
    }

    @Override
    public void setPosition(int position) {
        if (this.currentRow != position) {
            this.currentRow = position;
            this.currentTuple = null;
        }
    }
}

