/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.json.simple.ContentHandler;
import org.teiid.json.simple.JSONParser;
import org.teiid.json.simple.ParseException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.util.CommandContext;

public class JSONFunctionMethods {
    private static final ContentHandler validatingContentHandler = new ContentHandler(){

        @Override
        public boolean startObjectEntry(String key) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean startObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void startJSON() throws ParseException, IOException {
        }

        @Override
        public boolean startArray() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean primitive(Object value) throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObjectEntry() throws ParseException, IOException {
            return true;
        }

        @Override
        public boolean endObject() throws ParseException, IOException {
            return true;
        }

        @Override
        public void endJSON() throws ParseException, IOException {
        }

        @Override
        public boolean endArray() throws ParseException, IOException {
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TeiidFunction(category="JSON")
    public static ClobType jsonParse(ClobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        Reader r = null;
        if (val.getType() == ClobType.Type.JSON) {
            return val;
        }
        if (!wellformed) {
            r = val.getCharacterStream();
        }
        try {
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            ClobType ct = new ClobType((Clob)val.getReference());
            ct.setType(ClobType.Type.JSON);
            ClobType clobType = ct;
            return clobType;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TeiidFunction(category="JSON")
    public static ClobType jsonParse(BlobType val, boolean wellformed) throws SQLException, IOException, ParseException {
        InputStreamReader r = XMLSystemFunctions.getJsonReader((Blob)val);
        try {
            if (!wellformed) {
                JSONParser parser = new JSONParser();
                parser.parse(r, validatingContentHandler);
            }
            ClobImpl clobImpl = new ClobImpl();
            clobImpl.setStreamFactory((InputStreamFactory)new InputStreamFactory.BlobInputStreamFactory((Blob)val.getReference()));
            clobImpl.setEncoding(r.getEncoding());
            ClobType ct = new ClobType((Clob)clobImpl);
            ct.setType(ClobType.Type.JSON);
            ClobType clobType = ct;
            return clobType;
        }
        finally {
            r.close();
        }
    }

    @TeiidFunction(category="JSON")
    public static ClobType jsonArray(CommandContext context, Object ... vals) throws TeiidProcessingException {
        if (vals == null) {
            return null;
        }
        BufferManager bm = context.getBufferManager();
        JSONBuilder array = new JSONBuilder(bm, true);
        for (Object object : vals) {
            array.addValue(object);
        }
        return array.close();
    }

    public static class JSONBuilder {
        private Writer writer;
        private FileStoreInputStreamFactory fsisf;
        private FileStore fs;
        private boolean initial = true;
        private boolean array;

        public JSONBuilder(BufferManager bm, boolean array) throws TeiidProcessingException {
            this.array = array;
            this.fs = bm.createFileStore("xml");
            this.fsisf = new FileStoreInputStreamFactory(this.fs, "UTF-8");
            this.writer = this.fsisf.getWriter();
            try {
                if (array) {
                    this.writer.append('[');
                } else {
                    this.writer.append('{');
                }
            }
            catch (IOException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
            }
        }

        public void addValue(Object object) throws TeiidProcessingException {
            this.addValue(null, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValue(String key, Object object) throws TeiidProcessingException {
            block16: {
                try {
                    if (this.initial) {
                        this.initial = false;
                    } else {
                        this.writer.append(',');
                    }
                    if (!this.array) {
                        this.writer.append('\"');
                        JSONParser.escape(key, this.writer);
                        this.writer.append('\"');
                        this.writer.append(":");
                    }
                    if (object == null) {
                        this.writer.append("null");
                        break block16;
                    }
                    if (object instanceof ClobType) {
                        ClobType clob = (ClobType)object;
                        if (clob.getType() == ClobType.Type.JSON) {
                            Reader r = clob.getCharacterStream();
                            try {
                                ObjectConverterUtil.write((Writer)this.writer, (Reader)r, (int)-1, (boolean)false);
                                break block16;
                            }
                            finally {
                                r.close();
                            }
                        }
                        this.writer.append('\"');
                        JSONParser.escape(clob.getCharSequence(), this.writer);
                        this.writer.append('\"');
                        break block16;
                    }
                    if (object instanceof Boolean) {
                        this.writer.append(object.toString());
                    } else if (object instanceof Number) {
                        this.writer.write(object.toString());
                    } else {
                        this.writer.append('\"');
                        String text = (String)DataTypeManager.transformValue((Object)object, (Class)DataTypeManager.DefaultDataClasses.STRING);
                        JSONParser.escape(text, this.writer);
                        this.writer.append('\"');
                    }
                }
                catch (IOException e) {
                    this.fs.remove();
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
                }
                catch (SQLException e) {
                    this.fs.remove();
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30438, (Throwable)e);
                }
            }
        }

        public Writer getWriter() {
            return this.writer;
        }

        public ClobType close() throws TeiidProcessingException {
            try {
                if (this.array) {
                    this.writer.append(']');
                } else {
                    this.writer.append('}');
                }
                this.writer.close();
            }
            catch (IOException e) {
                this.fs.remove();
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30442, (Throwable)e);
            }
            ClobType result = new ClobType((Clob)new ClobImpl((InputStreamFactory)this.fsisf, -1L));
            result.setType(ClobType.Type.JSON);
            return result;
        }
    }
}

