/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.processor.relational.TupleSourceValueIterator;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.ValueIterator;

public class DependentCriteriaProcessor {
    private static final int SORT = 2;
    private static final int SET_PROCESSING = 3;
    private int maxSetSize;
    private int maxPredicates;
    private RelationalNode dependentNode;
    private Criteria dependentCrit;
    private List<Criteria> queryCriteria;
    private Map<Integer, SetState> setStates = new HashMap<Integer, SetState>();
    private LinkedHashMap<String, TupleState> dependentState = new LinkedHashMap();
    private List<List<SetState>> sources = new ArrayList<List<SetState>>();
    private int phase = 2;
    private LinkedList<Integer> restartIndexes = new LinkedList();
    private int currentIndex;
    private boolean hasNextCommand;
    protected SubqueryAwareEvaluator eval;

    public DependentCriteriaProcessor(int maxSetSize, int maxPredicates, RelationalNode dependentNode, Criteria dependentCriteria) throws ExpressionEvaluationException, TeiidComponentException {
        this.maxSetSize = maxSetSize;
        this.maxPredicates = maxPredicates;
        this.dependentNode = dependentNode;
        this.dependentCrit = dependentCriteria;
        this.eval = new SubqueryAwareEvaluator(Collections.emptyMap(), dependentNode.getDataManager(), dependentNode.getContext(), dependentNode.getBufferManager());
        this.queryCriteria = Criteria.separateCriteriaByAnd(this.dependentCrit);
        for (int i = 0; i < this.queryCriteria.size(); ++i) {
            TupleState ts;
            Criteria criteria = this.queryCriteria.get(i);
            if (!(criteria instanceof AbstractSetCriteria)) continue;
            if (criteria instanceof SetCriteria) {
                SetCriteria setCriteria = (SetCriteria)criteria;
                if (setCriteria.isNegated() || setCriteria.getNumberOfValues() <= maxSetSize || !setCriteria.isAllConstants()) continue;
                SetState state = new SetState();
                this.setStates.put(i, state);
                LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                for (Expression expr : setCriteria.getValues()) {
                    values.add(this.eval.evaluate(expr, null));
                }
                state.valueIterator = new CollectionValueIterator(values);
                this.sources.add(Arrays.asList(state));
                continue;
            }
            if (!(criteria instanceof DependentSetCriteria)) continue;
            DependentSetCriteria dsc = (DependentSetCriteria)criteria;
            String source = dsc.getContextSymbol();
            SetState state = new SetState();
            this.setStates.put(i, state);
            state.valueExpression = dsc.getValueExpression();
            if (dsc.hasMultipleAttributes()) {
                state.valueCount = ((Array)dsc.getExpression()).getExpressions().size();
            }
            if ((ts = this.dependentState.get(source)) == null) {
                ts = new TupleState(source);
                this.dependentState.put(source, ts);
                this.sources.add(ts.getDepedentSetStates());
            }
            ts.getDepedentSetStates().add(state);
            state.maxNdv = dsc.getMaxNdv();
        }
    }

    public void close() {
        if (this.dependentState != null) {
            for (TupleState state : this.dependentState.values()) {
                state.close();
            }
        }
        if (this.eval != null) {
            this.eval.close();
        }
    }

    public Criteria prepareCriteria() throws TeiidComponentException, TeiidProcessingException {
        if (this.phase == 2) {
            for (TupleState state : this.dependentState.values()) {
                state.sort();
            }
            this.phase = 3;
        }
        this.replaceDependentValueIterators();
        LinkedList<Criteria> crits = new LinkedList<Criteria>();
        for (int i = 0; i < this.queryCriteria.size(); ++i) {
            SetState state = this.setStates.get(i);
            if (state == null) {
                crits.add((Criteria)this.queryCriteria.get(i).clone());
                continue;
            }
            Criteria crit = this.replaceDependentCriteria((AbstractSetCriteria)this.queryCriteria.get(i), state);
            if (crit == QueryRewriter.FALSE_CRITERIA) {
                return QueryRewriter.FALSE_CRITERIA;
            }
            crits.add(crit);
        }
        if (crits.size() == 1) {
            return (Criteria)crits.get(0);
        }
        return new CompoundCriteria(0, crits);
    }

    public void consumedCriteria() {
        int restartIndex;
        if (this.restartIndexes.isEmpty()) {
            return;
        }
        for (int i = restartIndex = this.restartIndexes.removeLast().intValue(); i < this.sources.size(); ++i) {
            List<SetState> source = this.sources.get(i);
            for (SetState setState : source) {
                setState.replacement.clear();
            }
        }
        this.currentIndex = restartIndex;
    }

    private void replaceDependentValueIterators() throws TeiidComponentException {
        int totalPredicates = this.setStates.size();
        if (this.maxPredicates > 0) {
            totalPredicates = Math.max(totalPredicates, this.maxPredicates);
        }
        long maxSize = Integer.MAX_VALUE;
        if (this.maxSetSize > 0) {
            maxSize = this.maxSetSize;
            if (this.maxPredicates > 0 && totalPredicates > this.maxPredicates) {
                long maxParams = this.maxPredicates * this.maxSetSize;
                maxSize = Math.max(1L, maxParams / (long)totalPredicates);
            }
        }
        int currentPredicates = 0;
        int run = 0;
        while (currentPredicates < totalPredicates) {
            currentPredicates = 0;
            if (!this.restartIndexes.isEmpty()) {
                this.currentIndex = this.restartIndexes.removeLast();
            }
            for (int i = 0; i < this.sources.size(); ++i) {
                List<SetState> source = this.sources.get(i);
                if (i == this.currentIndex) {
                    ++this.currentIndex;
                    int doneCount = 0;
                    while (doneCount < source.size()) {
                        boolean isNull = false;
                        boolean lessThanMax = true;
                        for (SetState state : source) {
                            if (state.overMax) {
                                ++doneCount;
                                continue;
                            }
                            if (state.nextValue == null && !state.isNull) {
                                if (state.valueIterator.hasNext()) {
                                    state.nextValue = state.valueIterator.next();
                                    state.isNull = state.nextValue == null;
                                } else {
                                    state.valueIterator.reset();
                                    ++doneCount;
                                    continue;
                                }
                            }
                            isNull |= state.isNull;
                            lessThanMax &= state.replacementSize() < maxSize * (long)(run + 1);
                        }
                        if (doneCount == source.size()) {
                            if (this.restartIndexes.isEmpty() || this.restartIndexes.getLast() != i) break;
                            this.restartIndexes.removeLast();
                            break;
                        }
                        if (lessThanMax || isNull) {
                            for (SetState state : source) {
                                if (!isNull) {
                                    state.replacement.add(state.nextValue);
                                }
                                state.nextValue = null;
                                state.isNull = false;
                            }
                            continue;
                        }
                        this.restartIndexes.add(i);
                        break;
                    }
                }
                for (SetState setState : source) {
                    currentPredicates = (int)((long)currentPredicates + (setState.replacementSize() / maxSize + (long)(setState.replacementSize() % maxSize != 0L ? 1 : 0)));
                }
            }
            if (this.restartIndexes.isEmpty()) break;
            ++run;
        }
        boolean bl = this.hasNextCommand = !this.restartIndexes.isEmpty();
        if (this.hasNextCommand && this.dependentState.size() > 1) {
            for (TupleState state : this.dependentState.values()) {
                state.originalVs.setUnused(true);
            }
        }
    }

    protected boolean hasNextCommand() {
        return this.hasNextCommand;
    }

    public Criteria replaceDependentCriteria(AbstractSetCriteria crit, SetState state) throws TeiidComponentException {
        if (state.overMax) {
            DependentValueSource originalVs = (DependentValueSource)this.dependentNode.getContext().getVariableContext().getGlobalValue(((DependentSetCriteria)crit).getContextSymbol());
            originalVs.setUnused(true);
            return QueryRewriter.TRUE_CRITERIA;
        }
        if (state.replacement.isEmpty()) {
            return QueryRewriter.FALSE_CRITERIA;
        }
        int numberOfSets = 1;
        int maxSize = Integer.MAX_VALUE;
        if (this.maxSetSize > 0) {
            maxSize = (int)Math.max(1L, (long)this.maxSetSize / state.valueCount);
            numberOfSets = state.replacement.size() / maxSize + (state.replacement.size() % maxSize != 0 ? 1 : 0);
        }
        Iterator<Object> iter = state.replacement.iterator();
        ArrayList<PredicateCriteria> orCrits = new ArrayList<PredicateCriteria>(numberOfSets);
        for (int i = 0; i < numberOfSets; ++i) {
            if (maxSize == 1 || i + 1 == state.replacement.size()) {
                orCrits.add(new CompareCriteria(crit.getExpression(), 1, this.newConstant(iter.next())));
                continue;
            }
            ArrayList<Constant> vals = new ArrayList<Constant>(Math.min(state.replacement.size(), maxSize));
            for (int j = 0; j < maxSize && iter.hasNext(); ++j) {
                Object val = iter.next();
                vals.add(this.newConstant(val));
            }
            SetCriteria sc = new SetCriteria();
            sc.setExpression(crit.getExpression());
            sc.setValues(vals);
            orCrits.add(sc);
        }
        if (orCrits.size() == 1) {
            return (Criteria)orCrits.get(0);
        }
        return new CompoundCriteria(1, orCrits);
    }

    private Constant newConstant(Object val) {
        Constant c = new Constant(val);
        c.setBindEligible(true);
        return c;
    }

    class TupleState {
        private SortUtility sortUtility;
        private DependentValueSource dvs;
        private List<SetState> dependentSetStates = new LinkedList<SetState>();
        private String valueSource;
        private DependentValueSource originalVs;

        public TupleState(String source) {
            this.valueSource = source;
        }

        public void sort() throws BlockedException, TeiidComponentException, TeiidProcessingException {
            if (this.dvs == null) {
                this.originalVs = (DependentValueSource)DependentCriteriaProcessor.this.dependentNode.getContext().getVariableContext().getGlobalValue(this.valueSource);
                if (!this.originalVs.isDistinct()) {
                    if (this.sortUtility == null) {
                        ArrayList<Expression> sortSymbols = new ArrayList<Expression>(this.dependentSetStates.size());
                        for (int i = 0; i < this.dependentSetStates.size(); ++i) {
                            if (this.dependentSetStates.get((int)i).valueExpression instanceof Array) {
                                Array array = (Array)this.dependentSetStates.get((int)i).valueExpression;
                                for (Expression ex : array.getExpressions()) {
                                    sortSymbols.add(ex);
                                }
                                continue;
                            }
                            sortSymbols.add(this.dependentSetStates.get((int)i).valueExpression);
                        }
                        List<Boolean> sortDirection = Collections.nCopies(sortSymbols.size(), true);
                        this.sortUtility = new SortUtility(null, sortSymbols, sortDirection, SortUtility.Mode.DUP_REMOVE, DependentCriteriaProcessor.this.dependentNode.getBufferManager(), DependentCriteriaProcessor.this.dependentNode.getConnectionID(), this.originalVs.getTupleBuffer().getSchema());
                        this.sortUtility.setWorkingBuffer(this.originalVs.getTupleBuffer());
                    }
                    this.dvs = new DependentValueSource(this.sortUtility.sort());
                } else {
                    this.dvs = this.originalVs;
                }
                for (SetState setState : this.dependentSetStates) {
                    setState.valueIterator = this.dvs.getValueIterator(setState.valueExpression);
                    int distinctCount = this.dvs.getTupleBuffer().getRowCount();
                    if (setState.maxNdv <= 0.0f || setState.maxNdv >= (float)distinctCount) continue;
                    if (this.dvs.getTupleBuffer().getSchema().size() > 1 && this.dependentSetStates.size() > 1) {
                        distinctCount = 0;
                        TupleSourceValueIterator vi = this.dvs.getValueIterator(setState.valueExpression);
                        if (setState.valueExpression.equals(this.dependentSetStates.get((int)0).valueExpression)) {
                            Object last = null;
                            while (vi.hasNext()) {
                                Object next = vi.next();
                                if (next != null && (last == null || Constant.COMPARATOR.compare(next, last) != 0)) {
                                    ++distinctCount;
                                }
                                last = next;
                            }
                        } else {
                            AbstractSet set = null;
                            int maxSize = Math.min(10000, this.dvs.getTupleBuffer().getRowCount());
                            List<Object> buffer = Arrays.asList(new Object[maxSize]);
                            set = !DataTypeManager.isHashable(setState.valueExpression.getType()) ? new TreeSet<Object>(Constant.COMPARATOR) : new HashSet();
                            int i = 0;
                            while (vi.hasNext()) {
                                Object next = vi.next();
                                if (next == null) continue;
                                if (set.add(next)) {
                                    ++distinctCount;
                                }
                                Object old = buffer.set(i++ % maxSize, next);
                                if (set.size() <= maxSize) continue;
                                set.remove(old);
                            }
                        }
                    }
                    if (setState.overMax || !((float)distinctCount > setState.maxNdv)) continue;
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30011, new Object[]{this.valueSource, setState.valueExpression, Float.valueOf(setState.maxNdv)}));
                    setState.overMax = true;
                }
            }
        }

        public void close() {
            if (this.sortUtility != null) {
                this.sortUtility.remove();
                this.sortUtility = null;
            }
            if (this.dvs != null) {
                if (this.dvs != this.originalVs) {
                    this.dvs.getTupleBuffer().remove();
                }
                this.dvs = null;
            }
        }

        public List<SetState> getDepedentSetStates() {
            return this.dependentSetStates;
        }
    }

    public static class SetState {
        Collection<Object> replacement = new LinkedHashSet<Object>();
        Expression valueExpression;
        ValueIterator valueIterator;
        Object nextValue;
        boolean isNull;
        float maxNdv = -1.0f;
        boolean overMax;
        long valueCount = 1L;

        long replacementSize() {
            return (long)this.replacement.size() * this.valueCount;
        }
    }
}

