/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SourceState;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class EnhancedSortMergeJoinStrategy
extends MergeJoinStrategy {
    private boolean semiDep;
    private TupleSource currentSource;
    private SourceState sortedSource;
    private SourceState notSortedSource;
    private List<?> currentTuple;
    private boolean matched;
    private TupleBrowser tb;
    private SingleTupleSource keyTs;
    private int reserved;
    private STree index;
    private int[] reverseIndexes;
    private List<?> sortedTuple;
    private boolean repeatedMerge;
    private boolean validSemiDep;
    private int preferMemCutoff = 8;

    public EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption sortLeft, MergeJoinStrategy.SortOption sortRight) {
        super(sortLeft, sortRight, false);
    }

    public void setPreferMemCutoff(int cutoff) {
        this.preferMemCutoff = cutoff;
    }

    @Override
    public void close() {
        if (this.joinNode == null) {
            return;
        }
        super.close();
        if (this.index != null) {
            this.index.remove();
        }
        this.releaseReserved();
        this.index = null;
        this.tb = null;
        this.currentSource = null;
        this.sortedSource = null;
        this.notSortedSource = null;
        this.sortedTuple = null;
        this.reverseIndexes = null;
        this.keyTs = null;
    }

    public void createIndex(SourceState state, boolean sorted) throws TeiidComponentException, TeiidProcessingException {
        int[] expressionIndexes = state.getExpressionIndexes();
        int keyLength = expressionIndexes.length;
        List<? extends Expression> elements = state.getSource().getOutputElements();
        LinkedHashSet<Integer> used = new LinkedHashSet<Integer>();
        for (int i : expressionIndexes) {
            used.add(i);
        }
        int[] reorderedSortIndex = Arrays.copyOf(expressionIndexes, keyLength + elements.size() - used.size());
        int j = keyLength;
        for (int i = 0; i < elements.size(); ++i) {
            if (used.contains(i)) continue;
            reorderedSortIndex[j++] = i;
        }
        List<? extends Expression> reordered = RelationalNode.projectTuple(reorderedSortIndex, elements);
        if (!state.isDistinct()) {
            reordered = new ArrayList<Expression>(reordered);
            ElementSymbol id = new ElementSymbol("rowId");
            id.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            reordered.add(keyLength, id);
            ++keyLength;
        }
        this.index = this.joinNode.getBufferManager().createSTree(reordered, this.joinNode.getConnectionID(), keyLength);
        this.index.setPreferMemory(true);
        if (!state.isDistinct()) {
            this.index.getComparator().setDistinctIndex(keyLength - 2);
        }
        TupleBuffer.TupleBufferTupleSource its = state.getTupleBuffer().createIndexedTupleSource(!this.joinNode.isDependent());
        int rowId = 0;
        List<?> lastTuple = null;
        boolean sortedDistinct = sorted && !state.isDistinct();
        int sizeHint = this.index.getExpectedHeight(state.getRowCount());
        this.index.setBatchInsert(sorted);
        block2: while (its.hasNext()) {
            List<?> originalTuple = its.nextTuple();
            for (int i : expressionIndexes) {
                if (originalTuple.get(i) == null) continue block2;
            }
            if (sortedDistinct && lastTuple != null && this.compare(lastTuple, originalTuple, expressionIndexes, expressionIndexes) == 0) {
                sortedDistinct = false;
            }
            lastTuple = originalTuple;
            List<?> tuple = RelationalNode.projectTuple(reorderedSortIndex, originalTuple);
            if (!state.isDistinct()) {
                tuple.add(keyLength - 1, rowId++);
            }
            this.index.insert(tuple, sorted ? STree.InsertMode.ORDERED : STree.InsertMode.NEW, sizeHint);
        }
        if (!sorted) {
            this.index.compact();
        } else {
            this.index.setBatchInsert(false);
        }
        its.closeSource();
        this.reverseIndexes = new int[elements.size()];
        for (int i = 0; i < reorderedSortIndex.length; ++i) {
            int oldIndex = reorderedSortIndex[i];
            this.reverseIndexes[oldIndex] = i + (!state.isDistinct() && i >= keyLength - 1 ? 1 : 0);
        }
        if (!state.isDistinct() && (!sorted && this.index.getComparator().isDistinct() || sorted && sortedDistinct)) {
            this.index.removeRowIdFromKey();
            state.markDistinct(true);
        }
        this.keyTs = new SingleTupleSource();
        SingleTupleSource.access$102(this.keyTs, this.notSortedSource.getExpressionIndexes());
        this.tb = new TupleBrowser(this.index, this.keyTs, true);
    }

    @Override
    protected void loadLeft() throws TeiidComponentException, TeiidProcessingException {
        if (this.joinNode.isDependent()) {
            this.leftSource.getTupleBuffer();
        }
    }

    private boolean shouldIndexIfSmall(SourceState source) throws TeiidComponentException, TeiidProcessingException {
        return source.rowCountLE(source.getSource().getBatchSize() / 2);
    }

    @Override
    protected void loadRight() throws TeiidComponentException, TeiidProcessingException {
        if (this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.joinNode.getJoinType() != JoinType.JOIN_LEFT_OUTER && this.shouldIndexIfSmall(this.leftSource)) {
            this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else if (!this.leftSource.hasBuffer() && this.processingSortLeft == MergeJoinStrategy.SortOption.SORT && this.shouldIndexIfSmall(this.rightSource)) {
            this.processingSortLeft = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else if (!this.rightSource.hasBuffer() && this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.joinNode.getJoinType() != JoinType.JOIN_LEFT_OUTER && this.shouldIndexIfSmall(this.leftSource)) {
            this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else if (this.processingSortRight == MergeJoinStrategy.SortOption.SORT && this.joinNode.getJoinType() != JoinType.JOIN_LEFT_OUTER && this.shouldIndex(this.leftSource, this.rightSource)) {
            this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
        } else if (this.processingSortLeft == MergeJoinStrategy.SortOption.SORT && this.shouldIndex(this.rightSource, this.leftSource)) {
            this.processingSortLeft = MergeJoinStrategy.SortOption.NOT_SORTED;
        }
        if (this.processingSortLeft != MergeJoinStrategy.SortOption.NOT_SORTED && this.processingSortRight != MergeJoinStrategy.SortOption.NOT_SORTED) {
            super.loadRight();
            super.loadLeft();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"degrading to merged join", this.joinNode.getID()});
            }
            return;
        }
        if (this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.sortedSource = this.rightSource;
            this.notSortedSource = this.leftSource;
            if (!this.repeatedMerge) {
                this.createIndex(this.rightSource, this.processingSortRight == MergeJoinStrategy.SortOption.ALREADY_SORTED);
            } else {
                super.loadRight();
                this.notSortedSource.sort(MergeJoinStrategy.SortOption.NOT_SORTED);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"performing single pass sort right", this.joinNode.getID()});
                }
            }
        } else if (this.processingSortRight == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.sortedSource = this.leftSource;
            this.notSortedSource = this.rightSource;
            if (this.semiDep && this.leftSource.isDistinct()) {
                this.rightSource.getTupleBuffer();
                if (!this.joinNode.getDependentValueSource().isUnused()) {
                    this.processingSortRight = MergeJoinStrategy.SortOption.NOT_SORTED;
                    this.validSemiDep = true;
                    return;
                }
            }
            if (!this.repeatedMerge) {
                this.createIndex(this.leftSource, this.processingSortLeft == MergeJoinStrategy.SortOption.ALREADY_SORTED);
            } else {
                super.loadLeft();
                this.notSortedSource.sort(MergeJoinStrategy.SortOption.NOT_SORTED);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"performing single pass sort left", this.joinNode.nodeToString()});
                }
            }
        }
    }

    private boolean shouldIndex(SourceState possibleIndex, SourceState other) throws TeiidComponentException, TeiidProcessingException {
        long size;
        int otherSize;
        int indexSize = possibleIndex.hasBuffer() ? possibleIndex.getRowCount() : -1;
        int n = otherSize = other.hasBuffer() ? other.getRowCount() : -1;
        for (size = (long)this.joinNode.getBatchSize(); size < Integer.MAX_VALUE && (indexSize == -1 || otherSize == -1); size *= 2L) {
            if (indexSize == -1 && (possibleIndex.rowCountLE((int)size) || possibleIndex.hasBuffer())) {
                indexSize = possibleIndex.getRowCount();
            }
            if (otherSize == -1 && (other.rowCountLE((int)size) || other.hasBuffer())) {
                otherSize = other.getRowCount();
            }
            if (indexSize == -1 && otherSize != -1 && size * 4L > (long)otherSize) {
                return false;
            }
            if (indexSize != -1 && otherSize == -1 && (long)(indexSize * 4) <= size) break;
        }
        if (size > Integer.MAX_VALUE && (indexSize == -1 || otherSize == -1) || indexSize != -1 && otherSize != -1 && indexSize * 4 > otherSize) {
            return false;
        }
        int schemaSize = this.joinNode.getBufferManager().getSchemaSize(other.getSource().getOutputElements());
        int toReserve = this.joinNode.getBufferManager().getMaxProcessingSize();
        if (other.hasBuffer() && (other.getRowCount() <= this.joinNode.getBatchSize() || possibleIndex.getRowCount() > this.joinNode.getBatchSize() && other.getRowCount() / this.joinNode.getBatchSize() < toReserve / schemaSize)) {
            return false;
        }
        boolean useIndex = false;
        int indexSchemaSize = this.joinNode.getBufferManager().getSchemaSize(possibleIndex.getSource().getOutputElements());
        toReserve = (int)((double)(indexSchemaSize * possibleIndex.getRowCount()) / ((double)possibleIndex.getSource().getBatchSize() * 0.5));
        if (toReserve < this.joinNode.getBufferManager().getMaxProcessingSize()) {
            useIndex = true;
        } else if (possibleIndex.getRowCount() / this.joinNode.getBatchSize() < this.preferMemCutoff) {
            useIndex = true;
        }
        if (useIndex) {
            this.reserved = this.joinNode.getBufferManager().reserveBuffers(toReserve, BufferManager.BufferReserveMode.FORCE);
            if (other.hasBuffer()) {
                other.getTupleBuffer().setForwardOnly(true);
            }
            return true;
        }
        if (this.joinNode.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
            return false;
        }
        this.repeatedMerge = true;
        possibleIndex.setImplicitBuffer(SourceState.ImplicitBuffer.FULL);
        return true;
    }

    private void releaseReserved() {
        this.joinNode.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
    }

    @Override
    protected void process() throws TeiidComponentException, TeiidProcessingException {
        if (this.processingSortLeft != MergeJoinStrategy.SortOption.NOT_SORTED && this.processingSortRight != MergeJoinStrategy.SortOption.NOT_SORTED) {
            super.process();
            return;
        }
        if (this.sortedSource.getRowCount() == 0 && this.joinNode.getJoinType() != JoinType.JOIN_LEFT_OUTER) {
            return;
        }
        if (this.repeatedMerge) {
            while (this.notSortedSource.hasBuffer()) {
                super.process();
                this.resetMatchState();
                this.sortedSource.resetState();
                this.notSortedSource.nextBuffer();
            }
            return;
        }
        if (this.currentSource == null) {
            this.currentSource = this.notSortedSource.getIterator();
        }
        while (true) {
            if (this.currentTuple == null) {
                this.currentTuple = this.currentSource.nextTuple();
                this.matched = false;
                if (this.currentTuple == null) {
                    return;
                }
                if (this.sortedSource.getRowCount() == 0 && this.joinNode.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
                    this.outerMatch();
                    continue;
                }
                if (this.validSemiDep) {
                    List<?> tuple = this.currentTuple;
                    this.currentTuple = null;
                    this.joinNode.addBatchRow(this.outputTuple(this.leftSource.getOuterVals(), tuple));
                    continue;
                }
                this.keyTs.setValues(this.currentTuple);
                this.tb.reset(this.keyTs);
            }
            if (this.sortedTuple == null) {
                this.sortedTuple = this.tb.nextTuple();
                if (this.sortedTuple == null) {
                    this.outerMatch();
                    continue;
                }
            }
            List<?> reorderedTuple = RelationalNode.projectTuple(this.reverseIndexes, this.sortedTuple);
            List outputTuple = this.outputTuple(this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED ? this.currentTuple : reorderedTuple, this.processingSortLeft == MergeJoinStrategy.SortOption.NOT_SORTED ? reorderedTuple : this.currentTuple);
            boolean matches = this.joinNode.matchesCriteria(outputTuple);
            this.sortedTuple = null;
            if (!matches) continue;
            this.matched = true;
            this.joinNode.addBatchRow(outputTuple);
        }
    }

    private void outerMatch() {
        List<?> tuple = this.currentTuple;
        this.currentTuple = null;
        if (!this.matched && this.joinNode.getJoinType() == JoinType.JOIN_LEFT_OUTER) {
            this.joinNode.addBatchRow(this.outputTuple(tuple, this.rightSource.getOuterVals()));
        }
    }

    @Override
    public EnhancedSortMergeJoinStrategy clone() {
        EnhancedSortMergeJoinStrategy clone = new EnhancedSortMergeJoinStrategy(this.sortLeft, this.sortRight);
        clone.semiDep = this.semiDep;
        return clone;
    }

    @Override
    public String getName() {
        return "ENHANCED SORT JOIN" + (this.semiDep ? " [SEMI]" : "");
    }

    public void setSemiDep(boolean semiDep) {
        this.semiDep = semiDep;
    }

    private static final class SingleTupleSource
    extends AbstractList<Object>
    implements TupleSource {
        boolean returned;
        private int[] indexes;
        private List<?> keyTuple;

        private SingleTupleSource() {
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            if (!this.returned) {
                this.returned = true;
                return this;
            }
            return null;
        }

        @Override
        public Object get(int index) {
            return this.keyTuple.get(this.indexes[index]);
        }

        @Override
        public int size() {
            return this.indexes.length;
        }

        public void setValues(List<?> values) {
            this.returned = false;
            this.keyTuple = values;
        }

        @Override
        public void closeSource() {
        }

        static /* synthetic */ int[] access$102(SingleTupleSource x0, int[] x1) {
            x0.indexes = x1;
            return x1;
        }
    }
}

