/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.ArrayAgg;
import org.teiid.query.function.aggregate.Avg;
import org.teiid.query.function.aggregate.ConstantFunction;
import org.teiid.query.function.aggregate.Count;
import org.teiid.query.function.aggregate.JSONArrayAgg;
import org.teiid.query.function.aggregate.Max;
import org.teiid.query.function.aggregate.Min;
import org.teiid.query.function.aggregate.RankingFunction;
import org.teiid.query.function.aggregate.StatsFunction;
import org.teiid.query.function.aggregate.StringAgg;
import org.teiid.query.function.aggregate.Sum;
import org.teiid.query.function.aggregate.TextAgg;
import org.teiid.query.function.aggregate.UserDefined;
import org.teiid.query.function.aggregate.XMLAgg;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class GroupingNode
extends SubqueryAwareRelationalNode {
    private List<OrderByItem> orderBy;
    private boolean removeDuplicates;
    private SymbolMap outputMapping;
    private int phase = 1;
    private Map elementMap;
    private LinkedHashMap<Expression, Integer> collectedExpressions;
    private int distinctCols = -1;
    private SortUtility sortUtility;
    private TupleBuffer sortBuffer;
    private TupleSource groupTupleSource;
    private AggregateFunction[] functions;
    private List<?> lastRow;
    private List<?> currentGroupTuple;
    private static final int COLLECTION = 1;
    private static final int SORT = 2;
    private static final int GROUP = 3;
    private int[] indexes;

    public GroupingNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.phase = 1;
        this.sortUtility = null;
        this.sortBuffer = null;
        this.lastRow = null;
        this.currentGroupTuple = null;
        if (this.functions != null) {
            for (AggregateFunction function : this.functions) {
                function.reset();
            }
        }
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public void setOrderBy(List<OrderByItem> orderBy) {
        this.orderBy = orderBy;
    }

    public void setOutputMapping(SymbolMap outputMapping) {
        this.outputMapping = outputMapping;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.functions != null) {
            return;
        }
        List<? extends Expression> sourceElements = this.getChildren()[0].getElements();
        this.elementMap = GroupingNode.createLookupMap(sourceElements);
        this.collectedExpressions = new LinkedHashMap();
        if (this.orderBy != null) {
            for (OrderByItem orderByItem : this.orderBy) {
                Expression ex = SymbolMap.getExpression(orderByItem.getSymbol());
                GroupingNode.getIndex(ex, this.collectedExpressions);
            }
            if (this.removeDuplicates) {
                for (Expression expression : sourceElements) {
                    GroupingNode.getIndex(expression, this.collectedExpressions);
                }
                this.distinctCols = this.collectedExpressions.size();
            }
        }
        this.functions = new AggregateFunction[this.getElements().size()];
        for (int i = 0; i < this.getElements().size(); ++i) {
            void var6_13;
            Expression expression = this.getElements().get(i);
            if (this.outputMapping != null) {
                Expression expression2 = this.outputMapping.getMappedExpression((ElementSymbol)expression);
            }
            Class<?> outputType = var6_13.getType();
            if (var6_13 instanceof AggregateSymbol) {
                AggregateSymbol aggSymbol = (AggregateSymbol)var6_13;
                this.functions[i] = GroupingNode.initAccumulator(aggSymbol, this, this.collectedExpressions);
                continue;
            }
            this.functions[i] = new ConstantFunction();
            this.functions[i].setArgIndexes(new int[]{this.collectedExpressions.get(var6_13)});
            this.functions[i].initialize(outputType, new Class[]{var6_13.getType()});
        }
    }

    static Integer getIndex(Expression ex, LinkedHashMap<Expression, Integer> expressionIndexes) {
        Integer index = expressionIndexes.get(ex);
        if (index == null) {
            index = expressionIndexes.size();
            expressionIndexes.put(ex, index);
        }
        return index;
    }

    static AggregateFunction initAccumulator(AggregateSymbol aggSymbol, RelationalNode node, LinkedHashMap<Expression, Integer> expressionIndexes) {
        int[] argIndexes = new int[aggSymbol.getArgs().length];
        AggregateFunction result = null;
        Expression[] args = aggSymbol.getArgs();
        Class[] inputTypes = new Class[args.length];
        for (int j = 0; j < args.length; ++j) {
            inputTypes[j] = args[j].getType();
            argIndexes[j] = GroupingNode.getIndex(args[j], expressionIndexes);
        }
        AggregateSymbol.Type function = aggSymbol.getAggregateFunction();
        switch (function) {
            case RANK: 
            case DENSE_RANK: {
                result = new RankingFunction(function);
                break;
            }
            case ROW_NUMBER: 
            case COUNT: {
                result = new Count();
                break;
            }
            case SUM: {
                result = new Sum();
                break;
            }
            case AVG: {
                result = new Avg();
                break;
            }
            case MIN: {
                result = new Min();
                break;
            }
            case MAX: {
                result = new Max();
                break;
            }
            case XMLAGG: {
                result = new XMLAgg();
                break;
            }
            case ARRAY_AGG: {
                result = new ArrayAgg();
                break;
            }
            case JSONARRAY_AGG: {
                result = new JSONArrayAgg();
                break;
            }
            case TEXTAGG: {
                result = new TextAgg((TextLine)args[0]);
                break;
            }
            case STRING_AGG: {
                result = new StringAgg(aggSymbol.getType() == DataTypeManager.DefaultDataClasses.BLOB);
                break;
            }
            case USER_DEFINED: {
                result = new UserDefined(aggSymbol.getFunctionDescriptor());
                break;
            }
            default: {
                result = new StatsFunction(function);
            }
        }
        if (aggSymbol.isDistinct()) {
            SortingFilter filter = new SortingFilter(result, node.getBufferManager(), node.getConnectionID(), true);
            List<ElementSymbol> elements = GroupingNode.createSortSchema(result, inputTypes);
            filter.setElements(elements);
            result = filter;
        } else if (aggSymbol.getOrderBy() != null) {
            int numOrderByItems = aggSymbol.getOrderBy().getOrderByItems().size();
            ArrayList<OrderByItem> orderByItems = new ArrayList<OrderByItem>(numOrderByItems);
            List<ElementSymbol> schema = GroupingNode.createSortSchema(result, inputTypes);
            argIndexes = Arrays.copyOf(argIndexes, argIndexes.length + numOrderByItems);
            ListIterator<OrderByItem> iterator = aggSymbol.getOrderBy().getOrderByItems().listIterator();
            while (iterator.hasNext()) {
                OrderByItem item = iterator.next();
                argIndexes[args.length + iterator.previousIndex()] = GroupingNode.getIndex(item.getSymbol(), expressionIndexes);
                ElementSymbol element = new ElementSymbol(String.valueOf(iterator.previousIndex()));
                element.setType(item.getSymbol().getType());
                schema.add(element);
                OrderByItem newItem = item.clone();
                newItem.setSymbol(element);
                orderByItems.add(newItem);
            }
            SortingFilter filter = new SortingFilter(result, node.getBufferManager(), node.getConnectionID(), false);
            filter.setElements(schema);
            filter.setSortItems(orderByItems);
            result = filter;
        }
        result.setArgIndexes(argIndexes);
        if (aggSymbol.getCondition() != null) {
            result.setConditionIndex(GroupingNode.getIndex(aggSymbol.getCondition(), expressionIndexes));
        }
        result.initialize(aggSymbol.getType(), inputTypes);
        return result;
    }

    private static List<ElementSymbol> createSortSchema(AggregateFunction af, Class<?>[] inputTypes) {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(inputTypes.length);
        int[] filteredArgIndexes = new int[inputTypes.length];
        for (int i = 0; i < inputTypes.length; ++i) {
            ElementSymbol element = new ElementSymbol("val" + i);
            element.setType(inputTypes[i]);
            elements.add(element);
            filteredArgIndexes[i] = i;
        }
        af.setArgIndexes(filteredArgIndexes);
        return elements;
    }

    AggregateFunction[] getFunctions() {
        return this.functions;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == 1) {
            this.collectionPhase();
        }
        if (this.phase == 2) {
            this.sortPhase();
        }
        if (this.phase == 3) {
            return this.groupPhase();
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    public TupleSource getCollectionTupleSource() {
        RelationalNode sourceNode = this.getChildren()[0];
        return new ProjectingTupleSource(sourceNode, this.getEvaluator(this.elementMap), new ArrayList<Expression>(this.collectedExpressions.keySet()));
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return this.getChildren()[0].getOutputElements();
    }

    private void collectionPhase() {
        if (this.orderBy == null) {
            this.groupTupleSource = this.getCollectionTupleSource();
            this.phase = 3;
        } else {
            ArrayList<SortSpecification.NullOrdering> nullOrdering = new ArrayList<SortSpecification.NullOrdering>(this.orderBy.size());
            ArrayList<Boolean> sortTypes = new ArrayList<Boolean>(this.orderBy.size());
            int size = this.orderBy.size();
            if (this.removeDuplicates) {
                size = this.distinctCols;
            }
            int[] sortIndexes = new int[size];
            for (int i = 0; i < size; ++i) {
                if (i < this.orderBy.size()) {
                    OrderByItem item = this.orderBy.get(i);
                    nullOrdering.add(item.getNullOrdering());
                    sortTypes.add(item.isAscending());
                } else {
                    nullOrdering.add(null);
                    sortTypes.add(true);
                }
                sortIndexes[i] = i;
            }
            this.indexes = Arrays.copyOf(sortIndexes, this.orderBy.size());
            this.sortUtility = new SortUtility(this.getCollectionTupleSource(), this.removeDuplicates ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.getBufferManager(), this.getConnectionID(), new ArrayList<Expression>(this.collectedExpressions.keySet()), sortTypes, nullOrdering, sortIndexes);
            this.phase = 2;
        }
    }

    private void sortPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.sortBuffer = this.sortUtility.sort();
        this.sortBuffer.setForwardOnly(true);
        this.groupTupleSource = this.sortBuffer.createIndexedTupleSource();
        this.phase = 3;
    }

    private TupleBatch groupPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        int i;
        ArrayList<Object> row;
        while (true) {
            if (this.currentGroupTuple == null) {
                this.currentGroupTuple = this.groupTupleSource.nextTuple();
                if (this.currentGroupTuple == null) break;
            }
            if (this.lastRow == null) {
                this.lastRow = this.currentGroupTuple;
            } else if (!GroupingNode.sameGroup(this.indexes, this.currentGroupTuple, this.lastRow)) {
                row = new ArrayList<Object>(this.functions.length);
                for (i = 0; i < this.functions.length; ++i) {
                    row.add(this.functions[i].getResult(this.getContext()));
                    this.functions[i].reset();
                }
                this.lastRow = this.currentGroupTuple;
                this.addBatchRow(row);
                if (this.isBatchFull()) {
                    return this.pullBatch();
                }
            }
            this.updateAggregates(this.currentGroupTuple);
            this.currentGroupTuple = null;
        }
        if (this.lastRow != null || this.orderBy == null) {
            row = new ArrayList(this.functions.length);
            for (i = 0; i < this.functions.length; ++i) {
                row.add(this.functions[i].getResult(this.getContext()));
            }
            this.addBatchRow(row);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    public static boolean sameGroup(int[] indexes, List<?> newTuple, List<?> oldTuple) {
        if (indexes == null) {
            return true;
        }
        return MergeJoinStrategy.compareTuples(newTuple, oldTuple, indexes, indexes, true) == 0;
    }

    private void updateAggregates(List<?> tuple) throws TeiidComponentException, TeiidProcessingException {
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].addInput(tuple, this.getContext());
        }
    }

    @Override
    public void closeDirect() {
        if (this.sortBuffer != null) {
            this.sortBuffer.remove();
            this.sortBuffer = null;
        }
        if (this.sortUtility != null) {
            this.sortUtility.remove();
            this.sortUtility = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.orderBy);
        if (this.outputMapping != null) {
            str.append(this.outputMapping);
        }
    }

    @Override
    public Object clone() {
        GroupingNode clonedNode = new GroupingNode(super.getID());
        super.copyTo(clonedNode);
        clonedNode.removeDuplicates = this.removeDuplicates;
        clonedNode.outputMapping = this.outputMapping;
        clonedNode.orderBy = this.orderBy;
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.orderBy != null) {
            int elements = this.orderBy.size();
            ArrayList<String> groupCols = new ArrayList<String>(elements);
            for (int i = 0; i < elements; ++i) {
                groupCols.add(this.orderBy.get(i).toString());
            }
            props.addProperty("Grouping Columns", groupCols);
        }
        props.addProperty("Sort Mode", String.valueOf(this.removeDuplicates));
        return props;
    }

    static class ProjectingTupleSource
    extends BatchCollector.BatchProducerTupleSource {
        private Evaluator eval;
        private List<Expression> collectedExpressions;

        ProjectingTupleSource(BatchCollector.BatchProducer sourceNode, Evaluator eval, List<Expression> expressions) {
            super(sourceNode);
            this.eval = eval;
            this.collectedExpressions = expressions;
        }

        protected List<Object> updateTuple(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
            int columns = this.collectedExpressions.size();
            ArrayList<Object> exprTuple = new ArrayList<Object>(columns);
            for (int col = 0; col < columns; ++col) {
                Object value = this.eval.evaluate(this.collectedExpressions.get(col), tuple);
                exprTuple.add(value);
            }
            return exprTuple;
        }
    }
}

