/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.symbol.Expression;

class SourceState {
    private RelationalNode source;
    private List expressions;
    private TupleBuffer buffer;
    private List<TupleBuffer> buffers;
    private List<Object> outerVals;
    private IndexedTupleSource iterator;
    private int[] expressionIndexes;
    private List currentTuple;
    private int maxProbeMatch = 1;
    private boolean distinct;
    private ImplicitBuffer implicitBuffer = ImplicitBuffer.FULL;
    boolean open;
    private BatchIterator prefetch;
    private SortUtility sortUtility;

    public SourceState(RelationalNode source, List expressions) {
        this.source = source;
        this.expressions = expressions;
        List<? extends Expression> elements = source.getElements();
        this.outerVals = Collections.nCopies(elements.size(), null);
        this.expressionIndexes = SourceState.getExpressionIndecies(expressions, elements);
    }

    public RelationalNode getSource() {
        return this.source;
    }

    public void setImplicitBuffer(ImplicitBuffer implicitBuffer) {
        this.implicitBuffer = implicitBuffer;
    }

    static int[] getExpressionIndecies(List expressions, List elements) {
        if (expressions == null) {
            return new int[0];
        }
        int[] indecies = new int[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            indecies[i] = elements.indexOf(expressions.get(i));
            assert (indecies[i] != -1);
        }
        return indecies;
    }

    TupleBuffer createSourceTupleBuffer() throws TeiidComponentException {
        return this.source.getBufferManager().createTupleBuffer(this.source.getElements(), this.source.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
    }

    public List saveNext() throws TeiidComponentException, TeiidProcessingException {
        this.currentTuple = this.getIterator().nextTuple();
        return this.currentTuple;
    }

    public void reset() throws TeiidComponentException, TeiidProcessingException {
        this.getIterator().reset();
        this.getIterator().mark();
        this.currentTuple = null;
    }

    public void close() {
        while (this.nextBuffer()) {
        }
        this.open = false;
        if (this.sortUtility != null) {
            this.sortUtility.remove();
            this.sortUtility = null;
        }
    }

    private void closeBuffer() {
        if (this.buffer != null) {
            this.buffer.remove();
            this.buffer = null;
        }
        if (this.iterator != null) {
            this.iterator.closeSource();
            this.iterator = null;
        }
        this.prefetch = null;
        this.currentTuple = null;
    }

    public int getRowCount() throws TeiidComponentException, TeiidProcessingException {
        return this.getTupleBuffer().getRowCount();
    }

    public boolean rowCountLE(int count) throws TeiidComponentException, TeiidProcessingException {
        if (this.buffer == null) {
            this.prefetch(false);
        }
        while (this.buffer.getRowCount() <= count) {
            if (this.prefetch == null) {
                return true;
            }
            this.prefetch(false);
        }
        return false;
    }

    IndexedTupleSource getIterator() throws TeiidComponentException, TeiidProcessingException {
        if (this.iterator == null) {
            if (this.buffer == null) {
                this.getTupleBuffer(false);
            }
            this.iterator = this.prefetch != null ? this.prefetch : this.buffer.createIndexedTupleSource(this.implicitBuffer == ImplicitBuffer.NONE);
        }
        return this.iterator;
    }

    private void createPrefetch() throws TeiidComponentException {
        this.prefetch = new BatchIterator(this.source);
        boolean useMark = this.implicitBuffer != ImplicitBuffer.FULL;
        this.buffer = this.createSourceTupleBuffer();
        this.prefetch.setBuffer(this.buffer, useMark);
        if (useMark) {
            this.prefetch.mark();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prefetch(boolean limit) throws TeiidComponentException, TeiidProcessingException {
        if (!this.open) {
            return;
        }
        if (this.prefetch == null) {
            if (this.buffer != null) {
                return;
            }
            if (this.sortUtility != null) {
                this.sortUtility.sort();
                return;
            }
            if (this.source.hasFinalBuffer()) {
                this.buffer = this.source.getFinalBuffer(-1);
                return;
            }
            this.createPrefetch();
        }
        if (limit && this.buffer.getManagedRowCount() >= this.source.getBatchSize() * this.source.getContext().getOptions().getJoinPrefetchBatches()) {
            return;
        }
        int curIndex = this.prefetch.getCurrentIndex();
        boolean marked = false;
        if (this.prefetch.ensureSave()) {
            marked = true;
        }
        this.prefetch.setPosition(this.buffer.getRowCount() + 1);
        BatchIterator bi = this.prefetch;
        try {
            if (!this.prefetch.hasNext()) {
                this.prefetch = null;
                if (this.iterator != bi) {
                    bi = null;
                }
            }
        }
        finally {
            if (bi != null) {
                if (marked) {
                    bi.reset();
                } else {
                    bi.setPosition(curIndex);
                }
            }
        }
    }

    public List<Object> getOuterVals() {
        return this.outerVals;
    }

    public List getCurrentTuple() {
        return this.currentTuple;
    }

    public int[] getExpressionIndexes() {
        return this.expressionIndexes;
    }

    void setMaxProbeMatch(int maxProbeMatch) {
        this.maxProbeMatch = maxProbeMatch;
    }

    int getMaxProbeMatch() {
        return this.maxProbeMatch;
    }

    public TupleBuffer getTupleBuffer() throws TeiidComponentException, TeiidProcessingException {
        return this.getTupleBuffer(true);
    }

    private TupleBuffer getTupleBuffer(boolean full) throws TeiidComponentException, TeiidProcessingException {
        if (this.buffer == null) {
            if (this.iterator instanceof BatchIterator) {
                throw new AssertionError((Object)"cannot buffer the source");
            }
            if (this.source.hasFinalBuffer()) {
                this.buffer = this.source.getFinalBuffer(-1);
                return this.buffer;
            }
            this.implicitBuffer = ImplicitBuffer.FULL;
            this.createPrefetch();
        }
        if (full && this.prefetch != null) {
            while (this.prefetch.hasNext()) {
                this.prefetch.setPosition(this.prefetch.getCurrentIndex() + this.source.getBatchSize());
            }
            this.prefetch = null;
        }
        return this.buffer;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void markDistinct(boolean distinct) {
        this.distinct |= distinct;
    }

    public void sort(MergeJoinStrategy.SortOption sortOption) throws TeiidComponentException, TeiidProcessingException {
        if (sortOption == MergeJoinStrategy.SortOption.ALREADY_SORTED) {
            return;
        }
        if (this.sortUtility == null) {
            BatchIterator ts = null;
            if (this.buffer != null) {
                this.buffer.setForwardOnly(true);
                if (this.prefetch != null) {
                    this.prefetch.setPosition(1);
                    this.prefetch.disableSave();
                    ts = this.prefetch;
                }
            } else {
                ts = new BatchIterator(this.source);
            }
            this.sortUtility = new SortUtility(ts, this.expressions, Collections.nCopies(this.expressions.size(), true), sortOption == MergeJoinStrategy.SortOption.SORT_DISTINCT ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.source.getBufferManager(), this.source.getConnectionID(), this.source.getElements());
            this.markDistinct(sortOption == MergeJoinStrategy.SortOption.SORT_DISTINCT && this.expressions.size() == this.getOuterVals().size());
            if (ts == null) {
                this.sortUtility.setWorkingBuffer(this.buffer);
            }
        }
        if (sortOption == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.buffers = this.sortUtility.onePassSort();
            if (this.buffers.size() == 1) {
                this.markDistinct(this.sortUtility.isDistinct());
            }
            this.nextBuffer();
            return;
        }
        TupleBuffer sorted = this.sortUtility.sort();
        if (this.buffer != null && this.buffer != sorted) {
            this.buffer.remove();
        }
        this.prefetch = null;
        this.buffer = sorted;
        this.markDistinct(this.sortUtility.isDistinct());
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.prefetch == null;
    }

    public boolean nextBuffer() {
        this.closeBuffer();
        if (this.buffers == null || this.buffers.isEmpty()) {
            return false;
        }
        this.buffer = this.buffers.remove(this.buffers.size() - 1);
        this.buffer.setForwardOnly(false);
        this.prefetch = null;
        this.resetState();
        return true;
    }

    public void resetState() {
        if (this.iterator != null) {
            this.iterator.reset();
            this.iterator.setPosition(1);
        }
        this.currentTuple = null;
        this.maxProbeMatch = 1;
    }

    public void setMaxProbePosition() throws TeiidComponentException, TeiidProcessingException {
        this.getIterator().setPosition(this.getMaxProbeMatch());
        this.currentTuple = null;
    }

    static enum ImplicitBuffer {
        NONE,
        FULL,
        ON_MARK;

    }
}

