/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;

public class CachedFinder
implements CapabilitiesFinder {
    static BasicSourceCapabilities INVALID_CAPS = new BasicSourceCapabilities();
    private static BasicSourceCapabilities SYSTEM_CAPS = new BasicSourceCapabilities();
    private ConnectorManagerRepository connectorRepo;
    private VDBMetaData vdb;
    private Map<String, SourceCapabilities> userCache = new HashMap<String, SourceCapabilities>();

    public CachedFinder(ConnectorManagerRepository repo, VDBMetaData vdb) {
        this.connectorRepo = repo;
        this.vdb = vdb;
        this.userCache.put("SYS", SYSTEM_CAPS);
        this.userCache.put("pg_catalog", SYSTEM_CAPS);
        this.userCache.put("SYSADMIN", SYSTEM_CAPS);
    }

    @Override
    public SourceCapabilities findCapabilities(String modelName) throws TeiidComponentException {
        SourceCapabilities caps = this.userCache.get(modelName);
        if (caps != null) {
            return caps;
        }
        ModelMetaData model = this.vdb.getModel(modelName);
        List sourceNames = model.getSourceNames();
        if (sourceNames.isEmpty()) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30499, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30499, new Object[]{modelName}));
        }
        for (String sourceName : sourceNames) {
            ConnectorManager mgr = this.connectorRepo.getConnectorManager(sourceName);
            if (mgr == null) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30497, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30497, new Object[]{sourceName, modelName, sourceName}));
            }
            try {
                caps = mgr.getCapabilities();
                break;
            }
            catch (TeiidException e) {
                LogManager.logDetail((String)"org.teiid.PROCESSOR", (Throwable)e, (Object[])new Object[]{"Could not obtain capabilities for" + sourceName});
            }
        }
        if (caps == null) {
            caps = INVALID_CAPS;
        }
        this.userCache.put(modelName, caps);
        return caps;
    }

    public void addCapabilities(String connBinding, SourceCapabilities sourceCaps) {
        this.userCache.put(connBinding, sourceCaps);
    }

    @Override
    public boolean isValid(String modelName) {
        return this.userCache.get(modelName) != INVALID_CAPS;
    }

    static {
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ONLY_LITERAL_COMPARE, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_REGEX, true);
        SYSTEM_CAPS.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_SIMILAR, true);
        SYSTEM_CAPS.setFunctionSupport("ucase", true);
        SYSTEM_CAPS.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, 100000);
        SYSTEM_CAPS.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, 1);
    }
}

