/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.client.RequestMessage;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class AtomicRequestMessage {
    static final long serialVersionUID = -4060941593023225562L;
    private static AtomicInteger EXECUTION_COUNT = new AtomicInteger(0);
    private AtomicRequestID atomicRequestId;
    private String connectorName;
    private String modelName;
    private TransactionContext txnContext;
    private Command command;
    private int fetchSize = 256;
    private long processingTimestamp = System.currentTimeMillis();
    private boolean partialResultsFlag;
    private RequestID requestID;
    private boolean exceptionOnMaxRows;
    private int maxRows;
    private boolean serial;
    private DQPWorkContext workContext;
    private CommandContext commandContext;

    public AtomicRequestMessage(RequestMessage requestMessage, DQPWorkContext parent, int nodeId) {
        this.workContext = parent;
        this.requestID = new RequestID(parent.getSessionId(), requestMessage.getExecutionId());
        this.atomicRequestId = new AtomicRequestID(this.requestID, nodeId, EXECUTION_COUNT.getAndIncrement());
    }

    public int getMaxResultRows() {
        return this.maxRows;
    }

    public void setMaxResultRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public boolean isExceptionOnMaxRows() {
        return this.exceptionOnMaxRows;
    }

    public void setExceptionOnMaxRows(boolean exceptionOnMaxRows) {
        this.exceptionOnMaxRows = exceptionOnMaxRows;
    }

    public AtomicRequestID getAtomicRequestID() {
        return this.atomicRequestId;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String string) {
        this.connectorName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public TransactionContext getTransactionContext() {
        return this.txnContext;
    }

    public void setTransactionContext(TransactionContext context) {
        this.txnContext = context;
    }

    public boolean isSerial() {
        return this.serial || this.isTransactional();
    }

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    public boolean isTransactional() {
        return this.txnContext != null && this.txnContext.getTransactionType() != TransactionContext.Scope.NONE;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("fetch size must be positive");
        }
        this.fetchSize = fetchSize;
    }

    public long getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public boolean supportsPartialResults() {
        return this.partialResultsFlag;
    }

    public void setPartialResults(boolean partial) {
        this.partialResultsFlag = partial;
    }

    public String toString() {
        return this.atomicRequestId.toString();
    }

    public void setRequestID(RequestID requestID) {
        this.requestID = requestID;
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public void setWorkContext(DQPWorkContext workContext) {
        this.workContext = workContext;
    }

    public DQPWorkContext getWorkContext() {
        return this.workContext;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public void setCommandContext(CommandContext commandContext) {
        this.commandContext = commandContext;
    }
}

