/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.SQLException;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.AnyToStringTransform;

public class ClobToStringTransform
extends AnyToStringTransform {
    public ClobToStringTransform() {
        super(DataTypeManager.DefaultDataClasses.CLOB);
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        ClobType source = (ClobType)value;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(source.getCharacterStream());
            StringBuffer contents = new StringBuffer();
            int chr = reader.read();
            while (chr != -1 && contents.length() < DataTypeManager.MAX_STRING_LENGTH) {
                contents.append((char)chr);
                chr = reader.read();
            }
            String string = contents.toString();
            return string;
        }
        catch (SQLException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        catch (IOException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

