/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.util.CommandContext;

public class StringAgg
extends AggregateFunction {
    private FileStoreInputStreamFactory result;
    private boolean binary;

    public StringAgg(boolean binary) {
        this.binary = binary;
    }

    private FileStoreInputStreamFactory buildResult(CommandContext context) {
        FileStore fs = context.getBufferManager().createFileStore("string_agg");
        FileStoreInputStreamFactory fisf = new FileStoreInputStreamFactory(fs, "UTF-8");
        return fisf;
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public void addInputDirect(List<?> tuple, CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        boolean first = false;
        if (this.result == null) {
            first = true;
            this.result = this.buildResult(commandContext);
        }
        if (!first) {
            Object delim = tuple.get(this.argIndexes[1]);
            this.writeValue(delim);
        }
        Object val = tuple.get(this.argIndexes[0]);
        this.writeValue(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValue(Object val) throws TeiidProcessingException {
        block12: {
            try {
                if (this.binary) {
                    if (val instanceof BinaryType) {
                        this.result.getOuputStream().write(((BinaryType)val).getBytesDirect());
                        return;
                    }
                    Blob b = (Blob)val;
                    InputStream binaryStream = b.getBinaryStream();
                    try {
                        ObjectConverterUtil.write((OutputStream)this.result.getOuputStream(), binaryStream, -1, false);
                        break block12;
                    }
                    finally {
                        binaryStream.close();
                    }
                }
                if (val instanceof String) {
                    this.result.getWriter().write((String)val);
                    return;
                }
                Clob c = (Clob)val;
                Reader characterStream = c.getCharacterStream();
                try {
                    ObjectConverterUtil.write(this.result.getWriter(), characterStream, -1, false);
                }
                finally {
                    characterStream.close();
                }
            }
            catch (IOException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30422, (Throwable)e);
            }
            catch (SQLException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30423, (Throwable)e);
            }
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws TeiidProcessingException {
        if (this.result == null) {
            this.result = this.buildResult(commandContext);
        }
        try {
            this.result.getWriter().close();
            FileStore.FileStoreOutputStream fs = this.result.getOuputStream();
            fs.close();
            if (this.binary) {
                if (fs.bytesWritten()) {
                    return new BlobType(new BlobImpl(this.result));
                }
                return new BlobType(new SerialBlob(Arrays.copyOf(fs.getBuffer(), fs.getCount())));
            }
            if (fs.bytesWritten()) {
                return new ClobType(new ClobImpl(this.result, -1L));
            }
            return new ClobType(new ClobImpl(new String(Arrays.copyOf(fs.getBuffer(), fs.getCount()), "UTF-8")));
        }
        catch (IOException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30422, (Throwable)e);
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30423, (Throwable)e);
        }
    }
}

