/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.Predicate;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class Like
extends Condition
implements Predicate {
    private Expression leftExpression;
    private Expression rightExpression;
    private Character escapeCharacter;
    private boolean isNegated;
    private MatchMode mode = MatchMode.LIKE;

    public Like(Expression left, Expression right, Character escapeCharacter, boolean negated) {
        this.leftExpression = left;
        this.rightExpression = right;
        this.escapeCharacter = escapeCharacter;
        this.isNegated = negated;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public void setEscapeCharacter(Character character) {
        this.escapeCharacter = character;
    }

    public void setNegated(boolean negated) {
        this.isNegated = negated;
    }

    public MatchMode getMode() {
        return this.mode;
    }

    public void setMode(MatchMode mode) {
        this.mode = mode;
    }

    public static enum MatchMode {
        LIKE,
        SIMILAR,
        REGEX;

    }
}

