/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.TupleSourceCache;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.util.CommandContext;

public class QueryProcessor
implements BatchCollector.BatchProducer {
    private static ExpiredTimeSliceException EXPIRED_TIME_SLICE = new ExpiredTimeSliceException();
    private CommandContext context;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private ProcessorPlan processPlan;
    private boolean initialized;
    private boolean open;
    private int reserved;
    private volatile boolean requestCanceled;
    private static final int DEFAULT_WAIT = 50;
    private boolean processorClosed;
    private boolean continuous;
    private String query;
    private PreparedPlan plan;
    private int rowOffset = 1;

    public QueryProcessor(ProcessorPlan plan, CommandContext context, BufferManager bufferMgr, ProcessorDataManager dataMgr) {
        this.context = context;
        this.context.setTupleSourceCache(new TupleSourceCache());
        this.dataMgr = dataMgr;
        this.processPlan = plan;
        this.bufferMgr = bufferMgr;
    }

    public CommandContext getContext() {
        return this.context;
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processPlan;
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        while (true) {
            long wait = 50L;
            try {
                return this.nextBatchDirect();
            }
            catch (BlockedException e) {
                if (!this.context.isNonBlocking()) {
                    throw e;
                }
                if (e == BlockedException.BLOCKED_ON_MEMORY_EXCEPTION) continue;
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException err) {
                    throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30159, (Throwable)err);
                }
            }
        }
    }

    private TupleBatch nextBatchDirect() throws BlockedException, TeiidProcessingException, TeiidComponentException {
        boolean done = false;
        TupleBatch result = null;
        try {
            this.init();
            long currentTime = System.currentTimeMillis();
            Assertion.assertTrue(!this.processorClosed);
            while (currentTime < this.context.getTimeSliceEnd() || this.context.isNonBlocking()) {
                if (this.requestCanceled) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30160, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30160, this.context.getRequestId()));
                }
                if (currentTime > this.context.getTimeoutEnd()) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30161, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30161, new Object[0]));
                }
                result = this.processPlan.nextBatch();
                if (this.continuous) {
                    result.setRowOffset(this.rowOffset);
                    if (result.getTerminationFlag()) {
                        result.setTermination((byte)2);
                        List<Object> terminationTuple = Arrays.asList(new Object[this.getOutputElements().size()]);
                        result.getTuples().add(terminationTuple);
                        this.context.getTupleSourceCache().close();
                        this.processPlan.close();
                        this.processPlan.reset();
                        this.context.incrementReuseCount();
                        this.open = false;
                    }
                    this.rowOffset = result.getEndRow() + 1;
                }
                if (result.getTermination() != 0) {
                    if (result.getTerminationFlag()) {
                        done = true;
                    }
                } else if (result.getRowCount() <= 0) continue;
                break;
            }
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (TeiidException e) {
            this.closeProcessing();
            if (e instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e;
            }
            if (e instanceof TeiidComponentException) {
                throw (TeiidComponentException)e;
            }
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30162, (Throwable)e);
        }
        if (done) {
            this.closeProcessing();
        }
        if (result == null) {
            RequestWorkItem workItem = this.getContext().getWorkItem();
            if (workItem != null) {
                workItem.moreWork();
            }
            throw EXPIRED_TIME_SLICE;
        }
        return result;
    }

    public void init() throws TeiidComponentException, TeiidProcessingException {
        if (!this.open) {
            if (this.continuous && this.context.getReuseCount() > 0L) {
                if (this.plan != null && !this.plan.validate()) {
                    this.plan = null;
                }
                if (this.plan == null) {
                    this.plan = this.context.getQueryProcessorFactory().getPreparedPlan(this.query, null, this.context, this.context.getMetadata());
                    this.processPlan = this.plan.getPlan().clone();
                    this.processPlan.initialize(this.context, this.dataMgr, this.bufferMgr);
                }
            }
            if (!this.initialized) {
                this.reserved = this.bufferMgr.reserveBuffers(this.bufferMgr.getSchemaSize(this.getOutputElements()), BufferManager.BufferReserveMode.FORCE);
                this.processPlan.initialize(this.context, this.dataMgr, this.bufferMgr);
                this.initialized = true;
            }
            this.processPlan.open();
            this.open = true;
        }
    }

    public void closeProcessing() {
        if (this.processorClosed) {
            return;
        }
        if (LogManager.isMessageToBeRecorded("org.teiid.PROCESSOR", 5)) {
            LogManager.logDetail("org.teiid.PROCESSOR", (Object)"QueryProcessor: closing processor");
        }
        this.context.getTupleSourceCache().close();
        this.bufferMgr.releaseBuffers(this.reserved);
        this.reserved = 0;
        this.processorClosed = true;
        if (this.initialized) {
            try {
                this.processPlan.close();
            }
            catch (TeiidComponentException e1) {
                LogManager.logDetail("org.teiid.PROCESSOR", (Object)e1, (Object)"Error closing processor");
            }
        }
    }

    @Override
    public List getOutputElements() {
        return this.processPlan.getOutputElements();
    }

    public List<Exception> getAndClearWarnings() {
        return this.context.getAndClearWarnings();
    }

    public void requestCanceled() {
        this.requestCanceled = true;
    }

    public BatchCollector createBatchCollector() throws TeiidComponentException {
        return new BatchCollector(this, this.bufferMgr, this.context, false);
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.context.setNonBlocking(nonBlocking);
    }

    @Override
    public TupleBuffer getBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (true) {
            long wait = 50L;
            try {
                this.init();
                return this.processPlan.getBuffer(maxRows);
            }
            catch (BlockedException e) {
                if (!this.context.isNonBlocking()) {
                    throw e;
                }
                if (e == BlockedException.BLOCKED_ON_MEMORY_EXCEPTION) {
                    continue;
                }
            }
            catch (TeiidComponentException e) {
                this.closeProcessing();
                throw e;
            }
            catch (TeiidProcessingException e) {
                this.closeProcessing();
                throw e;
            }
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException err) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30163, (Throwable)err);
            }
        }
    }

    @Override
    public boolean hasBuffer(boolean requireFinal) {
        return !this.continuous && this.processPlan.hasBuffer(false);
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public void setContinuous(PreparedPlan prepPlan, String query) {
        this.continuous = true;
        this.plan = prepPlan;
        this.query = query;
        this.context.setContinuous();
    }

    @Override
    public void close() throws TeiidComponentException {
        this.closeProcessing();
    }

    public static interface ProcessorFactory {
        public QueryProcessor createQueryProcessor(String var1, String var2, CommandContext var3, Object ... var4) throws TeiidProcessingException, TeiidComponentException;

        public PreparedPlan getPreparedPlan(String var1, String var2, CommandContext var3, QueryMetadataInterface var4) throws TeiidProcessingException, TeiidComponentException;

        public CapabilitiesFinder getCapabiltiesFinder();
    }

    public static class ExpiredTimeSliceException
    extends BlockedException {
        private static final long serialVersionUID = 4585044674826578060L;
    }
}

