/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.io.IOException;
import java.sql.SQLException;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.ObjectConverterUtil;

public class BlobToBinaryTransform
extends Transform {
    @Override
    public Object transformDirect(Object value) throws TransformationException {
        BlobType source = (BlobType)value;
        try {
            byte[] bytes = ObjectConverterUtil.convertToByteArray(source.getBinaryStream(), DataTypeManager.MAX_LOB_MEMORY_BYTES, true);
            return new BinaryType(bytes);
        }
        catch (SQLException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
        catch (IOException e) {
            throw new TransformationException(CorePlugin.Event.TEIID10080, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10080, this.getSourceType().getName(), this.getTargetType().getName()));
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.BLOB;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.VARBINARY;
    }
}

