/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RulePushSelectCriteria
implements OptimizerRule {
    private List<PlanNode> createdNodes;

    public List<PlanNode> getCreatedNodes() {
        return this.createdNodes;
    }

    public void setCreatedNodes(List<PlanNode> createdNodes) {
        this.createdNodes = createdNodes;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean movedAnyNode = true;
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        while (movedAnyNode) {
            movedAnyNode = false;
            List<PlanNode> critNodes = NodeEditor.findAllNodes(plan, 16);
            Collections.reverse(critNodes);
            for (PlanNode critNode : critNodes) {
                boolean isPhantom = critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM);
                boolean isCopied = critNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED);
                boolean isPushed = critNode.hasBooleanProperty(NodeConstants.Info.IS_PUSHED);
                if (isPhantom || isCopied || isPushed || deadNodes.contains(critNode)) continue;
                PlanNode sourceNode = this.findOriginatingNode(metadata, capFinder, critNode, analysisRecord);
                if (sourceNode == null) {
                    deadNodes.add(critNode);
                    continue;
                }
                boolean moved = this.pushTowardOriginatingNode(sourceNode, critNode, metadata, capFinder);
                if (critNode.hasBooleanProperty(NodeConstants.Info.IS_PUSHED) || critNode.getGroups().isEmpty() && critNode.getSubqueryContainers().isEmpty() || !this.atBoundary(critNode, sourceNode)) {
                    deadNodes.add(critNode);
                    movedAnyNode |= moved;
                    continue;
                }
                switch (sourceNode.getType()) {
                    case 64: {
                        Boolean acrossFrame = this.pushAcrossFrame(sourceNode, critNode, metadata);
                        if (acrossFrame != null) {
                            moved = acrossFrame;
                            break;
                        }
                        movedAnyNode = true;
                        break;
                    }
                    case 4: {
                        if (NodeEditor.findParent(critNode, 1) != null || !critNode.getSubqueryContainers().isEmpty()) break;
                        moved = this.handleJoinCriteria(sourceNode, critNode, metadata);
                        break;
                    }
                    case 128: {
                        moved = this.pushAcrossGroupBy(sourceNode, critNode, metadata, true, capFinder);
                    }
                }
                if (!moved) {
                    deadNodes.add(critNode);
                    continue;
                }
                movedAnyNode = true;
            }
        }
        return plan;
    }

    boolean pushAcrossGroupBy(PlanNode sourceNode, PlanNode critNode, QueryMetadataInterface metadata, boolean inPlan, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode accessNode;
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING)) {
            return false;
        }
        if (sourceNode.hasBooleanProperty(NodeConstants.Info.ROLLUP) && inPlan) {
            PlanNode copy = this.copyNode(critNode);
            critNode.setProperty(NodeConstants.Info.IS_PUSHED, true);
            critNode.setProperty(NodeConstants.Info.IS_HAVING, true);
            critNode.getFirstChild().addAsParent(copy);
            critNode = copy;
        }
        boolean moved = false;
        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        FrameUtil.convertNode(critNode, null, null, symbolMap.asMap(), metadata, true);
        if (inPlan) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            sourceNode.getFirstChild().addAsParent(critNode);
        }
        moved = true;
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET) && (accessNode = NodeEditor.findParent(critNode, 1)) != null) {
            this.markDependent(critNode, accessNode, metadata, capFinder);
            moved = false;
        }
        return moved;
    }

    private PlanNode findOriginatingNode(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode critNode, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException {
        if (critNode.getGroups().isEmpty()) {
            PlanNode groupNode = NodeEditor.findNodePreOrder(critNode, 128, 64);
            if (groupNode != null && !groupNode.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) {
                return groupNode;
            }
            Object modelId = this.getSubqueryModelId(metadata, capFinder, critNode, record);
            if (modelId != null) {
                for (PlanNode node : NodeEditor.findAllNodes(critNode, 64)) {
                    GroupSymbol group = node.getGroups().iterator().next();
                    Object srcModelID = metadata.getModelID(group.getMetadataID());
                    if (!CapabilitiesUtil.isSameConnector(srcModelID, modelId, metadata, capFinder)) continue;
                    return node;
                }
            }
        }
        return FrameUtil.findOriginatingNode(critNode, critNode.getGroups());
    }

    private Object getSubqueryModelId(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode critNode, AnalysisRecord record) throws TeiidComponentException, QueryMetadataException {
        Object modelId = null;
        for (SubqueryContainer<?> subqueryContainer : critNode.getSubqueryContainers()) {
            Object validId = CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(subqueryContainer, null, metadata, capFinder, record);
            if (validId == null) {
                return null;
            }
            if (modelId == null) {
                modelId = validId;
                continue;
            }
            if (CapabilitiesUtil.isSameConnector(modelId, validId, metadata, capFinder)) continue;
            return null;
        }
        return modelId;
    }

    private boolean handleJoinCriteria(PlanNode joinNode, PlanNode critNode, QueryMetadataInterface metadata) {
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
            if (jt == JoinType.JOIN_CROSS) {
                joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_INNER);
            }
            return this.moveCriteriaIntoOnClause(critNode, joinNode);
        }
        JoinType optimized = JoinUtil.optimizeJoinType(critNode, joinNode, metadata);
        if (optimized == JoinType.JOIN_INNER) {
            this.moveCriteriaIntoOnClause(critNode, joinNode);
            return true;
        }
        return false;
    }

    private boolean moveCriteriaIntoOnClause(PlanNode critNode, PlanNode joinNode) {
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
        LinkedList<Criteria> joinCriteria = (LinkedList<Criteria>)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        Criteria criteria = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (joinCriteria == null || joinCriteria.size() == 0) {
            joinCriteria = new LinkedList<Criteria>();
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
        }
        if (joinCriteria.contains(criteria)) {
            return false;
        }
        boolean moved = false;
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
            DependentSetCriteria dsc;
            if (criteria instanceof DependentSetCriteria && (dsc = (DependentSetCriteria)criteria).hasMultipleAttributes()) {
                PlanNode right;
                ArrayList<DependentSetCriteria.AttributeComparison> joinExprs = new ArrayList<DependentSetCriteria.AttributeComparison>();
                ArrayList<DependentSetCriteria.AttributeComparison> leftExprs = new ArrayList<DependentSetCriteria.AttributeComparison>();
                ArrayList<DependentSetCriteria.AttributeComparison> rightExprs = new ArrayList<DependentSetCriteria.AttributeComparison>();
                PlanNode leftJoinSource = FrameUtil.findJoinSourceNode(joinNode.getFirstChild());
                PlanNode rightJoinSource = FrameUtil.findJoinSourceNode(joinNode.getLastChild());
                for (int i = 0; i < dsc.getAttributes().size(); ++i) {
                    DependentSetCriteria.AttributeComparison comp = dsc.getAttributes().get(i);
                    Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(comp.dep);
                    if (leftJoinSource.getGroups().containsAll(groups)) {
                        leftExprs.add(comp);
                        continue;
                    }
                    if (rightJoinSource.getGroups().containsAll(groups)) {
                        rightExprs.add(comp);
                        continue;
                    }
                    joinExprs.add(comp);
                }
                criteria = RuleChooseDependent.createDependentSetCriteria(dsc.getContextSymbol(), joinExprs);
                PlanNode left = RuleChooseDependent.createDependentSetNode(dsc.getContextSymbol(), leftExprs);
                if (left != null) {
                    moved = true;
                    joinNode.getFirstChild().addAsParent(left);
                }
                if ((right = RuleChooseDependent.createDependentSetNode(dsc.getContextSymbol(), rightExprs)) != null) {
                    moved = true;
                    joinNode.getLastChild().addAsParent(right);
                }
            }
            if (criteria != null) {
                joinNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
            }
        }
        if (criteria != null) {
            joinCriteria.add(criteria);
        }
        return moved;
    }

    boolean pushTowardOriginatingNode(PlanNode sourceNode, PlanNode critNode, final QueryMetadataInterface metadata, final CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Criteria crit;
        boolean groupSelects;
        boolean bl = groupSelects = sourceNode.getParent().getType() == 16 && sourceNode.getChildCount() == 0;
        while (sourceNode.getParent().getType() == 16) {
            if ((sourceNode = sourceNode.getParent()) != critNode) continue;
            return false;
        }
        final PlanNode destination = this.examinePath(critNode, sourceNode, metadata, capFinder);
        boolean result = false;
        if (this.createdNodes == null & destination.getType() == 1 && this.isDependentFinalDestination(critNode, destination) && this.isMultiAttributeDependentSet(crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA))) {
            result = this.splitSet(critNode, new DependentNodeTest(){

                @Override
                public boolean isValid(PlanNode copyNode) throws QueryMetadataException, QueryPlannerException, TeiidComponentException {
                    return RuleRaiseAccess.canRaiseOverSelect(destination, metadata, capFinder, copyNode, null);
                }
            }, (DependentSetCriteria)crit, destination);
        }
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
        destination.addAsParent(critNode);
        if (groupSelects && destination == sourceNode) {
            RuleMergeCriteria.mergeChain(critNode, metadata);
        }
        return result;
    }

    private boolean splitSet(PlanNode critNode, DependentNodeTest test, DependentSetCriteria dscOrig, PlanNode destination) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        boolean result = false;
        List<DependentSetCriteria> dscList = this.splitDependentSetCriteria(dscOrig);
        ArrayList<DependentSetCriteria.AttributeComparison> pushable = new ArrayList<DependentSetCriteria.AttributeComparison>();
        ArrayList<DependentSetCriteria.AttributeComparison> nonPushable = new ArrayList<DependentSetCriteria.AttributeComparison>();
        for (DependentSetCriteria dsc : dscList) {
            PlanNode copyNode = this.copyNode(critNode);
            this.setCriteria(dsc, copyNode);
            if (test.isValid(copyNode)) {
                pushable.add(dsc.getAttributes().get(0));
                continue;
            }
            nonPushable.add(dsc.getAttributes().get(0));
        }
        if (!pushable.isEmpty()) {
            result = true;
            if (nonPushable.isEmpty()) {
                throw new AssertionError((Object)"should not be completely pushed");
            }
            this.setCriteria(RuleChooseDependent.createDependentSetCriteria(dscOrig.getContextSymbol(), nonPushable), critNode);
            PlanNode copyNode = this.copyNode(critNode);
            this.setCriteria(RuleChooseDependent.createDependentSetCriteria(dscOrig.getContextSymbol(), pushable), copyNode);
            destination.addAsParent(copyNode);
        }
        return result;
    }

    private void setCriteria(DependentSetCriteria dsc, PlanNode copyNode) {
        copyNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, dsc);
        copyNode.getGroups().clear();
        copyNode.addGroups(GroupsUsedByElementsVisitor.getGroups(dsc));
    }

    PlanNode examinePath(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, TeiidComponentException {
        PlanNode currentNode;
        Stack<PlanNode> path = new Stack<PlanNode>();
        for (currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            path.push(currentNode);
        }
        block7: while (!path.empty()) {
            currentNode = (PlanNode)path.pop();
            switch (currentNode.getType()) {
                case 1: {
                    try {
                        if (!RuleRaiseAccess.canRaiseOverSelect(currentNode, metadata, capFinder, critNode, null)) {
                            return currentNode;
                        }
                        if (!RuleRaiseAccess.checkConformedSubqueries(currentNode, critNode, this.createdNodes == null)) {
                            return currentNode;
                        }
                        if (this.createdNodes == null) {
                            RulePushSelectCriteria.satisfyConditions(critNode, currentNode, metadata);
                        }
                        if (!this.isDependentFinalDestination(critNode, currentNode)) continue block7;
                        this.markDependent(critNode, currentNode, metadata, capFinder);
                        return currentNode.getFirstChild();
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException(QueryPlugin.Event.TEIID30267, e, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30267, currentNode.getGroups()));
                    }
                }
                case 4: {
                    JoinType optimized;
                    if (this.createdNodes == null && NodeEditor.findParent(currentNode, 1) != null) {
                        return currentNode;
                    }
                    JoinType jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(currentNode, critNode);
                    if (jt != null && ((optimized = JoinUtil.optimizeJoinType(critNode, currentNode, metadata)) == null || optimized.isOuter())) {
                        return currentNode;
                    }
                    if (this.createdNodes != null) continue block7;
                    RulePushSelectCriteria.satisfyConditions(critNode, currentNode, metadata);
                    break;
                }
                default: {
                    if (!FrameUtil.isOrderedOrStrictLimit(currentNode)) continue block7;
                    return currentNode;
                }
            }
        }
        return sourceNode;
    }

    private boolean isMultiAttributeDependentSet(Criteria crit) {
        return crit instanceof DependentSetCriteria && ((DependentSetCriteria)crit).hasMultipleAttributes();
    }

    private boolean isDependentFinalDestination(PlanNode critNode, PlanNode currentNode) {
        return critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET) && NodeEditor.findNodePreOrder(currentNode.getFirstChild(), 128, 64) == null;
    }

    private void markDependent(PlanNode critNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        critNode.setProperty(NodeConstants.Info.IS_PUSHED, Boolean.TRUE);
        if (this.createdNodes != null) {
            return;
        }
        accessNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (this.isMultiAttributeDependentSet(crit) && !CapabilitiesUtil.supports(SourceCapabilities.Capability.ARRAY_TYPE, RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata), metadata, capFinder)) {
            List<DependentSetCriteria> crits = this.splitDependentSetCriteria((DependentSetCriteria)crit);
            critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, new CompoundCriteria(crits));
        }
        Collection<ElementSymbol> elements = null;
        for (PlanNode joinNode : NodeEditor.findAllNodes(accessNode, 4, 64)) {
            List joinCriteria = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            if (joinCriteria == null) continue;
            for (Criteria joinPredicate : joinCriteria) {
                CompareCriteria cc;
                if (!(joinPredicate instanceof CompareCriteria) || !(cc = (CompareCriteria)joinPredicate).isOptional()) continue;
                if (elements == null) {
                    elements = ElementCollectorVisitor.getElements((LanguageObject)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA), true);
                }
                if (Collections.disjoint(elements, ElementCollectorVisitor.getElements((LanguageObject)cc, false))) continue;
                cc.setOptional(false);
            }
        }
    }

    private List<DependentSetCriteria> splitDependentSetCriteria(DependentSetCriteria dsc) {
        List<DependentSetCriteria.AttributeComparison> attributes = dsc.getAttributes();
        ArrayList<DependentSetCriteria> crits = new ArrayList<DependentSetCriteria>(attributes.size());
        for (int i = 0; i < attributes.size(); ++i) {
            DependentSetCriteria.AttributeComparison comp = attributes.get(i);
            DependentSetCriteria crit = RuleChooseDependent.createDependentSetCriteria(dsc.getContextSymbol(), Arrays.asList(comp));
            crit.setMakeDepOptions(dsc.getMakeDepOptions());
            crits.add(crit);
        }
        return crits;
    }

    Boolean pushAcrossFrame(PlanNode sourceNode, PlanNode critNode, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        if (sourceNode.getChildCount() == 1 && FrameUtil.isOrderedOrStrictLimit(sourceNode.getFirstChild())) {
            return false;
        }
        if (sourceNode.getChildCount() > 0) {
            PlanNode child = sourceNode.getFirstChild();
            if ((child = FrameUtil.findOriginatingNode(child, child.getGroups())) != null && child.getType() == 256) {
                if (child == sourceNode.getFirstChild() && critNode.getSubqueryContainers().isEmpty()) {
                    return this.pushAcrossSetOp(critNode, child, metadata);
                }
                return false;
            }
        }
        return this.moveNodeAcrossFrame(critNode, sourceNode, metadata);
    }

    boolean atBoundary(PlanNode critNode, PlanNode sourceNode) {
        for (PlanNode currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 16) continue;
            return false;
        }
        return true;
    }

    Boolean moveNodeAcrossFrame(PlanNode critNode, PlanNode sourceNode, final QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        if (sourceNode.getChildCount() == 0) {
            return false;
        }
        final PlanNode projectNode = NodeEditor.findNodePreOrder(sourceNode.getFirstChild(), 8, 64);
        if (FrameUtil.isProcedure(projectNode)) {
            return false;
        }
        final SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        final GroupSymbol sourceGroup = sourceNode.getGroups().iterator().next();
        if (!this.placeConvertedSelectNode(critNode, sourceGroup, projectNode, symbolMap, metadata)) {
            Criteria crit;
            if (this.createdNodes == null && this.isMultiAttributeDependentSet(crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA)) && this.splitSet(critNode, new DependentNodeTest(){

                @Override
                public boolean isValid(PlanNode copyNode) throws QueryMetadataException, QueryPlannerException, TeiidComponentException {
                    return RulePushSelectCriteria.this.createConvertedSelectNode(copyNode, sourceGroup, projectNode, symbolMap, metadata) != null;
                }
            }, (DependentSetCriteria)crit, sourceNode)) {
                return null;
            }
            return false;
        }
        if (this.createdNodes == null) {
            RulePushSelectCriteria.satisfyConditions(critNode, sourceNode, metadata);
        }
        critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
        return true;
    }

    static void satisfyConditions(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        ElementSymbol es;
        CompareCriteria cc;
        List aps = (List)sourceNode.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (sourceNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE) && crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).getLeftExpression() instanceof ElementSymbol && cc.getRightExpression() instanceof Constant && metadata.isMultiSourceElement((es = (ElementSymbol)cc.getLeftExpression()).getMetadataID())) {
            sourceNode.setProperty(NodeConstants.Info.IS_MULTI_SOURCE, false);
            sourceNode.setProperty(NodeConstants.Info.SOURCE_NAME, ((Constant)cc.getRightExpression()).getValue());
        }
        if (aps == null) {
            return;
        }
        Collection<ElementSymbol> elements = RulePushSelectCriteria.getElementsIncriteria(crit);
        boolean removeAps = RulePushSelectCriteria.satisfyAccessPatterns(aps, elements);
        if (removeAps) {
            sourceNode.removeProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
            return;
        }
        Collections.sort(aps);
    }

    static Collection<ElementSymbol> getElementsIncriteria(Criteria crit) {
        HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
        boolean first = true;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            for (Criteria subCrit : compCrit.getCriteria()) {
                if (compCrit.getOperator() == 0 || first) {
                    first = false;
                    elements.addAll(RulePushSelectCriteria.getElementsIncriteria(subCrit));
                    continue;
                }
                elements.retainAll(RulePushSelectCriteria.getElementsIncriteria(subCrit));
            }
        } else {
            elements.addAll(ElementCollectorVisitor.getElements((LanguageObject)crit, true));
        }
        return elements;
    }

    static boolean satisfyAccessPatterns(List<AccessPattern> aps, Collection<ElementSymbol> elements) {
        for (AccessPattern ap : aps) {
            ap.getUnsatisfied().removeAll(elements);
            if (!ap.getUnsatisfied().isEmpty()) continue;
            return true;
        }
        return false;
    }

    PlanNode copyNode(PlanNode critNode) {
        PlanNode copyNode = NodeFactory.getNewNode(16);
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        copyNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, copyCrit);
        copyNode.addGroups(critNode.getGroups());
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
            copyNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        if (this.createdNodes != null) {
            this.createdNodes.add(copyNode);
        }
        return copyNode;
    }

    boolean pushAcrossSetOp(PlanNode critNode, PlanNode setOp, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        SymbolMap symbolMap;
        PlanNode sourceNode = NodeEditor.findParent(setOp, 64);
        GroupSymbol virtualGroup = sourceNode.getGroups().iterator().next();
        if (this.createdNodes == null) {
            RulePushSelectCriteria.satisfyConditions(critNode, sourceNode, metadata);
        }
        SymbolMap childMap = symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        RulePushSelectCriteria.collectUnionChildren(setOp, unionChildren);
        int movedCount = 0;
        for (PlanNode planNode : unionChildren) {
            PlanNode projectNode = NodeEditor.findNodePreOrder(planNode, 8);
            if (childMap == null) {
                childMap = SymbolMap.createSymbolMap(symbolMap.getKeys(), (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS));
            }
            if (this.placeConvertedSelectNode(critNode, virtualGroup, projectNode, childMap, metadata)) {
                ++movedCount;
            }
            childMap = null;
        }
        if (movedCount == unionChildren.size()) {
            critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
            return true;
        }
        critNode.setProperty(NodeConstants.Info.IS_PUSHED, Boolean.TRUE);
        return false;
    }

    static void collectUnionChildren(PlanNode unionNode, List<PlanNode> unionChildren) {
        for (PlanNode child : unionNode.getChildren()) {
            if (child.getType() == 256) {
                RulePushSelectCriteria.collectUnionChildren(child, unionChildren);
                continue;
            }
            unionChildren.add(child);
        }
    }

    private boolean placeConvertedSelectNode(PlanNode critNode, GroupSymbol sourceGroup, PlanNode projectNode, SymbolMap symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode copyNode = this.createConvertedSelectNode(critNode, sourceGroup, projectNode, symbolMap, metadata);
        if (copyNode == null) {
            return false;
        }
        PlanNode intermediateParent = NodeEditor.findParent(projectNode, 1, 320);
        if (intermediateParent != null) {
            intermediateParent.addAsParent(copyNode);
        } else {
            projectNode.getFirstChild().addAsParent(copyNode);
        }
        return true;
    }

    private PlanNode createConvertedSelectNode(PlanNode critNode, GroupSymbol sourceGroup, PlanNode projectNode, SymbolMap symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        Boolean conversionResult;
        if (projectNode.getChildCount() == 0) {
            return null;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Collection<ElementSymbol> cols = ElementCollectorVisitor.getElements((LanguageObject)crit, true);
        if (projectNode.hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS)) {
            Set<WindowFunction> windowFunctions = RuleAssignOutputElements.getWindowFunctions((List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS));
            for (WindowFunction windowFunction : windowFunctions) {
                WindowSpecification spec = windowFunction.getWindowSpecification();
                if (spec.getOrderBy() != null || spec.getPartition() == null) {
                    return null;
                }
                for (ElementSymbol col : cols) {
                    if (spec.getPartition().contains(symbolMap.getMappedExpression(col))) continue;
                    return null;
                }
            }
        }
        if ((conversionResult = this.checkConversion(symbolMap, cols)) == Boolean.FALSE) {
            return null;
        }
        if (!critNode.getSubqueryContainers().isEmpty() && this.checkConversion(symbolMap, critNode.getCorrelatedReferenceElements()) != null) {
            return null;
        }
        PlanNode copyNode = this.copyNode(critNode);
        if (conversionResult == Boolean.TRUE) {
            copyNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
        }
        FrameUtil.convertNode(copyNode, sourceGroup, null, symbolMap.asMap(), metadata, true);
        if (sourceGroup.isProcedure() && !copyNode.getGroups().isEmpty()) {
            if (this.createdNodes != null) {
                this.createdNodes.remove(this.createdNodes.size() - 1);
            }
            return null;
        }
        return copyNode;
    }

    private Boolean checkConversion(SymbolMap symbolMap, Collection<ElementSymbol> elements) {
        Boolean result = null;
        for (ElementSymbol element : elements) {
            Expression converted = symbolMap.getMappedExpression(element);
            if (converted == null) {
                return false;
            }
            List<SubqueryContainer<?>> scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(converted);
            if (!scalarSubqueries.isEmpty()) {
                return false;
            }
            if (ElementCollectorVisitor.getAggregates(converted, false).isEmpty()) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    public String toString() {
        return "PushSelectCriteria";
    }

    private static interface DependentNodeTest {
        public boolean isValid(PlanNode var1) throws QueryMetadataException, QueryPlannerException, TeiidComponentException;
    }
}

