/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class MoveCursorInstruction
extends ProcessorInstruction {
    private String resultSetName;

    public MoveCursorInstruction(String resultSetName) {
        this.resultSetName = resultSetName;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        LogManager.logTrace("org.teiid.PROCESSOR.XML_PLAN", new Object[]{"NEXT", this.resultSetName});
        context.getNextRow(this.resultSetName);
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        return "NEXT " + this.resultSetName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("NEXT ROW");
        props.addProperty("Result Set", this.resultSetName);
        return props;
    }

    String getResultSetName() {
        return this.resultSetName;
    }

    void setResultSetName(String rsName) {
        this.resultSetName = rsName;
    }
}

