/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;

public class SetQuery
extends QueryCommand {
    private boolean all = true;
    private Operation operation;
    private QueryCommand leftQuery;
    private QueryCommand rightQuery;
    private List<Class<?>> projectedTypes = null;
    private QueryMetadataInterface metadata = null;

    public SetQuery(Operation operation) {
        this.operation = operation;
    }

    public SetQuery(Operation operation, boolean all, QueryCommand leftQuery, QueryCommand rightQuery) {
        this.operation = operation;
        this.all = all;
        this.leftQuery = leftQuery;
        this.rightQuery = rightQuery;
    }

    @Override
    public Query getProjectedQuery() {
        if (this.leftQuery instanceof SetQuery) {
            return ((SetQuery)this.leftQuery).getProjectedQuery();
        }
        return (Query)this.leftQuery;
    }

    @Override
    public int getType() {
        return 1;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        Query query = this.getProjectedQuery();
        List<Expression> projectedSymbols = query.getProjectedSymbols();
        if (this.projectedTypes != null) {
            return SetQuery.getTypedProjectedSymbols(projectedSymbols, this.projectedTypes, this.metadata);
        }
        return projectedSymbols;
    }

    public static List<Expression> getTypedProjectedSymbols(List<? extends Expression> acutal, List<Class<?>> projectedTypes, QueryMetadataInterface metadata) {
        ArrayList<Expression> newProject = new ArrayList<Expression>();
        for (int i = 0; i < acutal.size(); ++i) {
            Expression originalSymbol;
            Expression symbol = originalSymbol = acutal.get(i);
            Class<?> type = projectedTypes.get(i);
            if (symbol.getType() != type) {
                symbol = SymbolMap.getExpression(originalSymbol);
                try {
                    symbol = ResolverUtil.convertExpression(symbol, DataTypeManager.getDataTypeName(type), metadata);
                }
                catch (QueryResolverException err) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30447, (Throwable)err);
                }
                if (originalSymbol instanceof Symbol) {
                    symbol = new AliasSymbol(Symbol.getShortName(originalSymbol), symbol);
                }
            }
            newProject.add(symbol);
        }
        return newProject;
    }

    @Override
    public Object clone() {
        SetQuery copy = new SetQuery(this.operation);
        this.copyMetadataState(copy);
        copy.leftQuery = (QueryCommand)this.leftQuery.clone();
        copy.rightQuery = (QueryCommand)this.rightQuery.clone();
        copy.setAll(this.all);
        if (this.getOrderBy() != null) {
            copy.setOrderBy(this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit(this.getLimit().clone());
        }
        copy.setWith(LanguageObject.Util.deepClone(this.getWith(), WithQueryCommand.class));
        if (this.projectedTypes != null) {
            copy.setProjectedTypes(new ArrayList(this.projectedTypes), this.metadata);
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SetQuery)) {
            return false;
        }
        SetQuery other = (SetQuery)obj;
        return this.getOperation() == other.getOperation() && EquivalenceUtil.areEqual(this.isAll(), other.isAll()) && EquivalenceUtil.areEqual(this.leftQuery, other.leftQuery) && EquivalenceUtil.areEqual(this.rightQuery, other.rightQuery) && EquivalenceUtil.areEqual(this.getOrderBy(), other.getOrderBy()) && EquivalenceUtil.areEqual(this.getLimit(), other.getLimit()) && EquivalenceUtil.areEqual(this.getWith(), other.getWith()) && this.sameOptionAndHint(other);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, new Object[]{this.operation});
        myHash = HashCodeUtil.hashCode(myHash, this.getProjectedQuery());
        return myHash;
    }

    @Override
    public boolean areResultsCachable() {
        return this.leftQuery.areResultsCachable() && this.rightQuery.areResultsCachable();
    }

    public List<QueryCommand> getQueryCommands() {
        return Collections.unmodifiableList(Arrays.asList(this.leftQuery, this.rightQuery));
    }

    public void setProjectedTypes(List<Class<?>> projectedTypes, QueryMetadataInterface metadata) {
        this.projectedTypes = projectedTypes;
        this.metadata = metadata;
    }

    public List<Class<?>> getProjectedTypes() {
        return this.projectedTypes;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public QueryCommand getLeftQuery() {
        return this.leftQuery;
    }

    public void setLeftQuery(QueryCommand leftQuery) {
        this.leftQuery = leftQuery;
    }

    public QueryCommand getRightQuery() {
        return this.rightQuery;
    }

    public void setRightQuery(QueryCommand rightQuery) {
        this.rightQuery = rightQuery;
    }

    public static enum Operation {
        UNION,
        INTERSECT,
        EXCEPT;

    }
}

