/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class FloatingNumberToBigDecimalTransform
extends Transform {
    private Class<?> sourceType;

    public FloatingNumberToBigDecimalTransform(Class<?> sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        BigDecimal result = BigDecimal.valueOf(((Number)value).doubleValue());
        result = result.setScale(Math.max(result.scale(), (value instanceof Double ? 16 : 8) - result.precision()));
        return result;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.BIG_DECIMAL;
    }
}

