/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.List;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.AbstractSymbolMappingVisitor;

public class XMLNodeMappingVisitor
extends AbstractSymbolMappingVisitor {
    private MappingNode rootNode;
    private QueryMetadataInterface metadata;

    public XMLNodeMappingVisitor(MappingDocument rootNode, QueryMetadataInterface metadata) {
        this.rootNode = rootNode;
        this.metadata = metadata;
    }

    @Override
    protected boolean createAliases() {
        return false;
    }

    @Override
    protected Symbol getMappedSymbol(Symbol symbol) {
        try {
            Object metadataId = null;
            Object groupId = null;
            if (symbol instanceof GroupSymbol) {
                GroupSymbol groupSymbol = (GroupSymbol)symbol;
                groupId = metadataId = groupSymbol.getMetadataID();
            } else {
                ElementSymbol element = (ElementSymbol)symbol;
                metadataId = element.getMetadataID();
                groupId = element.getGroupSymbol().getMetadataID();
            }
            boolean xml = this.metadata.isXMLGroup(groupId);
            if (!xml) {
                return symbol;
            }
            String path = this.metadata.getFullName(metadataId);
            MappingNode node = MappingNode.findNode(this.rootNode, path);
            if (node == null) {
                return null;
            }
            MappingSourceNode msn = node.getSourceNode();
            if (msn == null) {
                return null;
            }
            if (symbol instanceof GroupSymbol) {
                GroupSymbol gs = msn.getMappedSymbol(new GroupSymbol(msn.getResultName()));
                return gs;
            }
            String symbolName = node.getNameInSource();
            if (symbolName == null) {
                return null;
            }
            ElementSymbol es = msn.getMappedSymbol(new ElementSymbol(symbolName));
            return es;
        }
        catch (TeiidException err) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30285, (Throwable)err);
        }
    }

    public static Criteria convertCriteria(Criteria simpleCrit, MappingDocument rootNode, QueryMetadataInterface metadata) throws QueryPlannerException, TeiidComponentException {
        return XMLNodeMappingVisitor.convertObject((Criteria)simpleCrit.clone(), rootNode, metadata, true);
    }

    public static <T extends LanguageObject> T convertObject(T object, MappingDocument rootNode, QueryMetadataInterface metadata, boolean deep) throws QueryPlannerException, TeiidComponentException {
        XMLNodeMappingVisitor mappingVisitor = new XMLNodeMappingVisitor(rootNode, metadata);
        try {
            PreOrPostOrderNavigator.doVisit(object, mappingVisitor, false, deep);
        }
        catch (TeiidRuntimeException e) {
            Throwable child = e.getCause();
            if (child instanceof TeiidComponentException) {
                throw (TeiidComponentException)child;
            }
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30286, child);
        }
        List unmappedSymbols = mappingVisitor.getUnmappedSymbols();
        if (unmappedSymbols != null && unmappedSymbols.size() > 0) {
            throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30287, QueryPlugin.Util.gs(QueryPlugin.Event.TEIID30287, unmappedSymbols, object));
        }
        return object;
    }
}

