/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;

public class MappingOutputter {
    private static final String ELEM_ROOT = "xmlMapping";
    private static final String ELEM_NODE = "mappingNode";
    XMLStreamWriter writer;

    public void write(MappingDocument doc, PrintWriter stream) throws IOException {
        try {
            XMLOutputFactory xof = XMLSystemFunctions.getOutputFactory();
            this.writer = xof.createXMLStreamWriter(stream);
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.writeStartElement(ELEM_ROOT);
            this.writeElement("documentEncoding", doc.getDocumentEncoding());
            this.writeElement("formattedDocument", Boolean.toString(doc.isFormatted()));
            this.loadNode(doc.getRootNode());
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    void writeElement(String name, String content) throws XMLStreamException {
        this.writer.writeStartElement(name);
        this.writer.writeCharacters(content);
        this.writer.writeEndElement();
    }

    void loadNode(MappingNode node) throws XMLStreamException {
        this.writer.writeStartElement(ELEM_NODE);
        Properties namespaces = (Properties)node.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        if (namespaces != null) {
            this.addNamespaceDeclarations(namespaces);
        }
        Map<MappingNodeConstants.Properties, Object> properties = node.getNodeProperties();
        this.addElementProperties(properties);
        for (MappingNode child : node.getChildren()) {
            this.loadNode(child);
        }
        this.writer.writeEndElement();
    }

    private void addNamespaceDeclarations(Properties namespaces) throws XMLStreamException {
        Enumeration<?> e = namespaces.propertyNames();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String uri = namespaces.getProperty(prefix);
            this.writer.writeStartElement("namespaceDeclaration");
            if (!prefix.equals("")) {
                this.writeElement("prefix", prefix);
            }
            this.writeElement("uri", uri);
            this.writer.writeEndElement();
        }
    }

    void addElementProperties(Map properties) throws XMLStreamException {
        for (String propName : MappingNodeConstants.Tags.OUTPUTTER_PROPERTY_TAGS) {
            MappingNodeConstants.Properties propKey = MappingNodeConstants.getProperty(propName);
            if (!properties.containsKey((Object)propKey)) continue;
            Object value = properties.get((Object)propKey);
            this.addElementProperty(propName, value);
        }
    }

    void addElementProperty(String name, Object value) throws XMLStreamException {
        if (value == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.002.0010", name));
        }
        if (value instanceof Collection) {
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                this.writeElement(name, this.getXMLText(i.next()));
            }
        } else {
            this.writeElement(name, this.getXMLText(value));
        }
    }

    private String getXMLText(Object obj) {
        if (obj instanceof String) {
            return this.getXMLText((String)obj);
        }
        if (obj instanceof Integer) {
            return this.getXMLText((Integer)obj);
        }
        if (obj instanceof Boolean) {
            return this.getXMLText((Boolean)obj);
        }
        throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.002.0011", obj.getClass().getName()));
    }

    private String getXMLText(String str) {
        return str != null ? str : "";
    }

    private String getXMLText(Integer value) {
        return value.toString();
    }

    private String getXMLText(Boolean value) {
        return value.toString();
    }
}

