/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.teiid.client.xa.XATransactionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;

public class ExceptionUtil {
    public static <T extends Throwable> T getExceptionOfType(Throwable ex, Class<T> cls) {
        while (ex != null) {
            if (cls.isAssignableFrom(ex.getClass())) {
                return (T)((Throwable)cls.cast(ex));
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
        }
        return null;
    }

    public static Throwable convertException(Method method, Throwable exception) {
        boolean canThrowXATransactionException = false;
        boolean canThrowComponentException = false;
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            if (exception.getClass().isAssignableFrom(exceptionClasses[i])) {
                return exception;
            }
            canThrowComponentException |= TeiidComponentException.class.isAssignableFrom(exceptionClasses[i]);
            canThrowXATransactionException |= XATransactionException.class.isAssignableFrom(exceptionClasses[i]);
        }
        if (canThrowComponentException) {
            return new TeiidComponentException(exception);
        }
        if (canThrowXATransactionException) {
            return new XATransactionException(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return new TeiidRuntimeException(exception);
    }

    public static Throwable sanitize(Throwable t, boolean perserveStack) {
        String code = null;
        code = t instanceof TeiidException ? ((TeiidException)t).getCode() : (t instanceof TeiidRuntimeException ? ((TeiidRuntimeException)t).getCode() : t.getClass().getName());
        Throwable child = null;
        if (t.getCause() != null && t.getCause() != t) {
            child = ExceptionUtil.sanitize(t.getCause(), perserveStack);
        }
        Throwable result = null;
        for (Class<?> clazz = t.getClass(); clazz != null && clazz != Throwable.class && clazz != Exception.class; clazz = clazz.getSuperclass()) {
            Constructor<?> ctor = null;
            try {
                ctor = clazz.getDeclaredConstructor(String.class);
                result = (Throwable)ctor.newInstance(code);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (result == null) {
            result = new TeiidException(code);
        }
        if (result instanceof TeiidException) {
            result.setCode(code);
        } else if (result instanceof TeiidRuntimeException) {
            result.setCode(code);
        }
        if (child != null) {
            result.initCause(child);
        }
        if (perserveStack) {
            result.setStackTrace(t.getStackTrace());
        } else {
            result.setStackTrace(new StackTraceElement[0]);
        }
        return result;
    }
}

