/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Schema;

public class MetadataStore
implements Serializable {
    private static final long serialVersionUID = -3130247626435324312L;
    protected NavigableMap<String, Schema> schemas = new TreeMap<String, Schema>(String.CASE_INSENSITIVE_ORDER);
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected NavigableMap<String, Datatype> datatypes = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    protected List<Grant> grants;
    private List<String> startTriggers;
    private List<String> shutdownTriggers;

    public NavigableMap<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        return (Schema)this.schemas.get(name);
    }

    public void addSchema(Schema schema) {
        if (this.schemas.put(schema.getName(), schema) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60012, DataPlugin.Util.gs(DataPlugin.Event.TEIID60012, schema.getName()));
        }
        this.schemaList.add(schema);
    }

    public List<Schema> getSchemaList() {
        return this.schemaList;
    }

    public void addDataTypes(Collection<Datatype> types) {
        if (types != null) {
            for (Datatype type : types) {
                this.addDatatype(type);
            }
        }
    }

    public void addDatatype(Datatype datatype) {
        if (!this.datatypes.containsKey(datatype.getName())) {
            this.datatypes.put(datatype.getName(), datatype);
        }
    }

    public NavigableMap<String, Datatype> getDatatypes() {
        return this.datatypes;
    }

    public void merge(MetadataStore store) {
        if (store != null) {
            for (Schema s : store.getSchemaList()) {
                this.addSchema(s);
            }
            this.addDataTypes(store.getDatatypes().values());
            this.addGrants(store.grants);
        }
    }

    void addGrants(List<Grant> g) {
        if (g == null) {
            return;
        }
        if (this.grants == null) {
            this.grants = new ArrayList<Grant>();
        }
        this.grants.addAll(g);
    }

    protected static class Grant
    implements Serializable {
        private static final long serialVersionUID = -3768577122034702953L;
        protected String role;
        protected DataPolicyMetadata.PermissionMetaData perm;

        public Grant(String role, DataPolicyMetadata.PermissionMetaData perm) {
            this.role = role;
            this.perm = perm;
        }

        public String getRole() {
            return this.role;
        }

        public DataPolicyMetadata.PermissionMetaData getPermission() {
            return this.perm;
        }
    }
}

