/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class XMLProjectionMinimizer {
    static void minimizeProjection(final XMLPlannerEnvironment planEnv) {
        final HashMap neededElements = new HashMap();
        Navigator visitor = new Navigator(true, new MappingVisitor(){

            @Override
            public void visit(MappingAttribute attribute) {
                this.collectElementSymbol(attribute);
            }

            private void collectElementSymbol(MappingNode node) {
                if (node.isExcluded() || node.getElementSymbol() == null) {
                    return;
                }
                MappingSourceNode msn = node.getSourceNode();
                ElementSymbol es = node.getElementSymbol();
                this.collectElementSymbol(msn, es);
            }

            private void collectElementSymbol(MappingSourceNode msn, ElementSymbol es) {
                LinkedHashSet<ElementSymbol> elems = (LinkedHashSet<ElementSymbol>)neededElements.get(msn = XMLProjectionMinimizer.getActualSourceNode(msn));
                if (elems == null) {
                    elems = new LinkedHashSet<ElementSymbol>();
                    neededElements.put(msn, elems);
                }
                elems.add(es);
            }

            @Override
            public void visit(MappingElement element) {
                this.collectElementSymbol(element);
            }

            @Override
            public void visit(MappingSourceNode element) {
                try {
                    QueryNode node = QueryUtil.getQueryNode(element.getResultName(), planEnv.getGlobalMetadata());
                    Collection<ElementSymbol> bindings = QueryUtil.getBindingElements(node);
                    MappingSourceNode parent = element.getParentSourceNode();
                    this.collectElementSymbols(element, bindings, parent);
                }
                catch (TeiidException e) {
                    throw new TeiidRuntimeException(e);
                }
            }

            private void collectElementSymbols(MappingSourceNode element, Collection<ElementSymbol> bindings, MappingSourceNode parent) {
                block0: for (ElementSymbol elementSymbol : bindings) {
                    if (element != null) {
                        elementSymbol = element.getMappedSymbol(elementSymbol);
                    }
                    while (parent != null) {
                        if (parent.getActualResultSetName().equalsIgnoreCase(elementSymbol.getGroupSymbol().getNonCorrelationName())) {
                            this.collectElementSymbol(parent, elementSymbol);
                            continue block0;
                        }
                        parent = parent.getParentSourceNode();
                    }
                }
            }

            @Override
            public void visit(MappingCriteriaNode element) {
                Criteria crit = element.getCriteriaNode();
                if (crit == null) {
                    return;
                }
                this.collectElementSymbols(null, ElementCollectorVisitor.getElements((LanguageObject)crit, true), element.getSourceNode());
            }

            @Override
            public void visit(MappingRecursiveElement element) {
                Criteria crit = element.getCriteriaNode();
                if (crit == null) {
                    return;
                }
                this.collectElementSymbols(null, ElementCollectorVisitor.getElements((LanguageObject)crit, true), element.getSourceNode());
            }
        });
        planEnv.mappingDoc.acceptVisitor(visitor);
        visitor = new Navigator(true, new MappingVisitor(){

            @Override
            public void visit(MappingSourceNode element) {
                try {
                    ResultSetInfo rsInfo = element.getResultSetInfo();
                    Query rsQuery = (Query)rsInfo.getCommand();
                    if (rsQuery.getSelect().isDistinct()) {
                        return;
                    }
                    LinkedHashSet elements = (LinkedHashSet)neededElements.get(element);
                    if (elements != null) {
                        rsQuery.setSelect(new Select(LanguageObject.Util.deepClone(elements, ElementSymbol.class)));
                    } else {
                        String alias = element.getAliasResultName();
                        if (alias == null) {
                            rsQuery.setSelect(new Select(Arrays.asList(new ExpressionSymbol("foo", new Constant(1)))));
                        } else {
                            MappingSourceNode actual = XMLProjectionMinimizer.getActualSourceNode(element);
                            elements = (LinkedHashSet)neededElements.get(actual);
                            if (elements != null) {
                                Map reverseMap = QueryUtil.createSymbolMap(new GroupSymbol(element.getAliasResultName()), rsInfo.getResultSetName(), ResolverUtil.resolveElementsInGroup(QueryUtil.createResolvedGroup(element.getAliasResultName(), (QueryMetadataInterface)planEnv.getGlobalMetadata()), planEnv.getGlobalMetadata()));
                                Select select = new Select(new ArrayList(elements));
                                ExpressionMappingVisitor.mapExpressions(select, reverseMap);
                                rsQuery.setSelect(select);
                            }
                        }
                    }
                }
                catch (TeiidException e) {
                    throw new TeiidRuntimeException(e);
                }
            }
        });
        planEnv.mappingDoc.acceptVisitor(visitor);
    }

    private static MappingSourceNode getActualSourceNode(MappingSourceNode element) {
        if (element.getAliasResultName() == null) {
            return element;
        }
        String actual = element.getActualResultSetName();
        for (MappingSourceNode parent = element.getParentSourceNode(); parent != null; parent = parent.getParentSourceNode()) {
            if (!parent.getActualResultSetName().equalsIgnoreCase(actual)) continue;
            return parent;
        }
        return null;
    }
}

