/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.core.util.PropertiesUtils;

public final class XMLType
extends Streamable<SQLXML>
implements SQLXML {
    private static final long serialVersionUID = -7922647237095135723L;
    static final boolean SUPPORT_DTD = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.supportDTD", false);
    private static ThreadLocal<XMLInputFactory> threadLocalFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLType.createXMLInputFactory();
        }
    };
    private static XMLInputFactory factory = XMLType.createXMLInputFactory();
    private static Boolean factoriesTreadSafe;
    private transient Type type = Type.UNKNOWN;
    private String encoding;

    private static XMLInputFactory createXMLInputFactory() throws FactoryConfigurationError {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        if (!SUPPORT_DTD) {
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setXMLResolver(new XMLResolver(){

                @Override
                public Object resolveEntity(String arg0, String arg1, String arg2, String arg3) throws XMLStreamException {
                    throw new XMLStreamException("Reading external entities is disabled");
                }
            });
        }
        return factory;
    }

    public static boolean isThreadSafeXmlFactories() {
        if (factoriesTreadSafe == null) {
            factoriesTreadSafe = factory.getClass().getName().contains(".wstx.");
        }
        return factoriesTreadSafe;
    }

    public static XMLInputFactory getXmlInputFactory() {
        if (XMLType.isThreadSafeXmlFactories()) {
            return factory;
        }
        return threadLocalFactory.get();
    }

    public XMLType() {
    }

    public XMLType(SQLXML xml) {
        super(xml);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return ((SQLXML)this.reference).getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return ((SQLXML)this.reference).getCharacterStream();
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        return ((SQLXML)this.reference).getSource(sourceClass);
    }

    @Override
    public String getString() throws SQLException {
        return ((SQLXML)this.reference).getString();
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        return ((SQLXML)this.reference).setBinaryStream();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        return ((SQLXML)this.reference).setCharacterStream();
    }

    @Override
    public void setString(String value) throws SQLException {
        ((SQLXML)this.reference).setString(value);
    }

    @Override
    public void free() throws SQLException {
        ((SQLXML)this.reference).free();
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        return ((SQLXML)this.reference).setResult(resultClass);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = XMLType.getEncoding(this);
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, (byte)0);
    }

    public void readExternal(ObjectInput in, byte version) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.encoding = (String)in.readObject();
        }
        catch (OptionalDataException e) {
            this.encoding = "UTF-8";
        }
        try {
            this.type = version > 0 ? ExternalizeUtil.readEnum(in, Type.class, Type.UNKNOWN) : (Type)((Object)in.readObject());
        }
        catch (OptionalDataException e) {
            this.type = Type.UNKNOWN;
        }
        catch (IOException e) {
            this.type = Type.UNKNOWN;
        }
        catch (ClassNotFoundException e) {
            this.type = Type.UNKNOWN;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, (byte)0);
    }

    public void writeExternal(ObjectOutput out, byte version) throws IOException {
        super.writeExternal(out);
        if (this.encoding == null) {
            this.encoding = XMLType.getEncoding(this);
        }
        out.writeObject(this.encoding);
        if (version > 0) {
            ExternalizeUtil.writeEnum(out, this.type);
        } else {
            out.writeObject((Object)this.type);
        }
    }

    public static String getEncoding(SQLXML xml) {
        try {
            Charset cs;
            if (xml instanceof XMLType) {
                XMLType type = (XMLType)xml;
                if (type.encoding != null) {
                    return type.encoding;
                }
                xml = (SQLXML)type.reference;
            }
            if (xml instanceof SQLXMLImpl && (cs = ((SQLXMLImpl)xml).getCharset()) != null) {
                return cs.name();
            }
            return XMLType.getEncoding(xml.getBinaryStream());
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(InputStream is) {
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            String string = reader.getEncoding();
            return string;
        }
        catch (XMLStreamException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    long computeLength() throws SQLException {
        if (this.reference instanceof SQLXMLImpl) {
            SQLXMLImpl impl = (SQLXMLImpl)this.reference;
            return impl.length();
        }
        return BaseLob.length(this.getBinaryStream());
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        byte[] bytes = new byte[(int)this.getLength()];
        in.readFully(bytes);
        this.reference = new SQLXMLImpl(bytes);
    }

    @Override
    protected void writeReference(DataOutput out) throws IOException {
        try {
            BlobType.writeBinary(out, this.getBinaryStream(), (int)this.length);
        }
        catch (SQLException e) {
            throw new IOException();
        }
    }

    @Override
    public long length() throws SQLException {
        if (this.length != -1L) {
            return this.length;
        }
        InputStreamFactory.StorageMode storageMode = InputStreamFactory.getStorageMode(this);
        if (storageMode != InputStreamFactory.StorageMode.OTHER) {
            return super.length();
        }
        throw new SQLException("Computing the length may leave the XML value unreadable");
    }

    public static enum Type {
        UNKNOWN,
        DOCUMENT,
        CONTENT,
        ELEMENT,
        COMMENT,
        PI,
        TEXT;

    }
}

