/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import org.teiid.core.CorePlugin;

public final class Assertion {
    private Assertion() {
    }

    public static final void assertTrue(boolean condition) {
        Assertion.assertTrue(condition, null);
    }

    public static final void assertTrue(boolean condition, String msgKey) {
        if (!condition) {
            String msg = msgKey != null ? msgKey : CorePlugin.Util.getString("Assertion.Assertion_failed");
            Assertion.failed(msg);
        }
    }

    public static final void failed(String msg) {
        throw new AssertionError((Object)msg);
    }

    public static final void isNull(Object value) {
        Assertion.isNull(value, null);
    }

    public static final void isNull(Object value, String message) {
        if (value != null) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNull");
            Assertion.failed(msg);
        }
    }

    public static final void isNotNull(Object value) {
        Assertion.isNotNull(value, null);
    }

    public static final void isNotNull(Object value, String message) {
        if (value == null) {
            String msg = message != null ? message : CorePlugin.Util.getString("Assertion.isNotNull");
            Assertion.failed(msg);
        }
    }

    public static final <T> T isInstanceOf(Object object, Class<T> expectedClass, String name) {
        if (object == null) {
            return null;
        }
        Class<?> objClass = object.getClass();
        if (!expectedClass.isAssignableFrom(objClass)) {
            Object[] params = new Object[]{name, expectedClass, objClass.getName()};
            String msg = CorePlugin.Util.getString("Assertion.invalidClassMessage", params);
            throw new ClassCastException(msg);
        }
        return expectedClass.cast(object);
    }
}

